/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.CliConfiguration;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintIssueDocGenerator;
import com.android.tools.lint.MultiProjectHtmlReporter;
import com.android.tools.lint.ProjectInitializerKt;
import com.android.tools.lint.ProjectMetadata;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.SyncOptions;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.XmlFileType;
import com.android.tools.lint.XmlReporter;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.checks.DesugaredMethodLookup;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.client.api.LintXmlConfiguration;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintModelModuleProject;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Option;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SeverityKt;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelSeverity;
import com.android.tools.lint.model.LintModelSourceProvider;
import com.android.tools.lint.model.LintModelVariant;
import com.android.tools.lint.model.PathVariables;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.intellij.pom.java.LanguageLevel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import kotlin.io.FilesKt;
import kotlin.text.StringsKt;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Beta
public class Main {
    static final int MAX_LINE_WIDTH = 78;
    private static final String ARG_ENABLE = "--enable";
    private static final String ARG_DISABLE = "--disable";
    private static final String ARG_CHECK = "--check";
    private static final String ARG_AUTO_FIX = "--apply-suggestions";
    private static final String ARG_DESCRIBE_FIXES = "--describe-suggestions";
    private static final String ARG_ABORT_IF_SUGGESTIONS_APPLIED = "--abort-if-suggestions-applied";
    private static final String ARG_FATAL = "--fatal";
    private static final String ARG_ERROR = "--error";
    private static final String ARG_WARNING = "--warning";
    private static final String ARG_INFO = "--info";
    private static final String ARG_IGNORE = "--ignore";
    private static final String ARG_LIST_IDS = "--list";
    private static final String ARG_SHOW = "--show";
    private static final String ARG_QUIET = "--quiet";
    private static final String ARG_GENERATE_DOCS = "--generate-docs";
    private static final String ARG_CLIENT_ID = "--client-id";
    private static final String ARG_CLIENT_NAME = "--client-name";
    private static final String ARG_CLIENT_VERSION = "--client-version";
    private static final String ARG_FULL_PATH = "--fullpath";
    private static final String ARG_SHOW_ALL = "--showall";
    private static final String ARG_HELP = "--help";
    private static final String ARG_NO_LINES = "--nolines";
    private static final String ARG_HTML = "--html";
    private static final String ARG_SIMPLE_HTML = "--simplehtml";
    private static final String ARG_SARIF = "--sarif";
    private static final String ARG_XML = "--xml";
    private static final String ARG_TEXT = "--text";
    private static final String ARG_CONFIG = "--config";
    private static final String ARG_OVERRIDE_CONFIG = "--override-config";
    private static final String ARG_URL = "--url";
    private static final String ARG_VERSION = "--version";
    private static final String ARG_EXIT_CODE = "--exitcode";
    private static final String ARG_SDK_HOME = "--sdk-home";
    private static final String ARG_JDK_HOME = "--jdk-home";
    private static final String ARG_FATAL_ONLY = "--fatalOnly";
    private static final String ARG_PROJECT = "--project";
    private static final String ARG_LINT_MODEL = "--lint-model";
    private static final String ARG_PATH_VARIABLES = "--path-variables";
    private static final String ARG_LINT_RULE_JARS = "--lint-rule-jars";
    private static final String ARG_VARIANT = "--variant";
    private static final String ARG_CLASSES = "--classpath";
    private static final String ARG_SOURCES = "--sources";
    private static final String ARG_RESOURCES = "--resources";
    private static final String ARG_LIBRARIES = "--libraries";
    private static final String ARG_BUILD_API = "--compile-sdk-version";
    private static final String ARG_JAVA_LANGUAGE_LEVEL = "--java-language-level";
    private static final String ARG_KOTLIN_LANGUAGE_LEVEL = "--kotlin-language-level";
    private static final String ARG_BASELINE = "--baseline";
    private static final String ARG_REMOVE_FIXED = "--remove-fixed";
    private static final String ARG_UPDATE_BASELINE = "--update-baseline";
    private static final String ARG_CONTINUE_AFTER_BASELINE_CREATED = "--continue-after-baseline-created";
    private static final String ARG_WRITE_REF_BASELINE = "--write-reference-baseline";
    private static final String ARG_ALLOW_SUPPRESS = "--allow-suppress";
    private static final String ARG_RESTRICT_SUPPRESS = "--restrict-suppress";
    private static final String ARG_PRINT_INTERNAL_ERROR_STACKTRACE = "--stacktrace";
    private static final String ARG_ANALYZE_ONLY = "--analyze-only";
    private static final String ARG_REPORT_ONLY = "--report-only";
    private static final String ARG_CACHE_DIR = "--cache-dir";
    private static final String ARG_NO_WARN_2 = "--nowarn";
    private static final String ARG_NO_WARN_1 = "-w";
    private static final String ARG_WARN_ALL = "-Wall";
    private static final String ARG_ALL_ERROR = "-Werror";
    private static final String PROP_WORK_DIR = "com.android.tools.lint.workdir";
    private final LintCliFlags flags = new LintCliFlags();
    private IssueRegistry globalIssueRegistry;
    private File sdkHome;
    private File jdkHome;

    public static void main(String[] args) {
        int exitCode = new Main().run(args);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    protected void initializeDriver(LintDriver driver) {
    }

    public int run(String[] args) {
        if (args.length < 1) {
            Main.printUsage(System.err);
            return 2;
        }
        LintClient.setClientName((String)"cli");
        ArgumentState argumentState = new ArgumentState();
        LintCliClient client = this.createClient(argumentState);
        int exitCode = this.parseArguments(args, client, argumentState);
        if (exitCode != 100) {
            return exitCode;
        }
        this.initializeConfigurations(client, argumentState);
        exitCode = this.initializeReporters(client, argumentState);
        if (exitCode != 100) {
            return exitCode;
        }
        LintRequest lintRequest = Main.createLintRequest(client, argumentState);
        this.createDefaultPathVariables(argumentState, client);
        exitCode = this.run(client, lintRequest, argumentState);
        if (!(exitCode != 1 || client.getFlags().isSetExitCode() && argumentState.mode != LintDriver.DriverMode.ANALYSIS_ONLY)) {
            exitCode = 0;
        }
        return exitCode;
    }

    private void createDefaultPathVariables(ArgumentState argumentState, LintCliClient client) {
        PathVariables pathVariables = client.getPathVariables();
        if (!pathVariables.any()) {
            for (LintModelModule module : argumentState.modules) {
                pathVariables.add("{" + module.getModulePath() + "*projectDir}", module.getDir(), false);
                pathVariables.add("{" + module.getModulePath() + "*buildDir}", module.getBuildFolder(), false);
                for (LintModelVariant variant : module.getVariants()) {
                    Object sourceProvider2;
                    int sourceProviderIndex = 0;
                    for (Object sourceProvider2 : variant.getSourceProviders()) {
                        Main.addSourceProviderPathVariables(pathVariables, (LintModelSourceProvider)sourceProvider2, "sourceProvider", sourceProviderIndex++, module.getModulePath(), variant.getName());
                    }
                    int testSourceProviderIndex = 0;
                    sourceProvider2 = variant.getTestSourceProviders().iterator();
                    while (sourceProvider2.hasNext()) {
                        LintModelSourceProvider testSourceProvider = (LintModelSourceProvider)sourceProvider2.next();
                        Main.addSourceProviderPathVariables(pathVariables, testSourceProvider, "testSourceProvider", testSourceProviderIndex++, module.getModulePath(), variant.getName());
                    }
                    int testFixturesSourceProviderIndex = 0;
                    for (LintModelSourceProvider testFixturesSourceProvider : variant.getTestFixturesSourceProviders()) {
                        Main.addSourceProviderPathVariables(pathVariables, testFixturesSourceProvider, "testFixturesSourceProvider", testFixturesSourceProviderIndex++, module.getModulePath(), variant.getName());
                    }
                }
            }
            pathVariables.sort();
        }
    }

    private static void addSourceProviderPathVariables(PathVariables pathVariables, LintModelSourceProvider sourceProvider, String sourceProviderType, int sourceProviderIndex, String modulePath, String variantName) {
        Main.addSourceProviderPathVariables(pathVariables, Arrays.asList(sourceProvider.getManifestFile()), modulePath, variantName, sourceProviderType, sourceProviderIndex, "manifest");
        Main.addSourceProviderPathVariables(pathVariables, sourceProvider.getJavaDirectories(), modulePath, variantName, sourceProviderType, sourceProviderIndex, "javaDir");
        Main.addSourceProviderPathVariables(pathVariables, sourceProvider.getResDirectories(), modulePath, variantName, sourceProviderType, sourceProviderIndex, "resDir");
        Main.addSourceProviderPathVariables(pathVariables, sourceProvider.getAssetsDirectories(), modulePath, variantName, sourceProviderType, sourceProviderIndex, "assetsDir");
    }

    private static void addSourceProviderPathVariables(PathVariables pathVariables, Collection<File> files, String modulePath, String variantName, String sourceProviderType, int sourceProviderIndex, String sourceType) {
        int index = 0;
        for (File file : files) {
            String name = "{" + modulePath + "*" + variantName + "*" + sourceProviderType + "*" + sourceProviderIndex + "*" + sourceType + "*" + index++ + "}";
            pathVariables.add(name, file, false);
        }
    }

    private void logArguments(String[] args, File log) {
        File parent = log.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Calendar.getInstance().getTime()).append("\n");
        sb.append("pwd=").append(System.getProperty("user.dir")).append("\narguments: ");
        for (String arg : args) {
            String s = arg.replace("\"", "\\\"");
            if (s.contains(" ")) {
                s = '\"' + s + '\"';
            }
            sb.append(s).append(' ');
        }
        sb.append("\n");
        FilesKt.appendText((File)log, (String)sb.toString(), (Charset)Charsets.UTF_8);
    }

    private LintCliClient createClient(ArgumentState argumentState) {
        return new MainLintClient(this.flags, argumentState);
    }

    private int parseArguments(String[] args, LintCliClient client, ArgumentState argumentState) {
        for (int index = 0; index < args.length; ++index) {
            String path;
            String version;
            File input;
            String paths;
            File output;
            File file;
            Object registry;
            String arg = args[index];
            if (arg.equals(ARG_HELP) || arg.equals("-h") || arg.equals("-?")) {
                if (index < args.length - 1) {
                    String topic = args[index + 1];
                    if (topic.equals("suppress") || topic.equals("ignore")) {
                        Main.printHelpTopicSuppress();
                        return 4;
                    }
                    System.err.printf("Unknown help topic \"%1$s\"%n", topic);
                    return 5;
                }
                Main.printUsage(System.out);
                return 4;
            }
            if (arg.equals(ARG_LIST_IDS)) {
                registry = this.getGlobalRegistry(client);
                if (index < args.length - 1 && !args[index + 1].startsWith("-")) {
                    String[] ids = args[++index].split(",");
                    for (String id : ids) {
                        if (registry.isCategoryName(id)) {
                            String category = id;
                            for (Issue issue : registry.getIssues()) {
                                if (!issue.getCategory().getName().startsWith(category) && !issue.getCategory().getFullName().startsWith(category)) continue;
                                Main.listIssue(System.out, issue);
                            }
                            continue;
                        }
                        System.err.println("Invalid category \"" + id + "\".\n");
                        Main.displayValidIds((IssueRegistry)registry, System.err);
                        return 5;
                    }
                } else {
                    Main.displayValidIds((IssueRegistry)registry, System.out);
                }
                return 0;
            }
            if (arg.equals(ARG_SHOW)) {
                registry = this.getGlobalRegistry(client);
                if (index < args.length - 1 && !args[index + 1].startsWith("-")) {
                    String[] ids = args[++index].split(",");
                    for (String id : ids) {
                        if (registry.isCategoryName(id)) {
                            String category = id;
                            for (Issue issue : registry.getIssues()) {
                                if (!issue.getCategory().getName().startsWith(category) && !issue.getCategory().getFullName().startsWith(category)) continue;
                                Main.describeIssue(issue);
                                System.out.println();
                            }
                            continue;
                        }
                        if (registry.isIssueId(id)) {
                            Main.describeIssue(registry.getIssue(id));
                            System.out.println();
                            continue;
                        }
                        System.err.println("Invalid id or category \"" + id + "\".\n");
                        Main.displayValidIds((IssueRegistry)registry, System.err);
                        return 5;
                    }
                } else {
                    Main.showIssues((IssueRegistry)registry);
                }
                return 0;
            }
            if (arg.equals(ARG_FULL_PATH) || arg.equals("--fullpaths")) {
                this.flags.setFullPath(true);
                continue;
            }
            if (arg.equals(ARG_SHOW_ALL)) {
                this.flags.setShowEverything(true);
                continue;
            }
            if (arg.equals(ARG_QUIET) || arg.equals("-q")) {
                this.flags.setQuiet(true);
                continue;
            }
            if (arg.equals(ARG_NO_LINES)) {
                this.flags.setShowSourceLines(false);
                continue;
            }
            if (arg.equals(ARG_EXIT_CODE) || arg.equals("--exit-code")) {
                this.flags.setSetExitCode(true);
                continue;
            }
            if (arg.equals(ARG_FATAL_ONLY)) {
                this.flags.setFatalOnly(true);
                continue;
            }
            if (arg.equals(ARG_VERSION)) {
                Main.printVersion(client);
                return 0;
            }
            if (arg.equals(ARG_URL)) {
                if (index == args.length - 1) {
                    System.err.println("Missing URL mapping string");
                    return 5;
                }
                String map = args[++index];
                String urlMap = argumentState.urlMap;
                urlMap = urlMap != null ? urlMap + ',' + map : map;
                argumentState.urlMap = urlMap;
                continue;
            }
            if (arg.equals(ARG_CONFIG) || arg.equals(ARG_OVERRIDE_CONFIG)) {
                if (index == args.length - 1 || !Lint.endsWith((String)args[index + 1], (String)".xml")) {
                    System.err.println("Missing XML configuration file argument");
                    return 5;
                }
                if (!(file = Main.getInArgumentPath(args[++index])).exists()) {
                    System.err.println(file.getAbsolutePath() + " does not exist");
                    return 5;
                }
                if (arg.equals(ARG_CONFIG)) {
                    this.flags.setLintConfig(file);
                    continue;
                }
                this.flags.setOverrideLintConfig(file);
                continue;
            }
            if (arg.equals(ARG_HTML) || arg.equals(ARG_SIMPLE_HTML)) {
                boolean delete;
                if (index == args.length - 1) {
                    System.err.println("Missing HTML output file name");
                    return 5;
                }
                output = Main.getOutArgumentPath(args[++index]);
                if ((output = output.getAbsoluteFile()).isDirectory() || !output.exists() && output.getName().indexOf(46) == -1) {
                    boolean mkdirs;
                    if (!output.exists() && !(mkdirs = output.mkdirs())) {
                        this.log(null, "Could not create output directory %1$s", output);
                        return 3;
                    }
                    MultiProjectHtmlReporter reporter = new MultiProjectHtmlReporter(client, output, this.flags);
                    if (arg.equals(ARG_SIMPLE_HTML)) {
                        System.err.println("--simplehtml ignored: no longer supported");
                    }
                    this.flags.getReporters().add(reporter);
                    continue;
                }
                if (output.exists() && !(delete = output.delete())) {
                    System.err.println("Could not delete old " + output);
                    return 3;
                }
                if (output.getParentFile() != null && !output.getParentFile().canWrite()) {
                    System.err.println("Cannot write HTML output file " + output);
                    return 3;
                }
                try {
                    Reporter reporter = Reporter.createHtmlReporter(client, output, this.flags);
                    this.flags.getReporters().add(reporter);
                    continue;
                }
                catch (IOException e) {
                    this.log(e, null, new Object[0]);
                    return 5;
                }
            }
            if (arg.equals(ARG_XML)) {
                boolean delete;
                if (index == args.length - 1) {
                    System.err.println("Missing XML output file name");
                    return 5;
                }
                output = Main.getOutArgumentPath(args[++index]);
                if ((output = output.getAbsoluteFile()).exists() && !(delete = output.delete())) {
                    System.err.println("Could not delete old " + output);
                    return 3;
                }
                if (output.getParentFile() != null && !output.getParentFile().canWrite()) {
                    System.err.println("Cannot write XML output file " + output);
                    return 3;
                }
                try {
                    this.flags.getReporters().add(Reporter.createXmlReporter(client, output, this.flags.isIncludeXmlFixes() ? XmlFileType.REPORT_WITH_FIXES : XmlFileType.REPORT));
                    continue;
                }
                catch (IOException e) {
                    this.log(e, null, new Object[0]);
                    return 5;
                }
            }
            if (arg.equals(ARG_SARIF)) {
                boolean delete;
                if (index == args.length - 1) {
                    System.err.println("Missing SARIF output file name");
                    return 5;
                }
                output = Main.getOutArgumentPath(args[++index]);
                if ((output = output.getAbsoluteFile()).exists() && !(delete = output.delete())) {
                    System.err.println("Could not delete old " + output);
                    return 3;
                }
                if (output.getParentFile() != null && !output.getParentFile().canWrite()) {
                    System.err.println("Cannot write SARIF output file " + output);
                    return 3;
                }
                try {
                    this.flags.getReporters().add(Reporter.createSarifReporter(client, output));
                    continue;
                }
                catch (IOException e) {
                    this.log(e, null, new Object[0]);
                    return 5;
                }
            }
            if (arg.equals(ARG_TEXT)) {
                boolean closeWriter;
                Writer writer;
                String outputName;
                if (index == args.length - 1) {
                    System.err.println("Missing text output file name");
                    return 5;
                }
                if ((outputName = args[++index]).equals("stdout")) {
                    writer = new PrintWriter(System.out, true);
                    closeWriter = false;
                } else if (outputName.equals("stderr")) {
                    writer = new PrintWriter(System.err, true);
                    closeWriter = false;
                } else {
                    boolean delete;
                    File output2 = Main.getOutArgumentPath(outputName);
                    if ((output2 = output2.getAbsoluteFile()).exists() && !(delete = output2.delete())) {
                        System.err.println("Could not delete old " + output2);
                        return 3;
                    }
                    if (output2.getParentFile() != null && !output2.getParentFile().canWrite()) {
                        System.err.println("Cannot write text output file " + output2);
                        return 3;
                    }
                    try {
                        writer = new BufferedWriter(new FileWriter(output2));
                    }
                    catch (IOException e) {
                        this.log(e, null, new Object[0]);
                        return 5;
                    }
                    closeWriter = true;
                }
                this.flags.getReporters().add(new TextReporter(client, this.flags, writer, closeWriter));
                continue;
            }
            if (arg.equals(ARG_DISABLE) || arg.equals(ARG_IGNORE) || arg.equals("--hide")) {
                if (index == args.length - 1) {
                    System.err.println("Missing categories or id's to disable");
                    return 5;
                }
                registry = this.getGlobalRegistry(client);
                String idString = args[++index];
                Main.setSeverity(this.flags, (IssueRegistry)registry, idString, this.flags.getSuppressedIds(), null);
                continue;
            }
            if (arg.equals(ARG_ENABLE)) {
                if (index == args.length - 1) {
                    System.err.println("Missing categories or id's to enable");
                    return 5;
                }
                registry = this.getGlobalRegistry(client);
                Main.setSeverity(this.flags, (IssueRegistry)registry, args[++index], this.flags.getEnabledIds(), null);
                continue;
            }
            if (arg.equals(ARG_CHECK)) {
                if (index == args.length - 1) {
                    System.err.println("Missing categories or id's to check");
                    return 5;
                }
                Set<String> checkedIds = this.flags.getExactCheckedIds();
                if (checkedIds == null) {
                    checkedIds = new HashSet<String>();
                    this.flags.setExactCheckedIds(checkedIds);
                }
                IssueRegistry registry2 = this.getGlobalRegistry(client);
                Main.setSeverity(this.flags, registry2, args[++index], checkedIds, null);
                continue;
            }
            if (arg.equals(ARG_FATAL)) {
                if (index == args.length - 1) {
                    System.err.println("Missing categories or id's to set to fatal severity");
                    return 5;
                }
                registry = this.getGlobalRegistry(client);
                Main.setSeverity(this.flags, (IssueRegistry)registry, args[++index], null, Severity.FATAL);
                continue;
            }
            if (arg.equals(ARG_ERROR)) {
                if (index == args.length - 1) {
                    System.err.println("Missing categories or id's to set to error severity");
                    return 5;
                }
                registry = this.getGlobalRegistry(client);
                Main.setSeverity(this.flags, (IssueRegistry)registry, args[++index], null, Severity.ERROR);
                continue;
            }
            if (arg.equals(ARG_WARNING)) {
                if (index == args.length - 1) {
                    System.err.println("Missing categories or id's to set to warning severity");
                    return 5;
                }
                registry = this.getGlobalRegistry(client);
                Main.setSeverity(this.flags, (IssueRegistry)registry, args[++index], null, Severity.WARNING);
                continue;
            }
            if (arg.equals(ARG_INFO) || arg.equals("--information") || arg.equals("--informational")) {
                if (index == args.length - 1) {
                    System.err.println("Missing categories or id's to set to info severity");
                    return 5;
                }
                registry = this.getGlobalRegistry(client);
                Main.setSeverity(this.flags, (IssueRegistry)registry, args[++index], null, Severity.INFORMATIONAL);
                continue;
            }
            if (arg.equals(ARG_NO_WARN_1) || arg.equals(ARG_NO_WARN_2)) {
                this.flags.setIgnoreWarnings(true);
                continue;
            }
            if (arg.equals(ARG_WARN_ALL)) {
                this.flags.setCheckAllWarnings(true);
                continue;
            }
            if (arg.equals(ARG_ALL_ERROR)) {
                this.flags.setWarningsAsErrors(true);
                continue;
            }
            if (arg.equals(ARG_AUTO_FIX)) {
                this.flags.setAutoFix(true);
                continue;
            }
            if (arg.equals(ARG_DESCRIBE_FIXES)) {
                this.flags.setIncludeXmlFixes(true);
                for (Reporter reporter : this.flags.getReporters()) {
                    XmlReporter xmlReporter;
                    if (!(reporter instanceof XmlReporter) || (xmlReporter = (XmlReporter)reporter).getType() != XmlFileType.REPORT) continue;
                    xmlReporter.setType(XmlFileType.REPORT_WITH_FIXES);
                }
                continue;
            }
            if (arg.equals(ARG_ABORT_IF_SUGGESTIONS_APPLIED)) {
                this.flags.setAbortOnAutoFix(true);
                continue;
            }
            if (arg.equals(ARG_CLASSES)) {
                if (index == args.length - 1) {
                    System.err.println("Missing class folder name");
                    return 5;
                }
                paths = args[++index];
                for (String path2 : Lint.splitPath((String)paths)) {
                    input = Main.getInArgumentPath(path2);
                    if (!input.exists()) {
                        System.err.println("Class path entry " + input + " does not exist.");
                        return 5;
                    }
                    List<File> classes = this.flags.getClassesOverride();
                    if (classes == null) {
                        classes = new ArrayList<File>();
                        this.flags.setClassesOverride(classes);
                    }
                    classes.add(input);
                }
                continue;
            }
            if (arg.equals(ARG_SOURCES)) {
                if (index == args.length - 1) {
                    System.err.println("Missing source folder name");
                    return 5;
                }
                paths = args[++index];
                for (String path2 : Lint.splitPath((String)paths)) {
                    input = Main.getInArgumentPath(path2);
                    if (!input.exists()) {
                        System.err.println("Source folder " + input + " does not exist.");
                        return 5;
                    }
                    List<File> sources = this.flags.getSourcesOverride();
                    if (sources == null) {
                        sources = new ArrayList<File>();
                        this.flags.setSourcesOverride(sources);
                    }
                    sources.add(input);
                }
                continue;
            }
            if (arg.equals(ARG_RESOURCES)) {
                if (index == args.length - 1) {
                    System.err.println("Missing resource folder name");
                    return 5;
                }
                paths = args[++index];
                for (String path2 : Lint.splitPath((String)paths)) {
                    input = Main.getInArgumentPath(path2);
                    if (!input.exists()) {
                        System.err.println("Resource folder " + input + " does not exist.");
                        return 5;
                    }
                    List<File> resources = this.flags.getResourcesOverride();
                    if (resources == null) {
                        resources = new ArrayList<File>();
                        this.flags.setResourcesOverride(resources);
                    }
                    resources.add(input);
                }
                continue;
            }
            if (arg.equals(ARG_LIBRARIES)) {
                if (index == args.length - 1) {
                    System.err.println("Missing library folder name");
                    return 5;
                }
                paths = args[++index];
                for (String path2 : Lint.splitPath((String)paths)) {
                    input = Main.getInArgumentPath(path2);
                    if (!input.exists()) {
                        System.err.println("Library " + input + " does not exist.");
                        return 5;
                    }
                    List<File> libraries = this.flags.getLibrariesOverride();
                    if (libraries == null) {
                        libraries = new ArrayList<File>();
                        this.flags.setLibrariesOverride(libraries);
                    }
                    libraries.add(input);
                }
                continue;
            }
            if (arg.equals(ARG_BUILD_API)) {
                if (index == args.length - 1) {
                    System.err.println("Missing compileSdkVersion");
                    return 5;
                }
                version = args[++index];
                this.flags.setCompileSdkVersionOverride(version);
                continue;
            }
            if (arg.equals(ARG_JAVA_LANGUAGE_LEVEL)) {
                LanguageLevel level;
                if (index == args.length - 1) {
                    System.err.println("Missing Java language level");
                    return 5;
                }
                if ((level = LanguageLevel.parse((String)(version = args[++index]))) == null) {
                    System.err.println("Invalid Java language level \"" + version + "\"");
                    return 5;
                }
                argumentState.javaLanguageLevel = level;
                continue;
            }
            if (arg.equals(ARG_KOTLIN_LANGUAGE_LEVEL)) {
                LanguageVersion languageLevel;
                if (index == args.length - 1) {
                    System.err.println("Missing Kotlin language level");
                    return 5;
                }
                if ((languageLevel = LanguageVersion.fromVersionString((String)(version = args[++index]))) == null) {
                    System.err.println("Invalid Kotlin language level \"" + version + "\"");
                    return 5;
                }
                ApiVersion apiVersion = ApiVersion.createByLanguageVersion((LanguageVersion)languageLevel);
                argumentState.kotlinLanguageLevel = new LanguageVersionSettingsImpl(languageLevel, apiVersion);
                continue;
            }
            if (arg.equals(ARG_PROJECT)) {
                if (index == args.length - 1) {
                    System.err.println("Missing project description file");
                    return 5;
                }
                paths = args[++index];
                for (String path2 : Lint.splitPath((String)paths)) {
                    input = Main.getInArgumentPath(path2);
                    if (!input.exists()) {
                        System.err.println("Project descriptor " + input + " does not exist.");
                        return 5;
                    }
                    if (!input.isFile()) {
                        System.err.println("Project descriptor " + input + " should be an XML descriptor file" + (input.isDirectory() ? ", not a directory" : ""));
                        return 5;
                    }
                    File descriptor = this.flags.getProjectDescriptorOverride();
                    if (descriptor != null) {
                        System.err.println("Project descriptor should only be specified once");
                        return 5;
                    }
                    this.flags.setProjectDescriptorOverride(input);
                }
                continue;
            }
            if (arg.equals(ARG_VARIANT)) {
                if (index == args.length - 1) {
                    System.err.println("Missing variant name after --variant");
                    return 5;
                }
                argumentState.variantName = args[++index];
                continue;
            }
            if (arg.equals(ARG_PATH_VARIABLES)) {
                if (index == args.length - 1) {
                    System.err.println("Missing path variable descriptor  after --path-variables");
                    return 5;
                }
                if (argumentState.pathVariables != null) {
                    System.err.println("--path-variables must be specified before --lint-model and only once");
                    return 5;
                }
                paths = args[++index];
                argumentState.pathVariables = PathVariables.Companion.parse(paths);
                continue;
            }
            if (arg.equals(ARG_LINT_MODEL)) {
                if (index == args.length - 1) {
                    System.err.println("Missing lint model argument after --lint-model");
                    return 5;
                }
                paths = args[++index];
                for (String path2 : Lint.splitPath((String)paths)) {
                    input = Main.getInArgumentPath(path2);
                    if (!input.exists()) {
                        System.err.println("Lint model " + input + " does not exist.");
                        return 5;
                    }
                    if (!input.isDirectory()) {
                        System.err.println("Lint model " + input + " should be a folder containing the XML descriptor files" + (input.isDirectory() ? ", not a file" : ""));
                        return 5;
                    }
                    if (argumentState.pathVariables == null) {
                        argumentState.pathVariables = new PathVariables();
                    }
                    try {
                        LintModelSerialization reader = LintModelSerialization.INSTANCE;
                        LintModelModule module = reader.readModule(input, null, true, argumentState.pathVariables);
                        argumentState.modules.add(module);
                    }
                    catch (Throwable error) {
                        System.err.println("Could not deserialize " + input + " to a lint model: " + error.toString());
                        return 5;
                    }
                }
                continue;
            }
            if (arg.equals(ARG_LINT_RULE_JARS)) {
                if (index == args.length - 1) {
                    System.err.println("Missing lint rule jar");
                    return 5;
                }
                ArrayList<File> lintRuleJarsOverride = new ArrayList<File>();
                List<File> currentOverrides = this.flags.getLintRuleJarsOverride();
                if (currentOverrides != null) {
                    lintRuleJarsOverride.addAll(currentOverrides);
                }
                for (String path3 : Lint.splitPath((String)args[++index])) {
                    lintRuleJarsOverride.add(Main.getInArgumentPath(path3));
                }
                this.flags.setLintRuleJarsOverride(lintRuleJarsOverride);
                continue;
            }
            if (arg.equals(ARG_SDK_HOME)) {
                if (index == args.length - 1) {
                    System.err.println("Missing SDK home directory");
                    return 5;
                }
                this.sdkHome = new File(args[++index]);
                if (this.sdkHome.isDirectory()) continue;
                System.err.println(this.sdkHome + " is not a directory");
                return 5;
            }
            if (arg.equals(ARG_JDK_HOME)) {
                if (index == args.length - 1) {
                    System.err.println("Missing JDK home directory");
                    return 5;
                }
                this.jdkHome = new File(args[++index]);
                if (!this.jdkHome.isDirectory()) {
                    System.err.println(this.jdkHome + " is not a directory");
                    return 5;
                }
                if (Lint.isJreFolder((File)this.jdkHome)) continue;
                System.err.println(this.jdkHome + " is not a JRE/JDK");
                return 5;
            }
            if (arg.equals(ARG_BASELINE)) {
                if (index == args.length - 1) {
                    System.err.println("Missing baseline file path");
                    return 5;
                }
                path = args[++index];
                File input2 = Main.getInArgumentPath(path);
                this.flags.setBaselineFile(input2);
                continue;
            }
            if (arg.equals(ARG_CACHE_DIR)) {
                if (index == args.length - 1) {
                    System.err.println("Missing cache directory");
                    return 5;
                }
                path = args[++index];
                File input3 = Main.getInArgumentPath(path);
                this.flags.setCacheDir(input3);
                continue;
            }
            if (arg.equals(ARG_REMOVE_FIXED)) {
                if (this.flags.isUpdateBaseline()) {
                    System.err.printf(Locale.US, "Cannot use both %s and %s.%n", ARG_REMOVE_FIXED, ARG_UPDATE_BASELINE);
                }
                this.flags.setRemovedFixedBaselineIssues(true);
                continue;
            }
            if (arg.equals(ARG_UPDATE_BASELINE)) {
                if (this.flags.isRemoveFixedBaselineIssues()) {
                    System.err.printf(Locale.US, "Cannot use both %s and %s.%n", ARG_UPDATE_BASELINE, ARG_REMOVE_FIXED);
                }
                this.flags.setUpdateBaseline(true);
                continue;
            }
            if (arg.equals(ARG_CONTINUE_AFTER_BASELINE_CREATED)) {
                this.flags.setContinueAfterBaselineCreated(true);
                continue;
            }
            if (arg.equals(ARG_WRITE_REF_BASELINE)) {
                if (index == args.length - 1) {
                    System.err.println("Missing baseline file path");
                    return 5;
                }
                path = args[++index];
                File output3 = Main.getOutArgumentPath(path);
                this.flags.setOutputBaselineFile(output3);
                this.flags.setUpdateBaseline(true);
                this.flags.setContinueAfterBaselineCreated(true);
                continue;
            }
            if (arg.equals(ARG_ALLOW_SUPPRESS)) {
                this.flags.setAllowSuppress(true);
                continue;
            }
            if (arg.equals(ARG_RESTRICT_SUPPRESS)) {
                this.flags.setAllowSuppress(false);
                continue;
            }
            if (arg.equals("--XallowBaselineSuppress")) {
                this.flags.setAllowBaselineSuppress(true);
                continue;
            }
            if (arg.equals("--Xdesugared-methods")) {
                File input4;
                if (index == args.length - 1) {
                    System.err.println("Missing desugared methods file");
                    return 5;
                }
                if (!(input4 = Main.getInArgumentPath(path = args[++index])).isFile()) {
                    System.err.println("Desugared methods file " + input4 + " does not exist.");
                    return 5;
                }
                DesugaredMethodLookup.Companion.setDesugaredMethods(FilesKt.readText((File)input4, (Charset)StandardCharsets.UTF_8));
                continue;
            }
            if (arg.equals(ARG_PRINT_INTERNAL_ERROR_STACKTRACE)) {
                this.flags.setPrintInternalErrorStackTrace(true);
                continue;
            }
            if (arg.equals(ARG_ANALYZE_ONLY)) {
                argumentState.mode = LintDriver.DriverMode.ANALYSIS_ONLY;
                continue;
            }
            if (arg.equals(ARG_REPORT_ONLY)) {
                argumentState.mode = LintDriver.DriverMode.MERGE;
                continue;
            }
            if (arg.equals(ARG_CLIENT_ID)) {
                if (index == args.length - 1) {
                    System.err.println("Missing client id");
                    return 5;
                }
                LintClient.setClientName((String)args[++index]);
                continue;
            }
            if (arg.equals(ARG_CLIENT_NAME)) {
                if (index == args.length - 1) {
                    System.err.println("Missing client name");
                    return 5;
                }
                argumentState.clientName = args[++index];
                continue;
            }
            if (arg.equals(ARG_CLIENT_VERSION)) {
                if (index == args.length - 1) {
                    System.err.println("Missing client version");
                    return 5;
                }
                argumentState.clientVersion = args[++index];
                continue;
            }
            if (arg.equals(ARG_GENERATE_DOCS)) {
                if (index != 0) {
                    System.err.println("--generate-docs cannot be used in combination with other flags.");
                    Main.printUsage(System.err);
                    return 5;
                }
                return LintIssueDocGenerator.run(Arrays.copyOfRange(args, 1, args.length), true);
            }
            if (arg.startsWith("--")) {
                System.err.println("Invalid argument " + arg + "\n");
                Main.printUsage(System.err);
                return 5;
            }
            file = Main.getInArgumentPath(arg);
            if (!file.exists()) {
                System.err.printf("%1$s does not exist.%n", arg);
                return 3;
            }
            argumentState.files.add(file);
        }
        List<LintModelModule> modules = argumentState.modules;
        List<File> files = argumentState.files;
        if (!modules.isEmpty()) {
            if (!files.isEmpty()) {
                System.err.println("Do not specify both files and lint models: lint models should instead include the files");
                return 5;
            }
            SyncOptions.syncTo(modules.get(0), this.flags);
        }
        if (files.isEmpty() && modules.isEmpty() && this.flags.getProjectDescriptorOverride() == null) {
            System.err.println("No files to analyze.");
            return 5;
        }
        if (files.size() > 1 && (this.flags.getClassesOverride() != null || this.flags.getSourcesOverride() != null || this.flags.getLibrariesOverride() != null || this.flags.getResourcesOverride() != null)) {
            System.err.printf("The %1$s, %2$s, %3$s and %4$s arguments can only be used with a single project%n", ARG_SOURCES, ARG_CLASSES, ARG_LIBRARIES, ARG_RESOURCES);
            return 5;
        }
        return 100;
    }

    private void initializeConfigurations(LintCliClient client, ArgumentState argumentState) {
        ConfigurationHierarchy configurations = client.getConfigurations();
        File overrideConfig = this.flags.getOverrideLintConfig();
        if (overrideConfig != null) {
            LintXmlConfiguration config = LintXmlConfiguration.create((ConfigurationHierarchy)configurations, (File)overrideConfig);
            configurations.addGlobalConfigurations(null, (Configuration)config);
        }
        CliConfiguration override = new CliConfiguration(configurations, this.flags, this.flags.isFatalOnly());
        File defaultConfiguration = this.flags.getLintConfig();
        configurations.addGlobalConfigurationFromFile(defaultConfiguration, (Configuration)override);
        client.syncConfigOptions();
        if (!argumentState.modules.isEmpty()) {
            File dir = argumentState.modules.get(0).getDir();
            override.setAssociatedLocation(Location.create((File)dir));
        }
    }

    private int initializeReporters(LintCliClient client, ArgumentState argumentState) {
        String urlMap = argumentState.urlMap;
        List<Reporter> reporters = this.flags.getReporters();
        if (reporters.isEmpty()) {
            if (urlMap != null) {
                System.err.printf("Warning: The %1$s option only applies to HTML reports (%2$s)%n", ARG_URL, ARG_HTML);
            }
            reporters.add(new TextReporter(client, this.flags, new PrintWriter(System.out, true), false));
        } else if (urlMap != null && !urlMap.equals("none")) {
            HashMap<String, String> map = new HashMap<String, String>();
            String[] replace = urlMap.split(",");
            for (String s : replace) {
                int index = s.indexOf(61);
                if (index == -1) {
                    System.err.println("The URL map argument must be of the form 'path_prefix=url_prefix'");
                    return 5;
                }
                String key = s.substring(0, index);
                String value = s.substring(index + 1);
                map.put(key, value);
            }
            for (Reporter reporter : reporters) {
                reporter.setUrlMap(map);
            }
        }
        return 100;
    }

    private static LintRequest createLintRequest(LintCliClient client, ArgumentState argumentState) {
        LintRequest lintRequest;
        List<LintModelModule> modules = argumentState.modules;
        if (!modules.isEmpty()) {
            ArrayList<LintModelModuleProject> projects = new ArrayList<LintModelModuleProject>();
            for (LintModelModule module : modules) {
                File dir = module.getDir();
                LintModelVariant variant = null;
                String variantName = argumentState.variantName;
                if (variantName != null && (variant = module.findVariant(variantName)) == null) {
                    System.err.println("Warning: Variant " + variantName + " not found in lint model for " + dir);
                }
                if (variant == null) {
                    variant = module.defaultVariant();
                }
                assert (variant != null);
                LintModelModuleProject project = new LintModelModuleProject((LintClient)client, dir, dir, variant, null);
                client.registerProject(project.getDir(), (Project)project);
                projects.add(project);
            }
            boolean isReporting = argumentState.mode == LintDriver.DriverMode.MERGE;
            List roots = LintModelModuleProject.resolveDependencies(projects, (boolean)isReporting);
            lintRequest = new LintRequest((LintClient)client, Collections.emptyList());
            lintRequest.setProjects((Collection)roots);
            if (isReporting) {
                EnumSet platforms = ((LintModelModuleProject)roots.get(0)).isAndroidProject() ? Platform.ANDROID_SET : Platform.JDK_SET;
                lintRequest.setPlatform(platforms);
            }
        } else {
            lintRequest = client.createLintRequest(argumentState.files);
        }
        return lintRequest;
    }

    private int run(LintCliClient client, LintRequest lintRequest, ArgumentState argumentState) {
        try {
            switch (argumentState.mode) {
                case GLOBAL: {
                    return client.run((IssueRegistry)new BuiltinIssueRegistry(), lintRequest);
                }
                case ANALYSIS_ONLY: {
                    return client.analyzeOnly((IssueRegistry)new BuiltinIssueRegistry(), lintRequest);
                }
                case MERGE: {
                    return client.mergeOnly((IssueRegistry)new BuiltinIssueRegistry(), lintRequest);
                }
            }
            throw new IllegalStateException("Unexpected value: " + argumentState.mode);
        }
        catch (IOException e) {
            this.log(e, null, new Object[0]);
            return 5;
        }
    }

    private static void setSeverity(LintCliFlags flags, IssueRegistry registry, String idString, Set<String> targetSet, Severity severity) {
        String[] ids;
        for (String id : ids = idString.split(",")) {
            if (registry.isCategoryName(id)) {
                for (Issue issue : registry.getIssues()) {
                    if (!issue.getCategory().getName().startsWith(id) && !issue.getCategory().getFullName().startsWith(id)) continue;
                    Main.setSeverity(flags, id, targetSet, severity);
                }
                continue;
            }
            Issue issue = registry.getIssue(id);
            if (issue != null) {
                id = issue.getId();
            }
            Main.setSeverity(flags, id, targetSet, severity);
        }
    }

    private static void setSeverity(LintCliFlags flags, String id, Set<String> targetSet, Severity severity) {
        if (targetSet != null) {
            assert (severity == null);
            targetSet.add(id);
        } else {
            assert (severity != null);
            HashMap<String, LintModelSeverity> map = new HashMap<String, LintModelSeverity>(flags.getSeverityOverrides());
            map.put(id, SeverityKt.getModelSeverity((Severity)severity));
            flags.setSeverityOverrides(map);
        }
    }

    private IssueRegistry getGlobalRegistry(LintCliClient client) {
        if (this.globalIssueRegistry == null) {
            this.globalIssueRegistry = client.addCustomLintRules((IssueRegistry)new BuiltinIssueRegistry(), null, false);
        }
        return this.globalIssueRegistry;
    }

    private static File getInArgumentPath(String filename) {
        File file = new File(filename);
        if (!file.isAbsolute()) {
            File file2;
            File workDir = Main.getLintWorkDir();
            if (workDir != null && (file2 = new File(workDir, filename)).exists()) {
                try {
                    file = file2.getCanonicalFile();
                }
                catch (IOException e) {
                    file = file2;
                }
            }
            if (!file.isAbsolute()) {
                file = file.getAbsoluteFile();
            }
        }
        return file;
    }

    private static File getOutArgumentPath(String filename) {
        File file = new File(filename);
        if (!file.isAbsolute()) {
            File workDir = Main.getLintWorkDir();
            if (workDir != null) {
                File file2 = new File(workDir, filename);
                try {
                    file = file2.getCanonicalFile();
                }
                catch (IOException e) {
                    file = file2;
                }
            }
            if (!file.isAbsolute()) {
                file = file.getAbsoluteFile();
            }
        }
        return file;
    }

    private static File getLintWorkDir() {
        if (LintClient.isGradle()) {
            return null;
        }
        String path = System.getProperty(PROP_WORK_DIR);
        if (path == null || path.isEmpty()) {
            path = System.getenv(PROP_WORK_DIR);
        }
        if (path != null && !path.isEmpty()) {
            return new File(path);
        }
        return null;
    }

    private static void printHelpTopicSuppress() {
        System.out.println(Main.wrap(TextFormat.RAW.convertTo(Main.getSuppressHelp(), TextFormat.TEXT)));
    }

    static String getSuppressHelp() {
        return "Lint errors can be suppressed in a variety of ways:\n\n1. With a `@SuppressLint` annotation in the Java code\n2. With a `tools:ignore` attribute in the XML file\n3. With a //noinspection comment in the source code\n4. With ignore flags specified in the `build.gradle` file, as explained below\n5. With a `lint.xml` configuration file in the project\n6. With a `lint.xml` configuration file passed to lint via the --config flag\n7. With the --ignore flag passed to lint.\n\nTo suppress a lint warning with an annotation, add a `@SuppressLint(\"id\")` annotation on the class, method or variable declaration closest to the warning instance you want to disable. The id can be one or more issue id's, such as `\"UnusedResources\"` or `{\"UnusedResources\",\"UnusedIds\"}`, or it can be `\"all\"` to suppress all lint warnings in the given scope.\n\nTo suppress a lint warning with a comment, add a `//noinspection id` comment on the line before the statement with the error.\n\nTo suppress a lint warning in an XML file, add a `tools:ignore=\"id\"` attribute on the element containing the error, or one of its surrounding elements. You also need to define the namespace for the tools prefix on the root element in your document, next to the `xmlns:android` declaration:\n`xmlns:tools=\"http://schemas.android.com/tools\"`\n\nTo suppress a lint warning in a `build.gradle` file, add a section like this:\n\n```gradle\nandroid {\n    lintOptions {\n        disable 'TypographyFractions','TypographyQuotes'\n    }\n}\n```\n\nHere we specify a comma separated list of issue id's after the disable command. You can also use `warning` or `error` instead of `disable` to change the severity of issues.\n\nTo suppress lint warnings with a configuration XML file, create a file named `lint.xml` and place it at the root directory of the module in which it applies.\n\nThe format of the `lint.xml` file is something like the following:\n\n```xml\n<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<lint>\n    <!-- Ignore everything in the test source set -->\n    <issue id=\"all\">\n        <ignore path=\"\\*/test/\\*\" />\n    </issue>\n\n    <!-- Disable this given check in this project -->\n    <issue id=\"IconMissingDensityFolder\" severity=\"ignore\" />\n\n    <!-- Ignore the ObsoleteLayoutParam issue in the given files -->\n    <issue id=\"ObsoleteLayoutParam\">\n        <ignore path=\"res/layout/activation.xml\" />\n        <ignore path=\"res/layout-xlarge/activation.xml\" />\n        <ignore regexp=\"(foo|bar)\\.java\" />\n    </issue>\n\n    <!-- Ignore the UselessLeaf issue in the given file -->\n    <issue id=\"UselessLeaf\">\n        <ignore path=\"res/layout/main.xml\" />\n    </issue>\n\n    <!-- Change the severity of hardcoded strings to \"error\" -->\n    <issue id=\"HardcodedText\" severity=\"error\" />\n</lint>\n```\n\nTo suppress lint checks from the command line, pass the --ignore flag with a comma separated list of ids to be suppressed, such as:\n`$ lint --ignore UnusedResources,UselessLeaf /my/project/path`\n\nFor more information, see https://developer.android.com/studio/write/lint.html#config\n";
    }

    private static void printVersion(LintCliClient client) {
        String revision = client.getClientDisplayRevision();
        if (revision != null) {
            System.out.printf("lint: version %1$s%n", revision);
        } else {
            System.out.println("lint: unknown version");
        }
    }

    private static void displayValidIds(IssueRegistry registry, PrintStream out) {
        List categories2 = registry.getCategories();
        out.println("Valid issue categories:");
        for (Category category : categories2) {
            out.println("    " + category.getFullName());
        }
        out.println();
        List issues = registry.getIssues();
        out.println("Valid issue id's:");
        for (Issue issue : issues) {
            Main.listIssue(out, issue);
        }
    }

    private static void listIssue(PrintStream out, Issue issue) {
        out.print(Main.wrapArg("\"" + issue.getId() + "\": " + issue.getBriefDescription(TextFormat.TEXT)));
    }

    private static void showIssues(IssueRegistry registry) {
        List issues = registry.getIssues();
        ArrayList sorted = new ArrayList(issues);
        sorted.sort((issue1, issue2) -> {
            int d = issue1.getCategory().compareTo(issue2.getCategory());
            if (d != 0) {
                return d;
            }
            d = issue2.getPriority() - issue1.getPriority();
            if (d != 0) {
                return d;
            }
            return issue1.getId().compareTo(issue2.getId());
        });
        System.out.println("Available issues:\n");
        Category previousCategory = null;
        for (Issue issue : sorted) {
            Category category = issue.getCategory();
            if (!category.equals(previousCategory)) {
                String name = category.getFullName();
                System.out.println(name);
                int n = name.length();
                for (int i = 0; i < n; ++i) {
                    System.out.print('=');
                }
                System.out.println('\n');
                previousCategory = category;
            }
            Main.describeIssue(issue);
            System.out.println();
        }
    }

    private static void describeIssue(Issue issue) {
        List moreInfo;
        System.out.println(issue.getId());
        for (int i = 0; i < issue.getId().length(); ++i) {
            System.out.print('-');
        }
        System.out.println();
        System.out.println(Main.wrap("Summary: " + issue.getBriefDescription(TextFormat.TEXT)));
        System.out.println("Priority: " + issue.getPriority() + " / 10");
        System.out.println("Severity: " + issue.getDefaultSeverity().getDescription());
        System.out.println("Category: " + issue.getCategory().getFullName());
        Vendor vendor = issue.getVendor();
        IssueRegistry registry = issue.getRegistry();
        if (vendor == null && registry != null) {
            vendor = registry.getVendor();
        }
        if (vendor != null) {
            String description = vendor.describe(TextFormat.TEXT);
            System.out.print(description);
        }
        if (!issue.isEnabledByDefault()) {
            System.out.println("NOTE: This issue is disabled by default!");
            System.out.printf("You can enable it by adding %1$s %2$s%n", ARG_ENABLE, issue.getId());
        }
        System.out.println();
        System.out.println(Main.wrap(issue.getExplanation(TextFormat.TEXT)));
        List options = issue.getOptions();
        if (!options.isEmpty()) {
            System.out.println(Option.Companion.describe(options, TextFormat.TEXT, true));
            System.out.println();
        }
        if (!(moreInfo = issue.getMoreInfo()).isEmpty()) {
            System.out.println("More information: ");
            for (String uri : moreInfo) {
                System.out.println(uri);
            }
        }
    }

    static String wrapArg(String explanation) {
        return Main.wrap(explanation, 78, "      ");
    }

    static String wrap(String explanation) {
        return Main.wrap(explanation, 78, "");
    }

    static String wrap(String explanation, int lineWidth, String hangingIndent) {
        return SdkUtils.wrap((String)explanation, (int)lineWidth, (String)hangingIndent);
    }

    private static void printUsage(PrintStream out) {
        String command = "lint";
        out.println("Usage: " + command + " [flags] <project directories>\n");
        out.println("Flags:\n");
        Main.printUsage(out, new String[]{ARG_HELP, "This message.", "--help <topic>", "Help on the given topic, such as \"suppress\".", ARG_LIST_IDS, "List the available issue id's and exit.", ARG_VERSION, "Output version information and exit.", ARG_EXIT_CODE, "Set the exit code to 1 if errors are found.", ARG_SHOW, "List available issues along with full explanations.", "--show <ids>", "Show full explanations for the given list of issue id's.", ARG_GENERATE_DOCS, "Generates documentation for all the lint checks. This flag cannot be combined with other lint flags, and it has its own sub-flags. Invoke on its own to see what they are.", ARG_FATAL_ONLY, "Only check for fatal severity issues", ARG_AUTO_FIX, "Apply suggestions to the source code (for safe fixes)", ARG_ABORT_IF_SUGGESTIONS_APPLIED, "Set the exit code to an error if any fixes are applied", "", "\nEnabled Checks:", "--disable <list>", "Disable the list of categories or specific issue id's. The list should be a comma-separated list of issue id's or categories.", "--enable <list>", "Enable the specific list of issues. This checks all the default issues plus the specifically enabled issues. The list should be a comma-separated list of issue id's or categories.", "--check <list>", "Only check the specific list of issues. This will disable everything and re-enable the given list of issues. The list should be a comma-separated list of issue id's or categories.", "--fatal <list>", "Sets the default severity of the given issue to fatal", "--error <list>", "Sets the default severity of the given issue to error", "--warning <list>", "Sets the default severity of the given issue to warning", "--info <list>", "Sets the default severity of the given issue to info", "-w, --nowarn", "Only check for errors (ignore warnings)", ARG_WARN_ALL, "Check all warnings, including those off by default", ARG_ALL_ERROR, "Treat all warnings as errors", "--config <filename>", "Use the given configuration file to determine whether issues are enabled or disabled. If a project contains a lint.xml file, then this config file will be used as a fallback.", "--override-config <filename>", "Like --config, but instead of being a fallback, this configuration overrides any local configuration files", ARG_BASELINE, "Use (or create) the given baseline file to filter out known issues.", ARG_UPDATE_BASELINE, "Updates the baselines even if they already exist", ARG_REMOVE_FIXED, "Rewrite the baseline files to remove any issues that have been fixed", ARG_WRITE_REF_BASELINE, "Writes the current results, including issues that were filtered from the input baseline if any. Does not set the exit code to indicate that the baseline is created the way --baseline would. Implies --update-baseline and --continue-after-baseline-created.", ARG_ALLOW_SUPPRESS, "Whether to allow suppressing issues that have been explicitly registered as not suppressible.", ARG_RESTRICT_SUPPRESS, "Opposite of --allow-suppress: do not allow suppressing restricted issues", "", "\nOutput Options:", ARG_QUIET, "Don't show progress.", ARG_PRINT_INTERNAL_ERROR_STACKTRACE, "Print full stacktrace for internal errors.", ARG_FULL_PATH, "Use full paths in the error output.", ARG_SHOW_ALL, "Do not truncate long messages, lists of alternate locations, etc.", ARG_NO_LINES, "Do not include the source file lines with errors in the output. By default, the error output includes snippets of source code on the line containing the error, but this flag turns it off.", "--html <filename>", "Create an HTML report instead. If the filename is a directory (or a new filename without an extension), lint will create a separate report for each scanned project.", "--url filepath=url", "Add links to HTML report, replacing local path prefixes with url prefix. The mapping can be a comma-separated list of path prefixes to corresponding URL prefixes, such as C:\\temp\\Proj1=http://buildserver/sources/temp/Proj1.  To turn off linking to files, use --url none", "--xml <filename>", "Create an XML report instead.", "--sarif <filename>", "Create a SARIF report instead.", "--text <filename>", "Write a text report to the given file. If the filename is just `stdout` (short for standard out), the report is written to the console.", "", "\nProject Options:", "--resources <dir>", "Add the given folder (or path) as a resource directory for the project. Only valid when running lint on a single project.", "--sources <dir>", "Add the given folder (or path) as a source directory for the project. Only valid when running lint on a single project.", "--classpath <dir>", "Add the given folder (or jar file, or path) as a class directory for the project. Only valid when running lint on a single project.", "--libraries <dir>", "Add the given folder (or jar file, or path) as a class library for the project. Only valid when running lint on a single project.", "--compile-sdk-version <version>", "Use the given compileSdkVersion to pick an SDK target to resolve Android API call to", "--sdk-home <dir>", "Use the given SDK instead of attempting to find it relative to the lint installation or via $ANDROID_SDK_ROOT", "--jdk-home <dir>", "Use the given JDK instead of attempting to find it via $JAVA_HOME or java.home", "--java-language-level <level>", "Use the given version of the Java programming language", "--kotlin-language-level <level>", "Use the given version of the Kotlin programming language", "", "\nAdvanced Options (for build system integration):", "--project <file>", "Use the given project layout descriptor file to describe the set of available sources, resources and libraries. Used to drive lint with build systems not natively integrated with lint.", "--lint-model <path>", "Alternative to --project which defines the project layout", "--variant <name>", "The name of the variant from the lint model to use for analysis", "--lint-rule-jars <path>", "One or more .jar files to load additional lint checks from", ARG_ANALYZE_ONLY, "Perform only analysis, not reporting, of the given lint model", ARG_REPORT_ONLY, "Perform only reporting of previous analysis results", "--path-variables <variables>", "Path variables to use in internal persistence files to make lint results cacheable. Use a semi-colon separated list of name=path pairs.", "--describe-suggestions <file>", "Describes all the quickfixes in an XML file expressed as document edits -- insert, replace, delete", ARG_CLIENT_ID, "Sets the id of the client, such as \"gradle\"", ARG_CLIENT_NAME, "Sets the display name of the client, such as \"Android Gradle Plugin\"", ARG_CLIENT_VERSION, "Sets the version of the client, such as 7.1.0-alpha01", "", "\nExit Status:", Integer.toString(0), "Success.", Integer.toString(1), "Lint errors detected.", Integer.toString(2), "Lint usage.", Integer.toString(3), "Cannot clobber existing file.", Integer.toString(4), "Lint help.", Integer.toString(5), "Invalid command-line argument.", Integer.toString(6), "A new baseline file was created.", Integer.toString(7), "Quickfixes were applied."});
    }

    static void printUsage(PrintStream out, String[] args) {
        boolean md = false;
        int argWidth = 0;
        for (int i = 0; i < args.length; i += 2) {
            String arg = args[i];
            argWidth = Math.max(argWidth, arg.length());
        }
        argWidth += 2;
        StringBuilder sb = new StringBuilder(20);
        for (int i = 0; i < argWidth; ++i) {
            sb.append(' ');
        }
        String indent = sb.toString();
        String formatString = "%1$-" + argWidth + "s%2$s";
        for (int i = 0; i < args.length; i += 2) {
            String arg = args[i];
            String description = args[i + 1];
            if (md) {
                if (arg.isEmpty()) {
                    out.print("## ");
                    out.println(StringsKt.removeSuffix((String)description.trim(), (CharSequence)":"));
                    out.println();
                    continue;
                }
                out.print("`");
                int index = arg.indexOf(32);
                if (index != -1) {
                    out.print(arg.substring(0, index));
                    out.print("` ");
                    String remainder = arg.substring(index + 1);
                    remainder = remainder.replace('<', '*').replace('>', '*');
                    out.print(remainder);
                } else {
                    out.print(arg);
                    out.print('`');
                }
                out.println();
                out.print(Main.wrap(": " + description, 70, "  "));
                out.println("");
                continue;
            }
            if (arg.isEmpty()) {
                out.println(description);
                continue;
            }
            out.print(Main.wrap(String.format(formatString, arg, description), 78, indent));
        }
    }

    public void log(Throwable exception, String format, Object ... args) {
        System.out.flush();
        if (format != null) {
            System.err.println(String.format(format, args));
        }
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    class MainLintClient
    extends LintCliClient {
        final ArgumentState argumentState;
        private Project unexpectedGradleProject;
        private ProjectMetadata metadata;

        MainLintClient(LintCliFlags flags, ArgumentState argumentState) {
            super(flags, "cli");
            this.unexpectedGradleProject = null;
            this.argumentState = argumentState;
            PathVariables pathVariables = this.getPathVariables();
            if (argumentState.pathVariables != null) {
                pathVariables.add(argumentState.pathVariables);
                pathVariables.normalize();
            }
        }

        public boolean supportsPartialAnalysis() {
            return this.argumentState.mode != LintDriver.DriverMode.GLOBAL;
        }

        public String getClientDisplayName() {
            String name = this.argumentState.clientName;
            if (name != null) {
                String version = this.argumentState.clientVersion;
                if (version != null && !name.contains(version)) {
                    return name + " (" + version + ")";
                }
                return name;
            }
            return super.getClientDisplayName();
        }

        @Override
        protected LintDriver createDriver(IssueRegistry registry, LintRequest request) {
            LintDriver driver = super.createDriver(registry, request);
            Project project = this.unexpectedGradleProject;
            if (project != null) {
                String message2 = String.format("\"`%1$s`\" is a Gradle project. To correctly analyze Gradle projects, you should run \"`gradlew lint`\" instead.", project.getName());
                Location location = Lint.guessGradleLocation((LintClient)this, (File)project.getDir(), null);
                LintClient.Companion.report((LintClient)this, IssueRegistry.LINT_ERROR, message2, driver, project, location, null);
            }
            Main.this.initializeDriver(driver);
            return driver;
        }

        public PathVariables getPathVariables() {
            PathVariables pathVariables = this.argumentState.pathVariables;
            if (pathVariables != null) {
                return pathVariables;
            }
            return super.getPathVariables();
        }

        @Override
        protected Project createProject(File dir, File referenceDir) {
            Project project = super.createProject(dir, referenceDir);
            if (project.isGradleProject()) {
                this.unexpectedGradleProject = project;
            }
            return project;
        }

        public LanguageLevel getJavaLanguageLevel(Project project) {
            LanguageLevel level = this.argumentState.javaLanguageLevel;
            if (level != null) {
                return level;
            }
            return super.getJavaLanguageLevel(project);
        }

        public LanguageVersionSettings getKotlinLanguageLevel(Project project) {
            LanguageVersionSettings settings = this.argumentState.kotlinLanguageLevel;
            if (settings != null) {
                return settings;
            }
            return super.getKotlinLanguageLevel(project);
        }

        public Configuration getConfiguration(Project project, LintDriver driver) {
            if (project.isGradleProject() && !(project instanceof LintModelModuleProject)) {
                ConfigurationHierarchy configurations = this.getConfigurations();
                configurations.setOverrides(null);
                configurations.setFallback(null);
                return new CliConfiguration(configurations, Main.this.flags, true){

                    public Severity getDefinedSeverity(Issue issue, Configuration source, Severity visibleDefault) {
                        return issue == IssueRegistry.LINT_ERROR ? Severity.FATAL : Severity.IGNORE;
                    }

                    public boolean isIgnored(Context context, Incident incident) {
                        Issue issue = incident.getIssue();
                        if (issue == IssueRegistry.LINT_ERROR && new LintCliClient(Main.this.flags, LintClient.getClientName()).isSuppressed(IssueRegistry.LINT_ERROR)) {
                            return true;
                        }
                        if (issue == IssueRegistry.LINT_WARNING && new LintCliClient(Main.this.flags, LintClient.getClientName()).isSuppressed(IssueRegistry.LINT_WARNING)) {
                            return true;
                        }
                        return issue != IssueRegistry.LINT_ERROR && issue != IssueRegistry.LINT_WARNING;
                    }
                };
            }
            return super.getConfiguration(project, driver);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private byte[] readSrcJar(File file) {
            block18: {
                File jarFile;
                String path = file.getPath();
                int srcJarIndex = path.indexOf("srcjar!");
                if (srcJarIndex != -1 && (jarFile = new File(path.substring(0, srcJarIndex + 6))).exists()) {
                    try (ZipFile zipFile = new ZipFile(jarFile);){
                        byte[] byArray;
                        block19: {
                            String name = path.substring(srcJarIndex + 8).replace(File.separatorChar, '/');
                            ZipEntry entry = zipFile.getEntry(name);
                            if (entry == null) break block18;
                            InputStream is = zipFile.getInputStream(entry);
                            try {
                                byArray = ByteStreams.toByteArray((InputStream)is);
                                if (is == null) break block19;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (is != null) {
                                        try {
                                            is.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (Exception e) {
                                    this.log(e, null, new Object[0]);
                                    break block18;
                                }
                            }
                            is.close();
                        }
                        return byArray;
                    }
                    catch (ZipException e) {
                        Main.this.log(e, "Could not unzip %1$s", jarFile);
                    }
                    catch (IOException e) {
                        Main.this.log(e, "Could not read %1$s", jarFile);
                    }
                }
            }
            return null;
        }

        @Override
        public CharSequence readFile(File file) {
            byte[] srcJarBytes = this.readSrcJar(file);
            if (srcJarBytes != null) {
                return new String(srcJarBytes, Charsets.UTF_8);
            }
            return super.readFile(file);
        }

        public byte[] readBytes(File file) throws IOException {
            byte[] srcJarBytes = this.readSrcJar(file);
            if (srcJarBytes != null) {
                return srcJarBytes;
            }
            return super.readBytes(file);
        }

        @Override
        protected void configureLintRequest(LintRequest request) {
            super.configureLintRequest(request);
            File descriptor = Main.this.flags.getProjectDescriptorOverride();
            if (descriptor != null) {
                List<Project> projects;
                this.metadata = ProjectInitializerKt.computeMetadata(this, descriptor);
                String clientName = this.metadata.getClientName();
                if (clientName != null) {
                    new LintCliClient(clientName);
                }
                if (!(projects = this.metadata.getProjects()).isEmpty()) {
                    request.setProjects(projects);
                    if (this.metadata.getSdk() != null) {
                        Main.this.sdkHome = this.metadata.getSdk();
                    }
                    if (this.metadata.getJdk() != null) {
                        Main.this.jdkHome = this.metadata.getJdk();
                    }
                    if (this.metadata.getBaseline() != null) {
                        Main.this.flags.setBaselineFile(this.metadata.getBaseline());
                    }
                    EnumSet scope = EnumSet.copyOf(Scope.ALL);
                    if (this.metadata.getIncomplete()) {
                        scope.remove(Scope.ALL_CLASS_FILES);
                        scope.remove(Scope.ALL_JAVA_FILES);
                        scope.remove(Scope.ALL_RESOURCE_FILES);
                    }
                    request.setScope(scope);
                    request.setPlatform(this.metadata.getPlatforms());
                }
            }
        }

        @Override
        public Iterable<File> findRuleJars(Project project) {
            List<File> jars;
            if (this.metadata != null && (jars = this.metadata.getLintChecks().get(project)) != null) {
                return jars;
            }
            return super.findRuleJars(project);
        }

        public List<File> findGlobalRuleJars(LintDriver driver, boolean warnDeprecated) {
            List<File> jars;
            if (this.metadata != null && !(jars = this.metadata.getGlobalLintChecks()).isEmpty()) {
                return jars;
            }
            return super.findGlobalRuleJars(driver, warnDeprecated);
        }

        @Override
        public File getCacheDir(String name, boolean create) {
            File dir;
            if (this.metadata != null && (dir = this.metadata.getCache()) != null) {
                if (name != null) {
                    dir = new File(dir, name);
                }
                if (create && !dir.exists() && !dir.mkdirs()) {
                    return null;
                }
                return dir;
            }
            return super.getCacheDir(name, create);
        }

        @Override
        public Document getMergedManifest(Project project) {
            File manifest;
            if (this.metadata != null && (manifest = this.metadata.getMergedManifests().get(project)) != null && manifest.exists()) {
                try {
                    return XmlUtils.parseUtfXmlFile((File)manifest, (boolean)true);
                }
                catch (IOException | SAXException e) {
                    this.log(e, "Could not read/parse %1$s", new Object[]{manifest});
                }
            }
            return super.getMergedManifest(project);
        }

        public File getSdkHome() {
            if (Main.this.sdkHome != null) {
                return Main.this.sdkHome;
            }
            return super.getSdkHome();
        }

        public File getJdkHome(Project project) {
            if (Main.this.jdkHome != null) {
                return Main.this.jdkHome;
            }
            return super.getJdkHome(project);
        }

        @Override
        protected boolean addBootClassPath(Collection<? extends Project> knownProjects, Set<File> files) {
            if (this.metadata != null && !this.metadata.getJdkBootClasspath().isEmpty()) {
                boolean isAndroid = false;
                for (Project project : knownProjects) {
                    if (!project.isAndroidProject()) continue;
                    isAndroid = true;
                    break;
                }
                if (!isAndroid) {
                    files.addAll(this.metadata.getJdkBootClasspath());
                    return true;
                }
                boolean ok = super.addBootClassPath(knownProjects, files);
                if (!ok) {
                    files.addAll(this.metadata.getJdkBootClasspath());
                }
                return ok;
            }
            return super.addBootClassPath(knownProjects, files);
        }

        public List<File> getExternalAnnotations(Collection<? extends Project> projects) {
            List externalAnnotations = super.getExternalAnnotations(projects);
            if (this.metadata != null) {
                externalAnnotations.addAll(this.metadata.getExternalAnnotations());
            }
            return externalAnnotations;
        }
    }

    static class ArgumentState {
        String clientVersion;
        String clientName;
        LanguageLevel javaLanguageLevel = null;
        LanguageVersionSettings kotlinLanguageLevel = null;
        List<LintModelModule> modules = new ArrayList<LintModelModule>();
        String variantName = null;
        String urlMap = null;
        List<File> files = new ArrayList<File>();
        LintDriver.DriverMode mode = LintDriver.DriverMode.GLOBAL;
        PathVariables pathVariables = null;

        ArgumentState() {
        }
    }
}

