/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintStatsKt;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Severity;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0013\u001a\u00020\u0003R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/LintStats;", "", "errorCount", "", "warningCount", "baselineErrorCount", "baselineWarningCount", "baselineFixedCount", "autoFixedCount", "hasAutoFixCount", "(IIIIIII)V", "getAutoFixedCount", "()I", "getBaselineErrorCount", "getBaselineFixedCount", "getBaselineWarningCount", "getErrorCount", "getHasAutoFixCount", "getWarningCount", "count", "Companion", "lint-cli"})
public final class LintStats {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int errorCount;
    private final int warningCount;
    private final int baselineErrorCount;
    private final int baselineWarningCount;
    private final int baselineFixedCount;
    private final int autoFixedCount;
    private final int hasAutoFixCount;

    public LintStats(int errorCount, int warningCount, int baselineErrorCount, int baselineWarningCount, int baselineFixedCount, int autoFixedCount, int hasAutoFixCount) {
        this.errorCount = errorCount;
        this.warningCount = warningCount;
        this.baselineErrorCount = baselineErrorCount;
        this.baselineWarningCount = baselineWarningCount;
        this.baselineFixedCount = baselineFixedCount;
        this.autoFixedCount = autoFixedCount;
        this.hasAutoFixCount = hasAutoFixCount;
    }

    public /* synthetic */ LintStats(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n8 & 4) != 0) {
            n3 = 0;
        }
        if ((n8 & 8) != 0) {
            n4 = 0;
        }
        if ((n8 & 0x10) != 0) {
            n5 = 0;
        }
        if ((n8 & 0x20) != 0) {
            n6 = 0;
        }
        if ((n8 & 0x40) != 0) {
            n7 = 0;
        }
        this(n, n2, n3, n4, n5, n6, n7);
    }

    public final int getErrorCount() {
        return this.errorCount;
    }

    public final int getWarningCount() {
        return this.warningCount;
    }

    public final int getBaselineErrorCount() {
        return this.baselineErrorCount;
    }

    public final int getBaselineWarningCount() {
        return this.baselineWarningCount;
    }

    public final int getBaselineFixedCount() {
        return this.baselineFixedCount;
    }

    public final int getAutoFixedCount() {
        return this.autoFixedCount;
    }

    public final int getHasAutoFixCount() {
        return this.hasAutoFixCount;
    }

    public final int count() {
        return this.errorCount + this.warningCount;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\"\u0010\u0003\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/LintStats$Companion;", "", "()V", "create", "Lcom/android/tools/lint/LintStats;", "errorCount", "", "warningCount", "mergedIncidents", "", "Lcom/android/tools/lint/detector/api/Incident;", "baseline", "Lcom/android/tools/lint/client/api/LintBaseline;", "incidents", "baselines", "lint-cli"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LintStats create(@NotNull List<Incident> mergedIncidents, @Nullable LintBaseline baseline) {
            Intrinsics.checkNotNullParameter(mergedIncidents, (String)"mergedIncidents");
            return this.create(mergedIncidents, baseline != null ? CollectionsKt.listOf((Object)baseline) : CollectionsKt.emptyList());
        }

        @NotNull
        public final LintStats create(int errorCount, int warningCount) {
            return new LintStats(errorCount, warningCount, 0, 0, 0, 0, 0, 64, null);
        }

        public static /* synthetic */ LintStats create$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.create(n, n2);
        }

        @NotNull
        public final LintStats create(@NotNull List<Incident> incidents, @NotNull List<LintBaseline> baselines) {
            Intrinsics.checkNotNullParameter(incidents, (String)"incidents");
            Intrinsics.checkNotNullParameter(baselines, (String)"baselines");
            int errorCount = 0;
            int warningCount = 0;
            int autofixed = 0;
            int hasAutoFixCount = 0;
            for (Incident incident : incidents) {
                int n;
                if (incident.getSeverity() == Severity.ERROR || incident.getSeverity() == Severity.FATAL) {
                    n = errorCount;
                    errorCount = n + 1;
                } else if (incident.getSeverity() == Severity.WARNING) {
                    n = warningCount;
                    warningCount = n + 1;
                }
                if (incident.getWasAutoFixed()) {
                    n = autofixed;
                    autofixed = n + 1;
                }
                if (!LintStatsKt.hasAutoFix(incident)) continue;
                n = hasAutoFixCount;
                hasAutoFixCount = n + 1;
            }
            int baselineErrorCount = 0;
            int baselineWarningCount = 0;
            int baselineFixedCount = 0;
            Collection collection = baselines;
            boolean bl = false;
            if (!collection.isEmpty()) {
                for (LintBaseline baseline : baselines) {
                    int n = baseline.getFoundErrorCount();
                    boolean bl2 = false;
                    baselineErrorCount = Math.max(baselineErrorCount, n);
                    n = baseline.getFoundWarningCount();
                    bl2 = false;
                    baselineWarningCount = Math.max(baselineWarningCount, n);
                    n = baseline.getFixedCount();
                    bl2 = false;
                    baselineFixedCount = Math.max(baselineFixedCount, n);
                }
            }
            return new LintStats(errorCount, warningCount, baselineErrorCount, baselineWarningCount, baselineFixedCount, autofixed, hasAutoFixCount);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

