/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.ArrayResourceValueImpl;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttrResourceValueImpl;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.DensityBasedResourceValueImpl;
import com.android.ide.common.rendering.api.PluralsResourceValue;
import com.android.ide.common.rendering.api.PluralsResourceValueImpl;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValueImpl;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.rendering.api.StyleableResourceValueImpl;
import com.android.ide.common.rendering.api.TextResourceValueImpl;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.tools.lint.LintResourceItem;
import com.android.tools.lint.LintResourcePersistence;
import com.android.tools.lint.LintResourceRepository;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.model.PathVariables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ListMultimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ*\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/LintResourcePersistence;", "", "()V", "deserialize", "Lcom/android/tools/lint/LintResourceRepository;", "s", "", "pathVariables", "Lcom/android/tools/lint/model/PathVariables;", "root", "Ljava/io/File;", "project", "Lcom/android/tools/lint/detector/api/Project;", "serialize", "repository", "sort", "", "DeserializationReader", "LintDeserializedResourceItem", "SerializationWriter", "lint-cli"})
public final class LintResourcePersistence {
    @NotNull
    public static final LintResourcePersistence INSTANCE = new LintResourcePersistence();

    private LintResourcePersistence() {
    }

    @NotNull
    public final String serialize(@NotNull LintResourceRepository repository, @NotNull PathVariables pathVariables, @Nullable File root, boolean sort) {
        Collection collection;
        boolean bl;
        Object object;
        Object object2;
        Integer n;
        Object source;
        String string;
        SerializationWriter serializationWriter;
        Intrinsics.checkNotNullParameter((Object)((Object)repository), (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pathVariables, (String)"pathVariables");
        Map<ResourceType, ListMultimap<String, ResourceItem>> typeToMap = repository.getTypeToMap$lint_cli();
        if (typeToMap.isEmpty()) {
            return "";
        }
        ResourceNamespace namespace = repository.getNamespace();
        boolean framework = Intrinsics.areEqual((Object)namespace, (Object)ResourceNamespace.ANDROID);
        StringBuilder stringBuilder = new StringBuilder(framework ? 20000000 : 1000);
        SerializationWriter writer = new SerializationWriter(stringBuilder);
        String string2 = namespace.getXmlNamespaceUri();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"namespace.xmlNamespaceUri");
        writer.write(string2);
        writer.write(';');
        string2 = repository.getLibraryName();
        if (string2 == null) {
            serializationWriter = null;
        } else {
            string = string2;
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string;
            boolean bl4 = false;
            serializationWriter = writer.write(it);
        }
        writer.write(';');
        string = HashBiMap.create((int)(framework ? 11000 : 100));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"create(if (framework) 11000 else 100)");
        BiMap fileMap = (BiMap)string;
        int fileCount = 0;
        for (ListMultimap<String, ResourceItem> multimap : typeToMap.values()) {
            for (ResourceItem item : multimap.values()) {
                Integer n2;
                source = item.getSource();
                n = (Integer)fileMap.get(source);
                if (n == null) {
                    object2 = this;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    LintResourcePersistence $this$serialize_u24lambda_u2d1 = object2;
                    boolean bl7 = false;
                    object = (Map)fileMap;
                    int n3 = fileCount;
                    fileCount = n3 + 1;
                    Integer n4 = n3;
                    bl = false;
                    object.put(source, n4);
                    n2 = Unit.INSTANCE;
                    continue;
                }
                n2 = n;
            }
        }
        File multimap = root;
        String rootPath = multimap == null ? null : multimap.getPath();
        BiMap indexToFile = fileMap.inverse();
        int it = 0;
        if (it < fileCount) {
            do {
                int i;
                if ((n = (PathString)indexToFile.get((Object)(i = it++))) == null) continue;
                source = n;
                writer.writePath(pathVariables, rootPath, source.getRawPath());
                writer.write(',');
            } while (it < fileCount);
        }
        if (sort) {
            boolean bl8 = false;
            collection = CollectionsKt.sortedWith((Iterable)typeToMap.entrySet(), (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Map.Entry it = (Map.Entry)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)it.getKey();
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Comparable comparable3 = (Comparable)it.getKey();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                }
            });
        } else {
            collection = typeToMap.entrySet();
        }
        Collection entries = collection;
        for (Map.Entry entry : entries) {
            Collection collection2;
            object2 = entry;
            boolean bl9 = false;
            ResourceType type = (ResourceType)object2.getKey();
            Object object3 = entry;
            boolean bl10 = false;
            ListMultimap map = (ListMultimap)object3.getValue();
            if (map.isEmpty()) continue;
            writer.write('+');
            object3 = type.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"type.getName()");
            writer.write((String)object3);
            writer.write(':');
            if (sort) {
                Collection collection3 = map.values();
                Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"map.values()");
                bl10 = false;
                collection2 = CollectionsKt.sortedWith((Iterable)collection3, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        ResourceItem it = (ResourceItem)a;
                        boolean bl2 = false;
                        ResourceItem resourceItem = it;
                        String string = resourceItem == null ? null : resourceItem.getName();
                        it = (ResourceItem)b;
                        Comparable comparable = (Comparable)((Object)string);
                        bl2 = false;
                        resourceItem = it;
                        Comparable comparable2 = (Comparable)((Object)(resourceItem == null ? null : resourceItem.getName()));
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)comparable2);
                    }
                });
            } else {
                collection2 = map.values();
            }
            Collection values = collection2;
            for (ResourceItem item : values) {
                Object object4;
                String string3 = item.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"item.name");
                writer.escape(string3);
                writer.write(',');
                writer.write(String.valueOf(fileMap.get((Object)item.getSource())));
                writer.write(',');
                if (item.isFileBased()) {
                    writer.write('F');
                } else {
                    writer.write('V');
                }
                string3 = item.getResourceValue();
                if (string3 == null) {
                    object4 = null;
                } else {
                    Object object5;
                    int i;
                    object = string3;
                    boolean bl11 = false;
                    bl = false;
                    Object resourceValue = object;
                    boolean bl12 = false;
                    if (item.isFileBased()) {
                        object4 = Unit.INSTANCE;
                    } else if (item.getType() == ResourceType.ARRAY && resourceValue instanceof ArrayResourceValue) {
                        int n5 = 0;
                        int n6 = ((ArrayResourceValue)resourceValue).getElementCount();
                        if (n5 < n6) {
                            do {
                                i = n5++;
                                String string4 = ((ArrayResourceValue)resourceValue).getElement(i);
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"resourceValue.getElement(i)");
                                writer.escape(string4);
                                writer.write(',');
                            } while (n5 < n6);
                        }
                        object4 = Unit.INSTANCE;
                    } else if (item.getType() == ResourceType.PLURALS && resourceValue instanceof PluralsResourceValue) {
                        int n7 = 0;
                        int n8 = ((PluralsResourceValue)resourceValue).getPluralsCount();
                        if (n7 < n8) {
                            do {
                                i = n7++;
                                String string5 = ((PluralsResourceValue)resourceValue).getQuantity(i);
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"resourceValue.getQuantity(i)");
                                writer.write(string5);
                                writer.write(':');
                                string5 = ((PluralsResourceValue)resourceValue).getValue(i);
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"resourceValue.getValue(i)");
                                writer.escape(string5);
                                writer.write(',');
                            } while (n7 < n8);
                        }
                        object4 = Unit.INSTANCE;
                    } else if (item.getType() == ResourceType.STYLE && resourceValue instanceof StyleResourceValue) {
                        String parentStyleName = ((StyleResourceValue)resourceValue).getParentStyleName();
                        if (parentStyleName == null) {
                            writer.write("N");
                        } else {
                            CharSequence charSequence = parentStyleName;
                            i = 0;
                            if (charSequence.length() == 0) {
                                writer.write("E");
                            } else {
                                writer.write("D").escape(parentStyleName).write(',');
                            }
                        }
                        for (StyleItemResourceValue styleItem : ((StyleResourceValue)resourceValue).getDefinedItems()) {
                            String string6 = styleItem.getAttrName();
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"styleItem.attrName");
                            writer.escape(string6);
                            writer.write(':');
                            string6 = styleItem.getValue();
                            writer.escape(string6 == null ? "" : string6);
                            writer.write(',');
                        }
                        object4 = Unit.INSTANCE;
                    } else if (item.getType() == ResourceType.ATTR && resourceValue instanceof AttrResourceValueImpl) {
                        Object parentStyleName = ((AttrResourceValueImpl)resourceValue).getFormats();
                        Intrinsics.checkNotNullExpressionValue((Object)parentStyleName, (String)"resourceValue.formats");
                        parentStyleName = (Collection)parentStyleName;
                        boolean bl13 = false;
                        if (!parentStyleName.isEmpty()) {
                            parentStyleName = ((AttrResourceValueImpl)resourceValue).getFormats();
                            Intrinsics.checkNotNullExpressionValue(parentStyleName, (String)"resourceValue.formats");
                            writer.write(CollectionsKt.joinToString$default((Iterable)((Iterable)parentStyleName), (CharSequence)"|", null, null, (int)0, null, (Function1)serialize.3.1.INSTANCE, (int)30, null));
                        }
                        writer.write(':');
                        Object object6 = ((AttrResourceValueImpl)resourceValue).getAttributeValues();
                        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"resourceValue.attributeValues");
                        boolean styleItem = false;
                        parentStyleName = object6.entrySet().iterator();
                        while (parentStyleName.hasNext()) {
                            String string7;
                            Object object7 = object6 = (Map.Entry)parentStyleName.next();
                            boolean bl14 = false;
                            String key = (String)object7.getKey();
                            Object object8 = object6;
                            boolean bl15 = false;
                            Integer value = (Integer)object8.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                            writer.escape(key);
                            writer.write(':');
                            object8 = value;
                            writer.escape(object8 == null ? "" : ((string7 = String.valueOf(object8)) == null ? "" : string7));
                            writer.write(',');
                        }
                        object4 = Unit.INSTANCE;
                    } else if (item.getType() == ResourceType.STYLEABLE && resourceValue instanceof StyleableResourceValue) {
                        for (AttrResourceValue attribute : ((StyleableResourceValue)resourceValue).getAllAttributes()) {
                            SerializationWriter serializationWriter2 = writer.write('-');
                            Iterator iterator = attribute.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"attribute.name");
                            serializationWriter2.escape((String)((Object)iterator)).write(':');
                            iterator = attribute.getFormats();
                            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"attribute.formats");
                            iterator = (Collection)((Object)iterator);
                            boolean bl16 = false;
                            if (!iterator.isEmpty()) {
                                iterator = attribute.getFormats();
                                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"attribute.formats");
                                writer.write(CollectionsKt.joinToString$default((Iterable)((Iterable)((Object)iterator)), (CharSequence)"|", null, null, (int)0, null, (Function1)serialize.3.2.INSTANCE, (int)30, null));
                            }
                            writer.write(':');
                            Object object9 = attribute.getAttributeValues();
                            Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"attribute.attributeValues");
                            boolean bl17 = false;
                            iterator = object9.entrySet().iterator();
                            while (iterator.hasNext()) {
                                String string8;
                                Object object10 = object9 = iterator.next();
                                boolean bl18 = false;
                                String key = (String)object10.getKey();
                                object5 = object9;
                                boolean bl19 = false;
                                Integer value = (Integer)object5.getValue();
                                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                                writer.escape(key);
                                writer.write(':');
                                object5 = value;
                                writer.escape(object5 == null ? "" : ((string8 = String.valueOf(object5)) == null ? "" : string8));
                                writer.write(',');
                            }
                        }
                        object4 = Unit.INSTANCE;
                    } else if (DensityBasedResourceValue.isDensityBasedResourceType((ResourceType)type) && resourceValue instanceof DensityBasedResourceValue) {
                        String density = ((DensityBasedResourceValue)resourceValue).getResourceDensity().getResourceValue();
                        Intrinsics.checkNotNullExpressionValue((Object)density, (String)"density");
                        object4 = writer.write(density);
                    } else {
                        String string9 = resourceValue.getValue();
                        if (string9 == null) {
                            object4 = null;
                        } else {
                            String rawSource;
                            String string10 = string9;
                            boolean bl20 = false;
                            boolean bl21 = false;
                            String it2 = string10;
                            boolean bl22 = false;
                            writer.write('\"');
                            writer.escape(it2);
                            writer.write('\"');
                            object5 = item.getResourceValue();
                            String string11 = rawSource = object5 == null ? null : object5.getRawXmlValue();
                            if (rawSource != null && !Intrinsics.areEqual((Object)it2, (Object)rawSource)) {
                                writer.escape(rawSource);
                            }
                            object4 = Unit.INSTANCE;
                        }
                    }
                }
                writer.write(';');
            }
        }
        String string12 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"stringBuilder.toString()");
        return string12;
    }

    public static /* synthetic */ String serialize$default(LintResourcePersistence lintResourcePersistence, LintResourceRepository lintResourceRepository, PathVariables pathVariables, File file, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return lintResourcePersistence.serialize(lintResourceRepository, pathVariables, file, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final LintResourceRepository deserialize(@NotNull String s, @NotNull PathVariables pathVariables, @Nullable File root, @Nullable Project project) {
        Object args22;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)pathVariables, (String)"pathVariables");
        CharSequence charSequence2 = s;
        boolean bl = false;
        if (charSequence2.length() == 0) {
            return LintResourceRepository.Companion.EmptyRepository.INSTANCE;
        }
        Map map = new EnumMap(ResourceType.class);
        DeserializationReader reader = new DeserializationReader(s);
        String namespaceUri = reader.readString(';');
        ResourceNamespace resourceNamespace = ResourceNamespace.fromNamespaceUri((String)namespaceUri);
        ResourceNamespace namespace = resourceNamespace == null ? ResourceNamespace.RES_AUTO : resourceNamespace;
        CharSequence charSequence3 = reader.readString(';');
        boolean bl2 = false;
        if (StringsKt.isBlank((CharSequence)charSequence3)) {
            boolean bl3 = false;
            charSequence = null;
        } else {
            charSequence = charSequence3;
        }
        String libraryName = (String)charSequence;
        int size = Intrinsics.areEqual((Object)namespace, (Object)ResourceNamespace.ANDROID) ? 11000 : 100;
        ArrayList<File> fileList = new ArrayList<File>(size);
        while (true) {
            DeserializationReader this_$iv = reader;
            boolean $i$f$eof = false;
            if (this_$iv.i >= this_$iv.n) break;
            this_$iv = reader;
            boolean $i$f$peek = false;
            if ((this_$iv.i < this_$iv.n ? (int)this_$iv.s.charAt(this_$iv.i) : 0) == 43) break;
            String path = reader.readString(',');
            File file = pathVariables.fromPathString(path, root);
            fileList.add(file);
        }
        HashMap parentConfigMap = new HashMap(size / 4);
        HashMap folderConfigMap = new HashMap(size);
        for (File file : fileList) {
            FolderConfiguration folderConfiguration;
            Object object = file.getParentFile();
            String string = object == null ? null : ((File)object).getName();
            if (string == null) continue;
            String folderName = string;
            Object object2 = (FolderConfiguration)parentConfigMap.get(folderName);
            if (object2 == null) {
                FolderConfiguration folderConfiguration2;
                FolderConfiguration folderConfiguration3;
                FolderConfiguration folderConfiguration4 = FolderConfiguration.getConfigForFolder((String)folderName);
                if (folderConfiguration4 == null) {
                    folderConfiguration3 = null;
                } else {
                    FolderConfiguration folderConfiguration5 = folderConfiguration4;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    FolderConfiguration it = folderConfiguration5;
                    boolean bl6 = false;
                    it.normalizeByAddingImpliedVersionQualifier();
                    Map map2 = parentConfigMap;
                    boolean bl7 = false;
                    map2.put(folderName, it);
                    folderConfiguration3 = folderConfiguration2 = folderConfiguration5;
                }
                if (folderConfiguration2 == null) continue;
                folderConfiguration = folderConfiguration2;
            } else {
                folderConfiguration = object2;
            }
            object = folderConfiguration;
            File config = object;
            object = folderConfigMap;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            object2 = file;
            boolean bl8 = false;
            object.put(object2, config);
        }
        HashMap valueItems = new HashMap();
        ResourceType type = ResourceType.AAPT;
        while (true) {
            List list2;
            List list3;
            ResourceMergerItem item;
            Object $i$f$peek5;
            String string;
            Object this_$iv;
            char this_$iv$iv22;
            String fileNumString;
            DeserializationReader deserializationReader;
            boolean $i$f$advance;
            DeserializationReader this_$iv2 = reader;
            boolean $i$f$eof = false;
            if (this_$iv2.i >= this_$iv2.n) break;
            this_$iv2 = reader;
            boolean $i$f$peek2 = false;
            if ((this_$iv2.i < this_$iv2.n ? (int)this_$iv2.s.charAt(this_$iv2.i) : 0) == 59) {
                this_$iv2 = reader;
                $i$f$advance = false;
                deserializationReader = this_$iv2;
                int n = deserializationReader.i;
                deserializationReader.i = n + 1;
                this_$iv2 = reader;
                $i$f$eof = false;
                if (this_$iv2.i >= this_$iv2.n) break;
            }
            this_$iv2 = reader;
            $i$f$peek2 = false;
            if ((this_$iv2.i < this_$iv2.n ? (int)this_$iv2.s.charAt(this_$iv2.i) : 0) == 43) {
                this_$iv2 = reader;
                $i$f$advance = false;
                deserializationReader = this_$iv2;
                int n = deserializationReader.i;
                deserializationReader.i = n + 1;
                String typeClass = reader.readString(':');
                ResourceType typeString = ResourceType.fromClassName((String)typeClass);
                boolean bl9 = typeString != null;
                n = 0;
                if (_Assertions.ENABLED && !bl9) {
                    boolean $i$a$-assert-LintResourcePersistence$deserialize$22 = false;
                    String $i$a$-assert-LintResourcePersistence$deserialize$22 = typeClass;
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-LintResourcePersistence$deserialize$22));
                }
                Intrinsics.checkNotNull((Object)typeString);
            }
            String name = reader.readString(',');
            String string2 = fileNumString = reader.readString(',');
            boolean $i$a$-assert-LintResourcePersistence$deserialize$22 = false;
            int fileNum = Integer.parseInt(string2);
            DeserializationReader this_$iv3 = reader;
            boolean $i$f$next = false;
            try {
                DeserializationReader this_$iv$iv22 = this_$iv3;
                boolean $i$f$peek3 = false;
                this_$iv$iv22 = this_$iv$iv22.i < this_$iv$iv22.n ? this_$iv$iv22.s.charAt(this_$iv$iv22.i) : (char)'\u0000';
            }
            finally {
                DeserializationReader $i$f$peek3 = this_$iv3;
                int n = $i$f$peek3.i;
                $i$f$peek3.i = n + 1;
            }
            boolean fileBased = this_$iv$iv22 == 'F';
            args22 = null;
            Object rawSource = null;
            DeserializationReader this_$iv4 = reader;
            boolean $i$f$peek4 = false;
            char peek = this_$iv4.i < this_$iv4.n ? this_$iv4.s.charAt(this_$iv4.i) : (char)'\u0000';
            if (peek == '\"') {
                DeserializationReader this_$iv5 = reader;
                boolean $i$f$advance2 = false;
                DeserializationReader bl6 = this_$iv5;
                int n = bl6.i;
                bl6.i = n + 1;
                String content = reader.readString('\"');
                this_$iv = reader;
                boolean $i$f$peek5 = false;
                if ((((DeserializationReader)this_$iv).i < ((DeserializationReader)this_$iv).n ? (int)((DeserializationReader)this_$iv).s.charAt(((DeserializationReader)this_$iv).i) : 0) != 59) {
                    rawSource = reader.readString(';');
                }
                string = content;
            } else if (peek != ';') {
                args22 = reader.readRaw(';');
                string = null;
            } else {
                string = null;
            }
            String content = string;
            this_$iv = fileList.get(fileNum);
            Intrinsics.checkNotNullExpressionValue(this_$iv, (String)"fileList[fileNum]");
            File file = (File)this_$iv;
            Intrinsics.checkNotNull(folderConfigMap.get(file));
            Intrinsics.checkNotNullExpressionValue($i$f$peek5, (String)"folderConfigMap[file]!!");
            FolderConfiguration config = (FolderConfiguration)$i$f$peek5;
            if (fileBased) {
                Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"namespace");
                item = new LintResourceItem(file, name, namespace, type, null, false, libraryName, config, true);
                LintResourceRepository.Companion.recordItem$lint_cli(map, type, name, (ResourceItem)item);
                new ResourceFile(file, item, config);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"namespace");
            item = new LintDeserializedResourceItem(file, name, namespace, type, config, false, (String)rawSource, content, (String)args22, libraryName);
            LintResourceRepository.Companion.recordItem$lint_cli(map, type, name, (ResourceItem)item);
            List list4 = (List)valueItems.get(file);
            if (list4 == null) {
                ArrayList arrayList = new ArrayList();
                boolean bl10 = false;
                boolean bl11 = false;
                ArrayList it = arrayList;
                boolean bl12 = false;
                Map map3 = valueItems;
                boolean bl13 = false;
                map3.put(file, it);
                list3 = arrayList;
            } else {
                list3 = list4;
            }
            List list5 = list2 = list3;
            list5.add(item);
        }
        Object object = valueItems;
        boolean fileNum = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object fileBased = object = iterator.next();
            boolean args22 = false;
            File file = (File)fileBased.getKey();
            args22 = object;
            boolean rawSource = false;
            List items = (List)args22.getValue();
            Intrinsics.checkNotNull(folderConfigMap.get(file));
            Intrinsics.checkNotNullExpressionValue(rawSource, (String)"folderConfigMap[file]!!");
            FolderConfiguration config = (FolderConfiguration)rawSource;
            List itemList = items;
            new ResourceFile(file, itemList, config);
        }
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"namespace");
        return new LintResourceRepository(project, map, namespace, libraryName);
    }

    public static /* synthetic */ LintResourceRepository deserialize$default(LintResourcePersistence lintResourcePersistence, String string, PathVariables pathVariables, File file, Project project, int n, Object object) {
        if ((n & 4) != 0) {
            file = null;
        }
        if ((n & 8) != 0) {
            project = null;
        }
        return lintResourcePersistence.deserialize(string, pathVariables, file, project);
    }

    @NotNull
    public final String serialize(@NotNull LintResourceRepository repository, @NotNull PathVariables pathVariables) {
        Intrinsics.checkNotNullParameter((Object)((Object)repository), (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pathVariables, (String)"pathVariables");
        return LintResourcePersistence.serialize$default(this, repository, pathVariables, null, false, 8, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\bH\u0016J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\bJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\bR\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/LintResourcePersistence$SerializationWriter;", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Ljava/lang/StringBuilder;)V", "escape", "s", "", "toString", "write", "char", "", "string", "writePath", "", "pathVariables", "Lcom/android/tools/lint/model/PathVariables;", "rootPath", "path", "lint-cli"})
    private static final class SerializationWriter {
        @NotNull
        private final StringBuilder sb;

        public SerializationWriter(@NotNull StringBuilder sb) {
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            this.sb = sb;
        }

        @NotNull
        public final SerializationWriter write(char c) {
            this.sb.append(c);
            return this;
        }

        @NotNull
        public final SerializationWriter write(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            this.sb.append(string);
            return this;
        }

        @NotNull
        public final SerializationWriter escape(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            int n = s.length();
            int n2 = 0;
            if (n2 < n) {
                do {
                    int i;
                    char c;
                    if ((((((c = s.charAt(i = n2++)) == '\\' ? true : c == '+') ? true : c == ',') ? true : c == ';') ? true : c == ':') ? true : c == '\"') {
                        this.write('\\').write(c);
                        continue;
                    }
                    this.write(c);
                } while (n2 < n);
            }
            return this;
        }

        public final void writePath(@NotNull PathVariables pathVariables, @Nullable String rootPath, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)pathVariables, (String)"pathVariables");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.escape(pathVariables.toPathString(path, rootPath, true));
        }

        @NotNull
        public String toString() {
            String string = this.sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\tH\u0086\bJ\t\u0010\n\u001a\u00020\u000bH\u0086\bJ\t\u0010\f\u001a\u00020\rH\u0086\bJ\t\u0010\u000e\u001a\u00020\rH\u0086\bJ\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\rJ\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/LintResourcePersistence$DeserializationReader;", "", "s", "", "(Ljava/lang/String;)V", "i", "", "n", "advance", "", "eof", "", "next", "", "peek", "readRaw", "terminator", "readString", "toString", "lint-cli"})
    private static final class DeserializationReader {
        @NotNull
        private final String s;
        private int i;
        private final int n;

        public DeserializationReader(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.s = s;
            this.n = this.s.length();
        }

        public final char peek() {
            boolean $i$f$peek = false;
            return this.i < this.n ? this.s.charAt(this.i) : (char)'\u0000';
        }

        @NotNull
        public final String readString(char terminator) {
            if (this.s.charAt(this.i) == terminator) {
                DeserializationReader deserializationReader = this;
                int n = deserializationReader.i;
                deserializationReader.i = n + 1;
                return "";
            }
            int n = this.i;
            int n2 = this.n;
            if (n < n2) {
                int index;
                char c;
                while ((c = this.s.charAt(index = n++)) != '\\') {
                    if (c == terminator) {
                        String string = this.s;
                        int n3 = this.i;
                        boolean bl = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(n3, index);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string4 = string3;
                        this.i = index + 1;
                        return string4;
                    }
                    if (n < n2) continue;
                }
            }
            StringBuilder contentBuilder = new StringBuilder();
            while (this.i < this.n) {
                char c;
                char c2;
                DeserializationReader index = this;
                int n4 = index.i;
                index.i = n4 + 1;
                char p = this.s.charAt(n4);
                if (p == '\\') {
                    if (this.i >= this.n) break;
                    DeserializationReader deserializationReader = this;
                    int n5 = deserializationReader.i;
                    deserializationReader.i = n5 + 1;
                    c2 = this.s.charAt(n5);
                } else {
                    c2 = c = p;
                }
                if (p == terminator) break;
                contentBuilder.append(c);
            }
            String string = contentBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contentBuilder.toString()");
            return string;
        }

        @NotNull
        public final String readRaw(char terminator) {
            int n;
            DeserializationReader deserializationReader;
            char p;
            int begin = this.i;
            while (this.i < this.n && (p = this.s.charAt(this.i)) != terminator) {
                if (p == '\\') {
                    deserializationReader = this;
                    n = deserializationReader.i;
                    deserializationReader.i = n + 1;
                }
                deserializationReader = this;
                n = deserializationReader.i;
                deserializationReader.i = n + 1;
            }
            String string = this.s;
            deserializationReader = this;
            n = deserializationReader.i;
            deserializationReader.i = n + 1;
            int n2 = n;
            n = 0;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(begin, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final char next() {
            boolean $i$f$next = false;
            try {
                DeserializationReader this_$iv = this;
                boolean $i$f$peek = false;
                char c = this_$iv.i < this_$iv.n ? this_$iv.s.charAt(this_$iv.i) : (char)'\u0000';
                return c;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                DeserializationReader deserializationReader = this;
                int n = deserializationReader.i;
                deserializationReader.i = n + 1;
                InlineMarker.finallyEnd((int)1);
            }
        }

        public final void advance() {
            boolean $i$f$advance = false;
            DeserializationReader deserializationReader = this;
            int n = deserializationReader.i;
            deserializationReader.i = n + 1;
        }

        public final boolean eof() {
            boolean $i$f$eof = false;
            return this.i >= this.n;
        }

        @NotNull
        public String toString() {
            int windowSize = 100;
            int n = 0;
            int n2 = this.i - windowSize;
            int n3 = 0;
            int start = Math.max(n, n2);
            n2 = this.n;
            n3 = this.i + windowSize;
            boolean bl = false;
            int end = Math.min(n2, n3);
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.s;
            n3 = this.i;
            bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(start, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            StringBuilder stringBuilder2 = stringBuilder.append(string3).append(" | ");
            string = this.s;
            n3 = this.i;
            bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n3, end);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return stringBuilder2.append(string5).toString();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\rH\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/LintResourcePersistence$LintDeserializedResourceItem;", "Lcom/android/ide/common/resources/ResourceMergerItem;", "sourceFile", "Ljava/io/File;", "name", "", "namespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "type", "Lcom/android/resources/ResourceType;", "config", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "fileBased", "", "rawSource", "text", "arguments", "library", "(Ljava/io/File;Ljava/lang/String;Lcom/android/ide/common/rendering/api/ResourceNamespace;Lcom/android/resources/ResourceType;Lcom/android/ide/common/resources/configuration/FolderConfiguration;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "createResourceValue", "Lcom/android/ide/common/rendering/api/ResourceValue;", "getConfiguration", "getFile", "getLibraryName", "getResourceValue", "getSource", "Lcom/android/ide/common/util/PathString;", "getValueText", "isFileBased", "toString", "lint-cli"})
    private static final class LintDeserializedResourceItem
    extends ResourceMergerItem {
        @NotNull
        private final File sourceFile;
        @NotNull
        private final FolderConfiguration config;
        private final boolean fileBased;
        @Nullable
        private final String rawSource;
        @Nullable
        private final String text;
        @Nullable
        private final String arguments;
        @Nullable
        private final String library;

        public LintDeserializedResourceItem(@NotNull File sourceFile, @NotNull String name, @NotNull ResourceNamespace namespace, @NotNull ResourceType type, @NotNull FolderConfiguration config, boolean fileBased, @Nullable String rawSource, @Nullable String text, @Nullable String arguments, @Nullable String library) {
            Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            super(name, namespace, type, null, Boolean.valueOf(false), null);
            this.sourceFile = sourceFile;
            this.config = config;
            this.fileBased = fileBased;
            this.rawSource = rawSource;
            this.text = text;
            this.arguments = arguments;
            this.library = library;
        }

        @NotNull
        public FolderConfiguration getConfiguration() {
            return this.config;
        }

        @NotNull
        public File getFile() {
            return this.sourceFile;
        }

        @NotNull
        public PathString getSource() {
            return new PathString(this.sourceFile);
        }

        @NotNull
        public String getValueText() {
            String string = this.text;
            return string == null ? "" : string;
        }

        @NotNull
        public ResourceValue getResourceValue() {
            ResourceValue resourceValue;
            ResourceValue resourceValue2 = this.mResourceValue;
            if (resourceValue2 == null) {
                ResourceValue resourceValue3 = this.createResourceValue();
                boolean bl = false;
                boolean bl2 = false;
                ResourceValue it = resourceValue3;
                boolean bl3 = false;
                this.mResourceValue = it;
                resourceValue = resourceValue3;
            } else {
                resourceValue = resourceValue2;
            }
            return resourceValue;
        }

        @Nullable
        public String getLibraryName() {
            return this.library;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ResourceValue createResourceValue() {
            ResourceValue resourceValue;
            if (this.arguments == null) {
                resourceValue = (ResourceValue)(this.getType() == ResourceType.ATTR ? (ResourceValueImpl)new AttrResourceValueImpl(this.getNamespace(), this.getName(), this.library) : (this.getType() == ResourceType.STRING && this.text != null ? (ResourceValueImpl)new TextResourceValueImpl(this.getNamespace(), this.getName(), this.text, this.rawSource, this.library) : (this.getType() == ResourceType.ARRAY ? (ResourceValueImpl)new ArrayResourceValueImpl(this.getNamespace(), this.getName(), this.library) : (this.getType() == ResourceType.STYLEABLE ? (ResourceValueImpl)new StyleableResourceValueImpl(this.getNamespace(), this.getName(), null, this.library) : (this.getType() == ResourceType.STYLE ? (ResourceValueImpl)new StyleItemResourceValueImpl(this.getNamespace(), this.getName(), null, this.library) : (this.text != null ? new ResourceValueImpl(this.getNamespace(), this.getType(), this.getName(), this.text, this.library) : (this.isFileBased() ? new ResourceValueImpl(this.getNamespace(), this.getType(), this.getName(), this.sourceFile.getPath(), this.library) : new ResourceValueImpl(this.getNamespace(), this.getType(), this.getName(), this.library))))))));
            } else {
                ResourceValueImpl resourceValueImpl;
                CharSequence charSequence = this.arguments;
                boolean bl = false;
                boolean bl2 = charSequence.length() > 0;
                bl = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                DeserializationReader reader = new DeserializationReader(this.arguments);
                if (this.getType() == ResourceType.ARRAY) {
                    ArrayResourceValueImpl array = new ArrayResourceValueImpl(this.getNamespace(), this.getName(), this.library);
                    while (true) {
                        DeserializationReader this_$iv = reader;
                        boolean $i$f$eof = false;
                        if (this_$iv.i >= this_$iv.n) break;
                        String element = reader.readString(',');
                        array.addElement(element);
                    }
                    resourceValueImpl = (ResourceValueImpl)array;
                } else if (this.getType() == ResourceType.PLURALS) {
                    PluralsResourceValueImpl plural = new PluralsResourceValueImpl(this.getNamespace(), this.getName(), this.text, this.library);
                    while (true) {
                        DeserializationReader this_$iv = reader;
                        boolean $i$f$eof = false;
                        if (this_$iv.i >= this_$iv.n) break;
                        String quantity = reader.readString(':');
                        String value = reader.readString(',');
                        plural.addPlural(quantity, value);
                    }
                    resourceValueImpl = (ResourceValueImpl)plural;
                } else if (this.getType() == ResourceType.STYLE) {
                    char this_$iv$iv22;
                    DeserializationReader this_$iv = reader;
                    boolean $i$f$next = false;
                    try {
                        DeserializationReader this_$iv$iv22 = this_$iv;
                        boolean $i$f$peek = false;
                        this_$iv$iv22 = this_$iv$iv22.i < this_$iv$iv22.n ? this_$iv$iv22.s.charAt(this_$iv$iv22.i) : (char)'\u0000';
                    }
                    finally {
                        DeserializationReader $i$f$peek = this_$iv;
                        int n = $i$f$peek.i;
                        $i$f$peek.i = n + 1;
                    }
                    char quantity = this_$iv$iv22;
                    String parent = quantity == 'E' ? "" : (quantity == 'N' ? null : reader.readString(','));
                    StyleResourceValueImpl style = new StyleResourceValueImpl(this.getNamespace(), this.getName(), parent, this.library);
                    while (true) {
                        this_$iv = reader;
                        boolean $i$f$eof = false;
                        if (this_$iv.i >= this_$iv.n) break;
                        String name = reader.readString(':');
                        String value = reader.readString(',');
                        StyleItemResourceValueImpl item = new StyleItemResourceValueImpl(this.getNamespace(), name, value, this.library);
                        style.addItem((StyleItemResourceValue)item);
                    }
                    resourceValueImpl = (ResourceValueImpl)style;
                } else if (this.getType() == ResourceType.STYLEABLE) {
                    int n;
                    Object $i$f$peek222;
                    char this_$iv$iv32;
                    StyleableResourceValueImpl style = new StyleableResourceValueImpl(this.getNamespace(), this.getName(), null, this.library);
                    DeserializationReader this_$iv22 = reader;
                    boolean $i$f$next = false;
                    try {
                        DeserializationReader this_$iv$iv32 = this_$iv22;
                        boolean $i$f$peek222 = false;
                        this_$iv$iv32 = this_$iv$iv32.i < this_$iv$iv32.n ? this_$iv$iv32.s.charAt(this_$iv$iv32.i) : (char)'\u0000';
                    }
                    finally {
                        $i$f$peek222 = this_$iv22;
                        n = ((DeserializationReader)$i$f$peek222).i;
                        ((DeserializationReader)$i$f$peek222).i = n + 1;
                    }
                    char separator = this_$iv$iv32;
                    boolean this_$iv22 = separator == '-';
                    $i$f$next = false;
                    this_$iv$iv32 = '\u0000';
                    if (_Assertions.ENABLED && !this_$iv22) {
                        boolean $i$f$peek222 = false;
                        String $i$f$peek222 = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)$i$f$peek222));
                    }
                    block9: while (true) {
                        DeserializationReader this_$iv = reader;
                        boolean $i$f$eof = false;
                        if (this_$iv.i >= this_$iv.n) break;
                        String attrName = reader.readString(':');
                        AttrResourceValueImpl attr2 = new AttrResourceValueImpl(this.getNamespace(), attrName, this.library);
                        style.addValue((AttrResourceValue)attr2);
                        String format = reader.readString(':');
                        $i$f$peek222 = format;
                        n = 0;
                        if ($i$f$peek222.length() > 0) {
                            Set formats = AttributeFormat.parse((String)format);
                            attr2.setFormats((Collection)formats);
                        }
                        while (true) {
                            Integer n2;
                            int n3;
                            Object object;
                            DeserializationReader this_$iv3 = reader;
                            boolean $i$f$eof2 = false;
                            if (this_$iv3.i >= this_$iv3.n) continue block9;
                            this_$iv3 = reader;
                            boolean $i$f$peek = false;
                            if ((this_$iv3.i < this_$iv3.n ? (int)this_$iv3.s.charAt(this_$iv3.i) : 0) == 45) {
                                this_$iv3 = reader;
                                boolean $i$f$advance = false;
                                object = this_$iv3;
                                n3 = ((DeserializationReader)object).i;
                                ((DeserializationReader)object).i = n3 + 1;
                                continue block9;
                            }
                            String name = reader.readString(':');
                            String value = reader.readString(',');
                            object = value;
                            n3 = 0;
                            if (!StringsKt.isBlank((CharSequence)object)) {
                                object = value;
                                n3 = 0;
                                n2 = Integer.parseInt((String)object);
                            } else {
                                n2 = null;
                            }
                            attr2.addValue(name, n2, null);
                        }
                        break;
                    }
                    resourceValueImpl = (ResourceValueImpl)style;
                } else if (this.getType() == ResourceType.ATTR) {
                    Collection formats;
                    AttrResourceValueImpl attr = new AttrResourceValueImpl(this.getNamespace(), this.getName(), this.library);
                    String format = reader.readString(':');
                    CharSequence attrName = format;
                    boolean attr2 = false;
                    if (attrName.length() == 0) {
                        formats = CollectionsKt.listOf((Object)AttributeFormat.REFERENCE);
                        attr.setFormats(formats);
                    } else {
                        formats = AttributeFormat.parse((String)format);
                        attr.setFormats(formats);
                    }
                    while (true) {
                        Integer n;
                        DeserializationReader this_$iv = reader;
                        boolean $i$f$eof = false;
                        if (this_$iv.i >= this_$iv.n) break;
                        String name = reader.readString(':');
                        String value = reader.readString(',');
                        CharSequence charSequence2 = value;
                        boolean bl5 = false;
                        if (!StringsKt.isBlank((CharSequence)charSequence2)) {
                            charSequence2 = value;
                            bl5 = false;
                            n = Integer.parseInt((String)charSequence2);
                        } else {
                            n = null;
                        }
                        attr.addValue(name, n, null);
                    }
                    resourceValueImpl = (ResourceValueImpl)attr;
                } else if (DensityBasedResourceValue.isDensityBasedResourceType((ResourceType)this.getType())) {
                    Density density = Density.getEnum((String)this.arguments);
                    Intrinsics.checkNotNull((Object)density);
                    Density density2 = density;
                    resourceValueImpl = (ResourceValueImpl)new DensityBasedResourceValueImpl(this.getNamespace(), this.getType(), this.getName(), null, density2, this.library);
                } else {
                    resourceValueImpl = new ResourceValueImpl(this.getNamespace(), this.getType(), this.getName(), this.getFile().getPath(), this.library);
                }
                resourceValue = (ResourceValue)resourceValueImpl;
            }
            return resourceValue;
        }

        public boolean isFileBased() {
            return this.fileBased;
        }

        @NotNull
        public String toString() {
            Object object;
            File file;
            String parentPath;
            String path = this.getFile().getPath();
            Object object2 = this.getFile().getParentFile();
            String string = object2 == null ? null : (parentPath = (file = ((File)object2).getParentFile()) == null ? null : file.getPath());
            if (parentPath != null) {
                StringBuilder stringBuilder = new StringBuilder().append((Object)((Object)((Object)this)).getClass().getSimpleName()).append('(');
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                object2 = path;
                int n = parentPath.length() + 1;
                boolean bl = false;
                String string2 = ((String)object2).substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                object = stringBuilder.append(string2).append(')').toString();
            } else {
                object2 = super.toString();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"{\n                super.toString()\n            }");
                object = object2;
            }
            return object;
        }
    }
}

