/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.tools.lint.HtmlReporter;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.LintSyntaxHighlighter;
import com.android.tools.lint.Main;
import com.android.tools.lint.MultiProjectHtmlReporter;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.ApplicableVariants;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Option;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 ]2\u00020\u0001:\u0002\\]B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000eH\u0002J0\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020)H\u0002J\"\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u000e0+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.H\u0002J\b\u00100\u001a\u00020\u001fH\u0002J\u0018\u00101\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u000204H\u0002J\u001e\u00105\u001a\u00020\u001f2\u0006\u00103\u001a\u0002042\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.H\u0016JB\u00106\u001a\u00020\u001f2\b\u00107\u001a\u0004\u0018\u00010\u000e2\u0006\u00108\u001a\u00020\u00192\b\u00109\u001a\u0004\u0018\u00010\u000e2\u000e\b\u0002\u0010:\u001a\b\u0012\u0004\u0012\u00020;0.2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001f0=H\u0002J*\u00106\u001a\u00020\u001f2\b\u00107\u001a\u0004\u0018\u00010\u000e2\b\u00109\u001a\u0004\u0018\u00010\u000e2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001f0=H\u0002J\u0016\u0010>\u001a\u00020\u001f2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;0.H\u0002J\b\u0010?\u001a\u00020\u001fH\u0002J\u001a\u0010@\u001a\u00020\u001f2\b\u00107\u001a\u0004\u0018\u00010\u000e2\u0006\u00109\u001a\u00020\u000eH\u0002J\u0010\u0010A\u001a\u00020\u001f2\u0006\u0010B\u001a\u00020\u000eH\u0002J\b\u0010C\u001a\u00020\u001fH\u0002J\b\u0010D\u001a\u00020\u001fH\u0002J\b\u0010E\u001a\u00020\u001fH\u0002J\b\u0010F\u001a\u00020\u001fH\u0002J\u0016\u0010G\u001a\u00020\u001f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.H\u0002J\"\u0010H\u001a\u00020\u001f2\u0006\u0010I\u001a\u00020,2\b\u0010J\u001a\u0004\u0018\u00010\u000e2\u0006\u0010K\u001a\u00020\u0019H\u0002J\"\u0010L\u001a\u0004\u0018\u00010\u000e2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010M\u001a\u00020\u000e2\u0006\u0010N\u001a\u00020\fH\u0002J\u001c\u0010O\u001a\u00020\u001f2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u000e0+H\u0002J\u001e\u0010Q\u001a\u00020\u001f2\u0006\u00103\u001a\u0002042\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001f0=H\u0002J\b\u0010R\u001a\u00020\u001fH\u0002J\b\u0010S\u001a\u00020\u001fH\u0002J$\u0010T\u001a\u00020\u001f2\u0012\u0010U\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0.2\u0006\u0010V\u001a\u00020\fH\u0002J\u001e\u0010W\u001a\u00020\u001f2\u0006\u00103\u001a\u0002042\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Y0.H\u0016J\b\u0010Z\u001a\u00020\u001fH\u0002J\b\u0010[\u001a\u00020\u001fH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/android/tools/lint/HtmlReporter;", "Lcom/android/tools/lint/Reporter;", "client", "Lcom/android/tools/lint/LintCliClient;", "output", "Ljava/io/File;", "flags", "Lcom/android/tools/lint/LintCliFlags;", "(Lcom/android/tools/lint/LintCliClient;Ljava/io/File;Lcom/android/tools/lint/LintCliFlags;)V", "builder", "Lcom/android/utils/HtmlBuilder;", "cardNumber", "", "highlightedFile", "", "highlighter", "Lcom/android/tools/lint/LintSyntaxHighlighter;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "usedCardIds", "", "writer", "Ljava/io/Writer;", "addImage", "", "url", "urlFile", "location", "Lcom/android/tools/lint/detector/api/Location;", "append", "", "s", "", "appendCodeBlock", "file", "contents", "", "startOffset", "endOffset", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "computeMissingIssues", "", "Lcom/android/tools/lint/detector/api/Issue;", "incidents", "", "Lcom/android/tools/lint/detector/api/Incident;", "finishReport", "getHighlighter", "startReport", "stats", "Lcom/android/tools/lint/LintStats;", "write", "writeCard", "title", "dismissible", "cardId", "actions", "Lcom/android/tools/lint/HtmlReporter$Action;", "appender", "Lkotlin/Function0;", "writeCardAction", "writeCardFooter", "writeCardHeader", "writeChip", "text", "writeCloseBodyTag", "writeCloseHtmlTag", "writeCloseNavigationHeader", "writeHeadTag", "writeIssueCard", "writeIssueMetadata", "issue", "disabledBy", "hide", "writeLocation", "path", "line", "writeMissingIssues", "missing", "writeNavigationHeader", "writeOpenBodyTag", "writeOpenHtmlTag", "writeOverview", "related", "missingCount", "writeProjectList", "projects", "Lcom/android/tools/lint/MultiProjectHtmlReporter$ProjectEntry;", "writeReport", "writeSuppressIssuesCard", "Action", "Companion", "lint-cli"})
@Beta
public final class HtmlReporter
extends Reporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Writer writer;
    @NotNull
    private final LintCliFlags flags;
    @Nullable
    private HtmlBuilder builder;
    @Nullable
    private StringBuilder sb;
    @Nullable
    private String highlightedFile;
    @Nullable
    private LintSyntaxHighlighter highlighter;
    private int cardNumber;
    @NotNull
    private final Set<String> usedCardIds;
    @NotNull
    private static final Comparator<File> ICON_DENSITY_COMPARATOR = Companion.ICON_DENSITY_COMPARATOR.1.INSTANCE;
    private static int SPLIT_LIMIT;
    private static int MAX_COUNT;
    private static int SHOWN_COUNT;
    @JvmField
    public static int CODE_WINDOW_SIZE;
    @NotNull
    private static final String REPORT_PREFERENCE_ENV_VAR = "LINT_HTML_PREFS";
    @NotNull
    public static final String REPORT_PREFERENCE_PROPERTY = "lint.html.prefs";
    private static boolean USE_WAVY_UNDERLINES_FOR_ERRORS;
    private static final boolean USE_CSS_DECORATION_FOR_WAVY_UNDERLINES = false;
    @NotNull
    private static String preferredThemeName;
    @NotNull
    private static String cssSyntaxColors;

    public HtmlReporter(@NotNull LintCliClient client, @NotNull File output, @NotNull LintCliFlags flags) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        super(client, output);
        this.writer = new BufferedWriter(Files.newWriter((File)output, (Charset)Charsets.UTF_8));
        this.flags = flags;
        boolean bl = false;
        this.usedCardIds = new LinkedHashSet();
    }

    @Override
    public void write(@NotNull LintStats stats, @NotNull List<Incident> incidents) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter(incidents, (String)"incidents");
        Map<Issue, String> missing = this.computeMissingIssues(incidents);
        List related = HtmlReporter.Companion.computeIssueLists(incidents);
        this.startReport(stats);
        this.writeNavigationHeader(stats, (Function0<Unit>)((Function0)new Function0<Unit>(this, (List<? extends List<Incident>>)related){
            final /* synthetic */ HtmlReporter this$0;
            final /* synthetic */ List<List<Incident>> $related;
            {
                this.this$0 = $receiver;
                this.$related = $related;
                super(0);
            }

            public final void invoke() {
                HtmlReporter.access$append(this.this$0, "      <a class=\"mdl-navigation__link\" href=\"#overview\"><i class=\"material-icons\">dashboard</i>Overview</a>\n");
                for (List<Incident> warnings : this.$related) {
                    Incident first = warnings.get(0);
                    String anchor = first.getIssue().getId();
                    String desc = first.getIssue().getBriefDescription(TextFormat.HTML);
                    HtmlReporter.access$append(this.this$0, "      <a class=\"mdl-navigation__link\" href=\"#" + anchor + "\">");
                    if (first.getSeverity().isError()) {
                        HtmlReporter.access$append(this.this$0, "<i class=\"material-icons error-icon\">error</i>");
                    } else {
                        HtmlReporter.access$append(this.this$0, "<i class=\"material-icons warning-icon\">warning</i>");
                    }
                    HtmlReporter.access$append(this.this$0, desc + " (" + warnings.size() + ")</a>\n");
                }
            }
        }));
        Collection collection = incidents;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.append("\n<a name=\"overview\"></a>\n");
            HtmlReporter.writeCard$default(this, "Overview", true, "OverviewCard", null, (Function0)new Function0<Unit>(this, (List<? extends List<Incident>>)related, missing){
                final /* synthetic */ HtmlReporter this$0;
                final /* synthetic */ List<List<Incident>> $related;
                final /* synthetic */ Map<Issue, String> $missing;
                {
                    this.this$0 = $receiver;
                    this.$related = $related;
                    this.$missing = $missing;
                    super(0);
                }

                public final void invoke() {
                    HtmlReporter.access$writeOverview(this.this$0, this.$related, this.$missing.size());
                }
            }, 8, null);
            Category previousCategory = null;
            for (List warnings : related) {
                Category category = ((Incident)warnings.get(0)).getIssue().getCategory();
                if (category != previousCategory) {
                    previousCategory = category;
                    this.append("\n<a name=\"");
                    this.append(category.getFullName());
                    this.append("\"></a>\n");
                }
                this.writeIssueCard(warnings);
            }
            if (!this.client.isCheckingSpecificIssues()) {
                this.writeMissingIssues(missing);
            }
            this.writeSuppressIssuesCard();
        } else {
            this.writeCard("No Issues Found", "NoIssuesCard", (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ HtmlReporter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    HtmlReporter.access$append(this.this$0, "Congratulations!");
                }
            }));
        }
        this.finishReport();
        this.writeReport();
        File output = this.getOutput();
        if (!(this.client.getFlags().isQuiet() || output == null || stats.getErrorCount() <= 0 && stats.getWarningCount() <= 0)) {
            String url = SdkUtils.fileToUrlString((File)output.getAbsoluteFile());
            String string = Intrinsics.stringPlus((String)"Wrote HTML report to ", (Object)url);
            boolean bl2 = false;
            System.out.println((Object)string);
        }
    }

    private final void append(String s) {
        StringBuilder stringBuilder = this.sb;
        if (stringBuilder != null) {
            stringBuilder.append(s);
        }
    }

    private final void append(char s) {
        StringBuilder stringBuilder = this.sb;
        if (stringBuilder != null) {
            stringBuilder.append(s);
        }
    }

    private final void writeSuppressIssuesCard() {
        this.append("\n<a name=\"SuppressInfo\"></a>\n");
        this.writeCard("Suppressing Warnings and Errors", "SuppressCard", (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ HtmlReporter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                String string = Main.getSuppressHelp();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSuppressHelp()");
                HtmlReporter.access$append(this.this$0, TextFormat.RAW.convertTo(string, TextFormat.HTML));
                HtmlReporter.access$append(this.this$0, '\n');
            }
        }));
    }

    private final void writeIssueCard(List<Incident> incidents) {
        Issue firstIssue = incidents.get(0).getIssue();
        this.append(StringsKt.trimIndent((String)("\n            <a name=\"" + firstIssue.getId() + "\"></a>\n\n            ")));
        this.writeCard(XmlUtils.toXmlTextValue((String)firstIssue.getBriefDescription(TextFormat.TEXT)), true, Intrinsics.stringPlus((String)firstIssue.getId(), (Object)"Card"), CollectionsKt.listOf((Object)new Action("Explain", HtmlReporter.Companion.getExplanationId(firstIssue), "reveal")), (Function0<Unit>)((Function0)new Function0<Unit>(incidents, this){
            final /* synthetic */ List<Incident> $incidents;
            final /* synthetic */ HtmlReporter this$0;
            {
                this.$incidents = $incidents;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                IssueRegistry issueRegistry;
                Incident issueVendor;
                Incident incident2;
                Incident first = this.$incidents.get(0);
                Issue issue = first.getIssue();
                HtmlReporter.access$append(this.this$0, "<div class=\"issue\">\n");
                HtmlReporter.access$append(this.this$0, "<div class=\"warningslist\">\n");
                boolean partialHide = this.$incidents.size() > HtmlReporter.access$getSPLIT_LIMIT$cp();
                int count = 0;
                for (Incident incident2 : this.$incidents) {
                    ApplicableVariants applicableVariants;
                    CharSequence fileContents;
                    if (count >= HtmlReporter.access$getMAX_COUNT$cp()) {
                        if (count == HtmlReporter.access$getMAX_COUNT$cp()) {
                            HtmlReporter.access$append(this.this$0, "<br/><b>NOTE: " + (this.$incidents.size() - count) + " results omitted.</b><br/><br/>");
                        }
                        int n = count;
                        count = n + 1;
                        continue;
                    }
                    if (partialHide && count == HtmlReporter.access$getSHOWN_COUNT$cp()) {
                        String id = Intrinsics.stringPlus((String)incident2.getIssue().getId(), (Object)"Div");
                        HtmlReporter.access$append(this.this$0, "<button");
                        HtmlReporter.access$append(this.this$0, " class=\"mdl-button mdl-js-button mdl-button--primary\"");
                        HtmlReporter.access$append(this.this$0, " id=\"");
                        HtmlReporter.access$append(this.this$0, id);
                        HtmlReporter.access$append(this.this$0, "Link\" onclick=\"reveal('");
                        HtmlReporter.access$append(this.this$0, id);
                        HtmlReporter.access$append(this.this$0, "');\" />");
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string = "+ %1$d More Occurrences...";
                        Object[] objectArray = new Object[]{this.$incidents.size() - HtmlReporter.access$getSHOWN_COUNT$cp()};
                        boolean bl = false;
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                        HtmlReporter.access$append(this.this$0, string2);
                        HtmlReporter.access$append(this.this$0, "</button>\n");
                        HtmlReporter.access$append(this.this$0, "<div id=\"");
                        HtmlReporter.access$append(this.this$0, id);
                        HtmlReporter.access$append(this.this$0, "\" style=\"display: none\">\n");
                    }
                    int id = count;
                    count = id + 1;
                    String url = HtmlReporter.access$writeLocation(this.this$0, incident2.getFile(), incident2.getDisplayPath(), incident2.getLine());
                    HtmlReporter.access$append(this.this$0, ':');
                    HtmlReporter.access$append(this.this$0, ' ');
                    boolean addedImage = false;
                    if (url != null && incident2.getLocation().getSecondary() == null) {
                        addedImage = HtmlReporter.access$addImage(this.this$0, url, incident2.getFile(), incident2.getLocation());
                    }
                    String rawMessage = incident2.getMessage();
                    if (issue == IssueRegistry.LINT_ERROR && StringsKt.contains$default((CharSequence)rawMessage, (CharSequence)"\u2190", (boolean)false, (int)2, null)) {
                        rawMessage = StringsKt.replace$default((String)rawMessage, (String)"\u2190", (String)"\n\u2190", (boolean)false, (int)4, null);
                    }
                    HtmlReporter.access$append(this.this$0, "<span class=\"message\">");
                    HtmlReporter.access$append(this.this$0, TextFormat.RAW.convertTo(rawMessage, TextFormat.HTML));
                    HtmlReporter.access$append(this.this$0, "</span>");
                    if (addedImage) {
                        HtmlReporter.access$append(this.this$0, "<br clear=\"right\"/>");
                    } else {
                        HtmlReporter.access$append(this.this$0, "<br />");
                    }
                    if (incident2.getWasAutoFixed()) {
                        HtmlReporter.access$append(this.this$0, "This issue has been automatically fixed.<br />");
                    }
                    CharSequence charSequence = fileContents = incident2.getLine() >= 0 ? this.this$0.client.getSourceText(incident2.getFile()) : null;
                    if (fileContents != null && incident2.getStartOffset() != -1 && incident2.getEndOffset() != -1) {
                        HtmlReporter.access$appendCodeBlock(this.this$0, incident2.getFile(), fileContents, incident2.getStartOffset(), incident2.getEndOffset(), incident2.getSeverity());
                    }
                    HtmlReporter.access$append(this.this$0, '\n');
                    if (incident2.getLocation().getSecondary() != null) {
                        String path;
                        int line2;
                        int n;
                        Location l;
                        HtmlReporter.access$append(this.this$0, "<ul>");
                        int otherLocations = 0;
                        int shownSnippetsCount = 0;
                        for (l = incident2.getLocation().getSecondary(); l != null; l = l.getSecondary()) {
                            String message2 = l.getMessage();
                            if (message2 != null) {
                                CharSequence charSequence2 = message2;
                                boolean bl = false;
                                if (charSequence2.length() > 0) {
                                    CharSequence s;
                                    Position start = l.getStart();
                                    Position position = start;
                                    line2 = position == null ? -1 : (n = position.getLine());
                                    path = this.this$0.client.getDisplayPath(incident2.getProject(), l.getFile());
                                    HtmlReporter.access$writeLocation(this.this$0, l.getFile(), path, line2);
                                    HtmlReporter.access$append(this.this$0, ':');
                                    HtmlReporter.access$append(this.this$0, ' ');
                                    HtmlReporter.access$append(this.this$0, "<span class=\"message\">");
                                    HtmlReporter.access$append(this.this$0, TextFormat.RAW.convertTo(message2, TextFormat.HTML));
                                    HtmlReporter.access$append(this.this$0, "</span>");
                                    HtmlReporter.access$append(this.this$0, "<br />");
                                    if (shownSnippetsCount >= 3 || SdkUtils.isBitmapFile((File)l.getFile())) continue;
                                    CharSequence charSequence3 = s = this.this$0.client.readFile(l.getFile());
                                    boolean bl2 = false;
                                    if (charSequence3.length() > 0) {
                                        int n2;
                                        int n3;
                                        Position position2 = start;
                                        int offset = position2 == null ? -1 : (n3 = position2.getOffset());
                                        Position position3 = l.getEnd();
                                        int endOffset = position3 == null ? -1 : (n2 = position3.getOffset());
                                        HtmlReporter.access$appendCodeBlock(this.this$0, l.getFile(), s, offset, endOffset, incident2.getSeverity());
                                    }
                                    int n4 = shownSnippetsCount;
                                    shownSnippetsCount = n4 + 1;
                                    continue;
                                }
                            }
                            int start = otherLocations;
                            otherLocations = start + 1;
                        }
                        HtmlReporter.access$append(this.this$0, "</ul>");
                        if (otherLocations > 0) {
                            String id2 = "Location" + count + "Div";
                            HtmlReporter.access$append(this.this$0, "<button id=\"");
                            HtmlReporter.access$append(this.this$0, id2);
                            HtmlReporter.access$append(this.this$0, "Link\" onclick=\"reveal('");
                            HtmlReporter.access$append(this.this$0, id2);
                            HtmlReporter.access$append(this.this$0, "');\" />");
                            HtmlReporter.access$append(this.this$0, "+ " + otherLocations + " Additional Locations...");
                            HtmlReporter.access$append(this.this$0, "</button>\n");
                            HtmlReporter.access$append(this.this$0, "<div id=\"");
                            HtmlReporter.access$append(this.this$0, id2);
                            HtmlReporter.access$append(this.this$0, "\" style=\"display: none\">\n");
                            HtmlReporter.access$append(this.this$0, "Additional locations: ");
                            HtmlReporter.access$append(this.this$0, "<ul>\n");
                            for (l = incident2.getLocation().getSecondary(); l != null; l = l.getSecondary()) {
                                Position start = l.getStart();
                                path = start;
                                line2 = path == null ? -1 : (n = path.getLine());
                                path = this.this$0.client.getDisplayPath(incident2.getProject(), l.getFile());
                                HtmlReporter.access$append(this.this$0, "<li> ");
                                HtmlReporter.access$writeLocation(this.this$0, l.getFile(), path, line2);
                                HtmlReporter.access$append(this.this$0, "\n");
                            }
                            HtmlReporter.access$append(this.this$0, "</ul>\n");
                            HtmlReporter.access$append(this.this$0, "</div><br/><br/>\n");
                        }
                    }
                    if (!addedImage && url != null && incident2.getLocation().getSecondary() != null) {
                        HtmlReporter.access$addImage(this.this$0, url, incident2.getFile(), incident2.getLocation());
                    }
                    if ((applicableVariants = incident2.getApplicableVariants()) == null || !applicableVariants.getVariantSpecific()) continue;
                    HtmlReporter.access$append(this.this$0, "\n");
                    HtmlReporter.access$append(this.this$0, "Applies to variants: ");
                    String otherLocations = Joiner.on((String)", ").join((Iterable)applicableVariants.getIncludedVariantNames());
                    Intrinsics.checkNotNullExpressionValue((Object)otherLocations, (String)"on(\", \").join(applicable\u2026nts.includedVariantNames)");
                    HtmlReporter.access$append(this.this$0, otherLocations);
                    HtmlReporter.access$append(this.this$0, "<br/>\n");
                    HtmlReporter.access$append(this.this$0, "Does <b>not</b> apply to variants: ");
                    otherLocations = Joiner.on((String)", ").join((Iterable)applicableVariants.getExcludedVariantNames());
                    Intrinsics.checkNotNullExpressionValue((Object)otherLocations, (String)"on(\", \").join(applicable\u2026nts.excludedVariantNames)");
                    HtmlReporter.access$append(this.this$0, otherLocations);
                    HtmlReporter.access$append(this.this$0, "<br/>\n");
                }
                if (partialHide) {
                    HtmlReporter.access$append(this.this$0, "</div>\n");
                }
                HtmlReporter.access$append(this.this$0, "</div>\n");
                HtmlReporter.access$writeIssueMetadata(this.this$0, issue, null, true);
                HtmlReporter.access$append(this.this$0, "</div>\n");
                incident2 = issue.getVendor();
                incident2 = issueVendor = incident2 == null ? ((issueRegistry = issue.getRegistry()) == null ? null : issueRegistry.getVendor()) : incident2;
                if (incident2 != null) {
                    Incident incident3 = incident2;
                    HtmlReporter htmlReporter = this.this$0;
                    boolean bl = false;
                    boolean bl3 = false;
                    Incident vendor = incident3;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)vendor, (Object)IssueRegistry.Companion.getAOSP_VENDOR())) {
                        HtmlReporter.access$append(htmlReporter, "<div class=\"vendor\">\n");
                        StringBuilder stringBuilder = HtmlReporter.access$getSb$p(htmlReporter);
                        Intrinsics.checkNotNull((Object)stringBuilder);
                        Vendor.describeInto$default((Vendor)vendor, (StringBuilder)stringBuilder, (TextFormat)TextFormat.HTML, null, (int)4, null);
                        HtmlReporter.access$append(htmlReporter, "</div>\n");
                    }
                }
                HtmlReporter.access$append(this.this$0, "<div class=\"chips\">\n");
                HtmlReporter.access$writeChip(this.this$0, issue.getId());
                for (Category category = issue.getCategory(); category != null && category != Category.LINT; category = category.getParent()) {
                    HtmlReporter.access$writeChip(this.this$0, category.getName());
                }
                HtmlReporter.access$writeChip(this.this$0, first.getSeverity().getDescription());
                HtmlReporter.access$writeChip(this.this$0, "Priority " + issue.getPriority() + "/10");
                HtmlReporter.access$append(this.this$0, "</div>\n");
            }
        }));
    }

    private final void startReport(LintStats stats) {
        StringBuilder stringBuilder = this.sb = new StringBuilder(1800 * stats.count());
        Intrinsics.checkNotNull((Object)stringBuilder);
        this.builder = new HtmlBuilder(stringBuilder);
        this.writeOpenHtmlTag();
        this.writeHeadTag();
        this.writeOpenBodyTag();
    }

    private final void finishReport() {
        this.writeCloseNavigationHeader();
        this.writeCloseBodyTag();
        this.writeCloseHtmlTag();
    }

    private final void writeNavigationHeader(LintStats stats, Function0<Unit> appender) {
        this.append("<div class=\"mdl-layout mdl-js-layout mdl-layout--fixed-header\">\n  <header class=\"mdl-layout__header\">\n    <div class=\"mdl-layout__header-row\">\n      <span class=\"mdl-layout-title\">" + this.title + ": " + Lint.describeCounts((int)stats.getErrorCount(), (int)stats.getWarningCount(), (boolean)false, (boolean)true) + "</span>\n      <div class=\"mdl-layout-spacer\"></div>\n      <nav class=\"mdl-navigation mdl-layout--large-screen-only\">\n");
        this.append(Intrinsics.stringPlus((String)"Check performed at ", (Object)new Date()));
        this.append("      </nav>\n    </div>\n  </header>\n  <div class=\"mdl-layout__drawer\">\n    <span class=\"mdl-layout-title\">Issue Types</span>\n    <nav class=\"mdl-navigation\">\n");
        appender.invoke();
        this.append("    </nav>\n  </div>\n  <main class=\"mdl-layout__content\">\n    <div class=\"mdl-layout__tab-panel is-active\">");
    }

    private final void writeCloseNavigationHeader() {
        this.append("    </div>\n  </main>\n</div>");
    }

    private final void writeOpenBodyTag() {
        this.append("<body class=\"mdl-color--grey-100 mdl-color-text--grey-700 mdl-base\">\n");
    }

    private final void writeCloseBodyTag() {
        this.append("\n</body>\n");
    }

    private final void writeOpenHtmlTag() {
        this.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
    }

    private final void writeCloseHtmlTag() {
        this.append("</html>");
    }

    private final void writeHeadTag() {
        this.append("\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n<title>" + this.title + "</title>\n");
        this.append("<link rel=\"stylesheet\" href=\"https://fonts.googleapis.com/icon?family=Material+Icons\">\n <link rel=\"stylesheet\" href=\"https://code.getmdl.io/1.2.1/material.blue-indigo.min.css\" />\n<link rel=\"stylesheet\" href=\"http://fonts.googleapis.com/css?family=Roboto:300,400,500,700\" type=\"text/css\">\n<script defer src=\"https://code.getmdl.io/1.2.0/material.min.js\"></script>\n");
        this.append("<style>\n" + Companion.getCssStyles() + "</style>\n");
        this.append("<script language=\"javascript\" type=\"text/javascript\">\n<!--\nfunction reveal(id) {\nif (document.getElementById) {\ndocument.getElementById(id).style.display = 'block';\ndocument.getElementById(id+'Link').style.display = 'none';\n}\n}\nfunction hideid(id) {\nif (document.getElementById) {\ndocument.getElementById(id).style.display = 'none';\n}\n}\n//-->\n</script>\n");
        this.append("</head>\n");
    }

    private final void writeIssueMetadata(Issue issue, String disabledBy, boolean hide) {
        int count;
        this.append("<div class=\"metadata\">");
        if (disabledBy != null) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Disabled By: %1$s<br/>\n";
            Object[] objectArray = new Object[]{disabledBy};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            this.append(string2);
        }
        this.append("<div class=\"explanation\"");
        if (hide) {
            this.append(" id=\"" + HtmlReporter.Companion.getExplanationId(issue) + "\" style=\"display: none;\"");
        }
        this.append(">\n");
        String explanationHtml = issue.getExplanation(TextFormat.HTML);
        this.append(explanationHtml);
        List moreInfo = issue.getMoreInfo();
        this.append("<br/>");
        List options = issue.getOptions();
        Collection collection = options;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.append("<br/>\nThis check can be configured via the following options:<br/><br/>\n");
            this.append("<div class=\"options\">\n");
            for (Option option : options) {
                this.append(option.describe(TextFormat.HTML, false));
                this.append("<br/>\n");
                this.append("To configure this option, use a `lint.xml` file in the project or source folder using an <code>&lt;option&gt;</code> block like the following:\n");
                String name = option.getName();
                String defaultValue = option.defaultAsString();
                HtmlBuilder builder = new HtmlBuilder();
                String string = defaultValue;
                String snippet = "<lint>\n    <issue id=\"" + issue.getId() + "\">\n        <option name=\"" + name + "\" value=\"" + (string == null ? "some string" : string) + "\" />\n    </issue>\n</lint>\n";
                LintSyntaxHighlighter highlighter = new LintSyntaxHighlighter("lint.xml", snippet);
                highlighter.setPadCaretLine(true);
                highlighter.setDedent(true);
                int start = StringsKt.indexOf$default((CharSequence)snippet, (String)name, (int)0, (boolean)false, (int)6, null) - 1;
                int end = StringsKt.lastIndexOf$default((CharSequence)snippet, (String)" />", (int)0, (boolean)false, (int)6, null);
                highlighter.generateHtml(builder, start, end, false);
                String highlighted = builder.getHtml();
                Intrinsics.checkNotNullExpressionValue((Object)highlighted, (String)"highlighted");
                this.append(highlighted);
            }
            this.append("</div>");
        }
        if ((count = moreInfo.size()) > 0) {
            this.append("<div class=\"moreinfo\">");
            this.append("More info: ");
            if (count > 1) {
                this.append("<ul>");
            }
            for (String uri : moreInfo) {
                if (count > 1) {
                    this.append("<li>");
                }
                this.append("<a href=\"");
                this.append(uri);
                this.append("\">");
                this.append(uri);
                this.append("</a>\n");
            }
            if (count > 1) {
                this.append("</ul>");
            }
            this.append("</div>");
        }
        if (this.client.getRegistry() instanceof BuiltinIssueRegistry && Reporter.Companion.hasAutoFix(issue)) {
            this.append("Note: This issue has an associated quickfix operation in Android Studio and IntelliJ IDEA.");
            this.append("<br>\n");
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "To suppress this error, use the issue id \"%1$s\" as explained in the %2$sSuppressing Warnings and Errors%3$s section.";
        Object[] objectArray = new Object[]{issue.getId(), "<a href=\"#SuppressInfo\">", "</a>"};
        boolean bl2 = false;
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        this.append(string3);
        this.append("<br/>\n");
        this.append("<br/>");
        this.append("</div>");
        this.append("\n</div>\n");
    }

    private final Map<Issue, String> computeMissingIssues(List<Incident> incidents) {
        Object it;
        Object object;
        Object object2;
        Set projects = new HashSet();
        Set seen = new HashSet();
        for (Incident incident : incidents) {
            object2 = incident.getProject();
            if (object2 != null) {
                object = object2;
                boolean bl = false;
                boolean bl2 = false;
                it = object;
                boolean bl3 = false;
                projects.add(it);
            }
            seen.add(incident.getIssue());
        }
        Configuration cliConfiguration = this.client.getConfigurations().getFallback();
        object2 = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"newHashMap()");
        Map map = (Map)object2;
        IssueRegistry issueRegistry = this.client.getRegistry();
        Object object3 = object = issueRegistry == null ? null : issueRegistry.getIssues();
        if (object == null) {
            return map;
        }
        Object issues = object;
        object = issues.iterator();
        block1: while (object.hasNext()) {
            Object object4;
            Issue issue = (Issue)object.next();
            if (seen.contains(issue)) continue;
            if (this.client.isSuppressed(issue)) {
                object4 = map;
                it = "Command line flag";
                boolean bl = false;
                object4.put(issue, it);
                continue;
            }
            if (!(issue.isEnabledByDefault() || this.client.isAllEnabled() || this.client.isExplicitlyEnabled(issue))) {
                object4 = map;
                it = "Default";
                boolean bl = false;
                object4.put(issue, it);
                continue;
            }
            if (cliConfiguration != null && !cliConfiguration.isEnabled(issue)) {
                object4 = map;
                it = "Command line supplied --config lint.xml file";
                boolean bl = false;
                object4.put(issue, it);
                continue;
            }
            for (Project project : projects) {
                if (project.getConfiguration(null).isEnabled(issue)) continue;
                Map map2 = map;
                String string = "Project lint.xml file";
                boolean bl = false;
                map2.put(issue, string);
                continue block1;
            }
        }
        return map;
    }

    private final void writeMissingIssues(Map<Issue, String> missing) {
        if (!this.client.isCheckingSpecificIssues()) {
            this.append("\n<a name=\"MissingIssues\"></a>\n");
            this.writeCard("Disabled Checks", true, "MissingIssuesCard", CollectionsKt.listOf((Object)new Action("List Missing Issues", "SuppressedIssues", "reveal")), (Function0<Unit>)((Function0)new Function0<Unit>(this, missing){
                final /* synthetic */ HtmlReporter this$0;
                final /* synthetic */ Map<Issue, String> $missing;
                {
                    this.this$0 = $receiver;
                    this.$missing = $missing;
                    super(0);
                }

                public final void invoke() {
                    HtmlReporter.access$append(this.this$0, "One or more issues were not run by lint, either\nbecause the check is not enabled by default, or because\nit was disabled with a command line flag or via one or\nmore <code>lint.xml</code> configuration files in the project directories.\n");
                    HtmlReporter.access$append(this.this$0, "<div id=\"SuppressedIssues\" style=\"display: none;\">");
                    ArrayList<E> list2 = new ArrayList<E>(this.$missing.keySet());
                    CollectionsKt.sort((List)list2);
                    HtmlReporter.access$append(this.this$0, "<br/><br/>");
                    for (Issue issue : list2) {
                        HtmlReporter.access$append(this.this$0, "<div class=\"issue\">\n");
                        HtmlReporter.access$append(this.this$0, "<div class=\"id\">");
                        HtmlReporter.access$append(this.this$0, issue.getId());
                        HtmlReporter.access$append(this.this$0, "<div class=\"issueSeparator\"></div>\n");
                        HtmlReporter.access$append(this.this$0, "</div>\n");
                        String disabledBy = this.$missing.get(issue);
                        Intrinsics.checkNotNullExpressionValue((Object)issue, (String)"issue");
                        HtmlReporter.access$writeIssueMetadata(this.this$0, issue, disabledBy, false);
                        HtmlReporter.access$append(this.this$0, "</div>\n");
                    }
                    HtmlReporter.access$append(this.this$0, "</div>");
                }
            }));
        }
    }

    private final void writeOverview(List<? extends List<Incident>> related, int missingCount) {
        this.append("<table class=\"overview\">\n");
        Category previousCategory = null;
        for (List<Incident> string : related) {
            Incident first = string.get(0);
            Issue issue = first.getIssue();
            boolean isError = first.getSeverity().isError();
            if (issue.getCategory() != previousCategory) {
                this.append("<tr><td class=\"countColumn\"></td><td class=\"categoryColumn\">");
                previousCategory = issue.getCategory();
                String categoryName = issue.getCategory().getFullName();
                this.append("<a href=\"#");
                this.append(categoryName);
                this.append("\">");
                this.append(categoryName);
                this.append("</a>\n");
                this.append("</td></tr>");
                this.append("\n");
            }
            this.append("<tr>\n");
            this.append("<td class=\"countColumn\">");
            this.append(String.valueOf(string.size()));
            this.append("</td>");
            this.append("<td class=\"issueColumn\">");
            if (isError) {
                this.append("<i class=\"material-icons error-icon\">error</i>");
            } else {
                this.append("<i class=\"material-icons warning-icon\">warning</i>");
            }
            this.append('\n');
            this.append("<a href=\"#");
            this.append(issue.getId());
            this.append("\">");
            this.append(issue.getId());
            this.append("</a>");
            this.append(": ");
            this.append(issue.getBriefDescription(TextFormat.HTML));
            this.append("</td></tr>\n");
        }
        if (missingCount > 0 && !this.client.isCheckingSpecificIssues()) {
            this.append("<tr><td></td>");
            this.append("<td class=\"categoryColumn\">");
            this.append("<a href=\"#MissingIssues\">");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Disabled Checks (%1$d)";
            Object[] objectArray = new Object[]{missingCount};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            this.append(string2);
            this.append("</a>\n");
            this.append("</td></tr>");
        }
        this.append("</table>\n");
        this.append("<br/>");
    }

    private final void writeCardHeader(String title, String cardId) {
        this.append("<section class=\"section--center mdl-grid mdl-grid--no-spacing mdl-shadow--2dp\" id=\"" + cardId + "\" style=\"display: block;\">\n            <div class=\"mdl-card mdl-cell mdl-cell--12-col\">\n");
        if (title != null) {
            this.append("  <div class=\"mdl-card__title\">\n    <h2 class=\"mdl-card__title-text\">" + title + "</h2>\n  </div>\n");
        }
        this.append("              <div class=\"mdl-card__supporting-text\">\n");
    }

    private final void writeCardAction(List<Action> actions) {
        this.append("              </div>\n              <div class=\"mdl-card__actions mdl-card--border\">\n");
        for (Action action : actions) {
            this.append("<button class=\"mdl-button mdl-js-button mdl-js-ripple-effect\" id=\"" + action.getId() + "Link\" onclick=\"" + action.getFunction() + "('" + action.getId() + "');\">\n" + action.getTitle() + "</button>");
        }
    }

    private final void writeCardFooter() {
        this.append("            </div>\n            </div>\n          </section>");
    }

    private final void writeCard(String title, String cardId, Function0<Unit> appender) {
        HtmlReporter.writeCard$default(this, title, false, cardId, null, appender, 8, null);
    }

    private final void writeChip(String text) {
        this.append(StringsKt.trimIndent((String)("\n            <span class=\"mdl-chip\">\n                <span class=\"mdl-chip__text\">" + text + "</span>\n            </span>\n\n            ")));
    }

    private final void writeCard(String title, boolean dismissible, String cardId, List<Action> actions, Function0<Unit> appender) {
        String string;
        String string2 = cardId;
        if (string2 == null) {
            HtmlReporter htmlReporter = this;
            boolean bl = false;
            boolean bl2 = false;
            HtmlReporter $this$writeCard_u24lambda_u2d1 = htmlReporter;
            boolean bl3 = false;
            HtmlReporter htmlReporter2 = $this$writeCard_u24lambda_u2d1;
            int n = htmlReporter2.cardNumber;
            htmlReporter2.cardNumber = n + 1;
            int card = n;
            string = HtmlReporter.Companion.getCardId(card);
        } else {
            string = string2;
        }
        String cardId2 = string;
        this.usedCardIds.add(cardId2);
        this.writeCardHeader(title, cardId2);
        appender.invoke();
        if (dismissible) {
            String dismissTitle = "Dismiss";
            if (Intrinsics.areEqual((Object)"New Lint Report Format", (Object)title)) {
                dismissTitle = "Got It";
            }
            List merged = CollectionsKt.plus((Collection)actions, (Object)new Action(dismissTitle, cardId2, "hideid"));
            this.writeCardAction(merged);
        }
        this.writeCardFooter();
    }

    static /* synthetic */ void writeCard$default(HtmlReporter htmlReporter, String string, boolean bl, String string2, List list2, Function0 function0, int n, Object object) {
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        htmlReporter.writeCard(string, bl, string2, list2, (Function0<Unit>)function0);
    }

    private final String writeLocation(File file, String path, int line2) {
        this.append("<span class=\"location\">");
        String url = this.getUrl(file);
        if (url != null) {
            this.append("<a href=\"");
            this.append(url);
            this.append("\">");
        }
        String displayPath = this.stripPath(path);
        if (url != null && StringsKt.startsWith$default((String)url, (String)"../", (boolean)false, (int)2, null) && new File(displayPath).isAbsolute()) {
            displayPath = url;
        }
        if (StringsKt.contains$default((CharSequence)displayPath, (CharSequence)"transforms-1", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)displayPath, (String)"lint.jar", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)displayPath, (CharSequence)".aar", (boolean)false, (int)2, null)) {
            int aarIndex = StringsKt.indexOf$default((CharSequence)displayPath, (String)".aar", (int)0, (boolean)false, (int)6, null);
            int startWin = StringsKt.lastIndexOf$default((CharSequence)displayPath, (char)'\\', (int)aarIndex, (boolean)false, (int)4, null) + 1;
            int startUnix = StringsKt.lastIndexOf$default((CharSequence)displayPath, (char)'/', (int)aarIndex, (boolean)false, (int)4, null) + 1;
            boolean bl = false;
            int start = Math.max(startWin, startUnix);
            StringBuilder stringBuilder = new StringBuilder();
            String string = displayPath;
            int n = aarIndex + 4;
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(start, n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            displayPath = stringBuilder.append(string3).append((Object)File.separator).append("...").append((Object)File.separator).append("lint.jar").toString();
        }
        this.append(displayPath);
        if (url != null) {
            this.append("</a>");
        }
        if (line2 >= 0) {
            this.append(':');
            this.append(String.valueOf(line2 + 1));
        }
        this.append("</span>");
        return url;
    }

    private final boolean addImage(String url, File urlFile, Location location) {
        if (url != null && urlFile != null && SdkUtils.isBitmapFile((File)urlFile)) {
            if (location.getSecondary() != null) {
                boolean bl = false;
                List files = new ArrayList();
                for (Location curr = location; curr != null; curr = curr.getSecondary()) {
                    File file = curr.getFile();
                    if (!SdkUtils.isBitmapFile((File)file)) continue;
                    files.add(file);
                }
                CollectionsKt.sortWith((List)files, ICON_DENSITY_COMPARATOR);
                boolean bl2 = false;
                List urls = new ArrayList();
                for (File file : files) {
                    String imageUrl = this.getUrl(file);
                    if (imageUrl == null) continue;
                    urls.add(imageUrl);
                }
                Iterator iterator = urls;
                boolean file = false;
                if (!iterator.isEmpty()) {
                    this.append("<table>\n");
                    this.append("<tr>");
                    for (String linkedUrl : urls) {
                        this.append("<td>");
                        this.append("<a href=\"");
                        this.append(linkedUrl);
                        this.append("\">");
                        this.append("<img border=\"0\" align=\"top\" src=\"");
                        this.append(linkedUrl);
                        this.append("\" /></a>\n");
                        this.append("</td>");
                    }
                    this.append("</tr>");
                    this.append("<tr>");
                    for (String linkedUrl : urls) {
                        int end;
                        this.append("<th>");
                        int index = StringsKt.lastIndexOf$default((CharSequence)linkedUrl, (String)"drawable-", (int)0, (boolean)false, (int)6, null);
                        if (index != -1 && (end = StringsKt.indexOf$default((CharSequence)linkedUrl, (char)'/', (int)(index += "drawable-".length()), (boolean)false, (int)4, null)) != -1) {
                            String string = linkedUrl;
                            boolean bl3 = false;
                            String string2 = string;
                            if (string2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string3 = string2.substring(index, end);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            this.append(string3);
                        }
                        this.append("</th>");
                    }
                    this.append("</tr>\n");
                    this.append("</table>\n");
                }
            } else {
                this.append("<img class=\"embedimage\" align=\"right\" src=\"");
                this.append(url);
                this.append("\" />");
            }
            return true;
        }
        return false;
    }

    @Override
    public void writeProjectList(@NotNull LintStats stats, @NotNull List<MultiProjectHtmlReporter.ProjectEntry> projects) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        this.startReport(stats);
        this.writeNavigationHeader(stats, (Function0<Unit>)((Function0)new Function0<Unit>(projects, this){
            final /* synthetic */ List<MultiProjectHtmlReporter.ProjectEntry> $projects;
            final /* synthetic */ HtmlReporter this$0;
            {
                this.$projects = $projects;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                for (MultiProjectHtmlReporter.ProjectEntry entry : this.$projects) {
                    String href = XmlUtils.toXmlAttributeValue((String)entry.getFileName());
                    String path = entry.getPath();
                    int count = entry.getErrorCount() + entry.getWarningCount();
                    HtmlReporter.access$append(this.this$0, "      <a class=\"mdl-navigation__link\" href=\"" + href + "\">" + path + " (" + count + ")</a>\n");
                }
            }
        }));
        if (stats.getErrorCount() == 0 && stats.getWarningCount() == 0) {
            this.writeCard("No Issues Found", "NoIssuesCard", (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ HtmlReporter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    HtmlReporter.access$append(this.this$0, "Congratulations!");
                }
            }));
            return;
        }
        this.writeCard("Projects", "OverviewCard", (Function0<Unit>)((Function0)new Function0<Unit>(this, projects){
            final /* synthetic */ HtmlReporter this$0;
            final /* synthetic */ List<MultiProjectHtmlReporter.ProjectEntry> $projects;
            {
                this.this$0 = $receiver;
                this.$projects = $projects;
                super(0);
            }

            public final void invoke() {
                HtmlReporter.access$append(this.this$0, "<table class=\"overview\">\n");
                HtmlReporter.access$append(this.this$0, "<tr><th>");
                HtmlReporter.access$append(this.this$0, "Project");
                HtmlReporter.access$append(this.this$0, "</th><th class=\"countColumn\">");
                HtmlReporter.access$append(this.this$0, "Errors");
                HtmlReporter.access$append(this.this$0, "</th><th class=\"countColumn\">");
                HtmlReporter.access$append(this.this$0, "Warnings");
                HtmlReporter.access$append(this.this$0, "</th></tr>\n");
                for (MultiProjectHtmlReporter.ProjectEntry entry : this.$projects) {
                    HtmlReporter.access$append(this.this$0, "<tr><td>");
                    HtmlReporter.access$append(this.this$0, "<a href=\"");
                    String string = XmlUtils.toXmlAttributeValue((String)entry.getFileName());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toXmlAttributeValue(entry.fileName)");
                    HtmlReporter.access$append(this.this$0, string);
                    HtmlReporter.access$append(this.this$0, "\">");
                    HtmlReporter.access$append(this.this$0, entry.getPath());
                    HtmlReporter.access$append(this.this$0, "</a></td><td class=\"countColumn\">");
                    HtmlReporter.access$append(this.this$0, String.valueOf(entry.getErrorCount()));
                    HtmlReporter.access$append(this.this$0, "</td><td class=\"countColumn\">");
                    HtmlReporter.access$append(this.this$0, String.valueOf(entry.getWarningCount()));
                    HtmlReporter.access$append(this.this$0, "</td></tr>\n");
                    HtmlReporter.access$append(this.this$0, "<tr>\n");
                }
                HtmlReporter.access$append(this.this$0, "</table>\n");
                HtmlReporter.access$append(this.this$0, "<br/>");
            }
        }));
        this.finishReport();
        this.writeReport();
    }

    private final void writeReport() throws IOException {
        this.writer.write(String.valueOf(this.sb));
        this.writer.close();
        this.sb = null;
        this.builder = null;
    }

    private final LintSyntaxHighlighter getHighlighter(File file, CharSequence contents) {
        if (this.highlightedFile == null || !Intrinsics.areEqual((Object)this.highlightedFile, (Object)file.getPath())) {
            LintSyntaxHighlighter highlighter;
            this.highlighter = highlighter = new LintSyntaxHighlighter(file.getName(), ((Object)contents).toString());
            highlighter.setPadCaretLine(true);
            highlighter.setDedent(true);
            this.highlightedFile = file.getPath();
        }
        LintSyntaxHighlighter lintSyntaxHighlighter = this.highlighter;
        Intrinsics.checkNotNull((Object)lintSyntaxHighlighter);
        return lintSyntaxHighlighter;
    }

    private final void appendCodeBlock(File file, CharSequence contents, int startOffset, int endOffset, Severity severity) {
        HtmlBuilder htmlBuilder = this.builder;
        if (htmlBuilder == null) {
            return;
        }
        HtmlBuilder builder = htmlBuilder;
        int n = 0;
        int n2 = 0;
        int start = Math.max(n, startOffset);
        n2 = contents.length();
        boolean bl = false;
        n2 = Math.min(endOffset, n2);
        bl = false;
        int end = Math.max(start, n2);
        this.getHighlighter(file, contents).generateHtml(builder, start, end, severity.isError());
    }

    public static final /* synthetic */ void access$append(HtmlReporter $this, String s) {
        $this.append(s);
    }

    public static final /* synthetic */ void access$writeOverview(HtmlReporter $this, List related, int missingCount) {
        $this.writeOverview(related, missingCount);
    }

    public static final /* synthetic */ void access$append(HtmlReporter $this, char s) {
        $this.append(s);
    }

    public static final /* synthetic */ int access$getMAX_COUNT$cp() {
        return MAX_COUNT;
    }

    public static final /* synthetic */ int access$getSHOWN_COUNT$cp() {
        return SHOWN_COUNT;
    }

    public static final /* synthetic */ String access$writeLocation(HtmlReporter $this, File file, String path, int line2) {
        return $this.writeLocation(file, path, line2);
    }

    public static final /* synthetic */ boolean access$addImage(HtmlReporter $this, String url, File urlFile, Location location) {
        return $this.addImage(url, urlFile, location);
    }

    public static final /* synthetic */ void access$appendCodeBlock(HtmlReporter $this, File file, CharSequence contents, int startOffset, int endOffset, Severity severity) {
        $this.appendCodeBlock(file, contents, startOffset, endOffset, severity);
    }

    public static final /* synthetic */ void access$writeIssueMetadata(HtmlReporter $this, Issue issue, String disabledBy, boolean hide) {
        $this.writeIssueMetadata(issue, disabledBy, hide);
    }

    public static final /* synthetic */ void access$writeChip(HtmlReporter $this, String text) {
        $this.writeChip(text);
    }

    public static final /* synthetic */ StringBuilder access$getSb$p(HtmlReporter $this) {
        return $this.sb;
    }

    static {
        preferredThemeName = "light";
        cssSyntaxColors = "";
        Companion.initializePreferences();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/HtmlReporter$Action;", "", "title", "", "id", "function", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFunction", "()Ljava/lang/String;", "getId", "getTitle", "lint-cli"})
    public static final class Action {
        @NotNull
        private final String title;
        @NotNull
        private final String id;
        @NotNull
        private final String function;

        public Action(@NotNull String title, @NotNull String id, @NotNull String function) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            this.title = title;
            this.id = id;
            this.function = function;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getFunction() {
            return this.function;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0#0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J\u0010\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u0004H\u0002J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0007H\u0002J\u0010\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020,H\u0002J\u0006\u0010-\u001a\u00020.R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u0002\u001a\u0004\b\u001a\u0010\u0016R\u001a\u0010\u001b\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u0002\u001a\u0004\b\u001d\u0010\u0016R\u001a\u0010\u001e\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010\u0002\u001a\u0004\b \u0010\u0016R\u000e\u0010!\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/tools/lint/HtmlReporter$Companion;", "", "()V", "CODE_WINDOW_SIZE", "", "ICON_DENSITY_COMPARATOR", "Ljava/util/Comparator;", "Ljava/io/File;", "kotlin.jvm.PlatformType", "getICON_DENSITY_COMPARATOR", "()Ljava/util/Comparator;", "MAX_COUNT", "REPORT_PREFERENCE_ENV_VAR", "", "REPORT_PREFERENCE_PROPERTY", "SHOWN_COUNT", "SPLIT_LIMIT", "USE_CSS_DECORATION_FOR_WAVY_UNDERLINES", "", "USE_WAVY_UNDERLINES_FOR_ERRORS", "cssStyles", "getCssStyles", "()Ljava/lang/String;", "cssSyntaxColors", "cssSyntaxColorsDarcula", "getCssSyntaxColorsDarcula$annotations", "getCssSyntaxColorsDarcula", "cssSyntaxColorsLightTheme", "getCssSyntaxColorsLightTheme$annotations", "getCssSyntaxColorsLightTheme", "cssSyntaxColorsSolarized", "getCssSyntaxColorsSolarized$annotations", "getCssSyntaxColorsSolarized", "preferredThemeName", "computeIssueLists", "", "Lcom/android/tools/lint/detector/api/Incident;", "issues", "getCardId", "cardNumber", "getDensity", "file", "getExplanationId", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "initializePreferences", "", "lint-cli"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<File> getICON_DENSITY_COMPARATOR() {
            return ICON_DENSITY_COMPARATOR;
        }

        private final String getCssSyntaxColorsLightTheme() {
            return "\npre.errorlines {\n    background-color: white;\n    font-family: monospace;\n    border: 1px solid #e0e0e0;\n    line-height: 0.9rem;\n    font-size: 0.9rem;    padding: 1px 0px 1px; 1px;\n    overflow: scroll;\n}\n.prefix {\n    color: #660e7a;\n    font-weight: bold;\n}\n.attribute {\n    color: #0000ff;\n    font-weight: bold;\n}\n.value {\n    color: #008000;\n    font-weight: bold;\n}\n.tag {\n    color: #000080;\n    font-weight: bold;\n}\n.comment {\n    color: #808080;\n    font-style: italic;\n}\n.javadoc {\n    color: #808080;\n    font-style: italic;\n}\n.annotation {\n    color: #808000;\n}\n.string {\n    color: #008000;\n    font-weight: bold;\n}\n.number {\n    color: #0000ff;\n}\n.keyword {\n    color: #000080;\n    font-weight: bold;\n}\n.caretline {\n    background-color: #fffae3;\n}\n.lineno {\n    color: #999999;\n    background-color: #f0f0f0;\n}\n.error {\n" + (USE_WAVY_UNDERLINES_FOR_ERRORS ? "    display: inline-block;\n    position:relative;\n    background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAAECAYAAACp8Z5+AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4AwCFR4T/3uLMgAAADxJREFUCNdNyLERQEAABMCjL4lQwIzcjErpguAL+C9AvgKJDbeD/PRpLdm35Hm+MU+cB+tCKaJW4L4YBy+CAiLJrFs9mgAAAABJRU5ErkJggg==) bottom repeat-x;\n" : "    text-decoration: none;\n    background-color: #f8d8d8;\n") + "}\n.warning {\n    text-decoration: none;\n    background-color: #f6ebbc;\n}\n";
        }

        private static /* synthetic */ void getCssSyntaxColorsLightTheme$annotations() {
        }

        private final String getCssSyntaxColorsDarcula() {
            return "pre.errorlines {\n    background-color: #2b2b2b;\n    color: #a9b7c6;\n    font-family: monospace;\n    font-size: 0.9rem;    line-height: 0.9rem;\n    padding: 6px;\n    border: 1px solid #e0e0e0;\n    overflow: scroll;\n}\n.prefix {\n    color: #9876aa;\n}\n.attribute {\n    color: #BABABA;\n}\n.value {\n    color: #6a8759;\n}\n.tag {\n    color: #e8bf6a;\n}\n.comment {\n    color: #808080;\n}\n.javadoc {\n    font-style: italic;\n    color: #629755;\n}\n.annotation {\n    color: #BBB529;\n}\n.string {\n    color: #6a8759;\n}\n.number {\n    color: #6897bb;\n}\n.keyword {\n    color: #cc7832;\n}\n.caretline {\n    background-color: #323232;\n}\n.lineno {\n    color: #606366;\n    background-color: #313335;\n}\n.error {\n" + (USE_WAVY_UNDERLINES_FOR_ERRORS ? "    display: inline-block;\n    position:relative;\n    background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAAECAYAAACp8Z5+AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4AwCFR46vckTXgAAAEBJREFUCNdj1NbW/s+ABJj4mJgYork5GNgZGSECYVzsDKd+/WaI5uZgEGVmYmBZ9e0nw6d//xg+/vvJEM7FwQAAPnUOmQBDSmAAAAAASUVORK5CYII=) bottom repeat-x;\n" : "    text-decoration: none;\n    background-color: #52503a;\n") + "}\n.warning {\n    text-decoration: none;\n    background-color: #52503a;\n}\n";
        }

        private static /* synthetic */ void getCssSyntaxColorsDarcula$annotations() {
        }

        private final String getCssSyntaxColorsSolarized() {
            return "pre.errorlines {\n    background-color: #FDF6E3;\n    color: #586E75;\n    font-family: monospace;\n    font-size: 0.9rem;    line-height: 0.9rem;\n    padding: 0px;\n    border: 1px solid #e0e0e0;\n    overflow: scroll;\n}\n.prefix {\n    color: #6C71C4;\n}\n.attribute {\n}\n.value {\n    color: #2AA198;\n}\n.tag {\n    color: #268BD2;\n}\n.comment {\n    color: #DC322F;\n}\n.javadoc {\n    font-style: italic;\n    color: #859900;\n}\n.annotation {\n    color: #859900;\n}\n.string {\n    color: #2AA198;\n}\n.number {\n    color: #CB4B16;\n}\n.keyword {\n    color: #B58900;\n}\n.caretline {\n    background-color: #EEE8D5;\n}\n.lineno {\n    color: #93A1A1;\n    background-color: #EEE8D5;\n}\n.error {\n" + (USE_WAVY_UNDERLINES_FOR_ERRORS ? "    display: inline-block;\n    position:relative;\n    background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAADCAYAAAC09K7GAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4AwCFRgHs/v4yQAAAD5JREFUCNcBMwDM/wDqe2//++zZ//324v/75NH/AgxKRgDuho8A/OTnAO2KkwAA/fbi//nXxf/mZlz/++TR/4EMI0ZH4MfyAAAAAElFTkSuQmCC) bottom repeat-x;\n" : "    text-decoration: none;\n    color: #073642;\n    background-color: #FFA0A3;\n") + "}\n.warning {\n    text-decoration: none;\n    color: #073642;\n    background-color: #FFDF80;\n}\n";
        }

        private static /* synthetic */ void getCssSyntaxColorsSolarized$annotations() {
        }

        @NotNull
        public final String getCssStyles() {
            return "section.section--center {\n    max-width: 860px;\n}\n.mdl-card__supporting-text + .mdl-card__actions {\n    border-top: 1px solid rgba(0, 0, 0, 0.12);\n}\nmain > .mdl-layout__tab-panel {\n  padding: 8px;\n  padding-top: 48px;\n}\n\n.mdl-card__actions {\n    margin: 0;\n    padding: 4px 40px;\n    color: inherit;\n}\n.mdl-card > * {\n    height: auto;\n}\n.mdl-card__actions a {\n    color: #00BCD4;\n    margin: 0;\n}\n.error-icon {\n    color: #bb7777;\n    vertical-align: bottom;\n}\n.warning-icon {\n    vertical-align: bottom;\n}\n.mdl-layout__content section:not(:last-of-type) {\n  position: relative;\n  margin-bottom: 48px;\n}\n\n.mdl-card .mdl-card__supporting-text {\n  margin: 40px;\n  -webkit-flex-grow: 1;\n      -ms-flex-positive: 1;\n          flex-grow: 1;\n  padding: 0;\n  color: inherit;\n  width: calc(100% - 80px);\n}\ndiv.mdl-layout__drawer-button .material-icons {\n    line-height: 48px;\n}\n.mdl-card .mdl-card__supporting-text {\n    margin-top: 0px;\n}\n.chips {\n    float: right;\n    vertical-align: middle;\n}\n" + cssSyntaxColors + ".overview {\n    padding: 10pt;\n    width: 100%;\n    overflow: auto;\n    border-collapse:collapse;\n}\n.overview tr {\n    border-bottom: solid 1px #eeeeee;\n}\n.categoryColumn a {\n     text-decoration: none;\n     color: inherit;\n}\n.countColumn {\n    text-align: right;\n    padding-right: 20px;\n    width: 50px;\n}\n.issueColumn {\n   padding-left: 16px;\n}\n.categoryColumn {\n   position: relative;\n   left: -50px;\n   padding-top: 20px;\n   padding-bottom: 5px;\n}\n.options {\n   padding-left: 16px;\n}\n";
        }

        private final List<List<Incident>> computeIssueLists(List<Incident> issues) {
            Issue previousIssue = null;
            List related = new ArrayList();
            Collection collection = issues;
            boolean bl = false;
            if (!collection.isEmpty()) {
                List currentList = null;
                for (Incident incident : issues) {
                    List list2;
                    if (incident.getIssue() != previousIssue) {
                        previousIssue = incident.getIssue();
                        currentList = new ArrayList();
                        related.add(currentList);
                    }
                    if ((list2 = currentList) == null) continue;
                    list2.add(incident);
                }
            }
            return related;
        }

        private final String getCardId(int cardNumber) {
            return Intrinsics.stringPlus((String)"card", (Object)cardNumber);
        }

        private final String getExplanationId(Issue issue) {
            return Intrinsics.stringPlus((String)"explanation", (Object)issue.getId());
        }

        private final int getDensity(File file) {
            Density density;
            DensityQualifier qualifier;
            String name;
            FolderConfiguration configuration;
            File parent = file.getParentFile();
            if (parent != null && (configuration = FolderConfiguration.getConfigForFolder((String)(name = parent.getName()))) != null && (qualifier = configuration.getDensityQualifier()) != null && !qualifier.hasFakeValue() && (density = qualifier.getValue()) != null) {
                return density.getDpiValue();
            }
            return 0;
        }

        public final void initializePreferences() {
            String string;
            boolean underlineErrors;
            int maxCount;
            int splitLimit;
            int codeWindowSize;
            block43: {
                String string2 = System.getenv(HtmlReporter.REPORT_PREFERENCE_ENV_VAR);
                String preferences = string2 == null ? System.getProperty(HtmlReporter.REPORT_PREFERENCE_PROPERTY) : string2;
                codeWindowSize = 3;
                splitLimit = 8;
                maxCount = 50;
                underlineErrors = true;
                if (preferences == null) break block43;
                for (String pref : Splitter.on((char)',').omitEmptyStrings().split((CharSequence)preferences)) {
                    Intrinsics.checkNotNullExpressionValue((Object)pref, (String)"pref");
                    int index = StringsKt.indexOf$default((CharSequence)pref, (char)'=', (int)0, (boolean)false, (int)6, null);
                    if (index == -1) continue;
                    String string3 = pref;
                    int n = 0;
                    int n2 = 0;
                    String string4 = string3.substring(n, index);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string3 = string4;
                    n = 0;
                    String string5 = string3;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String key = ((Object)StringsKt.trim((CharSequence)string5)).toString();
                    String string6 = pref;
                    n2 = index + 1;
                    int n3 = 0;
                    String string7 = string6.substring(n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                    string6 = string7;
                    n2 = 0;
                    String string8 = string6;
                    if (string8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String value = ((Object)StringsKt.trim((CharSequence)string8)).toString();
                    switch (key) {
                        case "theme": {
                            preferredThemeName = value;
                            break;
                        }
                        case "window": {
                            try {
                                Integer size = Integer.decode(value);
                                Intrinsics.checkNotNullExpressionValue((Object)size, (String)"size");
                                n3 = size;
                                boolean bl = 1 <= n3 ? n3 <= 3000 : false;
                                if (!bl) break;
                                codeWindowSize = size;
                            }
                            catch (NumberFormatException size) {}
                            break;
                        }
                        case "maxPerIssue": 
                        case "splitLimit": {
                            try {
                                Integer count = Integer.decode(value);
                                Intrinsics.checkNotNullExpressionValue((Object)count, (String)"count");
                                n3 = count;
                                boolean bl = 1 <= n3 ? n3 <= 3000 : false;
                                if (!bl) break;
                                splitLimit = count;
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        case "maxIncidents": {
                            try {
                                n2 = 1;
                                Integer n4 = Integer.decode(value);
                                Intrinsics.checkNotNullExpressionValue((Object)n4, (String)"decode(value)");
                                n3 = ((Number)n4).intValue();
                                boolean bl = false;
                                maxCount = Math.max(n2, n3);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        case "underlineErrors": {
                            String string9 = value;
                            n3 = 0;
                            underlineErrors = Boolean.parseBoolean(string9);
                        }
                    }
                }
            }
            SPLIT_LIMIT = splitLimit;
            MAX_COUNT = maxCount;
            int n = 1;
            int n5 = SPLIT_LIMIT - 3;
            boolean bl = false;
            SHOWN_COUNT = Math.max(n, n5);
            CODE_WINDOW_SIZE = codeWindowSize;
            USE_WAVY_UNDERLINES_FOR_ERRORS = underlineErrors;
            switch (preferredThemeName) {
                case "darcula": {
                    string = this.getCssSyntaxColorsDarcula();
                    break;
                }
                case "solarized": {
                    string = this.getCssSyntaxColorsSolarized();
                    break;
                }
                case "light": {
                    string = this.getCssSyntaxColorsLightTheme();
                    break;
                }
                default: {
                    string = this.getCssSyntaxColorsLightTheme();
                }
            }
            String css = string;
            cssSyntaxColors = css;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ int access$getDensity(Companion $this, File file) {
            return $this.getDensity(file);
        }
    }
}

