/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profgen.cli;

import com.android.tools.profgen.ArchiveClassFileResourceProvider;
import com.android.tools.profgen.ClassFileResourceKt;
import com.android.tools.profgen.HumanReadableProfile;
import com.android.tools.profgen.cli.BinCommandKt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.cli.AbstractSingleArgument;
import kotlinx.cli.ArgParser;
import kotlinx.cli.ArgType;
import kotlinx.cli.ArgumentValueDelegate;
import kotlinx.cli.ArgumentsKt;
import kotlinx.cli.ExperimentalCli;
import kotlinx.cli.OptionsKt;
import kotlinx.cli.SingleNullableOption;
import kotlinx.cli.Subcommand;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006R!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\b\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/profgen/cli/ExpandWildcardsCommand;", "Lkotlinx/cli/Subcommand;", "()V", "hrpPath", "", "getHrpPath", "()Ljava/lang/String;", "hrpPath$delegate", "Lkotlinx/cli/ArgumentValueDelegate;", "outPath", "getOutPath", "outPath$delegate", "programPaths", "", "getProgramPaths", "()Ljava/util/List;", "programPaths$delegate", "execute", "", "unnamed"})
@ExperimentalCli
@SourceDebugExtension(value={"SMAP\nExpandWildcardsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpandWildcardsCommand.kt\ncom/android/tools/profgen/cli/ExpandWildcardsCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class ExpandWildcardsCommand
extends Subcommand {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ArgumentValueDelegate hrpPath$delegate = OptionsKt.required((SingleNullableOption)ArgParser.option$default((ArgParser)((ArgParser)this), (ArgType)((ArgType)ArgType.String.INSTANCE), (String)"profile", (String)"p", (String)"File path to the human readable profile", null, (int)16, null)).provideDelegate((Object)this, $$delegatedProperties[0]);
    @NotNull
    private final ArgumentValueDelegate outPath$delegate = OptionsKt.required((SingleNullableOption)ArgParser.option$default((ArgParser)((ArgParser)this), (ArgType)((ArgType)ArgType.String.INSTANCE), (String)"output", (String)"o", (String)"File path for the resulting human readable profile without wildcards", null, (int)16, null)).provideDelegate((Object)this, $$delegatedProperties[1]);
    @NotNull
    private final ArgumentValueDelegate programPaths$delegate = ArgumentsKt.vararg((AbstractSingleArgument)((AbstractSingleArgument)ArgParser.argument$default((ArgParser)((ArgParser)this), (ArgType)((ArgType)ArgType.String.INSTANCE), (String)"program", (String)"File paths to program sources (.class or .jar). Class files must be on the form <src dir>:<path to file>.class, e.g., src:pkg/Main.class.", null, (int)8, null))).provideDelegate((Object)this, $$delegatedProperties[2]);

    public ExpandWildcardsCommand() {
        super("expandWildcards", "Dump a binary profile to a HRF");
    }

    @NotNull
    public final String getHrpPath() {
        return (String)this.hrpPath$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final String getOutPath() {
        return (String)this.outPath$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @NotNull
    public final List<String> getProgramPaths() {
        return (List)this.programPaths$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        File archiveClassFileResourceProvider;
        Path path = Paths.get(this.getHrpPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(path)");
        File hrpFile = path.toFile();
        if (!hrpFile.exists()) {
            boolean $i$a$-require-ExpandWildcardsCommand$execute$72 = false;
            String $i$a$-require-ExpandWildcardsCommand$execute$72 = "File not found: " + this.getHrpPath();
            throw new IllegalArgumentException($i$a$-require-ExpandWildcardsCommand$execute$72.toString());
        }
        Path path2 = Paths.get(this.getOutPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
        File outFile = path2.toFile();
        if (!outFile.getParentFile().exists()) {
            boolean $i$a$-require-ExpandWildcardsCommand$execute$82 = false;
            String $i$a$-require-ExpandWildcardsCommand$execute$82 = "Directory does not exist: " + outFile.getParent();
            throw new IllegalArgumentException($i$a$-require-ExpandWildcardsCommand$execute$82.toString());
        }
        if (!(!((Collection)this.getProgramPaths()).isEmpty())) {
            boolean $i$a$-require-ExpandWildcardsCommand$execute$92 = false;
            String $i$a$-require-ExpandWildcardsCommand$execute$92 = "Must pass at least one program source";
            throw new IllegalArgumentException($i$a$-require-ExpandWildcardsCommand$execute$92.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)hrpFile, (String)"hrpFile");
        HumanReadableProfile hrp = BinCommandKt.readHumanReadableProfileOrExit(hrpFile);
        List archiveClassFileResourceProviders = new ArrayList();
        List classFileResources = new ArrayList();
        for (String programPath : this.getProgramPaths()) {
            if (StringsKt.endsWith$default((String)programPath, (String)".class", (boolean)false, (int)2, null)) {
                int separatorIndex = StringsKt.lastIndexOf$default((CharSequence)programPath, (char)':', (int)0, (boolean)false, (int)6, null);
                if (!(separatorIndex >= 0)) {
                    boolean $i$a$-require-ExpandWildcardsCommand$execute$102 = false;
                    String $i$a$-require-ExpandWildcardsCommand$execute$102 = "Missing ':' separator for class file: " + programPath;
                    throw new IllegalArgumentException($i$a$-require-ExpandWildcardsCommand$execute$102.toString());
                }
                String string = programPath.substring(separatorIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                String classBinaryName = StringsKt.dropLast((String)string, (int)6);
                String classDescriptor = ClassFileResourceKt.getClassDescriptorFromBinaryName((String)classBinaryName);
                String string2 = programPath.substring(0, separatorIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Object object = string2;
                String[] stringArray = new String[]{classBinaryName + ".class"};
                Path path3 = Paths.get((String)object, Arrays.copyOf(stringArray, stringArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(base, *subpaths)");
                File programFile = path3.toFile();
                if (!programFile.exists()) {
                    boolean bl = false;
                    String string3 = "File not found: " + programFile;
                    throw new IllegalArgumentException(string3.toString());
                }
                object = classFileResources;
                Path path4 = programFile.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"programFile.toPath()");
                object.add(ClassFileResourceKt.ClassFileResource((String)classDescriptor, (Path)path4));
                continue;
            }
            if (StringsKt.endsWith$default((String)programPath, (String)".jar", (boolean)false, (int)2, null)) {
                Path path5 = Paths.get(programPath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"get(path)");
                File programFile = path5.toFile();
                if (!programFile.exists()) {
                    boolean $i$a$-require-ExpandWildcardsCommand$execute$112 = false;
                    String $i$a$-require-ExpandWildcardsCommand$execute$112 = "File not found: " + programPath;
                    throw new IllegalArgumentException($i$a$-require-ExpandWildcardsCommand$execute$112.toString());
                }
                Path path6 = programFile.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"programFile.toPath()");
                archiveClassFileResourceProvider = new ArchiveClassFileResourceProvider(path6, null, 2, null);
                ((Collection)archiveClassFileResourceProviders).add(archiveClassFileResourceProvider);
                CollectionsKt.addAll((Collection)classFileResources, (Iterable)archiveClassFileResourceProvider.getClassFileResources());
                continue;
            }
            throw new IllegalArgumentException("Unexpected program file: " + programPath);
        }
        HumanReadableProfile result = hrp.expandWildcards((Collection)classFileResources);
        Intrinsics.checkNotNullExpressionValue((Object)outFile, (String)"outFile");
        Iterator iterator = outFile;
        Object programFile = Charsets.UTF_8;
        archiveClassFileResourceProvider = iterator;
        int $i$a$-require-ExpandWildcardsCommand$execute$112 = 8192;
        Object object = archiveClassFileResourceProvider;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)programFile);
        iterator = new PrintWriter(object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, $i$a$-require-ExpandWildcardsCommand$execute$112));
        programFile = null;
        try {
            PrintWriter it = (PrintWriter)((Object)iterator);
            boolean bl = false;
            result.printExact((Appendable)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            programFile = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)((Object)iterator), (Throwable)programFile);
        }
        for (ArchiveClassFileResourceProvider archiveClassFileResourceProvider2 : archiveClassFileResourceProviders) {
            try {
                archiveClassFileResourceProvider2.close();
            }
            catch (Throwable throwable) {}
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ExpandWildcardsCommand.class, "hrpPath", "getHrpPath()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ExpandWildcardsCommand.class, "outPath", "getOutPath()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ExpandWildcardsCommand.class, "programPaths", "getProgramPaths()Ljava/util/List;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

