/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.lang.management.ThreadMXBean;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.TotalProfiler;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\bJ!\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0096\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/daemon/common/WallAndThreadAndMemoryTotalProfiler;", "Lorg/jetbrains/kotlin/daemon/common/TotalProfiler;", "withGC", "", "(Z)V", "getWithGC", "()Z", "beginMeasure", "", "", "obj", "", "endMeasure", "", "startState", "daemon-common"})
@SourceDebugExtension(value={"SMAP\nPerfUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/WallAndThreadAndMemoryTotalProfiler\n+ 2 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n*L\n1#1,196:1\n123#2:197\n90#2,5:198\n124#2,2:203\n83#2:205\n126#2:206\n86#2:207\n128#2:208\n132#2,5:209\n83#2:214\n137#2:215\n86#2:216\n138#2:217\n90#2,5:218\n139#2:223\n*S KotlinDebug\n*F\n+ 1 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/WallAndThreadAndMemoryTotalProfiler\n*L\n176#1:197\n176#1:198,5\n176#1:203,2\n176#1:205\n176#1:206\n176#1:207\n176#1:208\n179#1:209,5\n179#1:214\n179#1:215\n179#1:216\n179#1:217\n179#1:218,5\n179#1:223\n*E\n"})
public final class WallAndThreadAndMemoryTotalProfiler
extends TotalProfiler {
    private final boolean withGC;

    public WallAndThreadAndMemoryTotalProfiler(boolean withGC) {
        this.withGC = withGC;
    }

    public final boolean getWithGC() {
        return this.withGC;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Long> beginMeasure(@Nullable Object obj) {
        void withGC$iv;
        boolean $i$f$beginMeasure = false;
        boolean bl = this.getWithGC();
        ThreadMXBean threadMXBean = this.getThreadMXBean();
        Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"threadMXBean");
        ThreadMXBean threadMXBean$iv = threadMXBean;
        boolean $i$f$beginMeasureWallAndThreadTimesAndMemory = false;
        boolean $i$f$usedMemory = false;
        if (withGC$iv != false) {
            System.gc();
        }
        Runtime rt$iv$iv = Runtime.getRuntime();
        long startMem$iv = rt$iv$iv.totalMemory() - rt$iv$iv.freeMemory();
        long startTime$iv = System.nanoTime();
        ThreadMXBean $this$threadCpuTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadCpuTime = false;
        long startThreadTime$iv = $this$threadCpuTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv$iv.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean $this$threadUserTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadUserTime = false;
        long startThreadUserTime$iv = $this$threadUserTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv$iv.getCurrentThreadUserTime() : 0L;
        Object[] objectArray = new Long[]{startMem$iv, startTime$iv, startThreadTime$iv, startThreadUserTime$iv};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void endMeasure(@Nullable Object obj, @NotNull List<Long> startState) {
        void perfCounters$iv;
        void withGC$iv;
        Intrinsics.checkNotNullParameter(startState, (String)"startState");
        boolean $i$f$endMeasure = false;
        PerfCounters perfCounters = this.getTotal();
        boolean bl = this.getWithGC();
        ThreadMXBean threadMXBean = this.getThreadMXBean();
        Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"threadMXBean");
        ThreadMXBean threadMXBean$iv = threadMXBean;
        boolean $i$f$endMeasureWallAndThreadTimesAndMemory = false;
        long startMem$iv = ((Number)startState.get(0)).longValue();
        long startTime$iv = ((Number)startState.get(1)).longValue();
        long startThreadTime$iv = ((Number)startState.get(2)).longValue();
        long startThreadUserTime$iv = ((Number)startState.get(3)).longValue();
        long l = System.nanoTime() - startTime$iv;
        ThreadMXBean $this$threadCpuTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadCpuTime = false;
        long l2 = ($this$threadCpuTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv$iv.getCurrentThreadCpuTime() : 0L) - startThreadTime$iv;
        ThreadMXBean $this$threadUserTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadUserTime = false;
        long l3 = ($this$threadUserTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv$iv.getCurrentThreadUserTime() : 0L) - startThreadUserTime$iv;
        boolean $i$f$usedMemory = false;
        if (withGC$iv != false) {
            System.gc();
        }
        Runtime rt$iv$iv = Runtime.getRuntime();
        perfCounters$iv.addMeasurement(l, l2, l3, rt$iv$iv.totalMemory() - rt$iv$iv.freeMemory() - startMem$iv);
    }
}

