/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirGlobalResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.project.structure.LLFirBuiltinsSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.project.structure.LLFirLibrarySessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.project.structure.LLFirNonUnderContentRootSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.FirSessionWithModificationTracker;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.KtModuleToSessionMappingByMapImpl;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.KtModuleToSessionMappingByWeakValueMapImpl;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirLibraryOrLibrarySourceResolvableModuleSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirResolvableModuleSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionsCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSourcesSession;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibrarySourceModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J+\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0019\u0010\u0014\u001a\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0015\u00a2\u0006\u0002\b\u0018H\u0002J+\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001a2\u0019\u0010\u0014\u001a\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0015\u00a2\u0006\u0002\b\u0018H\u0002J+\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u001b\b\u0002\u0010\u0014\u001a\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0015\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionProviderStorage;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "builtInsSessionFactory", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/project/structure/LLFirBuiltinsSessionFactory;", "globalComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirGlobalResolveComponents;", "librariesSessionFactory", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/project/structure/LLFirLibrarySessionFactory;", "libraryAsUseSiteSessionCache", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionsCache;", "getProject", "()Lcom/intellij/openapi/project/Project;", "sourceAsUseSiteSessionCache", "createSessionProviderForLibraryOrLibrarySource", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionProvider;", "useSiteKtModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "configureSession", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "", "Lkotlin/ExtensionFunctionType;", "createSessionProviderForSourceSession", "Lorg/jetbrains/kotlin/analysis/project/structure/KtSourceModule;", "getSessionProvider", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirSessionProviderStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirSessionProviderStorage.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionProviderStorage\n+ 2 LLFirSessionProviderStorage.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionsCache\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n111#2:205\n112#2,2:213\n111#2:215\n112#2,2:222\n442#3:206\n392#3:207\n442#3:216\n392#3:217\n1238#4,4:208\n1238#4,4:218\n1#5:212\n*S KotlinDebug\n*F\n+ 1 LLFirSessionProviderStorage.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionProviderStorage\n*L\n60#1:205\n60#1:213,2\n81#1:215\n81#1:222,2\n60#1:206\n60#1:207\n81#1:216\n81#1:217\n60#1:208,4\n81#1:218,4\n*E\n"})
public final class LLFirSessionProviderStorage {
    @NotNull
    private final Project project;
    @NotNull
    private final LLFirSessionsCache sourceAsUseSiteSessionCache;
    @NotNull
    private final LLFirSessionsCache libraryAsUseSiteSessionCache;
    @NotNull
    private final LLFirLibrarySessionFactory librariesSessionFactory;
    @NotNull
    private final LLFirBuiltinsSessionFactory builtInsSessionFactory;
    @NotNull
    private final LLFirGlobalResolveComponents globalComponents;

    public LLFirSessionProviderStorage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.sourceAsUseSiteSessionCache = new LLFirSessionsCache();
        this.libraryAsUseSiteSessionCache = new LLFirSessionsCache();
        this.librariesSessionFactory = LLFirLibrarySessionFactory.Companion.getInstance(this.project);
        this.builtInsSessionFactory = LLFirBuiltinsSessionFactory.Companion.getInstance(this.project);
        this.globalComponents = new LLFirGlobalResolveComponents(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final LLFirSessionProvider getSessionProvider(@NotNull KtModule useSiteKtModule, @Nullable Function1<? super LLFirSession, Unit> configureSession) {
        LLFirSessionProvider lLFirSessionProvider;
        Intrinsics.checkNotNullParameter((Object)useSiteKtModule, (String)"useSiteKtModule");
        KtModule ktModule = useSiteKtModule;
        if (ktModule instanceof KtSourceModule) {
            lLFirSessionProvider = this.createSessionProviderForSourceSession((KtSourceModule)useSiteKtModule, configureSession);
        } else if (ktModule instanceof KtLibraryModule ? true : ktModule instanceof KtLibrarySourceModule) {
            lLFirSessionProvider = this.createSessionProviderForLibraryOrLibrarySource(useSiteKtModule, configureSession);
        } else if (ktModule instanceof KtNotUnderContentRootModule) {
            LLFirResolvableModuleSession session2 = LLFirNonUnderContentRootSessionFactory.Companion.getInstance(this.project).getNonUnderContentRootSession((KtNotUnderContentRootModule)useSiteKtModule);
            lLFirSessionProvider = new LLFirSessionProvider(this.project, session2, new KtModuleToSessionMappingByMapImpl(MapsKt.mapOf((Pair)TuplesKt.to((Object)useSiteKtModule, (Object)session2))));
        } else {
            throw new IllegalStateException(("Unexpected " + Reflection.getOrCreateKotlinClass(useSiteKtModule.getClass()).getSimpleName()).toString());
        }
        return lLFirSessionProvider;
    }

    public static /* synthetic */ LLFirSessionProvider getSessionProvider$default(LLFirSessionProviderStorage lLFirSessionProviderStorage, KtModule ktModule, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return lLFirSessionProviderStorage.getSessionProvider(ktModule, (Function1<? super LLFirSession, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final LLFirSessionProvider createSessionProviderForSourceSession(KtSourceModule useSiteKtModule, Function1<? super LLFirSession, Unit> configureSession) {
        void $this$mapValuesTo$iv$iv$iv;
        void $this$mapValues$iv$iv;
        Map map;
        Object object;
        Object object2;
        Object k;
        Object object3;
        Map $this$mapValuesTo$iv$iv$iv2;
        void this_$iv;
        LLFirSessionsCache lLFirSessionsCache = this.sourceAsUseSiteSessionCache;
        Project project$iv = this.project;
        boolean $i$f$withMappings = false;
        Map $this$mapValues$iv$iv2 = LLFirSessionsCache.access$getSessions((LLFirSessionsCache)this_$iv);
        boolean $i$f$mapValues = false;
        Map map2 = $this$mapValues$iv$iv2;
        Map destination$iv$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv$iv2.size()));
        boolean $i$f$mapValuesTo22 = false;
        Iterable $this$associateByTo$iv$iv$iv$iv = $this$mapValuesTo$iv$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv$iv : $this$associateByTo$iv$iv$iv$iv) {
            void it$iv;
            void it$iv$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv$iv;
            Map map3 = destination$iv$iv$iv;
            boolean bl4 = false;
            object3 = (Map.Entry)element$iv$iv$iv$iv;
            k = it$iv$iv$iv.getKey();
            object2 = map3;
            boolean bl2 = false;
            object = (LLFirSession)it$iv.getValue();
            object2.put(k, object);
        }
        Map mappings2 = destination$iv$iv$iv;
        boolean bl = false;
        Map $this$createSessionProviderForSourceSession_u24lambda_u241_u24lambda_u240 = map = (Map)new LinkedHashMap();
        boolean bl3 = false;
        $this$createSessionProviderForSourceSession_u24lambda_u241_u24lambda_u240.putAll(mappings2);
        Map sessions = map;
        LLFirSourcesSession session2 = LLFirSessionFactory.INSTANCE.createSourcesSession(this.project, useSiteKtModule, this.globalComponents, this.libraryAsUseSiteSessionCache.getSessionInvalidator(), sessions, this.librariesSessionFactory, configureSession);
        Pair pair = TuplesKt.to((Object)sessions, (Object)session2);
        Map newMappings$iv = (Map)pair.component1();
        Object result$iv = pair.component2();
        $this$mapValuesTo$iv$iv$iv2 = newMappings$iv;
        void var31_35 = this_$iv;
        boolean $i$f$mapValues2 = false;
        void $i$f$mapValuesTo22 = $this$mapValues$iv$iv;
        Map destination$iv$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv$iv2 = $this$mapValuesTo$iv$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv$iv : $this$associateByTo$iv$iv$iv$iv2) {
            void it$iv;
            void it$iv$iv$iv;
            Map.Entry bl4 = (Map.Entry)element$iv$iv$iv$iv;
            object3 = destination$iv$iv$iv2;
            boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv$iv2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv$iv;
            k = it$iv$iv$iv.getKey();
            object2 = object3;
            boolean bl5 = false;
            object = new FirSessionWithModificationTracker(project$iv, (LLFirSession)it$iv.getValue());
            object2.put(k, object);
        }
        LLFirSessionsCache.access$setMappings$p((LLFirSessionsCache)var31_35, ExtensionsKt.toPersistentMap(destination$iv$iv$iv2));
        Pair pair2 = TuplesKt.to((Object)newMappings$iv, (Object)result$iv);
        Map sessions2 = (Map)pair2.component1();
        LLFirSourcesSession session3 = (LLFirSourcesSession)pair2.component2();
        return new LLFirSessionProvider(this.project, session3, new KtModuleToSessionMappingByWeakValueMapImpl(sessions2));
    }

    /*
     * WARNING - void declaration
     */
    private final LLFirSessionProvider createSessionProviderForLibraryOrLibrarySource(KtModule useSiteKtModule, Function1<? super LLFirSession, Unit> configureSession) {
        void $this$mapValuesTo$iv$iv$iv;
        void $this$mapValues$iv$iv;
        Map map;
        Object object;
        Object object2;
        Object k;
        Object object3;
        Map $this$mapValuesTo$iv$iv$iv2;
        void this_$iv;
        LLFirSessionsCache lLFirSessionsCache = this.libraryAsUseSiteSessionCache;
        Project project$iv = this.project;
        boolean $i$f$withMappings = false;
        Map $this$mapValues$iv$iv2 = LLFirSessionsCache.access$getSessions((LLFirSessionsCache)this_$iv);
        boolean $i$f$mapValues = false;
        Map map2 = $this$mapValues$iv$iv2;
        Map destination$iv$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv$iv2.size()));
        boolean $i$f$mapValuesTo22 = false;
        Iterable $this$associateByTo$iv$iv$iv$iv = $this$mapValuesTo$iv$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv$iv : $this$associateByTo$iv$iv$iv$iv) {
            void it$iv;
            void it$iv$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv$iv;
            Map map3 = destination$iv$iv$iv;
            boolean bl4 = false;
            object3 = (Map.Entry)element$iv$iv$iv$iv;
            k = it$iv$iv$iv.getKey();
            object2 = map3;
            boolean bl2 = false;
            object = (LLFirSession)it$iv.getValue();
            object2.put(k, object);
        }
        Map mappings2 = destination$iv$iv$iv;
        boolean bl = false;
        Map $this$createSessionProviderForLibraryOrLibrarySource_u24lambda_u243_u24lambda_u242 = map = (Map)new LinkedHashMap();
        boolean bl3 = false;
        $this$createSessionProviderForLibraryOrLibrarySource_u24lambda_u243_u24lambda_u242.putAll(mappings2);
        Map sessions = map;
        LLFirLibraryOrLibrarySourceResolvableModuleSession session2 = LLFirSessionFactory.createLibraryOrLibrarySourceResolvableSession$default(LLFirSessionFactory.INSTANCE, this.project, useSiteKtModule, this.globalComponents, this.libraryAsUseSiteSessionCache.getSessionInvalidator(), this.builtInsSessionFactory.getBuiltinsSession(useSiteKtModule.getPlatform()), sessions, null, configureSession, 64, null);
        Pair pair = TuplesKt.to((Object)sessions, (Object)session2);
        Map newMappings$iv = (Map)pair.component1();
        Object result$iv = pair.component2();
        $this$mapValuesTo$iv$iv$iv2 = newMappings$iv;
        void var31_35 = this_$iv;
        boolean $i$f$mapValues2 = false;
        void $i$f$mapValuesTo22 = $this$mapValues$iv$iv;
        Map destination$iv$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv$iv2 = $this$mapValuesTo$iv$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv$iv : $this$associateByTo$iv$iv$iv$iv2) {
            void it$iv;
            void it$iv$iv$iv;
            Map.Entry bl4 = (Map.Entry)element$iv$iv$iv$iv;
            object3 = destination$iv$iv$iv2;
            boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv$iv2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv$iv;
            k = it$iv$iv$iv.getKey();
            object2 = object3;
            boolean bl5 = false;
            object = new FirSessionWithModificationTracker(project$iv, (LLFirSession)it$iv.getValue());
            object2.put(k, object);
        }
        LLFirSessionsCache.access$setMappings$p((LLFirSessionsCache)var31_35, ExtensionsKt.toPersistentMap(destination$iv$iv$iv2));
        Pair pair2 = TuplesKt.to((Object)newMappings$iv, (Object)result$iv);
        Map sessions2 = (Map)pair2.component1();
        LLFirLibraryOrLibrarySourceResolvableModuleSession session3 = (LLFirLibraryOrLibrarySourceResolvableModuleSession)pair2.component2();
        return new LLFirSessionProvider(this.project, session3, new KtModuleToSessionMappingByWeakValueMapImpl(sessions2));
    }
}

