/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.rewriter;

import com.android.tools.smali.dexlib2.base.reference.BaseTypeReference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import com.android.tools.smali.dexlib2.rewriter.Rewriter;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RewriterUtils {
    @Nullable
    public static <T> T rewriteNullable(@Nonnull Rewriter<T> rewriter, @Nullable T value) {
        return value == null ? null : (T)rewriter.rewrite(value);
    }

    public static <T> Set<T> rewriteSet(final @Nonnull Rewriter<T> rewriter, final @Nonnull Set<? extends T> set) {
        return new AbstractSet<T>(){

            @Override
            @Nonnull
            public Iterator<T> iterator() {
                final Iterator iterator = set.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return RewriterUtils.rewriteNullable(rewriter, iterator.next());
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return set.size();
            }
        };
    }

    public static <T> List<T> rewriteList(final @Nonnull Rewriter<T> rewriter, final @Nonnull List<? extends T> list) {
        return new AbstractList<T>(){

            @Override
            public T get(int i) {
                return RewriterUtils.rewriteNullable(rewriter, list.get(i));
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static <T> Iterable<T> rewriteIterable(final @Nonnull Rewriter<T> rewriter, final @Nonnull Iterable<? extends T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator = iterable.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return RewriterUtils.rewriteNullable(rewriter, iterator.next());
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    public static TypeReference rewriteTypeReference(final @Nonnull Rewriter<String> typeRewriter, final @Nonnull TypeReference typeReference) {
        return new BaseTypeReference(){

            @Override
            @Nonnull
            public String getType() {
                return typeRewriter.rewrite(typeReference.getType());
            }
        };
    }
}

