/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.value;

import com.android.tools.smali.dexlib2.base.value.BaseArrayEncodedValue;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexReader;
import com.android.tools.smali.dexlib2.dexbacked.util.VariableSizeList;
import com.android.tools.smali.dexlib2.dexbacked.value.DexBackedEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.ArrayEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.EncodedValue;
import java.util.List;
import javax.annotation.Nonnull;

public class DexBackedArrayEncodedValue
extends BaseArrayEncodedValue
implements ArrayEncodedValue {
    @Nonnull
    public final DexBackedDexFile dexFile;
    private final int elementCount;
    private final int encodedArrayOffset;

    public DexBackedArrayEncodedValue(@Nonnull DexBackedDexFile dexFile, @Nonnull DexReader reader) {
        this.dexFile = dexFile;
        this.elementCount = reader.readSmallUleb128();
        this.encodedArrayOffset = reader.getOffset();
        DexBackedArrayEncodedValue.skipElementsFrom(reader, this.elementCount);
    }

    public static void skipFrom(@Nonnull DexReader reader) {
        int elementCount = reader.readSmallUleb128();
        DexBackedArrayEncodedValue.skipElementsFrom(reader, elementCount);
    }

    private static void skipElementsFrom(@Nonnull DexReader reader, int elementCount) {
        for (int i = 0; i < elementCount; ++i) {
            DexBackedEncodedValue.skipFrom(reader);
        }
    }

    @Override
    @Nonnull
    public List<? extends EncodedValue> getValue() {
        return new VariableSizeList<EncodedValue>(this.dexFile.getDataBuffer(), this.encodedArrayOffset, this.elementCount){

            @Override
            @Nonnull
            protected EncodedValue readNextItem(@Nonnull DexReader dexReader, int index) {
                return DexBackedEncodedValue.readFrom(DexBackedArrayEncodedValue.this.dexFile, dexReader);
            }
        };
    }
}

