/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.builder;

import com.android.tools.smali.dexlib2.builder.ItemWithLocation;
import com.android.tools.smali.dexlib2.builder.MethodLocation;
import com.google.common.collect.ImmutableList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class LocatedItems<T extends ItemWithLocation> {
    @Nullable
    private List<T> items = null;

    @Nonnull
    private List<T> getItems() {
        if (this.items == null) {
            return ImmutableList.of();
        }
        return this.items;
    }

    public Set<T> getModifiableItems(final MethodLocation newItemsLocation) {
        return new AbstractSet<T>(){

            @Override
            @Nonnull
            public Iterator<T> iterator() {
                final Iterator it = LocatedItems.this.getItems().iterator();
                return new Iterator<T>(this){
                    @Nullable
                    private T currentItem = null;

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public T next() {
                        this.currentItem = (ItemWithLocation)it.next();
                        return this.currentItem;
                    }

                    @Override
                    public void remove() {
                        if (this.currentItem != null) {
                            ((ItemWithLocation)this.currentItem).setLocation(null);
                        }
                        it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return LocatedItems.this.getItems().size();
            }

            @Override
            public boolean add(@Nonnull T item) {
                if (((ItemWithLocation)item).isPlaced()) {
                    throw new IllegalArgumentException(LocatedItems.this.getAddLocatedItemError());
                }
                ((ItemWithLocation)item).setLocation(newItemsLocation);
                LocatedItems.this.addItem(item);
                return true;
            }
        };
    }

    private void addItem(@Nonnull T item) {
        if (this.items == null) {
            this.items = new ArrayList<T>(1);
        }
        this.items.add(item);
    }

    protected abstract String getAddLocatedItemError();

    public void mergeItemsIntoNext(@Nonnull MethodLocation nextLocation, LocatedItems<T> otherLocatedItems) {
        if (otherLocatedItems == this) {
            return;
        }
        if (this.items != null) {
            for (ItemWithLocation item : this.items) {
                item.setLocation(nextLocation);
            }
            List<T> mergedItems = this.items;
            mergedItems.addAll(super.getItems());
            otherLocatedItems.items = mergedItems;
            this.items = null;
        }
    }
}

