/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.ide.common.util.PathString;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.Constraint;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0013H\u0002J\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0&J\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\rH\u0002J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00180*J\n\u0010+\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110&J\b\u0010-\u001a\u00020#H\u0002J\b\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020#H\u0002J\b\u00101\u001a\u00020\u0013H\u0002J\b\u00102\u001a\u00020\u0013H\u0002J\b\u00103\u001a\u00020#H\u0002J\b\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u00020\u0013H\u0002J\b\u00107\u001a\u00020\u0013H\u0002J\b\u00108\u001a\u00020\u0013H\u0002J\b\u00109\u001a\u00020#H\u0002J\b\u0010:\u001a\u00020\u0011H\u0002J\b\u0010;\u001a\u00020\u001cH\u0002J\b\u0010<\u001a\u00020#H\u0002J\b\u0010=\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/android/tools/lint/XmlReader;", "", "client", "Lcom/android/tools/lint/LintCliClient;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "project", "Lcom/android/tools/lint/detector/api/Project;", "xmlFile", "Ljava/io/File;", "(Lcom/android/tools/lint/LintCliClient;Lcom/android/tools/lint/client/api/IssueRegistry;Lcom/android/tools/lint/detector/api/Project;Ljava/io/File;)V", "configs", "", "", "Lcom/android/tools/lint/detector/api/Severity;", "data", "Lcom/android/tools/lint/detector/api/Issue;", "Lcom/android/tools/lint/detector/api/LintMap;", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "fixLists", "Ljava/util/ArrayDeque;", "", "incidents", "Lcom/android/tools/lint/detector/api/Incident;", "issueId", "lintMap", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "prevLocation", "severity", "addFix", "", "newFix", "getConfiguredIssues", "", "getFile", "path", "getIncidents", "", "getParentFix", "getPartialResults", "parse", "readCondition", "Lcom/android/tools/lint/detector/api/Constraint;", "readConfigInto", "readCreateFile", "readFixAnnotate", "readFixComposite", "readFixData", "Lcom/android/tools/lint/detector/api/LintFix$DataMap;", "readFixReplace", "readFixSetAttribute", "readFixShowUrl", "readIncidentHeader", "readLintMap", "readLocation", "readRange", "skipToNextTag", "lint-cli"})
@SourceDebugExtension(value={"SMAP\nXmlReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlReader.kt\ncom/android/tools/lint/XmlReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,687:1\n1#2:688\n37#3,2:689\n*S KotlinDebug\n*F\n+ 1 XmlReader.kt\ncom/android/tools/lint/XmlReader\n*L\n508#1:689,2\n*E\n"})
public final class XmlReader {
    @NotNull
    private final LintCliClient client;
    @NotNull
    private final IssueRegistry registry;
    @Nullable
    private final Project project;
    @NotNull
    private final List<Incident> incidents;
    @Nullable
    private Map<Issue, LintMap> data;
    @Nullable
    private Map<String, Severity> configs;
    @NotNull
    private final XmlPullParser parser;
    @Nullable
    private String issueId;
    @Nullable
    private String message;
    @Nullable
    private Severity severity;
    @Nullable
    private Location location;
    @Nullable
    private Location prevLocation;
    @Nullable
    private LintMap lintMap;
    @Nullable
    private LintFix fix;
    @NotNull
    private final ArrayDeque<List<LintFix>> fixLists;

    public XmlReader(@NotNull LintCliClient client, @NotNull IssueRegistry registry, @Nullable Project project, @NotNull File xmlFile) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        this.client = client;
        this.registry = registry;
        this.project = project;
        this.incidents = new ArrayList();
        this.fixLists = new ArrayDeque();
        if (xmlFile.exists()) {
            XmlPullParser xmlPullParser = this.client.createXmlPullParser(new PathString(xmlFile));
            if (xmlPullParser == null) {
                xmlPullParser = (XmlPullParser)new KXmlParser();
            }
            this.parser = xmlPullParser;
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            this.parse();
        } else {
            this.parser = (XmlPullParser)new KXmlParser();
        }
    }

    @NotNull
    public final List<Incident> getIncidents() {
        return this.incidents;
    }

    @NotNull
    public final Map<Issue, LintMap> getPartialResults() {
        Map map = this.data;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @NotNull
    public final Map<String, Severity> getConfiguredIssues() {
        Map map = this.configs;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private final void addFix(LintFix newFix) {
        if (this.fixLists.isEmpty()) {
            this.fix = newFix;
        } else {
            this.fixLists.getLast().add(newFix);
        }
    }

    private final LintFix getParentFix() {
        LintFix lintFix;
        if (this.fixLists.isEmpty()) {
            lintFix = this.fix;
        } else {
            List<LintFix> list2 = this.fixLists.getLast();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"fixLists.last");
            lintFix = (LintFix)CollectionsKt.last(list2);
        }
        return lintFix;
    }

    /*
     * Unable to fully structure code
     */
    private final void parse() {
        try {
            block44: while (this.parser.next() != 1) {
                block79: {
                    block80: {
                        block77: {
                            block78: {
                                eventType = this.parser.getEventType();
                                if (eventType != 3) break block77;
                                var2_5 = this.parser.getName();
                                if (var2_5 == null) continue;
                                switch (var2_5.hashCode()) {
                                    case -1732277553: {
                                        if (!var2_5.equals("fix-composite")) {
                                            ** break;
                                        }
                                        break block78;
                                    }
                                    case 100509913: {
                                        if (!var2_5.equals("issue")) {
                                            ** break;
                                        }
                                        ** GOTO lbl22
                                    }
                                    case 477851934: {
                                        if (var2_5.equals("fix-alternatives")) break;
                                        ** break;
                                    }
                                    case 86983890: {
                                        if (!var2_5.equals("incident")) ** break;
lbl22:
                                        // 2 sources

                                        issueId = this.issueId;
                                        message = this.message;
                                        location = this.location;
                                        if (issueId != null && message != null && location != null && (issue = this.registry.getIssue(issueId)) != null) {
                                            incident = new Incident(issue, message, location, this.fix);
                                            if (this.severity != null) {
                                                $i$a$-let-XmlReader$parse$1 = false;
                                                incident.setSeverity(it);
                                            }
                                            if (this.lintMap != null) {
                                                $i$a$-let-XmlReader$parse$2 = false;
                                                incident.setClientProperties((LintMap)it);
                                            }
                                            if (this.project != null) {
                                                $i$a$-let-XmlReader$parse$3 = false;
                                                incident.setProject((Project)it);
                                            }
                                            this.incidents.add(incident);
                                        }
                                        this.issueId = null;
                                        this.message = null;
                                        this.location = null;
                                        this.prevLocation = null;
                                        this.lintMap = null;
                                        this.severity = null;
                                        this.fix = null;
                                        this.fixLists.clear();
                                        ** break;
                                    }
                                }
                                this.fixLists.removeLast();
                                continue;
                            }
                            this.fixLists.removeLast();
lbl53:
                            // 7 sources

                            continue;
                        }
                        if (eventType != 2) break block79;
                        tag = this.parser.getName();
                        if (tag == null) break block80;
                        tmp = -1;
                        switch (tag.hashCode()) {
                            case -540167251: {
                                if (tag.equals("create-file")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case -339980641: {
                                if (tag.equals("show-url")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case 100509913: {
                                if (tag.equals("issue")) {
                                    tmp = 3;
                                }
                                break;
                            }
                            case 477851934: {
                                if (tag.equals("fix-alternatives")) {
                                    tmp = 4;
                                }
                                break;
                            }
                            case 108280125: {
                                if (tag.equals("range")) {
                                    tmp = 5;
                                }
                                break;
                            }
                            case -649662132: {
                                if (tag.equals("annotate")) {
                                    tmp = 6;
                                }
                                break;
                            }
                            case -1179159878: {
                                if (tag.equals("issues")) {
                                    tmp = 7;
                                }
                                break;
                            }
                            case -1732277553: {
                                if (tag.equals("fix-composite")) {
                                    tmp = 4;
                                }
                                break;
                            }
                            case 96667762: {
                                if (tag.equals("entry")) {
                                    tmp = 8;
                                }
                                break;
                            }
                            case -319438108: {
                                if (tag.equals("fix-attribute")) {
                                    tmp = 9;
                                }
                                break;
                            }
                            case -443233694: {
                                if (tag.equals("fix-data")) {
                                    tmp = 10;
                                }
                                break;
                            }
                            case -1994113796: {
                                if (tag.equals("fix-replace")) {
                                    tmp = 11;
                                }
                                break;
                            }
                            case -1598466591: {
                                if (tag.equals("incidents")) {
                                    tmp = 7;
                                }
                                break;
                            }
                            case 1901043637: {
                                if (tag.equals("location")) {
                                    tmp = 12;
                                }
                                break;
                            }
                            case 86983890: {
                                if (tag.equals("incident")) {
                                    tmp = 3;
                                }
                                break;
                            }
                            case -1354792126: {
                                if (tag.equals("config")) {
                                    tmp = 13;
                                }
                                break;
                            }
                            case 107868: {
                                if (tag.equals("map")) {
                                    tmp = 14;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 7: {
                                continue block44;
                            }
                            case 12: {
                                newLocation = this.readLocation();
                                if (this.prevLocation != null) {
                                    $i$a$-let-XmlReader$parse$4 = false;
                                    it.setSecondary(newLocation);
                                    this.prevLocation = newLocation;
                                    v0 = Unit.INSTANCE;
                                } else {
                                    v0 = null;
                                }
                                if (v0 != null) continue block44;
                                $this$parse_u24lambda_u244 = this;
                                $i$a$-run-XmlReader$parse$5 = false;
                                $this$parse_u24lambda_u244.location = newLocation;
                                $this$parse_u24lambda_u244.prevLocation = newLocation;
                                continue block44;
                            }
                            case 5: {
                                this.readRange();
                                continue block44;
                            }
                            case 3: {
                                this.readIncidentHeader();
                                continue block44;
                            }
                            case 13: {
                                this.readConfigInto();
                                continue block44;
                            }
                            case 14: {
                                if (this.parser.getAttributeValue(null, "id") != null) {
                                    $i$a$-let-XmlReader$parse$issue$1 = false;
                                    v1 = this.registry.getIssue(it);
                                } else {
                                    v1 = null;
                                }
                                issue = v1;
                                newNote = this.readLintMap();
                                if (issue != null) {
                                    v2 = this.data;
                                    if (v2 == null) {
                                        it = var7_14 = new HashMap<K, V>();
                                        $i$a$-also-XmlReader$parse$map$1 = false;
                                        this.data = it;
                                        v2 = var7_14;
                                    }
                                    if ((map = v2).get(issue) != null) {
                                        throw new IllegalStateException(("Should only specify one LintMap for issue " + issue).toString());
                                    }
                                    map.put((Issue)issue, (LintMap)newNote);
                                    continue block44;
                                }
                                this.lintMap = newNote;
                                continue block44;
                            }
                            case 8: {
                                throw new IllegalStateException("entry should be nested inside map".toString());
                            }
                            case 10: {
                                this.addFix((LintFix)this.readFixData());
                                continue block44;
                            }
                            case 2: {
                                this.addFix(this.readFixShowUrl());
                                continue block44;
                            }
                            case 6: {
                                this.addFix(this.readFixAnnotate());
                                continue block44;
                            }
                            case 11: {
                                this.addFix(this.readFixReplace());
                                continue block44;
                            }
                            case 9: {
                                this.addFix(this.readFixSetAttribute());
                                continue block44;
                            }
                            case 1: {
                                this.addFix(this.readCreateFile());
                                continue block44;
                            }
                            case 4: {
                                this.readFixComposite();
                                continue block44;
                            }
                        }
                    }
                    throw new IllegalStateException(("Unexpected tag " + tag).toString());
                }
                if (eventType == 2) continue;
            }
        }
        catch (IOException e) {
            this.client.log(e, null, new Object[0]);
        }
        catch (XmlPullParserException e) {
            this.client.log(e, null, new Object[0]);
        }
        if (this.project != null) {
            for (Incident incident : this.incidents) {
                incident.setProject(this.project);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void readIncidentHeader() {
        int n = this.parser.getAttributeCount();
        block10: for (int i = 0; i < n; ++i) {
            String name = this.parser.getAttributeName(i);
            String value = this.parser.getAttributeValue(i);
            String string = name;
            if (string == null) throw new IllegalStateException(("Unexpected issue attribute: " + value).toString());
            int n2 = -1;
            switch (string.hashCode()) {
                case 1478300413: {
                    if (string.equals("severity")) {
                        n2 = 1;
                    }
                    break;
                }
                case 3355: {
                    if (string.equals("id")) {
                        n2 = 2;
                    }
                    break;
                }
                case 954925063: {
                    if (string.equals("message")) {
                        n2 = 3;
                    }
                    break;
                }
            }
            switch (n2) {
                case 2: {
                    this.issueId = value;
                    continue block10;
                }
                case 3: {
                    this.message = value;
                    continue block10;
                }
                case 1: {
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    this.severity = Severity.Companion.fromName(value);
                    continue block10;
                }
                default: {
                    throw new IllegalStateException(("Unexpected issue attribute: " + value).toString());
                }
            }
        }
        if (this.issueId != null && this.message != null) return;
        throw new IllegalStateException("Missing required issue or message".toString());
    }

    private final void readRange() {
        Location newLocation = this.readLocation();
        LintFix parentFix = this.getParentFix();
        if (parentFix instanceof LintFix.ReplaceString) {
            ((LintFix.ReplaceString)parentFix).setRange(newLocation);
        } else if (parentFix instanceof LintFix.SetAttribute) {
            ((LintFix.SetAttribute)parentFix).setRange(newLocation);
        } else if (parentFix instanceof LintFix.AnnotateFix) {
            ((LintFix.AnnotateFix)parentFix).setRange(newLocation);
        } else {
            throw new IllegalStateException("Unexpected parent of <range>".toString());
        }
    }

    private final void readConfigInto() {
        Map map;
        String id = this.parser.getAttributeValue(null, "id");
        String severityString = this.parser.getAttributeValue(null, "severity");
        if (id == null || severityString == null) {
            throw new IllegalStateException("Missing required id or severity".toString());
        }
        Map map2 = this.configs;
        if (map2 == null) {
            HashMap hashMap;
            HashMap it = hashMap = new HashMap();
            boolean bl = false;
            this.configs = it;
            map2 = hashMap;
        }
        if ((map = map2).get(id) != null) {
            throw new IllegalStateException(("Should only specify one severity for issue " + id).toString());
        }
        Severity severity = Severity.Companion.fromName(severityString);
        if (severity == null) {
            throw new IllegalStateException(("Unknown severity " + severityString).toString());
        }
        Severity s = severity;
        map.put(id, s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void readFixComposite() {
        String tag = this.parser.getName();
        String displayName = null;
        String familyName = null;
        boolean robot = false;
        boolean independent = false;
        int n = this.parser.getAttributeCount();
        block12: for (int i = 0; i < n; ++i) {
            String name = this.parser.getAttributeName(i);
            String value = this.parser.getAttributeValue(i);
            String string = name;
            if (string == null) throw new IllegalStateException(("Unexpected note attribute: " + name).toString());
            int n2 = -1;
            switch (string.hashCode()) {
                case 0x67A6A6A: {
                    if (string.equals("robot")) {
                        n2 = 1;
                    }
                    break;
                }
                case -952207494: {
                    if (string.equals("independent")) {
                        n2 = 2;
                    }
                    break;
                }
                case -1724546052: {
                    if (string.equals("description")) {
                        n2 = 3;
                    }
                    break;
                }
                case -1281860764: {
                    if (string.equals("family")) {
                        n2 = 4;
                    }
                    break;
                }
            }
            switch (n2) {
                case 3: {
                    displayName = value;
                    continue block12;
                }
                case 4: {
                    familyName = value;
                    continue block12;
                }
                case 1: {
                    robot = true;
                    continue block12;
                }
                case 2: {
                    independent = true;
                    continue block12;
                }
                default: {
                    throw new IllegalStateException(("Unexpected note attribute: " + name).toString());
                }
            }
        }
        ArrayList fixList = new ArrayList();
        LintFix.GroupType type = Intrinsics.areEqual((Object)tag, (Object)"fix-alternatives") ? LintFix.GroupType.ALTERNATIVES : LintFix.GroupType.COMPOSITE;
        LintFix.LintFixGroup newFix = new LintFix.LintFixGroup(displayName, familyName, type, (List)fixList);
        newFix.autoFix(robot, independent);
        this.addFix((LintFix)newFix);
        this.fixLists.addLast(fixList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final LintFix readCreateFile() {
        LintFix.CreateFileBuilder createFileBuilder;
        String text = null;
        byte[] binary = null;
        String selectPattern = null;
        boolean reformat = false;
        String displayName = null;
        String familyName = null;
        boolean robot = false;
        boolean independent = false;
        File file = null;
        boolean delete = false;
        int n = this.parser.getAttributeCount();
        block24: for (int i = 0; i < n; ++i) {
            String name = this.parser.getAttributeName(i);
            String value = this.parser.getAttributeValue(i);
            String string = name;
            if (string == null) throw new IllegalStateException(("Unexpected fix attribute: " + name).toString());
            int n2 = -1;
            switch (string.hashCode()) {
                case 0x67A6A6A: {
                    if (string.equals("robot")) {
                        n2 = 1;
                    }
                    break;
                }
                case -713337878: {
                    if (string.equals("reformat")) {
                        n2 = 2;
                    }
                    break;
                }
                case 3143036: {
                    if (string.equals("file")) {
                        n2 = 3;
                    }
                    break;
                }
                case -67634444: {
                    if (string.equals("selectPattern")) {
                        n2 = 4;
                    }
                    break;
                }
                case -952207494: {
                    if (string.equals("independent")) {
                        n2 = 5;
                    }
                    break;
                }
                case -1388966911: {
                    if (string.equals("binary")) {
                        n2 = 6;
                    }
                    break;
                }
                case -1724546052: {
                    if (string.equals("description")) {
                        n2 = 7;
                    }
                    break;
                }
                case -1281860764: {
                    if (string.equals("family")) {
                        n2 = 8;
                    }
                    break;
                }
                case -1335458389: {
                    if (string.equals("delete")) {
                        n2 = 9;
                    }
                    break;
                }
                case 430919186: {
                    if (string.equals("replacement")) {
                        n2 = 10;
                    }
                    break;
                }
            }
            switch (n2) {
                case 3: {
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    file = this.getFile(value);
                    continue block24;
                }
                case 9: {
                    delete = Intrinsics.areEqual((Object)value, (Object)"true");
                    continue block24;
                }
                case 10: {
                    text = value;
                    continue block24;
                }
                case 6: {
                    binary = Base64.getDecoder().decode(value);
                    continue block24;
                }
                case 4: {
                    selectPattern = value;
                    continue block24;
                }
                case 2: {
                    reformat = true;
                    continue block24;
                }
                case 7: {
                    displayName = value;
                    continue block24;
                }
                case 8: {
                    familyName = value;
                    continue block24;
                }
                case 5: {
                    independent = true;
                    continue block24;
                }
                case 1: {
                    robot = true;
                    continue block24;
                }
                default: {
                    throw new IllegalStateException(("Unexpected fix attribute: " + name).toString());
                }
            }
        }
        LintFix.Builder builder = LintFix.Companion.create().name(displayName).sharedName(familyName);
        if (delete) {
            File file2 = file;
            Intrinsics.checkNotNull(file2);
            createFileBuilder = builder.deleteFile(file2);
        } else if (text != null) {
            File file3 = file;
            Intrinsics.checkNotNull(file3);
            createFileBuilder = builder.newFile(file3, text);
        } else {
            File file4 = file;
            Intrinsics.checkNotNull(file4);
            Intrinsics.checkNotNull(binary);
            createFileBuilder = builder.newFile(file4, binary);
        }
        LintFix.CreateFileBuilder fix = createFileBuilder;
        return fix.select(selectPattern).reformat(reformat).autoFix(robot, independent).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final LintFix readFixSetAttribute() {
        String namespace = null;
        String attributeName = null;
        String attributeValue = null;
        int dot = Integer.MIN_VALUE;
        int mark = Integer.MIN_VALUE;
        String displayName = null;
        String familyName = null;
        boolean robot = false;
        boolean independent = false;
        int n = this.parser.getAttributeCount();
        block22: for (int i = 0; i < n; ++i) {
            String name = this.parser.getAttributeName(i);
            String value = this.parser.getAttributeValue(i);
            String string = name;
            if (string == null) throw new IllegalStateException(("Unexpected note attribute: " + name).toString());
            int n2 = -1;
            switch (string.hashCode()) {
                case 0x67A6A6A: {
                    if (string.equals("robot")) {
                        n2 = 1;
                    }
                    break;
                }
                case -952207494: {
                    if (string.equals("independent")) {
                        n2 = 2;
                    }
                    break;
                }
                case 1252218203: {
                    if (string.equals("namespace")) {
                        n2 = 3;
                    }
                    break;
                }
                case 99657: {
                    if (string.equals("dot")) {
                        n2 = 4;
                    }
                    break;
                }
                case -1724546052: {
                    if (string.equals("description")) {
                        n2 = 5;
                    }
                    break;
                }
                case 13085340: {
                    if (string.equals("attribute")) {
                        n2 = 6;
                    }
                    break;
                }
                case -1281860764: {
                    if (string.equals("family")) {
                        n2 = 7;
                    }
                    break;
                }
                case 111972721: {
                    if (string.equals("value")) {
                        n2 = 8;
                    }
                    break;
                }
                case 3344077: {
                    if (string.equals("mark")) {
                        n2 = 9;
                    }
                    break;
                }
            }
            switch (n2) {
                case 3: {
                    namespace = value;
                    continue block22;
                }
                case 6: {
                    attributeName = value;
                    continue block22;
                }
                case 8: {
                    attributeValue = value;
                    continue block22;
                }
                case 4: {
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    dot = Integer.parseInt(value);
                    continue block22;
                }
                case 9: {
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    mark = Integer.parseInt(value);
                    continue block22;
                }
                case 5: {
                    displayName = value;
                    continue block22;
                }
                case 7: {
                    familyName = value;
                    continue block22;
                }
                case 2: {
                    independent = true;
                    continue block22;
                }
                case 1: {
                    robot = true;
                    continue block22;
                }
                default: {
                    throw new IllegalStateException(("Unexpected note attribute: " + name).toString());
                }
            }
        }
        Intrinsics.checkNotNull(attributeName);
        return LintFix.Companion.create().set().name(displayName).sharedName(familyName).namespace(namespace).attribute(attributeName).value(attributeValue).range(null).select(dot, mark).autoFix(robot, independent).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final LintFix readFixAnnotate() {
        String source = null;
        boolean replace = true;
        String displayName = null;
        String familyName = null;
        boolean robot = false;
        boolean independent = false;
        int n = this.parser.getAttributeCount();
        block16: for (int i = 0; i < n; ++i) {
            String name = this.parser.getAttributeName(i);
            String value = this.parser.getAttributeValue(i);
            String string = name;
            if (string == null) throw new IllegalStateException(("Unexpected note attribute: " + name).toString());
            int n2 = -1;
            switch (string.hashCode()) {
                case 0x67A6A6A: {
                    if (string.equals("robot")) {
                        n2 = 1;
                    }
                    break;
                }
                case -952207494: {
                    if (string.equals("independent")) {
                        n2 = 2;
                    }
                    break;
                }
                case 1094496948: {
                    if (string.equals("replace")) {
                        n2 = 3;
                    }
                    break;
                }
                case -1724546052: {
                    if (string.equals("description")) {
                        n2 = 4;
                    }
                    break;
                }
                case -896505829: {
                    if (string.equals("source")) {
                        n2 = 5;
                    }
                    break;
                }
                case -1281860764: {
                    if (string.equals("family")) {
                        n2 = 6;
                    }
                    break;
                }
            }
            switch (n2) {
                case 5: {
                    source = value;
                    continue block16;
                }
                case 3: {
                    replace = true;
                    continue block16;
                }
                case 4: {
                    displayName = value;
                    continue block16;
                }
                case 6: {
                    familyName = value;
                    continue block16;
                }
                case 2: {
                    independent = true;
                    continue block16;
                }
                case 1: {
                    robot = true;
                    continue block16;
                }
                default: {
                    throw new IllegalStateException(("Unexpected note attribute: " + name).toString());
                }
            }
        }
        LintFix.Builder builder = LintFix.Companion.create().name(displayName).sharedName(familyName);
        String string = source;
        Intrinsics.checkNotNull(string);
        return builder.annotate(string, replace).autoFix(robot, independent).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final LintFix readFixShowUrl() {
        String url = null;
        String displayName = null;
        String familyName = null;
        int n = this.parser.getAttributeCount();
        block5: for (int i = 0; i < n; ++i) {
            String value;
            String name;
            block7: {
                name = this.parser.getAttributeName(i);
                value = this.parser.getAttributeValue(i);
                String string = name;
                if (string == null) throw new IllegalStateException(("Unexpected note attribute: " + name).toString());
                switch (string.hashCode()) {
                    case -1724546052: {
                        if (string.equals("description")) break;
                        throw new IllegalStateException(("Unexpected note attribute: " + name).toString());
                    }
                    case -1281860764: {
                        if (!string.equals("family")) {
                            throw new IllegalStateException(("Unexpected note attribute: " + name).toString());
                        }
                        break block7;
                    }
                    case 116079: {
                        if (!string.equals("url")) throw new IllegalStateException(("Unexpected note attribute: " + name).toString());
                        url = value;
                        continue block5;
                    }
                }
                displayName = value;
                continue;
            }
            familyName = value;
            continue;
            throw new IllegalStateException(("Unexpected note attribute: " + name).toString());
        }
        LintFix.Builder builder = LintFix.Companion.create().name(displayName).sharedName(familyName);
        String string = url;
        Intrinsics.checkNotNull(string);
        return builder.url(string).build();
    }

    private final LintFix.DataMap readFixData() {
        HashMap map = new HashMap();
        String desc = null;
        String familyName = null;
        int n = this.parser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String value;
            String name = this.parser.getAttributeName(i);
            Intrinsics.checkNotNull((Object)this.parser.getAttributeValue(i));
            String string = name;
            if (Intrinsics.areEqual((Object)string, (Object)"description")) {
                desc = value;
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"family")) {
                familyName = value;
                continue;
            }
            Map map2 = map;
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            map2.put(name, value);
        }
        return new LintFix.DataMap(desc, familyName, (Map)map);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final LintFix readFixReplace() {
        LintFix.ReplaceStringBuilder replaceStringBuilder;
        String oldString = null;
        String oldPattern = null;
        String selectPattern = null;
        String replacement = null;
        boolean shortenNames = false;
        boolean reformat = false;
        List imports = null;
        String displayName = null;
        String familyName = null;
        boolean robot = false;
        boolean independent = false;
        int n = this.parser.getAttributeCount();
        block26: for (int i = 0; i < n; ++i) {
            String name = this.parser.getAttributeName(i);
            String value = this.parser.getAttributeValue(i);
            String string = name;
            if (string == null) throw new IllegalStateException(("Unexpected note attribute: " + name).toString());
            int n2 = -1;
            switch (string.hashCode()) {
                case -1793911773: {
                    if (string.equals("shortenNames")) {
                        n2 = 1;
                    }
                    break;
                }
                case 0x67A6A6A: {
                    if (string.equals("robot")) {
                        n2 = 2;
                    }
                    break;
                }
                case -713337878: {
                    if (string.equals("reformat")) {
                        n2 = 3;
                    }
                    break;
                }
                case -67634444: {
                    if (string.equals("selectPattern")) {
                        n2 = 4;
                    }
                    break;
                }
                case 1926037870: {
                    if (string.equals("imports")) {
                        n2 = 5;
                    }
                    break;
                }
                case 1086188393: {
                    if (string.equals("oldPattern")) {
                        n2 = 6;
                    }
                    break;
                }
                case -952207494: {
                    if (string.equals("independent")) {
                        n2 = 7;
                    }
                    break;
                }
                case -1724546052: {
                    if (string.equals("description")) {
                        n2 = 8;
                    }
                    break;
                }
                case 1523876120: {
                    if (string.equals("oldString")) {
                        n2 = 9;
                    }
                    break;
                }
                case -1281860764: {
                    if (string.equals("family")) {
                        n2 = 10;
                    }
                    break;
                }
                case 430919186: {
                    if (string.equals("replacement")) {
                        n2 = 11;
                    }
                    break;
                }
            }
            switch (n2) {
                case 9: {
                    oldString = value;
                    continue block26;
                }
                case 6: {
                    oldPattern = value;
                    continue block26;
                }
                case 4: {
                    selectPattern = value;
                    continue block26;
                }
                case 11: {
                    replacement = value;
                    continue block26;
                }
                case 1: {
                    shortenNames = true;
                    continue block26;
                }
                case 3: {
                    reformat = true;
                    continue block26;
                }
                case 5: {
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    String[] stringArray = new String[]{","};
                    imports = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    continue block26;
                }
                case 8: {
                    displayName = value;
                    continue block26;
                }
                case 10: {
                    familyName = value;
                    continue block26;
                }
                case 7: {
                    independent = true;
                    continue block26;
                }
                case 2: {
                    robot = true;
                    continue block26;
                }
                default: {
                    throw new IllegalStateException(("Unexpected note attribute: " + name).toString());
                }
            }
        }
        LintFix.ReplaceStringBuilder replaceStringBuilder2 = LintFix.Companion.create().replace().name(displayName).sharedName(familyName).text(oldString).pattern(oldPattern).select(selectPattern);
        String string = replacement;
        if (string == null) {
            string = "";
        }
        LintFix.ReplaceStringBuilder $this$readFixReplace_u24lambda_u249 = replaceStringBuilder = replaceStringBuilder2.with(string).shortenNames(shortenNames).reformat(reformat);
        boolean bl = false;
        List list2 = imports;
        if (list2 == null) return replaceStringBuilder.autoFix(robot, independent).build();
        List it = list2;
        boolean bl2 = false;
        Collection $this$toTypedArray$iv = it;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        $this$readFixReplace_u24lambda_u249.imports(Arrays.copyOf(stringArray, stringArray.length));
        return replaceStringBuilder.autoFix(robot, independent).build();
    }

    private final File getFile(String path) {
        Project project = this.project;
        return this.client.getPathVariables().fromPathString(path, project != null ? project.getDir() : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Location readLocation() {
        Location newLocation;
        File file = null;
        String line2 = null;
        String endLine = null;
        String column = "0";
        String endColumn = "0";
        String startOffset = null;
        String endOffset = null;
        String locationMessage = null;
        int n = this.parser.getAttributeCount();
        block24: for (int i = 0; i < n; ++i) {
            String name = this.parser.getAttributeName(i);
            String value = this.parser.getAttributeValue(i);
            String string = name;
            if (string == null) throw new IllegalStateException(("Unexpected location attribute: " + value).toString());
            int n2 = -1;
            switch (string.hashCode()) {
                case -1607481489: {
                    if (string.equals("endLine")) {
                        n2 = 1;
                    }
                    break;
                }
                case 1146353681: {
                    if (string.equals("endColumn")) {
                        n2 = 2;
                    }
                    break;
                }
                case 1481410894: {
                    if (string.equals("endOffset")) {
                        n2 = 3;
                    }
                    break;
                }
                case 3143036: {
                    if (string.equals("file")) {
                        n2 = 4;
                    }
                    break;
                }
                case -1993948267: {
                    if (string.equals("startOffset")) {
                        n2 = 5;
                    }
                    break;
                }
                case 3321844: {
                    if (string.equals("line")) {
                        n2 = 6;
                    }
                    break;
                }
                case -1354837162: {
                    if (string.equals("column")) {
                        n2 = 7;
                    }
                    break;
                }
                case 3355: {
                    if (string.equals("id")) {
                        n2 = 8;
                    }
                    break;
                }
                case 954925063: {
                    if (string.equals("message")) {
                        n2 = 9;
                    }
                    break;
                }
            }
            switch (n2) {
                case 4: {
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    file = this.getFile(value);
                    continue block24;
                }
                case 6: {
                    line2 = value;
                    continue block24;
                }
                case 1: {
                    endLine = value;
                    continue block24;
                }
                case 7: {
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    column = value;
                    continue block24;
                }
                case 2: {
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    endColumn = value;
                    continue block24;
                }
                case 5: {
                    startOffset = value;
                    continue block24;
                }
                case 3: {
                    endOffset = value;
                    continue block24;
                }
                case 9: {
                    locationMessage = value;
                    continue block24;
                }
                default: {
                    throw new IllegalStateException(("Unexpected location attribute: " + value).toString());
                }
                case 8: 
            }
        }
        if (file == null) {
            throw new IllegalStateException(("Missing " + file + " attribute").toString());
        }
        if (line2 == null && startOffset == null) {
            v0 = Location.Companion.create(file);
        } else {
            Location location;
            try {
                String string = line2;
                String string2 = startOffset;
                DefaultPosition start = new DefaultPosition(string != null ? Integer.parseInt(string) - 1 : -1, Integer.parseInt(column) - 1, string2 != null ? Integer.parseInt(string2) : -1);
                String string3 = endLine;
                String string4 = endOffset;
                DefaultPosition end = new DefaultPosition(string3 != null ? Integer.parseInt(string3) - 1 : -1, Integer.parseInt(endColumn) - 1, string4 != null ? Integer.parseInt(string4) : -1);
                location = Location.Companion.create(file, (Position)start, (Position)end);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(("Invalid number: " + e).toString());
            }
            v0 = newLocation = location;
        }
        if (locationMessage == null) return newLocation;
        newLocation.setMessage(locationMessage);
        return newLocation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Constraint readCondition() {
        int index = this.parser.getAttributeCount() == 2 ? 1 : 0;
        String name = this.parser.getAttributeName(index);
        String value = this.parser.getAttributeValue(index);
        String string = name;
        if (string == null) throw new IllegalStateException(("Unexpected condition attribute: " + name + "=" + value).toString());
        int n = -1;
        switch (string.hashCode()) {
            case 103899824: {
                if (string.equals("minGE")) {
                    n = 1;
                }
                break;
            }
            case -441951527: {
                if (string.equals("targetLT")) {
                    n = 2;
                }
                break;
            }
            case 92905304: {
                if (string.equals("allOf")) {
                    n = 3;
                }
                break;
            }
            case 166208699: {
                if (string.equals("library")) {
                    n = 4;
                }
                break;
            }
            case -441951697: {
                if (string.equals("targetGE")) {
                    n = 5;
                }
                break;
            }
            case -861391249: {
                if (string.equals("android")) {
                    n = 6;
                }
                break;
            }
            case 92977379: {
                if (string.equals("anyOf")) {
                    n = 7;
                }
                break;
            }
            case 103899994: {
                if (string.equals("minLT")) {
                    n = 8;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                Constraint constraint = Constraints.minSdkAtLeast((ApiConstraint)ApiConstraint.Companion.deserialize(value));
                return constraint;
            }
            case 8: {
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                Constraint constraint = Constraints.minSdkLessThan((ApiConstraint)ApiConstraint.Companion.deserialize(value));
                return constraint;
            }
            case 5: {
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                Constraint constraint = Constraints.targetSdkAtLeast((int)Integer.parseInt(value));
                return constraint;
            }
            case 2: {
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                Constraint constraint = Constraints.targetSdkLessThan((int)Integer.parseInt(value));
                return constraint;
            }
            case 4: {
                Constraint constraint;
                if (Intrinsics.areEqual((Object)value, (Object)"true")) {
                    constraint = Constraints.isLibraryProject();
                    return constraint;
                }
                constraint = Constraints.notLibraryProject();
                return constraint;
            }
            case 6: {
                Constraint constraint;
                if (Intrinsics.areEqual((Object)value, (Object)"true")) {
                    constraint = Constraints.isAndroidProject();
                    return constraint;
                }
                constraint = Constraints.notAndroidProject();
                return constraint;
            }
            case 3: {
                this.skipToNextTag();
                Constraint left = this.readCondition();
                this.skipToNextTag();
                Constraint right = this.readCondition();
                Constraint constraint = left.and(right);
                return constraint;
            }
            case 7: {
                this.skipToNextTag();
                Constraint left = this.readCondition();
                this.skipToNextTag();
                Constraint right = this.readCondition();
                Constraint constraint = left.or(right);
                return constraint;
            }
            default: {
                throw new IllegalStateException(("Unexpected condition attribute: " + name + "=" + value).toString());
            }
        }
    }

    private final void skipToNextTag() {
        int eventType;
        while (this.parser.next() != 1 && (eventType = this.parser.getEventType()) != 2) {
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final LintMap readLintMap() {
        boolean bl;
        boolean bl2 = bl = Intrinsics.areEqual((Object)this.parser.getName(), (Object)"map") || Intrinsics.areEqual((Object)this.parser.getName(), (Object)"data");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        LintMap lintMap = new LintMap();
        Map map = LintMap.Companion.getInternalMap(lintMap);
        block43: while (this.parser.next() != 1) {
            int eventType = this.parser.getEventType();
            switch (eventType) {
                case 3: {
                    String tag = this.parser.getName();
                    if (tag == null) throw new IllegalStateException(("Unexpected tag " + tag).toString());
                    int n = -1;
                    switch (tag.hashCode()) {
                        case 96667762: {
                            if (tag.equals("entry")) {
                                n = 1;
                            }
                            break;
                        }
                        case -861311717: {
                            if (tag.equals("condition")) {
                                n = 1;
                            }
                            break;
                        }
                        case 329913474: {
                            if (tag.equals("api-levels")) {
                                n = 1;
                            }
                            break;
                        }
                        case 1901043637: {
                            if (tag.equals("location")) {
                                n = 1;
                            }
                            break;
                        }
                        case 107868: {
                            if (tag.equals("map")) {
                                n = 2;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            continue block43;
                        }
                        case 2: {
                            return lintMap;
                        }
                    }
                    throw new IllegalStateException(("Unexpected tag " + tag).toString());
                }
                case 2: {
                    String tag = this.parser.getName();
                    if (tag == null) throw new IllegalStateException(("Unexpected tag " + tag).toString());
                    int n = -1;
                    switch (tag.hashCode()) {
                        case 96667762: {
                            if (tag.equals("entry")) {
                                n = 1;
                            }
                            break;
                        }
                        case -861311717: {
                            if (tag.equals("condition")) {
                                n = 2;
                            }
                            break;
                        }
                        case 329913474: {
                            if (tag.equals("api-levels")) {
                                n = 3;
                            }
                            break;
                        }
                        case 1901043637: {
                            if (tag.equals("location")) {
                                n = 4;
                            }
                            break;
                        }
                        case 107868: {
                            if (tag.equals("map")) {
                                n = 5;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            int n2 = this.parser.getAttributeCount();
                            if (n2 != 2) {
                                throw new IllegalStateException("Expected key and value".toString());
                            }
                            String noteKey = "";
                            Object noteValue = null;
                            block44: for (int i = 0; i < n2; ++i) {
                                String name = this.parser.getAttributeName(i);
                                String value = this.parser.getAttributeValue(i);
                                String string = name;
                                if (string == null) throw new IllegalStateException(("Unexpected note attribute: " + name).toString());
                                tmp = -1;
                                switch (string.hashCode()) {
                                    case 1478300413: {
                                        if (string.equals("severity")) {
                                            tmp = 1;
                                        }
                                        break;
                                    }
                                    case 64711720: {
                                        if (string.equals("boolean")) {
                                            tmp = 2;
                                        }
                                        break;
                                    }
                                    case -891985903: {
                                        if (string.equals("string")) {
                                            tmp = 3;
                                        }
                                        break;
                                    }
                                    case 3373707: {
                                        if (string.equals("name")) {
                                            tmp = 4;
                                        }
                                        break;
                                    }
                                    case 104431: {
                                        if (string.equals("int")) {
                                            tmp = 5;
                                        }
                                        break;
                                    }
                                }
                                switch (tmp) {
                                    case 4: {
                                        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                                        noteKey = value;
                                        continue block44;
                                    }
                                    case 5: {
                                        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                                        noteValue = Integer.parseInt(value);
                                        continue block44;
                                    }
                                    case 2: {
                                        String string2 = value;
                                        Intrinsics.checkNotNull((Object)string2);
                                        noteValue = Boolean.parseBoolean(string2);
                                        continue block44;
                                    }
                                    case 1: {
                                        String string3 = value;
                                        Intrinsics.checkNotNull((Object)string3);
                                        noteValue = Severity.Companion.fromName(string3);
                                        continue block44;
                                    }
                                    case 3: {
                                        noteValue = value;
                                        continue block44;
                                    }
                                    default: {
                                        throw new IllegalStateException(("Unexpected note attribute: " + name).toString());
                                    }
                                }
                            }
                            String string = noteValue;
                            Intrinsics.checkNotNull(string);
                            map.put(noteKey, string);
                            continue block43;
                        }
                        case 5: {
                            String mapName;
                            if (this.parser.getAttributeValue(null, "id") == null) {
                                throw new IllegalStateException("No key on nested map".toString());
                            }
                            LintMap nestedNode = this.readLintMap();
                            map.put(mapName, nestedNode);
                            continue block43;
                        }
                        case 4: {
                            String id = this.parser.getAttributeValue(null, "id");
                            Location location = this.readLocation();
                            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                            map.put(id, location);
                            continue block43;
                        }
                        case 2: {
                            String string = this.parser.getAttributeValue(null, "id");
                            if (string == null) {
                                string = "_condition_";
                            }
                            String id = string;
                            Constraint condition = this.readCondition();
                            map.put(id, condition);
                            continue block43;
                        }
                        case 3: {
                            String string = this.parser.getAttributeValue(null, "id");
                            if (string == null) {
                                string = "_condition_";
                            }
                            String id = string;
                            String value = this.parser.getAttributeValue(null, "value");
                            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                            ApiConstraint apiLevels = ApiConstraint.Companion.deserialize(value);
                            map.put(id, apiLevels);
                            continue block43;
                        }
                    }
                    throw new IllegalStateException(("Unexpected tag " + tag).toString());
                }
            }
        }
        return lintMap;
    }
}

