/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.SdkConstants;
import com.android.Version;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.resources.ResourceRepository;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.LintBatchAnalytics;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintCliXmlParser;
import com.android.tools.lint.LintExternalAnnotationsManager;
import com.android.tools.lint.LintFixPerformer;
import com.android.tools.lint.LintResourceRepository;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.UastEnvironment;
import com.android.tools.lint.UastEnvironmentKt;
import com.android.tools.lint.XmlFileType;
import com.android.tools.lint.XmlReader;
import com.android.tools.lint.XmlReporter;
import com.android.tools.lint.XmlWriter;
import com.android.tools.lint.checks.HardcodedValuesDetector;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JarFileIssueRegistry;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintListener;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.client.api.LintXmlConfiguration;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraint;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.gradle.GroovyGradleVisitor;
import com.android.tools.lint.helpers.DefaultJavaEvaluator;
import com.android.tools.lint.helpers.DefaultUastParser;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.tools.lint.model.LintModelSourceProvider;
import com.android.tools.lint.model.LintModelVariant;
import com.android.tools.lint.model.PathVariables;
import com.android.utils.CharSequences;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.mock.MockProject;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.util.lang.UrlClassLoader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.impl.JavaSdkUtil;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.util.PerformanceCounter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0016\u0018\u0000 \u00e7\u00012\u00020\u0001:\u0006\u00e7\u0001\u00e8\u0001\u00e9\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ$\u0010W\u001a\u00020'2\f\u0010X\u001a\b\u0012\u0004\u0012\u0002080Y2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\"0[H\u0014J\b\u0010\\\u001a\u00020]H\u0014J\b\u0010^\u001a\u00020]H\u0002J\u0016\u0010_\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020<2\u0006\u0010`\u001a\u00020aJ4\u0010b\u001a\u00020]2\u0006\u0010c\u001a\u0002082\u0012\u0010d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020f0e2\u0006\u0010g\u001a\u0002082\u0006\u0010h\u001a\u00020iH\u0002J\u0010\u0010j\u001a\u00020]2\u0006\u0010`\u001a\u00020aH\u0014J\u0010\u0010k\u001a\u00020'2\u0006\u0010l\u001a\u00020\u0003H\u0002J\b\u0010m\u001a\u00020'H\u0002J\u0010\u0010n\u001a\u00020]2\u0006\u0010o\u001a\u00020fH\u0002J\u0018\u0010p\u001a\u00020\u00152\u0006\u0010=\u001a\u00020<2\u0006\u0010q\u001a\u00020aH\u0014J\u0016\u0010r\u001a\u00020a2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\"0sH\u0014J\u0018\u0010t\u001a\u0002082\u0006\u0010u\u001a\u00020\"2\u0006\u0010v\u001a\u00020\"H\u0014J#\u0010w\u001a\u00020x2\f\u0010y\u001a\b\u0012\u0004\u0012\u00020{0z2\u0006\u0010|\u001a\u00020xH\u0017\u00a2\u0006\u0002\u0010}J\u001e\u0010w\u001a\u00020x2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\"0s2\u0006\u0010|\u001a\u00020xH\u0016J\u0016\u0010~\u001a\u00020]2\f\u0010X\u001a\b\u0012\u0004\u0012\u0002080YH\u0016J%\u0010\u007f\u001a\u00020]2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\u0007\u0010\u0082\u0001\u001a\u00020\"2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0002J\u0019\u0010\u0085\u0001\u001a\t\u0012\u0004\u0012\u00020\"0\u0086\u00012\u0007\u0010\u0087\u0001\u001a\u000208H\u0016J\u0012\u0010\u0088\u0001\u001a\u00020\u00032\u0007\u0010\u0082\u0001\u001a\u00020\"H\u0002J\u001f\u0010\u0089\u0001\u001a\u0004\u0018\u00010\"2\t\u0010\u008a\u0001\u001a\u0004\u0018\u00010\u00032\u0007\u0010\u008b\u0001\u001a\u00020'H\u0016J\u0012\u0010\u008c\u0001\u001a\u0002092\u0007\u0010\u0087\u0001\u001a\u000208H\u0014J\"\u0010\u008d\u0001\u001a\u0005\u0018\u0001H\u008e\u0001\"\u0005\b\u0000\u0010\u008e\u00012\u0007\u0010\u008f\u0001\u001a\u00020\u000eH\u0016\u00a2\u0006\u0003\u0010\u0090\u0001J\t\u0010\u0091\u0001\u001a\u00020\u0003H\u0016J\u001b\u0010\u0092\u0001\u001a\u00020\u00032\t\u0010\u0087\u0001\u001a\u0004\u0018\u0001082\u0007\u0010\u0093\u0001\u001a\u00020\"J$\u0010\u0092\u0001\u001a\u00020\u00032\t\u0010\u0087\u0001\u001a\u0004\u0018\u0001082\u0007\u0010\u0093\u0001\u001a\u00020\"2\u0007\u0010\u0094\u0001\u001a\u00020'J'\u0010\u0092\u0001\u001a\u00020\u00032\u0007\u0010\u0093\u0001\u001a\u00020\"2\t\u0010\u0087\u0001\u001a\u0004\u0018\u0001082\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0016J!\u0010\u0092\u0001\u001a\u00020\u00032\u0006\u0010v\u001a\u00020\"2\u0007\u0010\u0093\u0001\u001a\u00020\"2\u0007\u0010\u0094\u0001\u001a\u00020'J\n\u0010\u0097\u0001\u001a\u00030\u0098\u0001H\u0016J\u0014\u0010\u0099\u0001\u001a\u0004\u0018\u00010Q2\u0007\u0010\u0087\u0001\u001a\u000208H\u0016J\u001b\u0010\u009a\u0001\u001a\u0002042\u0007\u0010\u0087\u0001\u001a\u0002082\u0007\u0010\u009b\u0001\u001a\u000203H\u0016J\u0018\u0010\u009c\u0001\u001a\b\u0012\u0004\u0012\u00020\"0s2\u0007\u0010\u0087\u0001\u001a\u000208H\u0016J\u001d\u0010\u009d\u0001\u001a\u00030\u009e\u00012\u0007\u0010\u0087\u0001\u001a\u0002082\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001H\u0016J\u000b\u0010\u00a1\u0001\u001a\u0004\u0018\u00010\"H\u0016J\u001c\u0010\u00a2\u0001\u001a\u00020\"2\u0007\u0010\u0087\u0001\u001a\u0002082\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001H\u0016J\u0010\u0010\u00a5\u0001\u001a\u00020#2\u0007\u0010\u0093\u0001\u001a\u00020\"J\u0015\u0010\u00a6\u0001\u001a\u00030\u00a7\u00012\t\u0010\u0087\u0001\u001a\u0004\u0018\u000108H\u0016J\u001f\u0010\u00a8\u0001\u001a\u0004\u0018\u00010Q2\u0007\u0010\u0093\u0001\u001a\u00020\"2\t\u0010\u00a9\u0001\u001a\u0004\u0018\u00010#H\u0016J\u0007\u0010\u00aa\u0001\u001a\u00020'J\t\u0010\u00ab\u0001\u001a\u00020]H\u0002J!\u0010\u00ac\u0001\u001a\u00020]2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\f\u0010X\u001a\b\u0012\u0004\u0012\u0002080YH\u0016J\u0010\u0010\u00ad\u0001\u001a\u00020'2\u0007\u0010\u009b\u0001\u001a\u000203J\u001a\u0010\u00ae\u0001\u001a\u00020'2\u0006\u0010l\u001a\u00020\u00032\u0007\u0010\u00af\u0001\u001a\u00020\u001cH\u0002J\u0010\u0010\u00b0\u0001\u001a\u00020'2\u0007\u0010\u009b\u0001\u001a\u000203JC\u0010\u00b1\u0001\u001a\u00020]2\u0006\u0010o\u001a\u00020f2\n\u0010\u00b2\u0001\u001a\u0005\u0018\u00010\u00b3\u00012\t\u0010\u0095\u0001\u001a\u0004\u0018\u00010\u00032\u0013\u0010\u00b4\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0z\"\u00020\u000eH\u0016\u00a2\u0006\u0003\u0010\u00b5\u0001J\u0019\u0010\u00b6\u0001\u001a\u00020'2\u000e\u0010\u00b7\u0001\u001a\t\u0012\u0004\u0012\u0002080\u00b8\u0001H\u0002JW\u0010\u00b9\u0001\u001a\u00020]2\u0006\u0010c\u001a\u0002082\u0006\u0010g\u001a\u0002082\u0006\u0010h\u001a\u00020i2\u0019\u0010\u00ba\u0001\u001a\u0014\u0012\u0004\u0012\u000208\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110s0e2\u0019\u0010\u00bb\u0001\u001a\u0014\u0012\u0004\u0012\u000208\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110s0eH\u0015J\u0017\u0010\u00bc\u0001\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020<2\u0006\u0010`\u001a\u00020aJ\u001a\u0010\u00bd\u0001\u001a\u00020]2\u0007\u0010\u00be\u0001\u001a\u0002082\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u001e\u0010\u00bf\u0001\u001a\u0005\u0018\u00010\u00c0\u00012\u0007\u0010\u00c1\u0001\u001a\u00020{2\u0007\u0010\u00c2\u0001\u001a\u00020\u001cH\u0016J\t\u0010\u00c3\u0001\u001a\u00020\u001cH\u0002J\u001a\u0010\u00c4\u0001\u001a\u0005\u0018\u00010\u00c5\u00012\f\u0010X\u001a\b\u0012\u0004\u0012\u0002080YH\u0002J\u001d\u0010\u00c6\u0001\u001a\u00020]2\u0007\u0010\u008f\u0001\u001a\u00020\u000e2\t\u0010\u00c7\u0001\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u00c8\u0001\u001a\u00020#2\u0007\u0010\u0093\u0001\u001a\u00020\"H\u0016J\t\u0010\u00c9\u0001\u001a\u0004\u0018\u00010\u0003J%\u0010\u00ca\u0001\u001a\u00020]2\u0007\u0010\u00cb\u0001\u001a\u00020i2\u0007\u0010\u00cc\u0001\u001a\u00020\u00112\b\u0010\u00cd\u0001\u001a\u00030\u00ce\u0001H\u0016J%\u0010\u00ca\u0001\u001a\u00020]2\u0007\u0010\u00cb\u0001\u001a\u00020i2\u0007\u0010\u00cc\u0001\u001a\u00020\u00112\b\u0010\u00cf\u0001\u001a\u00030\u00d0\u0001H\u0016J%\u0010\u00ca\u0001\u001a\u00020]2\u0007\u0010\u00cb\u0001\u001a\u00020i2\u0007\u0010\u00cc\u0001\u001a\u00020\u00112\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0016J2\u0010\u00d1\u0001\u001a\u00020]2\t\u0010\u0087\u0001\u001a\u0004\u0018\u0001082\u0006\u0010=\u001a\u00020<2\u0007\u0010\u00d2\u0001\u001a\u00020\u00032\u000b\b\u0002\u0010\u0093\u0001\u001a\u0004\u0018\u00010\"H\u0002J\u0007\u0010\u00d3\u0001\u001a\u00020'J\u0017\u0010\u00d4\u0001\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020<2\u0006\u0010`\u001a\u00020aJ;\u0010\u00d4\u0001\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020<2\u0006\u0010`\u001a\u00020a2\u000e\u0010\u00d5\u0001\u001a\t\u0012\u0004\u0012\u00020]0\u00d6\u00012\u0010\b\u0002\u0010\u00d7\u0001\u001a\t\u0012\u0004\u0012\u00020\u001c0\u00d6\u0001H\u0002J\u001b\u0010\u00d8\u0001\u001a\u00020]2\u0007\u0010\u0093\u0001\u001a\u00020\"2\t\u0010\u00d9\u0001\u001a\u0004\u0018\u00010#J\t\u0010\u00da\u0001\u001a\u00020]H\u0014J\u0012\u0010\u00db\u0001\u001a\u00020]2\u0007\u0010\u0087\u0001\u001a\u000208H\u0016J\u0007\u0010\u00dc\u0001\u001a\u00020]J\t\u0010\u00dd\u0001\u001a\u00020]H\u0004J\u0014\u0010\u00dd\u0001\u001a\u00020]2\t\u0010\u0087\u0001\u001a\u0004\u0018\u000108H\u0002J:\u0010\u00dd\u0001\u001a\u00020]2\t\u0010\u0087\u0001\u001a\u0004\u0018\u0001082\u0006\u0010=\u001a\u00020<2\u000f\u0010\u00de\u0001\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010Y2\u000b\b\u0002\u0010\u0093\u0001\u001a\u0004\u0018\u00010\"H\u0002J\u0012\u0010\u00df\u0001\u001a\u00020]2\u0007\u0010\u0087\u0001\u001a\u000208H\u0002J+\u0010\u00e0\u0001\u001a\u00020]2\u0007\u0010\u0087\u0001\u001a\u0002082\b\u0010\u00e1\u0001\u001a\u00030\u00a4\u00012\r\u0010\u00e2\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110sH\u0002J%\u0010\u00e3\u0001\u001a\u00020\u001c2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0093\u0001\u001a\u00020\"2\u0007\u0010\u00e4\u0001\u001a\u00020'H\u0002J\u0012\u0010\u00e5\u0001\u001a\u00020]2\u0007\u0010\u0087\u0001\u001a\u000208H\u0002J\u0013\u0010\u00e6\u0001\u001a\u00020]2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0014R\u0016\u0010\t\u001a\u0004\u0018\u00010\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@DX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010(\u001a\u0004\u0018\u00010)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010-R\u0010\u0010/\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u00102\u001a\u0010\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u000204\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010-R\u001c\u00107\u001a\u0010\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u000209\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u0013R(\u0010=\u001a\u0004\u0018\u00010<2\b\u0010\u0014\u001a\u0004\u0018\u00010<@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u001c\u0010B\u001a\u0004\u0018\u00010CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u001a\u0010H\u001a\u00020'X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010-\"\u0004\bJ\u0010KR\u001a\u0010L\u001a\u00020\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\u001e\"\u0004\bN\u0010 R*\u0010O\u001a\u001e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020Q0Pj\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020Q`RX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010S\u001a\u00020T8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u0010V\u00a8\u0006\u00ea\u0001"}, d2={"Lcom/android/tools/lint/LintCliClient;", "Lcom/android/tools/lint/client/api/LintClient;", "clientName", "", "(Ljava/lang/String;)V", "()V", "flags", "Lcom/android/tools/lint/LintCliFlags;", "(Lcom/android/tools/lint/LintCliFlags;Ljava/lang/String;)V", "baselineVariantName", "getBaselineVariantName", "()Ljava/lang/String;", "clientProperties", "", "", "definiteIncidents", "", "Lcom/android/tools/lint/detector/api/Incident;", "getDefiniteIncidents", "()Ljava/util/List;", "<set-?>", "Lcom/android/tools/lint/client/api/LintDriver;", "driver", "getDriver", "()Lcom/android/tools/lint/client/api/LintDriver;", "setDriver", "(Lcom/android/tools/lint/client/api/LintDriver;)V", "errorCount", "", "getErrorCount", "()I", "setErrorCount", "(I)V", "fileContentCache", "Ljava/io/File;", "", "getFlags", "()Lcom/android/tools/lint/LintCliFlags;", "hasErrors", "", "ideaProject", "Lcom/intellij/mock/MockProject;", "getIdeaProject", "()Lcom/intellij/mock/MockProject;", "isAllEnabled", "()Z", "isCheckingSpecificIssues", "jdkHome", "kotlinPerformanceManager", "Lcom/android/tools/lint/LintCliClient$LintCliKotlinPerformanceManager;", "partialResults", "Lcom/android/tools/lint/detector/api/Issue;", "Lcom/android/tools/lint/detector/api/PartialResult;", "printInternalErrorStackTrace", "getPrintInternalErrorStackTrace", "projectInfoMap", "Lcom/android/tools/lint/detector/api/Project;", "Lcom/android/tools/lint/client/api/LintClient$ClassPathInfo;", "provisionalIncidents", "getProvisionalIncidents", "Lcom/android/tools/lint/client/api/IssueRegistry;", "registry", "getRegistry", "()Lcom/android/tools/lint/client/api/IssueRegistry;", "setRegistry", "(Lcom/android/tools/lint/client/api/IssueRegistry;)V", "uastEnvironment", "Lcom/android/tools/lint/UastEnvironment;", "getUastEnvironment", "()Lcom/android/tools/lint/UastEnvironment;", "setUastEnvironment", "(Lcom/android/tools/lint/UastEnvironment;)V", "validatedIds", "getValidatedIds", "setValidatedIds", "(Z)V", "warningCount", "getWarningCount", "setWarningCount", "xmlDocuments", "Ljava/util/HashMap;", "Lorg/w3c/dom/Document;", "Lkotlin/collections/HashMap;", "xmlParser", "Lcom/android/tools/lint/client/api/XmlParser;", "getXmlParser", "()Lcom/android/tools/lint/client/api/XmlParser;", "addBootClassPath", "knownProjects", "", "files", "", "addCancellationChecker", "", "addGlobalXmlFallbackConfiguration", "analyzeOnly", "lintRequest", "Lcom/android/tools/lint/client/api/LintRequest;", "checkConfigured", "library", "libraryConfigured", "", "Lcom/android/tools/lint/detector/api/Severity;", "main", "mainContext", "Lcom/android/tools/lint/detector/api/Context;", "configureLintRequest", "containsEmbeddedParentRef", "path", "continueAfterBaselineCreated", "countIncident", "severity", "createDriver", "request", "createLintRequest", "", "createProject", "dir", "referenceDir", "createUrlClassLoader", "Ljava/lang/ClassLoader;", "urls", "", "Ljava/net/URL;", "parent", "([Ljava/net/URL;Ljava/lang/ClassLoader;)Ljava/lang/ClassLoader;", "disposeProjects", "emitBaselineDiagnostics", "baseline", "Lcom/android/tools/lint/client/api/LintBaseline;", "baselineFile", "stats", "Lcom/android/tools/lint/LintStats;", "findRuleJars", "", "project", "getBaselineCreationMessage", "getCacheDir", "name", "create", "getClassPath", "getClientProperty", "T", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "getClientRevision", "getDisplayPath", "file", "fullPath", "format", "Lcom/android/tools/lint/detector/api/TextFormat;", "getGradleVisitor", "Lcom/android/tools/lint/client/api/GradleVisitor;", "getMergedManifest", "getPartialResults", "issue", "getResourceFolders", "getResources", "Lcom/android/ide/common/resources/ResourceRepository;", "scope", "Lcom/android/tools/lint/client/api/ResourceRepositoryScope;", "getRootDir", "getSerializationFile", "xmlType", "Lcom/android/tools/lint/XmlFileType;", "getSourceText", "getUastParser", "Lcom/android/tools/lint/client/api/UastParser;", "getXmlDocument", "contents", "haveErrors", "initialize", "initializeProjects", "isExplicitlyEnabled", "isParentRef", "index", "isSuppressed", "log", "exception", "", "args", "(Lcom/android/tools/lint/detector/api/Severity;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "mayNeedKotlinScripting", "allProjects", "", "mergeIncidents", "definiteMap", "provisionalMap", "mergeOnly", "mergeState", "root", "openConnection", "Ljava/net/URLConnection;", "url", "timeout", "performReporting", "pickBuildTarget", "Lcom/android/sdklib/IAndroidTarget;", "putClientProperty", "value", "readFile", "readStamp", "report", "context", "incident", "constraint", "Lcom/android/tools/lint/detector/api/Constraint;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "reportNonExistingIssueId", "id", "reportingToConsole", "run", "analyze", "Lkotlin/Function0;", "finish", "setSourceText", "text", "sortResults", "storeState", "syncConfigOptions", "validateIssueIds", "ids", "writeConfiguredIssues", "writeIncidents", "type", "incidents", "writeNewBaselineFile", "writeEmptyBaseline", "writePartialResults", "writeReports", "Companion", "LintCliKotlinPerformanceManager", "LintCliUastParser", "lint-cli"})
@SourceDebugExtension(value={"SMAP\nLintCliClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintCliClient.kt\ncom/android/tools/lint/LintCliClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,2011:1\n1#2:2012\n223#3,2:2013\n1238#3,4:2017\n766#3:2021\n857#3,2:2022\n1549#3:2042\n1620#3,3:2043\n1855#3,2:2046\n1747#3,3:2050\n442#4:2015\n392#4:2016\n1415#5,14:2024\n11335#6:2038\n11670#6,3:2039\n37#7,2:2048\n*S KotlinDebug\n*F\n+ 1 LintCliClient.kt\ncom/android/tools/lint/LintCliClient\n*L\n386#1:2013,2\n459#1:2017,4\n1063#1:2021\n1063#1:2022,2\n1669#1:2042\n1669#1:2043,3\n1712#1:2046,2\n1808#1:2050,3\n459#1:2015\n459#1:2016\n1563#1:2024,14\n1652#1:2038\n1652#1:2039,3\n1761#1:2048,2\n*E\n"})
public class LintCliClient
extends LintClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private IssueRegistry registry;
    protected LintDriver driver;
    @NotNull
    private final LintCliFlags flags;
    private boolean validatedIds;
    @Nullable
    private LintCliKotlinPerformanceManager kotlinPerformanceManager;
    @Nullable
    private File jdkHome;
    @Nullable
    private UastEnvironment uastEnvironment;
    private boolean hasErrors;
    private int errorCount;
    private int warningCount;
    @NotNull
    private final List<Incident> definiteIncidents;
    @NotNull
    private final List<Incident> provisionalIncidents;
    @Nullable
    private Map<Issue, PartialResult> partialResults;
    @NotNull
    private HashMap<File, org.w3c.dom.Document> xmlDocuments;
    @NotNull
    private final Map<File, CharSequence> fileContentCache;
    @Nullable
    private Map<Object, Object> clientProperties;
    @Nullable
    private Map<Project, LintClient.ClassPathInfo> projectInfoMap;
    @NotNull
    private static final String LINT_OVERRIDE_CONFIGURATION_ENV_VAR = "LINT_OVERRIDE_CONFIGURATION";
    @NotNull
    private static final String LINT_CONFIGURATION_OVERRIDE_PROP = "lint.configuration.override";

    public LintCliClient(@NotNull String clientName) {
        Intrinsics.checkNotNullParameter((Object)clientName, (String)"clientName");
        super(clientName);
        this.definiteIncidents = new ArrayList();
        this.provisionalIncidents = new ArrayList();
        this.xmlDocuments = new HashMap();
        this.fileContentCache = new HashMap(100);
        this.flags = new LintCliFlags();
        PrintStream printStream = System.out;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
        TextReporter reporter = new TextReporter(this, this.flags, Companion.printWriter(printStream), false);
        this.flags.getReporters().add(reporter);
        this.initialize();
    }

    @Deprecated(message="Specify client explicitly by calling {@link LintCliClient(String)} ")
    public LintCliClient() {
        this("test");
    }

    public LintCliClient(@NotNull LintCliFlags flags, @NotNull String clientName) {
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        Intrinsics.checkNotNullParameter((Object)clientName, (String)"clientName");
        super(clientName);
        this.definiteIncidents = new ArrayList();
        this.provisionalIncidents = new ArrayList();
        this.xmlDocuments = new HashMap();
        this.fileContentCache = new HashMap(100);
        this.flags = flags;
        this.initialize();
    }

    @Nullable
    public IssueRegistry getRegistry() {
        return this.registry;
    }

    protected void setRegistry(@Nullable IssueRegistry issueRegistry) {
        this.registry = issueRegistry;
    }

    @NotNull
    public final LintDriver getDriver() {
        LintDriver lintDriver = this.driver;
        if (lintDriver != null) {
            return lintDriver;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"driver");
        return null;
    }

    protected final void setDriver(@NotNull LintDriver lintDriver) {
        Intrinsics.checkNotNullParameter((Object)lintDriver, (String)"<set-?>");
        this.driver = lintDriver;
    }

    @NotNull
    public final LintCliFlags getFlags() {
        return this.flags;
    }

    protected final boolean getValidatedIds() {
        return this.validatedIds;
    }

    protected final void setValidatedIds(boolean bl) {
        this.validatedIds = bl;
    }

    @Nullable
    public final UastEnvironment getUastEnvironment() {
        return this.uastEnvironment;
    }

    public final void setUastEnvironment(@Nullable UastEnvironment uastEnvironment) {
        this.uastEnvironment = uastEnvironment;
    }

    @Nullable
    public final MockProject getIdeaProject() {
        UastEnvironment uastEnvironment = this.uastEnvironment;
        return uastEnvironment != null ? uastEnvironment.getIdeaProject() : null;
    }

    protected final int getErrorCount() {
        return this.errorCount;
    }

    protected final void setErrorCount(int n) {
        this.errorCount = n;
    }

    protected final int getWarningCount() {
        return this.warningCount;
    }

    protected final void setWarningCount(int n) {
        this.warningCount = n;
    }

    @NotNull
    public final List<Incident> getDefiniteIncidents() {
        return this.definiteIncidents;
    }

    @NotNull
    public final List<Incident> getProvisionalIncidents() {
        return this.provisionalIncidents;
    }

    private final void initialize() {
        this.addGlobalXmlFallbackConfiguration();
    }

    private final void addGlobalXmlFallbackConfiguration() {
        String configuration = System.getenv(LINT_OVERRIDE_CONFIGURATION_ENV_VAR);
        if (configuration == null) {
            configuration = System.getProperty(LINT_CONFIGURATION_OVERRIDE_PROP);
        }
        if (configuration != null) {
            File file = new File(configuration);
            if (file.exists()) {
                LintXmlConfiguration xmlConfiguration = LintXmlConfiguration.Companion.create(this.getConfigurations(), file);
                xmlConfiguration.setDir(null);
                ConfigurationHierarchy.addGlobalConfigurations$default((ConfigurationHierarchy)this.getConfigurations(), (Configuration)((Configuration)xmlConfiguration), null, (int)2, null);
                System.out.println((Object)("Overriding configuration from " + file));
            } else {
                this.log(Severity.ERROR, null, "Configuration override requested but does not exist: " + file, new Object[0]);
            }
        }
    }

    @Nullable
    protected String getBaselineVariantName() {
        if (this.flags.isFatalOnly()) {
            return "fatal";
        }
        Collection projects = this.getDriver().getProjects();
        for (Project project : projects) {
            Object object = project.getBuildVariant();
            if (object == null || (object = object.getName()) == null) continue;
            return object;
        }
        return "all";
    }

    public final int run(@NotNull IssueRegistry registry, @NotNull LintRequest lintRequest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)lintRequest, (String)"lintRequest");
        return this.run(registry, lintRequest, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ LintCliClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getDriver().analyze();
            }
        }), (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ LintCliClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return LintCliClient.access$performReporting(this.this$0);
            }
        }));
    }

    public final int analyzeOnly(@NotNull IssueRegistry registry, @NotNull LintRequest lintRequest) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)lintRequest, (String)"lintRequest");
        boolean bl = this.supportsPartialAnalysis();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return LintCliClient.run$default(this, registry, lintRequest, (Function0)new Function0<Unit>(this){
            final /* synthetic */ LintCliClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getDriver().analyzeOnly();
            }
        }, null, 8, null);
    }

    public final int mergeOnly(@NotNull IssueRegistry registry, @NotNull LintRequest lintRequest) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)lintRequest, (String)"lintRequest");
        this.validatedIds = false;
        return this.run(registry, lintRequest, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ LintCliClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getDriver().mergeOnly();
            }
        }), (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ LintCliClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return LintCliClient.access$performReporting(this.this$0);
            }
        }));
    }

    private final int run(IssueRegistry registry, LintRequest lintRequest, Function0<Unit> analyze, Function0<Integer> finish) {
        int exitCode;
        long startTime = System.currentTimeMillis();
        this.setRegistry(registry);
        String kotlinPerfReport = System.getenv("KOTLIN_PERF_REPORT");
        if (kotlinPerfReport != null && ((CharSequence)kotlinPerfReport).length() > 0) {
            this.kotlinPerformanceManager = new LintCliKotlinPerformanceManager(kotlinPerfReport);
        }
        this.setDriver(this.createDriver(registry, lintRequest));
        this.getDriver().setAnalysisStartTime(startTime);
        this.addCancellationChecker();
        this.validateIssueIds();
        analyze.invoke();
        LintCliKotlinPerformanceManager lintCliKotlinPerformanceManager = this.kotlinPerformanceManager;
        if (lintCliKotlinPerformanceManager != null) {
            lintCliKotlinPerformanceManager.report(lintRequest);
        }
        this.sortResults();
        Collection projects = lintRequest.getProjects();
        if (projects == null) {
            projects = this.getKnownProjects();
        }
        if (!projects.isEmpty()) {
            LintBatchAnalytics analytics = new LintBatchAnalytics();
            analytics.logSession(registry, this.flags, this.getDriver(), projects, this.definiteIncidents);
        }
        if ((exitCode = ((Number)finish.invoke()).intValue()) != 100) {
            return exitCode;
        }
        return this.flags.isSetExitCode() ? (this.hasErrors ? 1 : 0) : 0;
    }

    static /* synthetic */ int run$default(LintCliClient lintCliClient, IssueRegistry issueRegistry, LintRequest lintRequest, Function0 function0, Function0 function02, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: run");
        }
        if ((n & 8) != 0) {
            function02 = run.3.INSTANCE;
        }
        return lintCliClient.run(issueRegistry, lintRequest, (Function0<Unit>)function0, (Function0<Integer>)function02);
    }

    /*
     * WARNING - void declaration
     */
    private final int performReporting() {
        boolean writeBaselineIfMissing;
        File baselineFile;
        boolean statistics;
        LintFixPerformer performer;
        boolean fixed;
        LintBaseline baseline = this.getDriver().getBaseline();
        LintStats stats = LintStats.Companion.create(this.definiteIncidents, baseline);
        this.writeReports(stats);
        if (this.flags.isAutoFix() && (fixed = (performer = new LintFixPerformer(this, statistics = !this.flags.isQuiet(), false, false, 12, null)).fix(this.definiteIncidents)) && this.flags.isAbortOnAutoFix()) {
            String message2 = "One or more issues were fixed in the source code.\nAborting the build since the edits to the source files were performed **after** compilation, so the outputs do not contain the fixes. Re-run the build.";
            System.err.println(message2);
            return 7;
        }
        File file = this.flags.getOutputBaselineFile();
        if (file == null) {
            file = this.flags.getBaselineFile();
        }
        if ((baselineFile = file) != null && baseline != null) {
            this.emitBaselineDiagnostics(baseline, baseline.getFile(), stats);
        }
        File outputBaselineFile = this.flags.getOutputBaselineFile();
        boolean bl = writeBaselineIfMissing = !this.flags.getMissingBaselineIsEmptyBaseline() || this.flags.isUpdateBaseline();
        if (outputBaselineFile != null && baseline != null) {
            baseline.setFile(outputBaselineFile);
            baseline.close();
        } else if (baselineFile != null && !baselineFile.exists() && writeBaselineIfMissing || outputBaselineFile != null && baseline == null) {
            File fileToWrite;
            int exitCode;
            File file2 = outputBaselineFile;
            if (file2 == null) {
                File file3 = baselineFile;
                file2 = file3;
                Intrinsics.checkNotNull((Object)file3);
            }
            if ((exitCode = this.writeNewBaselineFile(stats, fileToWrite = file2, !this.flags.getMissingBaselineIsEmptyBaseline() || outputBaselineFile != null)) != 100) {
                return exitCode;
            }
            if (!this.flags.isUpdateBaseline() && outputBaselineFile == null) {
                System.err.println(this.getBaselineCreationMessage(fileToWrite));
            }
            if (outputBaselineFile == null) {
                if (this.flags.isUpdateBaseline() || !this.flags.isContinueAfterBaselineCreated()) {
                    return 6;
                }
                return 0;
            }
        } else {
            if (baseline != null && baseline.getWriteOnClose() && baseline.getFixedCount() > 0 && this.flags.isRemoveFixedBaselineIssues()) {
                baseline.close();
                return 6;
            }
            if (baseline != null && this.flags.isUpdateBaseline()) {
                if (this.flags.getMissingBaselineIsEmptyBaseline() && this.definiteIncidents.isEmpty()) {
                    Comparable<File> comparable = this.flags.getBaselineFile();
                    if (comparable != null && (comparable = comparable.toPath()) != null) {
                        Comparable<File> it = comparable;
                        boolean bl2 = false;
                        Files.deleteIfExists((Path)it);
                    }
                } else {
                    baseline.close();
                }
                return 6;
            }
        }
        if (this.hasErrors && !this.reportingToConsole() && this.flags.isSetExitCode() && !this.flags.isQuiet()) {
            Object element$iv2;
            TextReporter textReporter;
            LintStats lintStats;
            block19: {
                void $this$first$iv;
                PrintStream printStream = System.out;
                Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
                PrintWriter writer = Companion.printWriter(printStream);
                String count = Lint.describeCounts((int)stats.getErrorCount(), (int)stats.getWarningCount(), (boolean)false, (boolean)false);
                System.out.println((Object)("Lint found " + count + ". First failure:"));
                TextReporter reporter = Reporter.Companion.createTextReporter(this, new LintCliFlags(), null, writer, false);
                reporter.setWriteStats(false);
                Iterable it = this.definiteIncidents;
                lintStats = stats;
                textReporter = reporter;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Incident it2 = (Incident)element$iv2;
                    boolean bl3 = false;
                    if (!it2.getSeverity().isError()) continue;
                    break block19;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object t = element$iv2;
            textReporter.write(lintStats, CollectionsKt.listOf(t), this.getDriver().getRegistry());
        }
        return this.flags.isSetExitCode() ? (this.hasErrors ? 1 : 0) : 0;
    }

    private final int writeNewBaselineFile(LintStats stats, File file, boolean writeEmptyBaseline) {
        if (writeEmptyBaseline || !((Collection)this.definiteIncidents).isEmpty()) {
            File dir = file.getParentFile();
            if (dir != null && !dir.isDirectory() && !dir.mkdirs()) {
                System.err.println("Couldn't create baseline folder " + dir);
                return 5;
            }
            XmlReporter reporter = Reporter.Companion.createXmlReporter(this, file, XmlFileType.BASELINE);
            reporter.setPathVariables(this.getPathVariables().filter((Function1)new Function1<String, Boolean>((Object)PathVariables.Companion){

                @NotNull
                public final Boolean invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((PathVariables.Companion)this.receiver).isPrivatePathVariable(p0);
                }
            }));
            reporter.setBaselineAttributes(this, this.getBaselineVariantName(), this.flags.isCheckDependencies());
            reporter.write(stats, this.definiteIncidents, this.getDriver().getRegistry());
        } else {
            Files.deleteIfExists(file.toPath());
        }
        return 100;
    }

    protected void sortResults() {
        CollectionsKt.sort(this.definiteIncidents);
    }

    protected void writeReports(@NotNull LintStats stats) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        for (Reporter reporter : this.flags.getReporters()) {
            reporter.write(stats, this.definiteIncidents, this.getDriver().getRegistry());
        }
    }

    public void storeState(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.writeIncidents(project, XmlFileType.INCIDENTS, this.definiteIncidents);
        this.writeIncidents(project, XmlFileType.CONDITIONAL_INCIDENTS, this.provisionalIncidents);
        this.writePartialResults(project);
        this.writeConfiguredIssues(project);
    }

    private final void writeIncidents(Project project, XmlFileType type, List<Incident> incidents) {
        File incidentsFile = this.getSerializationFile(project, type);
        if (incidents.isEmpty()) {
            incidentsFile.delete();
        } else {
            File file = incidentsFile.getParentFile();
            if (file != null) {
                file.mkdirs();
            }
            XmlWriter.writeIncidents$default(new XmlWriter(this, incidentsFile, type), incidents, null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writePartialResults(Project project) {
        XmlFileType type = XmlFileType.PARTIAL_RESULTS;
        File partialFile = this.getSerializationFile(project, type);
        Map<Issue, PartialResult> map = this.partialResults;
        if (map != null) {
            void $this$mapValuesTo$iv$iv;
            Map<Issue, PartialResult> map2 = map;
            boolean bl = false;
            File file = partialFile.getParentFile();
            if (file != null) {
                file.mkdirs();
            }
            Map<Issue, PartialResult> $this$mapValues$iv = map2;
            boolean $i$f$mapValues = false;
            Map<Issue, PartialResult> map3 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map5 = map4;
                boolean bl3 = false;
                LintMap lintMap = ((PartialResult)it.getValue()).mapFor(project);
                map5.put(k, lintMap);
            }
            Map resultMap = destination$iv$iv;
            new XmlWriter(this, partialFile, type).writePartialResults(resultMap, project);
        } else {
            partialFile.delete();
        }
    }

    private final void writeConfiguredIssues(Project project) {
        XmlFileType type = XmlFileType.CONFIGURED_ISSUES;
        Configuration projectConfiguration = ConfigurationHierarchy.getConfigurationForProject$default((ConfigurationHierarchy)this.getConfigurations(), (Project)project, null, (int)2, null);
        Map issues = projectConfiguration.getConfiguredIssues(this.getDriver().getRegistry(), true);
        File issuesFile = this.getSerializationFile(project, type);
        if (issues.isEmpty()) {
            issuesFile.delete();
        } else {
            File file = issuesFile.getParentFile();
            if (file != null) {
                file.mkdirs();
            }
            new XmlWriter(this, issuesFile, type).writeConfiguredIssues(issues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeState(@NotNull Project root, @NotNull LintDriver driver) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        HashSet<Project> projects = new HashSet<Project>();
        Map dependentsMap = new HashMap();
        projects.add(root);
        if (driver.getCheckDependencies()) {
            for (Project dependency : root.getAllLibraries()) {
                if (dependency.isExternalLibrary()) continue;
                List list2 = (List)dependentsMap.get(dependency);
                if (list2 == null) {
                    var9_8 = new ArrayList();
                    ArrayList arrayList = var9_8;
                    bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"dependency");
                    dependentsMap.put(dependency, arrayList);
                    list2 = (List)((Object)var9_8);
                }
                dependents = list2;
                dependents.add(root);
                projects.add(dependency);
            }
        } else {
            for (Project dependency : root.getAllLibraries()) {
                if (dependency.getType() != LintModelModuleType.DYNAMIC_FEATURE) continue;
                List list3 = (List)dependentsMap.get(dependency);
                if (list3 == null) {
                    Iterator iterator = var9_8 = new ArrayList();
                    bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"dependency");
                    dependentsMap.put(dependency, iterator);
                    list3 = (List)((Object)var9_8);
                }
                dependents = list3;
                dependents.add(root);
                projects.add(dependency);
            }
        }
        HashMap definiteMap = new HashMap();
        HashMap provisionalMap = new HashMap();
        HashMap dataMap = new HashMap();
        Map issueMap = new HashMap();
        for (Project project : projects) {
            File issuesFile;
            boolean bl;
            HashMap it;
            HashMap hashMap;
            File partialFile;
            File definite;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            driver.computeDetectors(project);
            IssueRegistry registry = driver.getRegistry();
            File conditional = this.getSerializationFile(project, XmlFileType.CONDITIONAL_INCIDENTS);
            if (conditional.isFile()) {
                ((Map)provisionalMap).put(project, new XmlReader(this, registry, project, conditional).getIncidents());
            }
            if ((definite = this.getSerializationFile(project, XmlFileType.INCIDENTS)).isFile()) {
                ((Map)definiteMap).put(project, new XmlReader(this, registry, project, definite).getIncidents());
            }
            if ((partialFile = this.getSerializationFile(project, XmlFileType.PARTIAL_RESULTS)).isFile()) {
                Map<Issue, LintMap> partial = new XmlReader(this, registry, project, partialFile).getPartialResults();
                for (Map.Entry<Issue, LintMap> entry : partial.entrySet()) {
                    Object issue = entry.getKey();
                    LintMap list4 = entry.getValue();
                    Map map = (Map)dataMap.get(issue);
                    if (map == null) {
                        it = hashMap = new HashMap();
                        bl = false;
                        ((Map)dataMap).put(issue, it);
                        map = hashMap;
                    }
                    Map projectMap = map;
                    projectMap.put(project, list4);
                }
            }
            if (!(issuesFile = this.getSerializationFile(project, XmlFileType.CONFIGURED_ISSUES)).isFile()) continue;
            Map<String, Severity> issues = new XmlReader(this, registry, project, issuesFile).getConfiguredIssues();
            for (Object issue : issues.entrySet()) {
                String issue2 = (String)issue.getKey();
                Severity severity = (Severity)issue.getValue();
                Map map = (Map)issueMap.get(project);
                if (map == null) {
                    it = hashMap = new HashMap();
                    bl = false;
                    issueMap.put(project, it);
                    map = hashMap;
                }
                Map projectMap = map;
                projectMap.put(issue2, severity);
            }
        }
        for (Map.Entry entry : dependentsMap.entrySet()) {
            Project library = (Project)entry.getKey();
            List dependents = (List)entry.getValue();
            Configuration libraryConfig = library.getConfiguration(driver);
            ConfigurationHierarchy configurationHierarchy = this.getConfigurations();
            Intrinsics.checkNotNullExpressionValue((Object)libraryConfig, (String)"libraryConfig");
            Configuration libraryConfigLeaf = configurationHierarchy.getScopeLeaf(libraryConfig);
            Configuration libraryConfigPrevParent = libraryConfigLeaf.getParent();
            try {
                for (Project project : dependents) {
                    Configuration mainConfig = project.getConfiguration(driver);
                    if (mainConfig != libraryConfigLeaf) {
                        Intrinsics.checkNotNullExpressionValue((Object)mainConfig, (String)"mainConfig");
                        libraryConfigLeaf.setParent(mainConfig);
                    }
                    File file = project.getDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"main.dir");
                    Context mainContext = new Context(driver, project, project, file, null, 16, null);
                    this.mergeIncidents(library, project, mainContext, definiteMap, provisionalMap);
                    Map map = (Map)issueMap.get(library);
                    if (map == null) {
                        map = MapsKt.emptyMap();
                    }
                    Map libraryIssues = map;
                    this.checkConfigured(library, libraryIssues, project, mainContext);
                }
            }
            finally {
                this.getConfigurations().setParent(libraryConfigLeaf, libraryConfigPrevParent);
            }
        }
        if (!dependentsMap.containsKey(root)) {
            File file = root.getDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"root.dir");
            Context rootContext = new Context(driver, root, root, file, null, 16, null);
            this.mergeIncidents(root, root, rootContext, definiteMap, provisionalMap);
            if (!((Map)dataMap).isEmpty()) {
                HashMap hashMap = new HashMap();
                for (Map.Entry entry : dataMap.entrySet()) {
                    Intrinsics.checkNotNullExpressionValue(entry, (String)"dataMap.entries");
                    Issue issue = (Issue)entry.getKey();
                    Map map = (Map)entry.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)issue, (String)"issue");
                    Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
                    PartialResult results = PartialResult.Companion.withRequestedProject(new PartialResult(issue, map), root);
                    Detector detector = (Detector)hashMap.get(issue);
                    if (detector == null) {
                        Object t = issue.getImplementation().getDetectorClass().newInstance();
                        Detector it = (Detector)t;
                        boolean bl = false;
                        Map map2 = hashMap;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        map2.put(issue, it);
                        detector = (Detector)t;
                    }
                    Detector detector2 = detector;
                    detector2.checkPartialResults(rootContext, results);
                }
            }
            driver.processMergedProjects(rootContext);
        }
    }

    private final void checkConfigured(Project library, Map<String, ? extends Severity> libraryConfigured, Project main, Context mainContext) {
        IssueRegistry issueRegistry = this.getRegistry();
        Intrinsics.checkNotNull((Object)issueRegistry);
        IssueRegistry registry = issueRegistry;
        Configuration mainConfiguration = main.getConfiguration(this.getDriver());
        Map mainConfigured = mainConfiguration.getConfiguredIssues(registry, true);
        for (Map.Entry entry : mainConfigured.entrySet()) {
            Location location;
            String issue = (String)entry.getKey();
            Severity severity = (Severity)entry.getValue();
            if (severity == Severity.IGNORE) continue;
            Severity librarySeverity = libraryConfigured.get(issue);
            if (librarySeverity != Severity.IGNORE) {
                if (librarySeverity != null) continue;
                Issue issue2 = registry.getIssue(issue);
                boolean bl = issue2 != null ? !issue2.isEnabledByDefault() : false;
                if (!bl) continue;
            }
            if ((location = mainConfiguration.getIssueConfigLocation(issue, true, true)) == null) {
                File file = main.getDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"main.dir");
                location = Location.Companion.create(file);
            }
            Location location2 = location;
            String appSeverity = severity.toName();
            mainContext.report(new Incident(IssueRegistry.CANNOT_ENABLE_HIDDEN, location2, "Issue `" + issue + "` was configured with severity `" + appSeverity + "` in " + main.getName() + ", but was not enabled (or was disabled) in library " + library.getName()));
        }
    }

    @JvmSuppressWildcards
    protected void mergeIncidents(@NotNull Project library, @NotNull Project main, @NotNull Context mainContext, @NotNull Map<Project, List<Incident>> definiteMap, @NotNull Map<Project, List<Incident>> provisionalMap) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)main, (String)"main");
        Intrinsics.checkNotNullParameter((Object)mainContext, (String)"mainContext");
        Intrinsics.checkNotNullParameter(definiteMap, (String)"definiteMap");
        Intrinsics.checkNotNullParameter(provisionalMap, (String)"provisionalMap");
        LintDriver lintDriver = this.getDriver();
        File file = main.getDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"main.dir");
        Context projectContext = new Context(lintDriver, library, main, file, null, 16, null);
        List<Incident> definite = definiteMap.get(library);
        if (definite != null) {
            for (Incident incident : definite) {
                projectContext.report(incident);
            }
        }
        if ((list2 = provisionalMap.get(library)) == null) {
            list2 = CollectionsKt.emptyList();
        }
        List provisional = list2;
        this.getDriver().mergeConditionalIncidents(projectContext, provisional);
    }

    @NotNull
    public File getSerializationFile(@NotNull Project project, @NotNull XmlFileType xmlType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)xmlType), (String)"xmlType");
        LintModelVariant variant = project.getBuildVariant();
        Object object2 = variant;
        if (object2 == null || (object2 = object2.getPartialResultsDir()) == null) {
            LintModelVariant lintModelVariant = variant;
            object2 = lintModelVariant != null && (lintModelVariant = lintModelVariant.getModule()) != null ? lintModelVariant.getBuildFolder() : project.getPartialResultsDir();
        }
        Object dir = (object = object2) == null ? new File(project.getDir(), "build") : object;
        Object object3 = variant;
        if (object3 == null || (object3 = object3.getName()) == null) {
            object3 = "all";
        }
        Object variantName = object3;
        return new File((File)dir, xmlType.getDefaultFileName((String)variantName));
    }

    private final String getBaselineCreationMessage(File baselineFile) {
        String summary = "Created baseline file " + baselineFile;
        if (this.continueAfterBaselineCreated()) {
            return summary;
        }
        String gradlePostScript = LintClient.Companion.isGradle() ? "\n            |You can run lint with -Dlint.baselines.continue=true\n            |if you want to create many missing baselines in one go.\n            " : "";
        return StringsKt.trimMargin$default((String)("\n            |" + summary + "\n            |\n            |Also breaking the build in case this was not intentional. If you\n            |deliberately created the baseline file, re-run the build and this\n            |time it should succeed without warnings.\n            |\n            |If not, investigate the baseline path in the lintOptions config\n            |or verify that the baseline file has been checked into version\n            |control.\n            |" + gradlePostScript + "\n            "), null, (int)1, null);
    }

    private final void emitBaselineDiagnostics(LintBaseline baseline, File baselineFile, LintStats stats) {
        boolean hasConsoleOutput = false;
        for (Reporter reporter : this.flags.getReporters()) {
            if (!(reporter instanceof TextReporter) || !reporter.isWriteToConsole()) continue;
            hasConsoleOutput = true;
            break;
        }
        if (!this.flags.isQuiet() && !hasConsoleOutput) {
            Boolean bl;
            Object count;
            if (stats.getBaselineErrorCount() > 0 || stats.getBaselineWarningCount() > 0) {
                if (this.errorCount == 0 && this.warningCount == 1) {
                    System.out.print((Object)"Lint found no new issues");
                } else {
                    count = Lint.describeCounts((int)this.errorCount, (int)Math.max(0, this.warningCount - 1), (boolean)true, (boolean)false);
                    System.out.print((Object)("Lint found " + (String)count));
                    if (stats.getAutoFixedCount() > 0) {
                        System.out.print((Object)(" (" + stats.getAutoFixedCount() + " of these were automatically fixed)"));
                    }
                }
                count = Lint.describeCounts((int)stats.getBaselineErrorCount(), (int)stats.getBaselineWarningCount(), (boolean)false, (boolean)true);
                System.out.print((Object)(" (" + (String)count + " filtered by baseline " + baselineFile.getName() + ")"));
            } else {
                count = Lint.describeCounts((int)this.errorCount, (int)this.warningCount, (boolean)true, (boolean)false);
                System.out.print((Object)("Lint found " + (String)count));
            }
            System.out.println();
            if (stats.getBaselineFixedCount() > 0) {
                count = "\n" + stats.getBaselineFixedCount() + " errors/warnings were listed in the baseline file (" + baselineFile + ") but not found in the project; perhaps they have been fixed?";
                System.out.println(count);
            }
            String checkVariant = this.getBaselineVariantName();
            String creationVariant = baseline.getAttribute("variant");
            if (creationVariant != null && !Intrinsics.areEqual((Object)creationVariant, (Object)checkVariant)) {
                Object object = "\nNote: The baseline was created using a different target/variant than it was checked against.";
                System.out.println(object);
                System.out.println((Object)("Creation variant: " + Companion.getTargetName(creationVariant)));
                String string = checkVariant;
                object = "Current variant: " + (string != null ? Companion.getTargetName(string) : "none");
                System.out.println(object);
            }
            String string = baseline.getAttribute("dependencies");
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                bl = Intrinsics.areEqual((Object)it, (Object)"true");
            } else {
                bl = null;
            }
            Boolean baselineTransitive = bl;
            boolean transitive = this.flags.isCheckDependencies();
            if (baselineTransitive != null && !Intrinsics.areEqual((Object)baselineTransitive, (Object)transitive)) {
                System.out.println((Object)("\nNote: The baseline was created using `includeDependencies=" + baselineTransitive + "`,"));
                System.out.println((Object)("but lint is currently running with `includeDependencies=" + transitive + "`."));
                if (transitive) {
                    System.out.println((Object)"This means that any incidents found in the dependencies are not included");
                    System.out.println((Object)"in the baseline and will be reported as new incidents.");
                } else {
                    System.out.println((Object)"This means that any incidents listed in the baseline from dependencies");
                    System.out.println((Object)"are not included in the current analysis, so lint will consider them");
                    System.out.println((Object)"\"fixed\" when comparing with the baseline.");
                }
            }
            if (stats.getBaselineFixedCount() > 0) {
                String checkVersion = this.getClientDisplayRevision();
                String checkClient = LintClient.Companion.getClientName();
                String creationVersion = baseline.getAttribute("version");
                String creationClient = baseline.getAttribute("client");
                if (Intrinsics.areEqual((Object)checkClient, (Object)creationClient) && creationVersion != null && checkVersion != null && !Intrinsics.areEqual((Object)creationVersion, (Object)checkVersion)) {
                    GradleVersion created = GradleVersion.tryParse((String)creationVersion);
                    GradleVersion current = GradleVersion.tryParse((String)checkVersion);
                    if (created != null && current != null && created.compareTo(current) > 0) {
                        String string2 = StringsKt.trimIndent((String)("\n                            Note: The baseline was created with a newer version of " + checkClient + " (" + creationVersion + ") than the current version (" + checkVersion + ")\n                            This means that some of the issues marked as fixed in the baseline may not actually be fixed, but may\n                            be new issues uncovered by the more recent version of lint.\n                            "));
                        System.out.println((Object)string2);
                    }
                }
            }
        }
    }

    protected final void validateIssueIds() {
        this.getDriver().addLintListener(new LintListener(this){
            final /* synthetic */ LintCliClient this$0;
            {
                this.this$0 = $receiver;
            }

            public void update(@NotNull LintDriver driver, @NotNull LintListener.EventType type, @Nullable Project project, @Nullable Context context) {
                Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                if (!(this.this$0.getValidatedIds() || type != LintListener.EventType.SCANNING_PROJECT && type != LintListener.EventType.MERGING)) {
                    LintCliClient.access$validateIssueIds(this.this$0, project);
                }
            }
        });
    }

    @NotNull
    protected LintDriver createDriver(@NotNull IssueRegistry registry, @NotNull LintRequest request) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.setRegistry(registry);
        LintDriver driver = new LintDriver(registry, (LintClient)this, request);
        driver.setAbbreviating(!this.flags.isShowEverything());
        driver.setCheckTestSources(this.flags.isCheckTestSources());
        driver.setIgnoreTestSources(this.flags.isIgnoreTestSources());
        driver.setIgnoreTestFixturesSources(this.flags.isIgnoreTestFixturesSources());
        driver.setCheckGeneratedSources(this.flags.isCheckGeneratedSources());
        driver.setFatalOnlyMode(this.flags.isFatalOnly());
        driver.setCheckDependencies(this.flags.isCheckDependencies());
        driver.setAllowSuppress(this.flags.getAllowSuppress());
        driver.setAllowBaselineSuppress(this.flags.getAllowBaselineSuppress());
        driver.setSkipAnnotations(this.flags.getSkipAnnotations());
        File baselineFile = this.flags.getBaselineFile();
        if (baselineFile != null) {
            LintBaseline baseline = new LintBaseline((LintClient)this, baselineFile);
            driver.setBaseline(baseline);
            if (this.flags.isRemoveFixedBaselineIssues()) {
                baseline.setWriteOnClose(true);
                baseline.setRemoveFixed(true);
            } else if (this.flags.isUpdateBaseline()) {
                baseline.setWriteOnClose(true);
            }
        }
        this.setDriver(driver);
        return driver;
    }

    protected void addCancellationChecker() {
        this.getDriver().addLintListener(new LintListener(){

            public void update(@NotNull LintDriver driver, @NotNull LintListener.EventType type, @Nullable Project project, @Nullable Context context) {
                Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
            }
        });
    }

    @NotNull
    protected LintRequest createLintRequest(@NotNull List<? extends File> files) {
        LintRequest lintRequest;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        LintRequest it = lintRequest = new LintRequest((LintClient)this, files);
        boolean bl = false;
        this.configureLintRequest(it);
        return lintRequest;
    }

    protected void configureLintRequest(@NotNull LintRequest lintRequest) {
        Intrinsics.checkNotNullParameter((Object)lintRequest, (String)"lintRequest");
    }

    public void log(@NotNull Severity severity, @Nullable Throwable exception, @Nullable String format, Object ... args) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            System.out.flush();
            if (format != null) {
                Object[] objectArray = Arrays.copyOf(args, args.length);
                String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                System.err.println(string);
            }
            Throwable throwable = exception;
            if (throwable == null) break block1;
            throwable.printStackTrace();
        }
    }

    @NotNull
    public XmlParser getXmlParser() {
        return new LintCliXmlParser(this);
    }

    @Nullable
    public org.w3c.dom.Document getXmlDocument(@NotNull File file, @Nullable CharSequence contents) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        org.w3c.dom.Document document = this.xmlDocuments.get(file);
        if (document == null) {
            org.w3c.dom.Document document2 = super.getXmlDocument(file, contents);
            if (document2 != null) {
                org.w3c.dom.Document document3;
                org.w3c.dom.Document it = document3 = document2;
                boolean bl = false;
                ((Map)this.xmlDocuments).put(file, it);
                document = document3;
            } else {
                document = null;
            }
        }
        return document;
    }

    @NotNull
    public ResourceRepository getResources(@NotNull Project project, @NotNull ResourceRepositoryScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return LintResourceRepository.Companion.get(this, project, scope);
    }

    @NotNull
    public final CharSequence getSourceText(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CharSequence charSequence = this.fileContentCache.computeIfAbsent(file, new Function(this, file){
            final /* synthetic */ LintCliClient this$0;
            final /* synthetic */ File $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
            }

            @NotNull
            public final CharSequence apply(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.readFile(this.$file);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"fun getSourceText(file: \u2026e) { readFile(file) }\n  }");
        return charSequence;
    }

    public final void setSourceText(@NotNull File file, @Nullable CharSequence text) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            CharSequence charSequence = text;
            if (charSequence == null) break block0;
            CharSequence it = charSequence;
            boolean bl = false;
            this.fileContentCache.put(file, it);
        }
    }

    public void putClientProperty(@NotNull Object key, @Nullable Object value) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map map2 = this.clientProperties;
        if (map2 == null) {
            HashMap hashMap;
            HashMap it = hashMap = new HashMap();
            boolean bl = false;
            this.clientProperties = it;
            map2 = map = (Map)hashMap;
        }
        if (value != null) {
            map.put((Object)key, (Object)value);
        } else {
            map.remove(key);
        }
    }

    @Nullable
    public <T> T getClientProperty(@NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<Object, Object> map = this.clientProperties;
        Object object = map != null ? map.get(key) : null;
        if (object == null) {
            object = null;
        }
        return (T)object;
    }

    @NotNull
    public UastParser getUastParser(@Nullable Project project) {
        return (UastParser)new LintCliUastParser(project);
    }

    @NotNull
    public GradleVisitor getGradleVisitor() {
        return new GroovyGradleVisitor();
    }

    public void report(@NotNull Context context, @NotNull Incident incident, @NotNull TextFormat format) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.countIncident(incident.getSeverity());
        incident.setMessage(format.convertTo(incident.getMessage(), TextFormat.RAW));
        incident.setProject(context.getProject());
        Location location = incident.getLocation();
        if (context.file == location.getFile()) {
            Position position = location.getStart();
            if ((position != null ? position.getLine() : -1) >= 0) {
                this.setSourceText(context.file, context.getContents());
            }
        }
        this.definiteIncidents.add(incident);
    }

    private final void countIncident(Severity severity) {
        if (severity.isError()) {
            this.hasErrors = true;
            int n = this.errorCount;
            this.errorCount = n + 1;
        } else if (severity == Severity.WARNING) {
            int n = this.warningCount;
            this.warningCount = n + 1;
        }
    }

    public void report(@NotNull Context context, @NotNull Incident incident, @NotNull Constraint constraint) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        if (this.getDriver().getMode() == LintDriver.DriverMode.MERGE) {
            if (constraint.accept(context, incident)) {
                context.report(incident);
            }
        } else {
            incident.setClientProperties(new LintMap().put("_condition_", constraint));
            this.provisionalIncidents.add(incident);
        }
    }

    public void report(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        if (this.getDriver().getMode() == LintDriver.DriverMode.MERGE) {
            Pair pair = Context.Companion.findCallingDetector(this.getDriver());
            if (pair == null) {
                throw new IllegalStateException("Unexpected call to report(Incident, LintMap) during the merge phase".toString());
            }
            Pair pair2 = pair;
            String detector = (String)pair2.component1();
            List issues = (List)pair2.component2();
            StringBuilder stack = new StringBuilder();
            LintDriver.Companion.appendStackTraceSummary((Throwable)new RuntimeException(), stack, 1, 20);
            String message2 = StringsKt.trimIndent((String)("\n                The lint detector\n                    `" + detector + "`\n                called `report(Incident, LintMap)` during the merge phase.\n\n                This does not work correctly; this is already the merge phase, so storing\n                data for later processing is pointless and probably not what was intended.\n\n                " + CollectionsKt.joinToString$default((Iterable)issues, (CharSequence)",", null, null, (int)0, null, (Function1)report.message.1.INSTANCE, (int)30, null) + "\n                ")) + "\nCall stack: " + stack;
            LintClient.Companion companion = LintClient.Companion;
            LintClient lintClient = this.getDriver().getClient();
            Issue issue = IssueRegistry.LINT_ERROR;
            Location location = Location.Companion.create(incident.getFile());
            Project project = incident.getProject();
            LintDriver lintDriver = this.getDriver();
            LintClient.Companion.report$default((LintClient.Companion)companion, (LintClient)lintClient, (Issue)issue, (String)message2, null, null, null, null, null, null, (Project)project, null, (LintDriver)lintDriver, (Location)location, (int)1528, null);
        }
        incident.setClientProperties(map);
        this.provisionalIncidents.add(incident);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PartialResult getPartialResults(@NotNull Project project, @NotNull Issue issue) {
        Map partialResults;
        PartialResult partialResult;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Map map = this.partialResults;
        if (map == null) {
            LintCliClient $this$getPartialResults_u24lambda_u2418 = this;
            boolean bl = false;
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            LinkedHashMap it = linkedHashMap;
            boolean bl2 = false;
            $this$getPartialResults_u24lambda_u2418.partialResults = it;
            LinkedHashMap partialResults2 = linkedHashMap;
            if (!$this$getPartialResults_u24lambda_u2418.getDriver().isGlobalAnalysis()) {
                void $this$filterTo$iv$iv;
                List list2 = project.getAllLibraries();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"project.allLibraries");
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Project it2 = (Project)element$iv$iv;
                    boolean bl3 = false;
                    if (!(!it2.isExternalLibrary())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Project dep : (List)destination$iv$iv) {
                    Intrinsics.checkNotNullExpressionValue((Object)dep, (String)"dep");
                    File file = $this$getPartialResults_u24lambda_u2418.getSerializationFile(dep, XmlFileType.PARTIAL_RESULTS);
                    if (!file.isFile()) continue;
                    XmlReader reader = new XmlReader($this$getPartialResults_u24lambda_u2418, $this$getPartialResults_u24lambda_u2418.getDriver().getRegistry(), project, file);
                    Map<Issue, LintMap> results = reader.getPartialResults();
                    for (Map.Entry<Issue, LintMap> entry : results.entrySet()) {
                        PartialResult partialResult2;
                        Issue loadedIssue = entry.getKey();
                        LintMap map2 = entry.getValue();
                        PartialResult partialResult3 = (PartialResult)partialResults2.get(loadedIssue);
                        if (partialResult3 == null) {
                            PartialResult partialResult4;
                            LintCliClient $this$getPartialResults_u24lambda_u2418_u24lambda_u2417 = $this$getPartialResults_u24lambda_u2418;
                            boolean bl4 = false;
                            LinkedHashMap newMap = new LinkedHashMap();
                            ((Map)newMap).put(dep, new LintMap());
                            PartialResult it3 = partialResult4 = new PartialResult(loadedIssue, (Map)newMap);
                            boolean bl5 = false;
                            ((Map)partialResults2).put(loadedIssue, it3);
                            partialResult2 = partialResult4;
                        } else {
                            partialResult2 = partialResult3;
                        }
                        PartialResult target = partialResult2;
                        LintMap targetMap = target.mapFor(dep);
                        targetMap.putAll(map2);
                    }
                }
            }
            map = partialResults2;
        }
        if ((partialResult = (partialResults = map).get(issue)) == null) {
            PartialResult partialResult5;
            LintCliClient $this$getPartialResults_u24lambda_u2420 = this;
            boolean bl = false;
            LinkedHashMap map3 = new LinkedHashMap();
            LintMap lintMap = new LintMap();
            ((Map)map3).put(project, lintMap);
            PartialResult it = partialResult5 = new PartialResult(issue, (Map)map3);
            boolean bl6 = false;
            partialResults.put(issue, it);
            partialResult = partialResult5;
        }
        PartialResult partialResult6 = partialResult;
        return PartialResult.Companion.withRequestedProject(partialResult6, project);
    }

    @NotNull
    public CharSequence readFile(@NotNull File file) {
        Document document;
        VirtualFile vFile;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            charSequence = Lint.getEncodedString((LintClient)this, (File)file, (boolean)false);
        }
        catch (IOException e) {
            charSequence = "";
        }
        CharSequence contents = charSequence;
        String path = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        if ((StringsKt.endsWith$default((String)path, (String)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".kt", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".kts", (boolean)false, (int)2, null)) && CharSequences.indexOf((CharSequence)contents, (char)'\r') != -1 && (vFile = StandardFileSystems.local().findFileByPath(path)) != null && (document = FileDocumentManager.getInstance().getDocument(vFile)) != null) {
            String string = document.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.text");
            return string;
        }
        return contents;
    }

    public final boolean isCheckingSpecificIssues() {
        return this.flags.getExactCheckedIds() != null;
    }

    @NotNull
    protected LintClient.ClassPathInfo getClassPath(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LintClient.ClassPathInfo classPath = super.getClassPath(project);
        List sources = this.flags.getSourcesOverride();
        List classes = this.flags.getClassesOverride();
        List libraries = this.flags.getLibrariesOverride();
        if (classes == null && sources == null && libraries == null) {
            return classPath;
        }
        LintClient.ClassPathInfo classPathInfo = this.projectInfoMap;
        if (classPathInfo == null || (classPathInfo = classPathInfo.get(project)) == null) {
            List list2;
            List list3;
            LintCliClient $this$getClassPath_u24lambda_u2422 = this;
            boolean bl = false;
            List list4 = sources;
            if (list4 == null) {
                list4 = classPath.getSourceFolders();
            }
            if ((list3 = classes) == null) {
                list3 = classPath.getClassFolders();
            }
            if ((list2 = libraries) == null) {
                list2 = classPath.getLibraries(true);
            }
            LintClient.ClassPathInfo info = new LintClient.ClassPathInfo(list4, list3, list2, classPath.getLibraries(false), classPath.getTestSourceFolders(), classPath.getTestLibraries(), classPath.getGeneratedFolders());
            Map map = $this$getClassPath_u24lambda_u2422.projectInfoMap;
            if (map == null) {
                LintCliClient $this$getClassPath_u24lambda_u2422_u24lambda_u2421 = $this$getClassPath_u24lambda_u2422;
                boolean bl2 = false;
                HashMap hashMap = new HashMap();
                $this$getClassPath_u24lambda_u2422_u24lambda_u2421.projectInfoMap = hashMap;
                map = hashMap;
            }
            Map map2 = map;
            map2.put((Project)project, (LintClient.ClassPathInfo)info);
            classPathInfo = info;
        }
        return classPathInfo;
    }

    @NotNull
    public Iterable<File> findRuleJars(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<File> list2 = this.flags.getLintRuleJarsOverride();
        return list2 == null ? super.findRuleJars(project) : (Iterable)list2;
    }

    @NotNull
    public List<File> getResourceFolders(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<File> list2 = this.flags.getResourcesOverride();
        if (list2 == null) {
            return super.getResourceFolders(project);
        }
        return list2;
    }

    @NotNull
    protected Project createProject(@NotNull File dir, @NotNull File referenceDir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)referenceDir, (String)"referenceDir");
        Project project = super.createProject(dir, referenceDir);
        String compileSdkVersion = this.flags.getCompileSdkVersionOverride();
        if (compileSdkVersion != null) {
            project.setBuildTargetHash(compileSdkVersion);
        }
        project.setIdeaProject((com.intellij.openapi.project.Project)this.getIdeaProject());
        return project;
    }

    private final void validateIssueIds(Project project) {
        if (this.driver != null) {
            IssueRegistry registry = this.getDriver().getRegistry();
            if (!registry.isIssueId(HardcodedValuesDetector.ISSUE.getId())) {
                return;
            }
            this.validatedIds = true;
            if (this.getDriver().getMode() != LintDriver.DriverMode.ANALYSIS_ONLY) {
                Configuration override;
                Configuration configuration = override = this.getConfigurations().getOverrides();
                if (configuration != null) {
                    configuration.validateIssueIds((LintClient)this, this.getDriver(), project, registry);
                }
            }
            if (project != null && this.getDriver().getMode() != LintDriver.DriverMode.MERGE) {
                Configuration configuration = project.getConfiguration(this.getDriver());
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.getConfiguration(driver)");
                Configuration configuration2 = configuration;
                configuration2.validateIssueIds((LintClient)this, this.getDriver(), project, registry);
            }
        }
    }

    private final void validateIssueIds(Project project, IssueRegistry registry, Collection<String> ids, File file) {
        if (ids != null) {
            for (String id : ids) {
                if (registry.getIssue(id) != null) continue;
                this.reportNonExistingIssueId(project, registry, id, file);
            }
        }
    }

    static /* synthetic */ void validateIssueIds$default(LintCliClient lintCliClient, Project project, IssueRegistry issueRegistry, Collection collection, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: validateIssueIds");
        }
        if ((n & 8) != 0) {
            file = null;
        }
        lintCliClient.validateIssueIds(project, issueRegistry, collection, file);
    }

    private final void reportNonExistingIssueId(Project project, IssueRegistry registry, String id, File file) {
        if (IssueRegistry.Companion.isDeletedIssueId(id)) {
            return;
        }
        if (JarFileIssueRegistry.Factory.isRejectedIssueId(id)) {
            return;
        }
        String message2 = Configuration.Companion.getUnknownIssueIdErrorMessage(id, registry);
        if (this.driver != null && project != null && !this.isSuppressed(IssueRegistry.UNKNOWN_ISSUE_ID)) {
            Location location;
            if (file != null) {
                location = Lint.guessGradleLocationForFile((LintClient)this, (File)file, (String)id);
            } else {
                LintClient lintClient = this;
                File file2 = project.getDir();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.dir");
                location = Lint.guessGradleLocation((LintClient)lintClient, (File)file2, (String)id);
            }
            Location location2 = location;
            Object[] objectArray = new Object[]{"id", id};
            LintClient.Companion.report((LintClient)this, IssueRegistry.UNKNOWN_ISSUE_ID, message2, this.getDriver(), project, location2, LintFix.Companion.create().data(objectArray));
        } else {
            Object[] objectArray = new Object[]{message2};
            this.log(Severity.WARNING, null, "Lint: %1$s", objectArray);
        }
    }

    static /* synthetic */ void reportNonExistingIssueId$default(LintCliClient lintCliClient, Project project, IssueRegistry issueRegistry, String string, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportNonExistingIssueId");
        }
        if ((n & 8) != 0) {
            file = null;
        }
        lintCliClient.reportNonExistingIssueId(project, issueRegistry, string, file);
    }

    @NotNull
    public String getDisplayPath(@NotNull File file, @Nullable Project project, @NotNull TextFormat format) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        if (project != null) {
            String path = this.getDisplayPath(project, file, false);
            string = TextFormat.TEXT.convertTo(path, format);
        } else {
            string = super.getDisplayPath(file, null, format);
        }
        return string;
    }

    @NotNull
    public final String getDisplayPath(@Nullable Project project, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getDisplayPath(project, file, this.flags.isFullPath());
    }

    @NotNull
    public final String getDisplayPath(@Nullable Project project, @NotNull File file, boolean fullPath) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (project == null) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            return string;
        }
        File referenceDir = project.getReferenceDir();
        Intrinsics.checkNotNullExpressionValue((Object)referenceDir, (String)"referenceDir");
        return this.getDisplayPath(referenceDir, file, fullPath);
    }

    @NotNull
    public final String getDisplayPath(@NotNull File referenceDir, @NotNull File file, boolean fullPath) {
        Intrinsics.checkNotNullParameter((Object)referenceDir, (String)"referenceDir");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String path = file.getPath();
        if (!fullPath) {
            String string = path;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
            String string2 = referenceDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"referenceDir.path");
            if (StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                int chop = referenceDir.getPath().length();
                if (path.length() > chop && path.charAt(chop) == File.separatorChar) {
                    String string3 = path;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"path");
                    String string4 = string3.substring(++chop);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                    String string5 = path = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"path");
                    if (((CharSequence)string5).length() == 0) {
                        path = file.getName();
                    }
                    String string6 = path;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"path");
                    return string6;
                }
                if (path.length() == chop) {
                    String string7 = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"file.name");
                    return string7;
                }
            }
        }
        if (fullPath) {
            File file2 = file.getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file.absoluteFile");
            path = Companion.getCleanPath(file2);
        } else if (file.isAbsolute()) {
            String string = this.getRelativePath(referenceDir, file);
            if (string == null) {
                string = file.getPath();
            }
            String string8 = path = string;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"path");
            if (this.containsEmbeddedParentRef(string8)) {
                String string9 = this.getRelativePath(referenceDir.getCanonicalFile(), file.getCanonicalFile());
                if (string9 == null) {
                    string9 = file.getPath();
                }
                path = string9;
            }
        }
        String string = path;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
        return string;
    }

    private final boolean containsEmbeddedParentRef(String path) {
        int index = 0;
        while (index < path.length()) {
            if (this.isParentRef(path, index)) {
                index += 3;
                continue;
            }
            while (index < path.length()) {
                int next = StringsKt.indexOf$default((CharSequence)path, (String)"..", (int)index, (boolean)false, (int)4, null);
                if (this.isParentRef(path, next)) {
                    return true;
                }
                index += 2;
            }
        }
        return false;
    }

    private final boolean isParentRef(String path, int index) {
        return StringsKt.startsWith$default((String)path, (String)"..", (int)index, (boolean)false, (int)4, null) && (index == path.length() - 2 || path.charAt(index + 2) == '/' || path.charAt(index + 2) == '\\');
    }

    public final boolean isAllEnabled() {
        return this.flags.isCheckAllWarnings();
    }

    public final boolean isSuppressed(@NotNull Issue issue) {
        Category category;
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Set<Category> disabledCategories = this.flags.getDisabledCategories();
        if (disabledCategories != null && (disabledCategories.contains(category = issue.getCategory()) || category.getParent() != null && disabledCategories.contains(category.getParent()))) {
            return true;
        }
        return this.flags.getSuppressedIds().contains(issue.getId());
    }

    public final boolean isExplicitlyEnabled(@NotNull Issue issue) {
        Category category;
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Set<Category> enabledCategories = this.flags.getEnabledCategories();
        if (enabledCategories != null && (enabledCategories.contains(category = issue.getCategory()) || category.getParent() != null && enabledCategories.contains(category.getParent()))) {
            return true;
        }
        return this.flags.getEnabledIds().contains(issue.getId());
    }

    private final boolean mayNeedKotlinScripting(Set<? extends Project> allProjects) {
        if (this.driver != null && !this.getDriver().getScope().contains(Scope.GRADLE_FILE)) {
            return false;
        }
        for (Project project : allProjects) {
            List list2 = project.getSubset();
            if (list2 == null) {
                list2 = project.getGradleBuildScripts();
            }
            List files = list2;
            for (File file : files) {
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                if (!StringsKt.endsWith$default((String)string, (String)".kts", (boolean)false, (int)2, null)) continue;
                return true;
            }
        }
        return false;
    }

    public void initializeProjects(@Nullable LintDriver driver, @NotNull Collection<? extends Project> knownProjects) {
        UastEnvironment uastEnvironment;
        Intrinsics.checkNotNullParameter(knownProjects, (String)"knownProjects");
        LintDriver lintDriver = driver;
        if ((lintDriver != null ? lintDriver.getMode() : null) == LintDriver.DriverMode.MERGE) {
            UastEnvironment env2;
            UastEnvironment.Configuration config = UastEnvironment.Configuration.Companion.create$default(UastEnvironment.Configuration.Companion, false, false, 2, null);
            this.uastEnvironment = env2 = UastEnvironment.Companion.create(config);
            return;
        }
        boolean includeTests = !this.flags.isIgnoreTestSources();
        Set allProjects = Sets.newIdentityHashSet();
        for (Project project : knownProjects) {
            allProjects.add(project);
            List list2 = project.getAllLibraries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"project.allLibraries");
            allProjects.addAll(list2);
        }
        Set sourceRoots = new LinkedHashSet(10);
        Set set = new LinkedHashSet(50);
        for (Object project : allProjects) {
            List list3 = project.getJavaSourceFolders();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"project.javaSourceFolders");
            sourceRoots.addAll(list3);
            if (includeTests) {
                List list4 = project.getTestSourceFolders();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"project.testSourceFolders");
                sourceRoots.addAll(list4);
            }
            List list5 = project.getGeneratedSourceFolders();
            Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"project.generatedSourceFolders");
            sourceRoots.addAll(list5);
            List list6 = project.getJavaLibraries(true);
            Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"project.getJavaLibraries(true)");
            set.addAll(list6);
            if (includeTests) {
                List list7 = project.getTestLibraries();
                Intrinsics.checkNotNullExpressionValue((Object)list7, (String)"project.testLibraries");
                set.addAll(list7);
            }
            if (!this.flags.isIgnoreTestFixturesSources()) {
                List list8 = project.getTestFixturesSourceFolders();
                Intrinsics.checkNotNullExpressionValue((Object)list8, (String)"project.testFixturesSourceFolders");
                sourceRoots.addAll(list8);
                List list9 = project.getTestFixturesLibraries();
                Intrinsics.checkNotNullExpressionValue((Object)list9, (String)"project.testFixturesLibraries");
                set.addAll(list9);
            }
            if (project.isLibrary() || LintClient.Companion.isUnitTest()) {
                List list10 = project.getJavaClassFolders();
                Intrinsics.checkNotNullExpressionValue((Object)list10, (String)"project.javaClassFolders");
                set.addAll(list10);
                continue;
            }
            if (!project.isGradleProject()) continue;
            for (File f : project.getJavaClassFolders()) {
                if (!Intrinsics.areEqual((Object)f.getName(), (Object)"R.jar")) continue;
                Intrinsics.checkNotNullExpressionValue((Object)f, (String)"f");
                set.add(f);
            }
        }
        this.addBootClassPath(knownProjects, set);
        LanguageLevel maxLevel = LanguageLevel.JDK_1_7;
        for (Project project : knownProjects) {
            LanguageLevel level = project.getJavaLanguageLevel();
            if (!maxLevel.isLessThan(level)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level");
            maxLevel = level;
        }
        for (File file : SetsKt.plus((Set)sourceRoots, (Iterable)set)) {
            if (file.isAbsolute()) continue;
            boolean $i$a$-require-LintCliClient$initializeProjects$232 = false;
            String $i$a$-require-LintCliClient$initializeProjects$232 = "Relative Path found: " + file + ". All paths should be absolute.";
            throw new IllegalArgumentException($i$a$-require-LintCliClient$initializeProjects$232.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)allProjects, (String)"allProjects");
        UastEnvironment.Configuration config = UastEnvironment.Configuration.Companion.create(this.mayNeedKotlinScripting(allProjects), this.flags.useK2Uast() || UastEnvironmentKt.useFirUast());
        config.setJavaLanguageLevel(maxLevel);
        config.addSourceRoots(CollectionsKt.toList((Iterable)sourceRoots));
        config.addClasspathRoots(CollectionsKt.toList((Iterable)set));
        config.getKotlinCompilerConfig().putIfNotNull(CLIConfigurationKeys.PERF_MANAGER, (Object)this.kotlinPerformanceManager);
        File file = this.jdkHome;
        if (file != null) {
            File it = file;
            boolean bl = false;
            config.getKotlinCompilerConfig().put(JVMConfigurationKeys.JDK_HOME, (Object)it);
            config.getKotlinCompilerConfig().put(JVMConfigurationKeys.NO_JDK, (Object)false);
        }
        this.uastEnvironment = uastEnvironment = UastEnvironment.Companion.create(config);
        LintCliKotlinPerformanceManager lintCliKotlinPerformanceManager = this.kotlinPerformanceManager;
        if (lintCliKotlinPerformanceManager != null) {
            lintCliKotlinPerformanceManager.notifyCompilerInitialized(-1, -1, "Android Lint");
        }
        for (Project project : allProjects) {
            project.setIdeaProject((com.intellij.openapi.project.Project)uastEnvironment.getIdeaProject());
        }
        super.initializeProjects(driver, knownProjects);
    }

    protected boolean addBootClassPath(@NotNull Collection<? extends Project> knownProjects, @NotNull Set<File> files) {
        File jdkHome;
        Intrinsics.checkNotNullParameter(knownProjects, (String)"knownProjects");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        IAndroidTarget buildTarget = this.pickBuildTarget(knownProjects);
        if (buildTarget != null) {
            File file;
            Path path = buildTarget.getPath(1);
            File file2 = file = path != null ? path.toFile() : null;
            if (file != null) {
                files.add(file);
                return true;
            }
        }
        if ((jdkHome = LintClient.getJdkHome$default((LintClient)this, null, (int)1, null)) != null) {
            boolean isJre = !Lint.isJdkFolder((File)jdkHome);
            List list2 = JavaSdkUtil.getJdkClassesRoots((Path)jdkHome.toPath(), (boolean)isJre);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getJdkClassesRoots(jdkHome.toPath(), isJre)");
            List roots = list2;
            for (Path root : roots) {
                File rootFile = root.toFile();
                if (!rootFile.exists()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)rootFile, (String)"rootFile");
                files.add(rootFile);
            }
            if (!isJre) {
                this.jdkHome = jdkHome;
            }
            return true;
        }
        return false;
    }

    private final IAndroidTarget pickBuildTarget(Collection<? extends Project> knownProjects) {
        Object v0;
        Sequence $this$maxByOrNull$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)knownProjects), (Function1)pickBuildTarget.1.INSTANCE), (Function1)pickBuildTarget.2.INSTANCE);
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                IAndroidTarget it = (IAndroidTarget)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = (Comparable)it.getVersion();
                do {
                    Object e$iv = iterator$iv.next();
                    IAndroidTarget it2 = (IAndroidTarget)e$iv;
                    $i$a$-maxByOrNull-LintCliClient$pickBuildTarget$3 = false;
                    Comparable v$iv = (Comparable)it2.getVersion();
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    public void disposeProjects(@NotNull Collection<? extends Project> knownProjects) {
        Intrinsics.checkNotNullParameter(knownProjects, (String)"knownProjects");
        UastEnvironment uastEnvironment = this.uastEnvironment;
        if (uastEnvironment != null) {
            uastEnvironment.dispose();
        }
        this.uastEnvironment = null;
        super.disposeProjects(knownProjects);
    }

    public final void syncConfigOptions() {
        Boolean applySuggestions;
        File baselineFile;
        Boolean abortOnError;
        Boolean removeFixedBaselineIssues;
        Boolean explainIssues;
        Boolean checkDependencies;
        Boolean checkGeneratedSources;
        Boolean ignoreTestSources;
        Boolean checkTestSources;
        Boolean fatalOnly;
        Boolean warningsAsErrors;
        Boolean ignoreWarnings;
        Sequence configs2 = SequencesKt.generateSequence((Object)this.getConfigurations().getFallback(), (Function1)((Function1)new Function1<Configuration, Configuration>(this){
            final /* synthetic */ LintCliClient this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Configuration invoke(@NotNull Configuration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.getConfigurations().getParentConfiguration(it);
            }
        }));
        LintXmlConfiguration lintXmlConfiguration = (LintXmlConfiguration)SequencesKt.firstOrNull((Sequence)SequencesKt.filterIsInstance((Sequence)configs2, LintXmlConfiguration.class));
        if (lintXmlConfiguration == null) {
            return;
        }
        LintXmlConfiguration config = lintXmlConfiguration;
        Boolean checkAllWarnings = config.getCheckAllWarnings();
        if (checkAllWarnings != null) {
            this.flags.setCheckAllWarnings(checkAllWarnings);
        }
        if ((ignoreWarnings = config.getIgnoreWarnings()) != null) {
            this.flags.setIgnoreWarnings(ignoreWarnings);
        }
        if ((warningsAsErrors = config.getWarningsAsErrors()) != null) {
            this.flags.setWarningsAsErrors(warningsAsErrors);
        }
        if ((fatalOnly = config.getFatalOnly()) != null) {
            this.flags.setFatalOnly(fatalOnly);
        }
        if ((checkTestSources = config.getCheckTestSources()) != null) {
            this.flags.setCheckTestSources(checkTestSources);
        }
        if ((ignoreTestSources = config.getIgnoreTestSources()) != null) {
            this.flags.setIgnoreTestSources(ignoreTestSources);
        }
        if ((checkGeneratedSources = config.getCheckGeneratedSources()) != null) {
            this.flags.setCheckGeneratedSources(checkGeneratedSources);
        }
        if ((checkDependencies = config.getCheckDependencies()) != null) {
            this.flags.setCheckDependencies(checkDependencies);
        }
        if ((explainIssues = config.getExplainIssues()) != null) {
            this.flags.setExplainIssues(explainIssues);
        }
        if ((removeFixedBaselineIssues = config.getRemoveFixedBaselineIssues()) != null) {
            this.flags.setRemovedFixedBaselineIssues(removeFixedBaselineIssues);
        }
        if ((abortOnError = config.getAbortOnError()) != null) {
            this.flags.setSetExitCode(abortOnError);
        }
        if ((baselineFile = config.getBaselineFile()) != null) {
            this.flags.setBaselineFile(Intrinsics.areEqual((Object)baselineFile.getPath(), (Object)"none") ? null : baselineFile);
        }
        if ((applySuggestions = config.getApplySuggestions()) != null && applySuggestions.booleanValue()) {
            this.flags.setAutoFix(true);
        }
    }

    @Nullable
    public final String readStamp() {
        byte[] byArray;
        InputStream stamp = Companion.getClass().getResourceAsStream("/resources/stamp.txt");
        return stamp != null && (byArray = ByteStreamsKt.readBytes((InputStream)stamp)) != null ? ((Object)StringsKt.trim((CharSequence)new String(byArray, Charsets.UTF_8))).toString() : null;
    }

    @NotNull
    public String getClientRevision() {
        String string;
        String stamp;
        String plugin;
        block5: {
            Object object;
            block4: {
                plugin = Version.ANDROID_GRADLE_PLUGIN_VERSION;
                object = this.readStamp();
                if (object == null) break block4;
                String it = object;
                boolean bl = false;
                String string2 = " [" + it + "] ";
                object = string2;
                if (string2 != null) break block5;
            }
            object = stamp = "";
        }
        if ((string = plugin) == null) {
            string = "unknown";
        }
        return string + stamp;
    }

    public final boolean haveErrors() {
        return this.errorCount > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Use the List<File> version")
    @NotNull
    public ClassLoader createUrlClassLoader(@NotNull URL[] urls, @NotNull ClassLoader parent) {
        ClassLoader classLoader;
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (LintClient.Companion.isGradle() || SdkConstants.currentPlatform() == 2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            URL[] uRLArray = urls;
            LintCliClient lintCliClient = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new File(UrlClassLoader.urlToFilePath((String)it.getPath())));
            }
            classLoader = lintCliClient.createUrlClassLoader(CollectionsKt.toList((Iterable)((List)destination$iv$iv)), parent);
        } else {
            classLoader = super.createUrlClassLoader(urls, parent);
        }
        return classLoader;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ClassLoader createUrlClassLoader(@NotNull List<? extends File> files, @NotNull ClassLoader parent) {
        ClassLoader classLoader;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (LintClient.Companion.isGradle() || SdkConstants.currentPlatform() == 2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = files;
            UrlClassLoader.Builder builder = UrlClassLoader.build().parent(parent);
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toPath());
            }
            UrlClassLoader urlClassLoader = builder.files((List)destination$iv$iv).get();
            Intrinsics.checkNotNullExpressionValue((Object)urlClassLoader, (String)"{\n      // When lint is \u2026t.toPath() }).get()\n    }");
            classLoader = (ClassLoader)urlClassLoader;
        } else {
            classLoader = super.createUrlClassLoader(files, parent);
        }
        return classLoader;
    }

    @Nullable
    public org.w3c.dom.Document getMergedManifest(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List manifests = new ArrayList();
        for (Project dependency : project.getAllLibraries()) {
            List list2 = dependency.getManifestFiles();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"dependency.manifestFiles");
            manifests.addAll(list2);
        }
        File injectedFile = new File("injected-from-gradle");
        StringBuilder injectedXml = new StringBuilder();
        LintModelVariant target = project.getBuildVariant();
        if (target != null) {
            AndroidVersion targetSdkVersion = target.getTargetSdkVersion();
            AndroidVersion minSdkVersion = target.getMinSdkVersion();
            if (targetSdkVersion != null || minSdkVersion != null) {
                injectedXml.append("<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    package=\"${packageName}\">\n    <uses-sdk");
                if (minSdkVersion != null) {
                    injectedXml.append(" android:minSdkVersion=\"").append(minSdkVersion.getApiString()).append("\"");
                }
                if (targetSdkVersion != null) {
                    injectedXml.append(" android:targetSdkVersion=\"").append(targetSdkVersion.getApiString()).append("\"");
                }
                injectedXml.append(" />\n</manifest>\n");
                manifests.add(injectedFile);
            }
        }
        File mainManifest = null;
        if (target != null) {
            for (LintModelSourceProvider provider : target.getSourceProviders()) {
                Iterable $this$forEach$iv = provider.getManifestFiles();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File manifestFile = (File)element$iv;
                    boolean bl = false;
                    if (!manifestFile.exists()) continue;
                    if (mainManifest == null) {
                        mainManifest = manifestFile;
                        continue;
                    }
                    manifests.add(manifestFile);
                }
            }
            if (mainManifest == null) {
                return null;
            }
        } else {
            List projectManifests = project.getManifestFiles();
            if (projectManifests.isEmpty()) {
                return null;
            }
            mainManifest = (File)projectManifests.get(0);
            int $this$forEach$iv = projectManifests.size();
            for (int i = 1; i < $this$forEach$iv; ++i) {
                Object e = projectManifests.get(i);
                Intrinsics.checkNotNullExpressionValue(e, (String)"projectManifests[i]");
                manifests.add(e);
            }
        }
        if (mainManifest == null) {
            return null;
        }
        try {
            StdLogger logger = new StdLogger(StdLogger.Level.INFO);
            ManifestMerger2.MergeType type = project.isLibrary() ? ManifestMerger2.MergeType.LIBRARY : ManifestMerger2.MergeType.APPLICATION;
            File blameFile = File.createTempFile("manifest-blame", ".txt");
            blameFile.deleteOnExit();
            Object[] objectArray = new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.SKIP_BLAME, ManifestMerger2.Invoker.Feature.SKIP_XML_STRING, ManifestMerger2.Invoker.Feature.NO_PLACEHOLDER_REPLACEMENT};
            ManifestMerger2.Invoker invoker = ManifestMerger2.newMerger((File)mainManifest, (ILogger)((ILogger)logger), (ManifestMerger2.MergeType)type).withFeatures(objectArray);
            Collection $this$toTypedArray$iv = manifests;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new File[0]);
            MergingReport mergeReport2 = invoker.addLibraryManifests((File[])Arrays.copyOf(objectArray, objectArray.length)).withFileStreamProvider(new ManifestMerger2.FileStreamProvider(injectedFile, injectedXml, this){
                final /* synthetic */ File $injectedFile;
                final /* synthetic */ StringBuilder $injectedXml;
                final /* synthetic */ LintCliClient this$0;
                {
                    this.$injectedFile = $injectedFile;
                    this.$injectedXml = $injectedXml;
                    this.this$0 = $receiver;
                }

                @NotNull
                protected InputStream getInputStream(@NotNull File file) throws FileNotFoundException {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    if (Intrinsics.areEqual((Object)this.$injectedFile, (Object)file)) {
                        InputStream inputStream = CharSequences.getInputStream((CharSequence)this.$injectedXml.toString());
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(injectedXml.toString())");
                        return inputStream;
                    }
                    CharSequence text = this.this$0.readFile(file);
                    InputStream inputStream = CharSequences.getInputStream((CharSequence)text);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(text)");
                    return inputStream;
                }
            }).setMergeReportFile(blameFile).merge();
            XmlDocument xmlDocument = mergeReport2.getMergedXmlDocument(MergingReport.MergedManifestKind.MERGED);
            if (xmlDocument != null) {
                org.w3c.dom.Document document = xmlDocument.getXml();
                if (document != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)blameFile, (String)"blameFile");
                    this.resolveMergeManifestSources(document, blameFile);
                    return document;
                }
            } else {
                this.log(Severity.WARNING, null, mergeReport2.getReportString(), new Object[0]);
            }
        }
        catch (ManifestMerger2.MergeFailureException e) {
            this.log(Severity.ERROR, e, "Couldn't parse merged manifest", new Object[0]);
        }
        return super.getMergedManifest(project);
    }

    @Nullable
    public File getRootDir() {
        if (this.driver != null) {
            File file = this.getDriver().getRequest().getSrcRoot();
            if (file != null) {
                File it = file;
                boolean bl = false;
                return it;
            }
        }
        return super.getRootDir();
    }

    public final boolean reportingToConsole() {
        boolean bl;
        block3: {
            List<Reporter> list2 = this.flags.getReporters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"flags.reporters");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Reporter it = (Reporter)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof TextReporter && it.isWriteToConsole())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public File getCacheDir(@Nullable String name, boolean create) {
        File cacheDir = this.flags.getCacheDir();
        if (cacheDir != null) {
            File dir;
            File file = dir = name != null ? new File(cacheDir, name) : cacheDir;
            if (create && !dir.exists() && !dir.mkdirs()) {
                return null;
            }
            return dir;
        }
        return super.getCacheDir(name, create);
    }

    private final boolean continueAfterBaselineCreated() {
        return Intrinsics.areEqual((Object)System.getProperty("lint.baselines.continue"), (Object)"true") || this.flags.isContinueAfterBaselineCreated();
    }

    public boolean getPrintInternalErrorStackTrace() {
        return this.flags.getPrintInternalErrorStackTrace() || super.getPrintInternalErrorStackTrace();
    }

    @Nullable
    public URLConnection openConnection(@NotNull URL url, int timeout) throws IOException {
        block2: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                if (!this.flags.isOffline() || Intrinsics.areEqual((Object)url.getProtocol(), (Object)"file")) break block2;
                if (!Intrinsics.areEqual((Object)url.getProtocol(), (Object)"jar")) break block3;
                String string = url.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.path");
                if (StringsKt.startsWith$default((String)string, (String)"file:", (boolean)false, (int)2, null)) break block2;
            }
            return null;
        }
        return super.openConnection(url, timeout);
    }

    @JvmStatic
    @NotNull
    public static final PrintWriter printWriter(@NotNull OutputStream $this$printWriter) {
        return Companion.printWriter($this$printWriter);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final String getCleanPath(@NotNull File file) {
        return Companion.getCleanPath(file);
    }

    public static final /* synthetic */ int access$performReporting(LintCliClient $this) {
        return $this.performReporting();
    }

    public static final /* synthetic */ void access$validateIssueIds(LintCliClient $this, Project project) {
        $this.validateIssueIds(project);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0004J\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/LintCliClient$Companion;", "", "()V", "LINT_CONFIGURATION_OVERRIDE_PROP", "", "LINT_OVERRIDE_CONFIGURATION_ENV_VAR", "getCleanPath", "file", "Ljava/io/File;", "getTargetName", "baselineVariantName", "printWriter", "Ljava/io/PrintWriter;", "Ljava/io/OutputStream;", "lint-cli"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final String getTargetName(@NotNull String baselineVariantName) {
            Intrinsics.checkNotNullParameter((Object)baselineVariantName, (String)"baselineVariantName");
            if (LintClient.Companion.isGradle()) {
                if (Intrinsics.areEqual((Object)"all", (Object)baselineVariantName)) {
                    return "lint";
                }
                if (Intrinsics.areEqual((Object)"fatal", (Object)baselineVariantName)) {
                    return "lintVitalRelease";
                }
            }
            return baselineVariantName;
        }

        @JvmStatic
        @NotNull
        public final PrintWriter printWriter(@NotNull OutputStream $this$printWriter) {
            Intrinsics.checkNotNullParameter((Object)$this$printWriter, (String)"<this>");
            Writer writer = new OutputStreamWriter($this$printWriter, Charsets.UTF_8);
            int n = 8192;
            return new PrintWriter((Writer)(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n)), true);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final String getCleanPath(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String path = file.getPath();
            StringBuilder sb = new StringBuilder(path.length());
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            String string = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
            if (StringsKt.startsWith$default((String)path, (String)string, (boolean)false, (int)2, null)) {
                sb.append(File.separator);
            }
            block0: for (String element : Splitter.on((char)File.separatorChar).omitEmptyStrings().split((CharSequence)path)) {
                if (Intrinsics.areEqual((Object)element, (Object)".")) continue;
                if (Intrinsics.areEqual((Object)element, (Object)"..") && ((CharSequence)sb).length() > 0) {
                    for (int i = sb.length() - 1; -1 < i; --i) {
                        char c = sb.charAt(i);
                        if (c != File.separatorChar) continue;
                        sb.setLength(i == 0 ? 1 : i);
                        continue block0;
                    }
                    sb.setLength(0);
                    continue;
                }
                if (sb.length() > 1) {
                    sb.append(File.separatorChar);
                } else if (((CharSequence)sb).length() > 0 && sb.charAt(0) != File.separatorChar) {
                    sb.append(File.separatorChar);
                }
                sb.append(element);
            }
            String string2 = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
            if (StringsKt.endsWith$default((String)path, (String)string2, (boolean)false, (int)2, null) && ((CharSequence)sb).length() > 0 && sb.charAt(sb.length() - 1) != File.separatorChar) {
                sb.append(File.separator);
            }
            String string3 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sb.toString()");
            return string3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/LintCliClient$LintCliKotlinPerformanceManager;", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "perfReportName", "", "(Ljava/lang/String;)V", "report", "", "request", "Lcom/android/tools/lint/client/api/LintRequest;", "lint-cli"})
    @SourceDebugExtension(value={"SMAP\nLintCliClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintCliClient.kt\ncom/android/tools/lint/LintCliClient$LintCliKotlinPerformanceManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2011:1\n1#2:2012\n*E\n"})
    private static final class LintCliKotlinPerformanceManager
    extends CommonCompilerPerformanceManager {
        @NotNull
        private final String perfReportName;

        public LintCliKotlinPerformanceManager(@NotNull String perfReportName) {
            Intrinsics.checkNotNullParameter((Object)perfReportName, (String)"perfReportName");
            super("Lint CLI");
            this.perfReportName = perfReportName;
            this.enableCollectingPerformanceStatistics();
            PerformanceCounter.Companion.resetAllCounters();
        }

        public final void report(@NotNull LintRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.notifyCompilationFinished();
            StringBuilder sb = new StringBuilder(this.perfReportName);
            Collection projects = request.getProjects();
            if (projects != null) {
                for (Project project : projects) {
                    sb.append('-');
                    sb.append(project.getName());
                    LintModelVariant lintModelVariant = project.getBuildVariant();
                    String variantName = lintModelVariant != null ? lintModelVariant.getName() : null;
                    boolean bl = false;
                    sb.append(variantName);
                }
            }
            sb.append(".txt");
            this.dumpPerformanceReport(new File(sb.toString()));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0094\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0014J*\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/LintCliClient$LintCliUastParser;", "Lcom/android/tools/lint/helpers/DefaultUastParser;", "project", "Lcom/android/tools/lint/detector/api/Project;", "(Lcom/android/tools/lint/LintCliClient;Lcom/android/tools/lint/detector/api/Project;)V", "createEvaluator", "Lcom/android/tools/lint/helpers/DefaultJavaEvaluator;", "p", "Lcom/intellij/openapi/project/Project;", "prepare", "", "contexts", "", "Lcom/android/tools/lint/detector/api/JavaContext;", "javaLanguageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "kotlinLanguageLevel", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "lint-cli"})
    protected class LintCliUastParser
    extends DefaultUastParser {
        public LintCliUastParser(Project project) {
            MockProject mockProject = LintCliClient.this.getIdeaProject();
            Intrinsics.checkNotNull((Object)mockProject);
            super(project, (com.intellij.openapi.project.Project)mockProject);
        }

        public boolean prepare(@NotNull List<? extends JavaContext> contexts, @Nullable LanguageLevel javaLanguageLevel, @Nullable LanguageVersionSettings kotlinLanguageLevel) {
            Intrinsics.checkNotNullParameter(contexts, (String)"contexts");
            List kotlinFiles = new ArrayList();
            for (JavaContext javaContext : contexts) {
                String path = javaContext.file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                if (!StringsKt.endsWith$default((String)path, (String)".kt", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)path, (String)".kts", (boolean)false, (int)2, null)) continue;
                kotlinFiles.add(javaContext.file);
            }
            UastEnvironment env = LintCliClient.this.getUastEnvironment();
            if (env != null) {
                if (kotlinLanguageLevel != null) {
                    CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)env.getKotlinCompilerConfig(), (LanguageVersionSettings)kotlinLanguageLevel);
                }
                env.analyzeFiles(kotlinFiles);
            }
            boolean bl = super.prepare(contexts, javaLanguageLevel, kotlinLanguageLevel);
            if (contexts.isEmpty()) {
                return bl;
            }
            ExternalAnnotationsManager externalAnnotationsManager = ExternalAnnotationsManager.getInstance((com.intellij.openapi.project.Project)this.getIdeaProject());
            Intrinsics.checkNotNull((Object)externalAnnotationsManager, (String)"null cannot be cast to non-null type com.android.tools.lint.LintExternalAnnotationsManager");
            LintExternalAnnotationsManager annotationsManager = (LintExternalAnnotationsManager)externalAnnotationsManager;
            List projects = ((JavaContext)CollectionsKt.first(contexts)).getDriver().getProjects();
            IAndroidTarget target = LintCliClient.this.pickBuildTarget(projects);
            annotationsManager.updateAnnotationRoots(LintCliClient.this, target, target == null && !((Collection)projects).isEmpty());
            return bl;
        }

        @NotNull
        protected DefaultJavaEvaluator createEvaluator(@Nullable Project project, @NotNull com.intellij.openapi.project.Project p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Project project2 = project;
            Intrinsics.checkNotNull((Object)project2);
            Project project3 = project2;
            return new DefaultJavaEvaluator(p, LintCliClient.this, project3){
                final /* synthetic */ LintCliClient this$0;
                {
                    this.this$0 = $receiver;
                    super($p, $super_call_param$1);
                }

                @Nullable
                public PsiClass findClass(@NotNull String qualifiedName) {
                    Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
                    if (this.this$0.driver != null && this.this$0.getDriver().getMode() == LintDriver.DriverMode.MERGE) {
                        throw new IllegalStateException("Class lookup is not allowed during report merging; see the lint partial analysis documentation".toString());
                    }
                    return super.findClass(qualifiedName);
                }
            };
        }
    }
}

