/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.FlagConfiguration;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SeverityKt;
import com.android.tools.lint.model.LintModelSeverity;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0016J\u0010\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0016J\u0010\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0016J\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000bH\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/CliConfiguration;", "Lcom/android/tools/lint/client/api/FlagConfiguration;", "configurations", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "flags", "Lcom/android/tools/lint/LintCliFlags;", "fatalOnly", "", "(Lcom/android/tools/lint/client/api/ConfigurationHierarchy;Lcom/android/tools/lint/LintCliFlags;Z)V", "allowSuppress", "disabledCategories", "", "Lcom/android/tools/lint/detector/api/Category;", "disabledIds", "", "enabledCategories", "enabledIds", "exactCategories", "exactCheckedIds", "isCheckAllWarnings", "isIgnoreWarnings", "isWarningsAsErrors", "severityOverride", "Lcom/android/tools/lint/detector/api/Severity;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "severityOverrides", "lint-cli"})
public class CliConfiguration
extends FlagConfiguration {
    @NotNull
    private final LintCliFlags flags;
    private final boolean fatalOnly;

    public CliConfiguration(@NotNull ConfigurationHierarchy configurations, @NotNull LintCliFlags flags, boolean fatalOnly) {
        Intrinsics.checkNotNullParameter((Object)configurations, (String)"configurations");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        super(configurations);
        this.flags = flags;
        this.fatalOnly = fatalOnly;
    }

    public boolean fatalOnly() {
        return this.fatalOnly;
    }

    public boolean isWarningsAsErrors() {
        return this.flags.isWarningsAsErrors();
    }

    public boolean isIgnoreWarnings() {
        return this.flags.isIgnoreWarnings();
    }

    public boolean isCheckAllWarnings() {
        return this.flags.isCheckAllWarnings();
    }

    @NotNull
    public Set<String> enabledIds() {
        Set<String> set = this.flags.getEnabledIds();
        Intrinsics.checkNotNullExpressionValue(set, (String)"flags.enabledIds");
        return set;
    }

    @NotNull
    public Set<String> disabledIds() {
        Set<String> set = this.flags.getSuppressedIds();
        Intrinsics.checkNotNullExpressionValue(set, (String)"flags.suppressedIds");
        return set;
    }

    @Nullable
    public Set<String> exactCheckedIds() {
        return this.flags.getExactCheckedIds();
    }

    @Nullable
    public Set<Category> disabledCategories() {
        return this.flags.getDisabledCategories();
    }

    @Nullable
    public Set<Category> enabledCategories() {
        return this.flags.getEnabledCategories();
    }

    @Nullable
    public Set<Category> exactCategories() {
        return this.flags.getExactCategories();
    }

    @Nullable
    public Severity severityOverride(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        LintModelSeverity lintModelSeverity = this.flags.getSeverityOverrides().get(issue.getId());
        return lintModelSeverity != null ? SeverityKt.getSeverity((LintModelSeverity)lintModelSeverity, (Issue)issue) : null;
    }

    public boolean allowSuppress() {
        return this.flags.getAllowSuppress();
    }

    @NotNull
    public Set<String> severityOverrides() {
        return this.flags.getSeverityOverrides().keySet();
    }
}

