/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderParams;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ViewInfo;
import java.util.List;
import java.util.function.Function;

public class SessionParams
extends RenderParams {
    private final ILayoutPullParser mLayoutDescription;
    private final RenderingMode mRenderingMode;
    private boolean mExtendedViewInfoMode = false;
    private final int mSimulatedPlatformVersion;
    private Function<Object, List<ViewInfo>> mCustomContentHierarchyParser = null;

    public SessionParams(ILayoutPullParser layoutDescription, RenderingMode renderingMode, Object projectKey, HardwareConfig hardwareConfig, RenderResources renderResources, LayoutlibCallback layoutlibCallback, int minSdkVersion, int targetSdkVersion, ILayoutLog log) {
        this(layoutDescription, renderingMode, projectKey, hardwareConfig, renderResources, layoutlibCallback, minSdkVersion, targetSdkVersion, log, 0);
    }

    public SessionParams(ILayoutPullParser layoutDescription, RenderingMode renderingMode, Object projectKey, HardwareConfig hardwareConfig, RenderResources renderResources, LayoutlibCallback projectCallback, int minSdkVersion, int targetSdkVersion, ILayoutLog log, int simulatedPlatformVersion) {
        super(projectKey, hardwareConfig, renderResources, projectCallback, minSdkVersion, targetSdkVersion, log);
        this.mLayoutDescription = layoutDescription;
        this.mRenderingMode = renderingMode;
        this.mSimulatedPlatformVersion = simulatedPlatformVersion;
    }

    public SessionParams(SessionParams params) {
        super(params);
        this.mLayoutDescription = params.mLayoutDescription;
        this.mRenderingMode = params.mRenderingMode;
        this.mSimulatedPlatformVersion = params.mSimulatedPlatformVersion;
        this.mExtendedViewInfoMode = params.mExtendedViewInfoMode;
        this.mCustomContentHierarchyParser = params.mCustomContentHierarchyParser;
    }

    public ILayoutPullParser getLayoutDescription() {
        return this.mLayoutDescription;
    }

    public RenderingMode getRenderingMode() {
        return this.mRenderingMode;
    }

    public void setExtendedViewInfoMode(boolean mode) {
        this.mExtendedViewInfoMode = mode;
    }

    public boolean getExtendedViewInfoMode() {
        return this.mExtendedViewInfoMode;
    }

    public void setCustomContentHierarchyParser(Function<Object, List<ViewInfo>> parser) {
        this.mCustomContentHierarchyParser = parser;
    }

    public Function<Object, List<ViewInfo>> getCustomContentHierarchyParser() {
        return this.mCustomContentHierarchyParser;
    }

    public int getSimulatedPlatformVersion() {
        return this.mSimulatedPlatformVersion;
    }

    public static enum RenderingMode {
        NORMAL(SizeAction.KEEP, SizeAction.KEEP),
        V_SCROLL(SizeAction.KEEP, SizeAction.EXPAND),
        H_SCROLL(SizeAction.EXPAND, SizeAction.KEEP),
        FULL_EXPAND(SizeAction.EXPAND, SizeAction.EXPAND),
        SHRINK(SizeAction.SHRINK, SizeAction.SHRINK);

        private final SizeAction mHorizAction;
        private final SizeAction mVertAction;

        private RenderingMode(SizeAction horizAction, SizeAction vertAction) {
            this.mHorizAction = horizAction;
            this.mVertAction = vertAction;
        }

        public SizeAction getHorizAction() {
            return this.mHorizAction;
        }

        public SizeAction getVertAction() {
            return this.mVertAction;
        }

        public static enum SizeAction {
            EXPAND,
            KEEP,
            SHRINK;

        }
    }

    public static class Key<T> {
        public final Class<T> mExpectedClass;
        public final String mName;

        public Key(String name, Class<T> expectedClass) {
            assert (name != null);
            assert (expectedClass != null);
            this.mExpectedClass = expectedClass;
            this.mName = name;
        }

        public int hashCode() {
            int result = this.mExpectedClass.hashCode();
            return 31 * result + this.mName.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && this.getClass() == obj.getClass()) {
                Key k = (Key)obj;
                return this.mExpectedClass.equals(k.mExpectedClass) && this.mName.equals(k.mName);
            }
            return false;
        }

        public String toString() {
            return this.mName;
        }
    }
}

