/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.compress.harmony.unpack200.bytecode.Attribute;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import org.apache.commons.compress.harmony.unpack200.bytecode.ClassConstantPool;
import org.apache.commons.compress.harmony.unpack200.bytecode.ClassFileEntry;

public class CPMember
extends ClassFileEntry {
    List attributes;
    short flags;
    CPUTF8 name;
    transient int nameIndex;
    protected final CPUTF8 descriptor;
    transient int descriptorIndex;

    public CPMember(CPUTF8 name2, CPUTF8 descriptor2, long flags, List attributes) {
        this.name = name2;
        this.descriptor = descriptor2;
        this.flags = (short)flags;
        List list = this.attributes = attributes == null ? Collections.EMPTY_LIST : attributes;
        if (name2 == null || descriptor2 == null) {
            throw new NullPointerException("Null arguments are not allowed");
        }
    }

    @Override
    protected ClassFileEntry[] getNestedClassFileEntries() {
        int attributeCount = this.attributes.size();
        ClassFileEntry[] entries2 = new ClassFileEntry[attributeCount + 2];
        entries2[0] = this.name;
        entries2[1] = this.descriptor;
        for (int i = 0; i < attributeCount; ++i) {
            entries2[i + 2] = (Attribute)this.attributes.get(i);
        }
        return entries2;
    }

    @Override
    protected void resolve(ClassConstantPool pool) {
        super.resolve(pool);
        this.nameIndex = pool.indexOf(this.name);
        this.descriptorIndex = pool.indexOf(this.descriptor);
        for (int it = 0; it < this.attributes.size(); ++it) {
            Attribute attribute = (Attribute)this.attributes.get(it);
            attribute.resolve(pool);
        }
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.attributes.hashCode();
        result2 = 31 * result2 + this.descriptor.hashCode();
        result2 = 31 * result2 + this.flags;
        result2 = 31 * result2 + this.name.hashCode();
        return result2;
    }

    @Override
    public String toString() {
        return "CPMember: " + this.name + "(" + this.descriptor + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CPMember other = (CPMember)obj;
        if (!this.attributes.equals(other.attributes)) {
            return false;
        }
        if (!this.descriptor.equals(other.descriptor)) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        return this.name.equals(other.name);
    }

    @Override
    protected void doWrite(DataOutputStream dos) throws IOException {
        dos.writeShort(this.flags);
        dos.writeShort(this.nameIndex);
        dos.writeShort(this.descriptorIndex);
        int attributeCount = this.attributes.size();
        dos.writeShort(attributeCount);
        for (int i = 0; i < attributeCount; ++i) {
            Attribute attribute = (Attribute)this.attributes.get(i);
            attribute.doWrite(dos);
        }
    }
}

