/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.CharSpliterator;
import one.util.streamex.CollapseSpliterator;
import one.util.streamex.CombinationSpliterator;
import one.util.streamex.ConstSpliterator;
import one.util.streamex.CrossSpliterator;
import one.util.streamex.EmitterSpliterator;
import one.util.streamex.EntryStream;
import one.util.streamex.HeadTailSpliterator;
import one.util.streamex.IntStreamEx;
import one.util.streamex.Internals;
import one.util.streamex.MoreCollectors;
import one.util.streamex.PairPermutationSpliterator;
import one.util.streamex.PairSpliterator;
import one.util.streamex.PermutationSpliterator;
import one.util.streamex.PrependSpliterator;
import one.util.streamex.RangeBasedSpliterator;
import one.util.streamex.StreamContext;
import one.util.streamex.TreeSpliterator;
import one.util.streamex.UnknownSizeSpliterator;
import one.util.streamex.WithFirstSpliterator;
import one.util.streamex.ZipSpliterator;

public final class StreamEx<T>
extends AbstractStreamEx<T, StreamEx<T>> {
    StreamEx(Stream<? extends T> stream, StreamContext context2) {
        super(stream, context2);
    }

    StreamEx(Spliterator<? extends T> spliterator, StreamContext context2) {
        super(spliterator, context2);
    }

    @Override
    StreamEx<T> supply(Stream<T> stream) {
        return new StreamEx<T>(stream, this.context);
    }

    @Override
    StreamEx<T> supply(Spliterator<T> spliterator) {
        return new StreamEx<T>(spliterator, this.context);
    }

    private <R> StreamEx<R> collapseInternal(BiPredicate<? super T, ? super T> collapsible, Function<T, R> mapper, BiFunction<R, T, R> accumulator, BinaryOperator<R> combiner) {
        CollapseSpliterator<? super T, R> spliterator = new CollapseSpliterator<T, R>(collapsible, mapper, accumulator, combiner, this.spliterator());
        return new StreamEx<T>(spliterator, this.context);
    }

    @Override
    public StreamEx<T> nonNull() {
        return (StreamEx)super.nonNull();
    }

    public <TT> StreamEx<TT> select(Class<TT> clazz) {
        return (StreamEx)this.filter(clazz::isInstance);
    }

    public <K> StreamEx<T> filterBy(Function<? super T, ? extends K> mapper, K value) {
        return value == null ? (StreamEx)this.filter((T t) -> mapper.apply(t) == null) : (StreamEx)this.filter((T t) -> value.equals(mapper.apply(t)));
    }

    public <K> StreamEx<T> removeBy(Function<? super T, ? extends K> mapper, K value) {
        return value == null ? (StreamEx)this.filter((T t) -> mapper.apply(t) != null) : (StreamEx)this.filter((T t) -> !value.equals(mapper.apply(t)));
    }

    public <V> EntryStream<T, V> mapToEntry(Function<? super T, ? extends V> valueMapper) {
        return new EntryStream(((Stream)this.stream()).map((? super T e) -> new AbstractMap.SimpleImmutableEntry(e, valueMapper.apply(e))), this.context);
    }

    public <K, V> EntryStream<K, V> mapToEntry(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return new EntryStream(((Stream)this.stream()).map((? super T e) -> new AbstractMap.SimpleImmutableEntry(keyMapper.apply(e), valueMapper.apply(e))), this.context);
    }

    public StreamEx<T> mapFirst(Function<? super T, ? extends T> mapper) {
        return this.supply(new PairSpliterator.PSOfRef<T, T>(mapper, this.spliterator(), true));
    }

    public <R> StreamEx<R> mapFirstOrElse(Function<? super T, ? extends R> firstMapper, Function<? super T, ? extends R> notFirstMapper) {
        return new StreamEx<T>(new PairSpliterator.PSOfRef<T, R>(firstMapper, notFirstMapper, this.spliterator(), true), this.context);
    }

    public StreamEx<T> mapLast(Function<? super T, ? extends T> mapper) {
        return this.supply(new PairSpliterator.PSOfRef<T, T>(mapper, this.spliterator(), false));
    }

    public <R> StreamEx<R> mapLastOrElse(Function<? super T, ? extends R> notLastMapper, Function<? super T, ? extends R> lastMapper) {
        return new StreamEx<T>(new PairSpliterator.PSOfRef<T, R>(lastMapper, notLastMapper, this.spliterator(), false), this.context);
    }

    public StreamEx<T> peekFirst(Consumer<? super T> action2) {
        return this.mapFirst(x -> {
            action2.accept(x);
            return x;
        });
    }

    public StreamEx<T> peekLast(Consumer<? super T> action2) {
        return this.mapLast(x -> {
            action2.accept(x);
            return x;
        });
    }

    public <K, V> EntryStream<K, V> flatMapToEntry(Function<? super T, ? extends Map<K, V>> mapper) {
        return new EntryStream(((Stream)this.stream()).flatMap((? super T e) -> {
            Map s = (Map)mapper.apply(e);
            return s == null ? null : s.entrySet().stream();
        }), this.context);
    }

    public <V> EntryStream<T, V> cross(V ... other) {
        if (other.length == 0) {
            return new EntryStream(Spliterators.emptySpliterator(), this.context);
        }
        if (other.length == 1) {
            return this.mapToEntry(e -> other[0]);
        }
        return this.cross((? super T t) -> StreamEx.of(other));
    }

    public <V> EntryStream<T, V> cross(Collection<? extends V> other) {
        if (other.isEmpty()) {
            return new EntryStream(Spliterators.emptySpliterator(), this.context);
        }
        return this.cross((? super T t) -> StreamEx.of(other));
    }

    public <V> EntryStream<T, V> cross(Function<? super T, ? extends Stream<? extends V>> mapper) {
        return new EntryStream(((Stream)this.stream()).flatMap((? super T a) -> EntryStream.withKey(a, (Stream)mapper.apply(a))), this.context);
    }

    public <K> Map<K, List<T>> groupingBy(Function<? super T, ? extends K> classifier) {
        return this.groupingBy(classifier, Collectors.toList());
    }

    public <K, D> Map<K, D> groupingBy(Function<? super T, ? extends K> classifier, Collector<? super T, ?, D> downstream) {
        if (this.isParallel() && downstream.characteristics().contains((Object)Collector.Characteristics.UNORDERED)) {
            return this.rawCollect(Collectors.groupingByConcurrent(classifier, downstream));
        }
        return this.rawCollect(Collectors.groupingBy(classifier, downstream));
    }

    public <K, D, M extends Map<K, D>> M groupingBy(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, ?, D> downstream) {
        if (this.isParallel() && downstream.characteristics().contains((Object)Collector.Characteristics.UNORDERED) && mapFactory.get() instanceof ConcurrentMap) {
            return (M)((Map)this.rawCollect(Collectors.groupingByConcurrent(classifier, mapFactory, downstream)));
        }
        return (M)((Map)this.rawCollect(Collectors.groupingBy(classifier, mapFactory, downstream)));
    }

    public <K, C extends Collection<T>> Map<K, C> groupingTo(Function<? super T, ? extends K> classifier, Supplier<C> collectionFactory) {
        return this.groupingBy(classifier, Collectors.toCollection(collectionFactory));
    }

    public <K, C extends Collection<T>, M extends Map<K, C>> M groupingTo(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Supplier<C> collectionFactory) {
        return this.groupingBy(classifier, mapFactory, Collectors.toCollection(collectionFactory));
    }

    public Map<Boolean, List<T>> partitioningBy(Predicate<? super T> predicate) {
        return this.collect(Collectors.partitioningBy(predicate));
    }

    public <D> Map<Boolean, D> partitioningBy(Predicate<? super T> predicate, Collector<? super T, ?, D> downstream) {
        return this.collect(MoreCollectors.partitioningBy(predicate, downstream));
    }

    public <C extends Collection<T>> Map<Boolean, C> partitioningTo(Predicate<? super T> predicate, Supplier<C> collectionFactory) {
        return this.collect(Collectors.partitioningBy(predicate, Collectors.toCollection(collectionFactory)));
    }

    public String joining() {
        return ((AbstractStreamEx)this.map(String::valueOf)).rawCollect(Collectors.joining());
    }

    public String joining(CharSequence delimiter) {
        return ((AbstractStreamEx)this.map(String::valueOf)).rawCollect(Collectors.joining(delimiter));
    }

    public String joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return ((AbstractStreamEx)this.map(String::valueOf)).rawCollect(Collectors.joining(delimiter, prefix, suffix));
    }

    public <A> A[] toArray(Class<A> elementClass) {
        return ((Stream)this.stream()).toArray((int size) -> (Object[])Array.newInstance(elementClass, size));
    }

    public <A> A[] toArray(A[] emptyArray) {
        if (emptyArray.length != 0) {
            throw new IllegalArgumentException("Empty array must be supplied");
        }
        return ((Stream)this.stream()).toArray((int size) -> size == 0 ? emptyArray : (Object[])Array.newInstance(emptyArray.getClass().getComponentType(), size));
    }

    public <U, C extends Collection<U>> C toFlatCollection(Function<? super T, ? extends Collection<U>> mapper, Supplier<C> supplier) {
        return (C)((AbstractStreamEx)this.map(mapper)).collect(supplier, Collection::addAll, Collection::addAll);
    }

    public <U> List<U> toFlatList(Function<? super T, ? extends Collection<U>> mapper) {
        return this.toFlatCollection(mapper, ArrayList::new);
    }

    public <V> Map<T, V> toMap(Function<? super T, ? extends V> valMapper) {
        return this.toMap(Function.identity(), valMapper);
    }

    public <K, V> Map<K, V> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valMapper) {
        AbstractMap map2 = this.isParallel() ? new ConcurrentHashMap() : new HashMap();
        return this.toMapThrowing(keyMapper, valMapper, map2);
    }

    public <K, V> Map<K, V> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valMapper, BinaryOperator<V> mergeFunction) {
        return this.rawCollect(Collectors.toMap(keyMapper, valMapper, mergeFunction, HashMap::new));
    }

    public <K> Map<K, T> valuesToMap(Function<? super T, ? extends K> keyMapper) {
        return this.toMap(keyMapper, Function.identity());
    }

    public <C extends Collection<? super T>> C into(C collection) {
        if (this.isParallel()) {
            List<Object> list = Arrays.asList(this.toArray());
            collection.addAll(list);
        } else {
            int size;
            Spliterator spltr = this.spliterator();
            if (collection instanceof ArrayList && (size = Internals.intSize(spltr)) > 0 && size <= Integer.MAX_VALUE - collection.size()) {
                ((ArrayList)collection).ensureCapacity(collection.size() + size);
            }
            spltr.forEachRemaining(collection::add);
        }
        return collection;
    }

    public <V> SortedMap<T, V> toSortedMap(Function<? super T, ? extends V> valMapper) {
        return this.toSortedMap(Function.identity(), valMapper);
    }

    public <K, V> SortedMap<K, V> toSortedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valMapper) {
        AbstractMap map2 = this.isParallel() ? new ConcurrentSkipListMap() : new TreeMap();
        return this.toMapThrowing(keyMapper, valMapper, map2);
    }

    public <K, V> SortedMap<K, V> toSortedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valMapper, BinaryOperator<V> mergeFunction) {
        return this.rawCollect(Collectors.toMap(keyMapper, valMapper, mergeFunction, TreeMap::new));
    }

    public <K> SortedMap<K, T> valuesToSortedMap(Function<? super T, ? extends K> keyMapper) {
        return this.toSortedMap(keyMapper, Function.identity());
    }

    public <V> NavigableMap<T, V> toNavigableMap(Function<? super T, ? extends V> valMapper) {
        return this.toNavigableMap(Function.identity(), valMapper);
    }

    public <K, V> NavigableMap<K, V> toNavigableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valMapper) {
        AbstractMap map2 = this.isParallel() ? new ConcurrentSkipListMap() : new TreeMap();
        return this.toMapThrowing(keyMapper, valMapper, map2);
    }

    public <K, V> NavigableMap<K, V> toNavigableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valMapper, BinaryOperator<V> mergeFunction) {
        return this.rawCollect(Collectors.toMap(keyMapper, valMapper, mergeFunction, TreeMap::new));
    }

    public <K> NavigableMap<K, T> valuesToNavigableMap(Function<? super T, ? extends K> keyMapper) {
        return this.toNavigableMap(keyMapper, Function.identity());
    }

    @SafeVarargs
    public final StreamEx<T> append(T ... values2) {
        return (StreamEx)this.appendSpliterator(null, Spliterators.spliterator(values2, 16));
    }

    public StreamEx<T> append(T value) {
        return (StreamEx)this.appendSpliterator(null, new ConstSpliterator.OfRef<T>(value, 1L, true));
    }

    @Override
    public StreamEx<T> append(Collection<? extends T> collection) {
        return (StreamEx)this.appendSpliterator(null, collection.spliterator());
    }

    @SafeVarargs
    public final StreamEx<T> prepend(T ... values2) {
        return (StreamEx)this.prependSpliterator(null, Spliterators.spliterator(values2, 16));
    }

    public StreamEx<T> prepend(T value) {
        return new StreamEx<T>(new PrependSpliterator<T>(this.spliterator(), value), this.context);
    }

    @Override
    public StreamEx<T> prepend(Collection<? extends T> collection) {
        return (StreamEx)this.prependSpliterator(null, collection.spliterator());
    }

    @SafeVarargs
    public final StreamEx<T> ifEmpty(T ... values2) {
        return (StreamEx)this.ifEmpty(null, Spliterators.spliterator(values2, 16));
    }

    public boolean has(T value) {
        return this.anyMatch(Predicate.isEqual(value));
    }

    public StreamEx<T> without(T value) {
        if (value == null) {
            return (StreamEx)this.filter(Objects::nonNull);
        }
        return (StreamEx)this.remove(value::equals);
    }

    @SafeVarargs
    public final StreamEx<T> without(T ... values2) {
        if (values2.length == 0) {
            return this;
        }
        if (values2.length == 1) {
            return this.without(values2[0]);
        }
        return (StreamEx)this.remove(Arrays.asList(values2)::contains);
    }

    public StreamEx<T> reverseSorted() {
        return (StreamEx)this.sorted(Comparator.reverseOrder());
    }

    public void forPairs(BiConsumer<? super T, ? super T> action2) {
        this.pairMap((a, b) -> {
            action2.accept(a, b);
            return null;
        }).reduce(null, Internals.selectFirst());
    }

    public StreamEx<T> collapse(BiPredicate<? super T, ? super T> collapsible, BinaryOperator<T> merger) {
        return this.collapseInternal(collapsible, Function.identity(), merger, merger);
    }

    public <R, A> StreamEx<R> collapse(BiPredicate<? super T, ? super T> collapsible, Collector<? super T, A, R> collector2) {
        Supplier supplier = collector2.supplier();
        BiConsumer accumulator = collector2.accumulator();
        StreamEx<Object> stream = this.collapseInternal(collapsible, t -> {
            Object acc = supplier.get();
            accumulator.accept((Object)acc, (Object)t);
            return acc;
        }, (acc, t) -> {
            accumulator.accept(acc, t);
            return acc;
        }, collector2.combiner());
        if (collector2.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            StreamEx<Object> result2 = stream;
            return result2;
        }
        return stream.map(collector2.finisher());
    }

    public StreamEx<T> collapse(BiPredicate<? super T, ? super T> collapsible) {
        return this.collapse(collapsible, Internals.selectFirst());
    }

    public EntryStream<T, Long> runLengths() {
        return new EntryStream(this.collapseInternal(Objects::equals, t -> new Internals.ObjLongBox<Object>(t, 1L), (acc, t) -> {
            ++acc.b;
            return acc;
        }, (e1, e2) -> {
            e1.b += e2.b;
            return e1;
        }), this.context);
    }

    public StreamEx<List<T>> groupRuns(BiPredicate<? super T, ? super T> sameGroup) {
        return this.collapseInternal(sameGroup, Collections::singletonList, (acc, t) -> {
            if (!(acc instanceof ArrayList)) {
                Object old = acc.get(0);
                acc = new ArrayList<Object>();
                acc.add(old);
            }
            acc.add(t);
            return acc;
        }, (acc1, acc2) -> {
            if (!(acc1 instanceof ArrayList)) {
                Object old = acc1.get(0);
                acc1 = new ArrayList();
                acc1.add(old);
            }
            acc1.addAll(acc2);
            return acc1;
        });
    }

    public <U> StreamEx<U> intervalMap(BiPredicate<? super T, ? super T> sameInterval, BiFunction<? super T, ? super T, ? extends U> mapper) {
        return this.collapseInternal(sameInterval, Internals.PairBox::single, (box, t) -> {
            box.b = t;
            return box;
        }, (left, right) -> {
            left.b = right.b;
            return left;
        }).map((T pair) -> mapper.apply(pair.a, pair.b));
    }

    public <R> StreamEx<R> withFirst(BiFunction<? super T, ? super T, ? extends R> mapper) {
        WithFirstSpliterator<? super T, ? extends R> spliterator = new WithFirstSpliterator<T, R>(this.spliterator(), mapper);
        return new StreamEx<T>(spliterator, this.context);
    }

    public EntryStream<T, T> withFirst() {
        WithFirstSpliterator<Object, Map.Entry> spliterator = new WithFirstSpliterator<Object, Map.Entry>(this.spliterator(), AbstractMap.SimpleImmutableEntry::new);
        return new EntryStream(spliterator, this.context);
    }

    public <V, R> StreamEx<R> zipWith(Stream<V> other, BiFunction<? super T, ? super V, ? extends R> mapper) {
        return this.zipWith((BaseStream<V, ?>)other, mapper);
    }

    public <V, R> StreamEx<R> zipWith(BaseStream<V, ?> other, BiFunction<? super T, ? super V, ? extends R> mapper) {
        return new StreamEx<T>(new ZipSpliterator<T, V, R>(this.spliterator(), other.spliterator(), mapper, true), this.context.combine(other));
    }

    public <V> EntryStream<T, V> zipWith(Stream<V> other) {
        return this.zipWith((BaseStream<V, ?>)other);
    }

    public <V> EntryStream<T, V> zipWith(BaseStream<V, ?> other) {
        return new EntryStream(new ZipSpliterator<Object, Object, AbstractMap.SimpleImmutableEntry>(this.spliterator(), other.spliterator(), AbstractMap.SimpleImmutableEntry::new, true), this.context.combine(other));
    }

    public <R> StreamEx<R> headTail(BiFunction<? super T, ? super StreamEx<T>, ? extends Stream<R>> mapper) {
        return this.headTail(mapper, () -> null);
    }

    public <R> StreamEx<R> headTail(BiFunction<? super T, ? super StreamEx<T>, ? extends Stream<R>> mapper, Supplier<? extends Stream<R>> supplier) {
        HeadTailSpliterator spliterator = new HeadTailSpliterator(this.spliterator(), mapper, supplier);
        spliterator.context = this.context = this.context.detach();
        return new StreamEx<T>(spliterator, this.context);
    }

    public static <T> StreamEx<T> empty() {
        return StreamEx.of(Spliterators.emptySpliterator());
    }

    public static <T> StreamEx<T> of(T element) {
        return StreamEx.of(new ConstSpliterator.OfRef<T>(element, 1L, true));
    }

    @SafeVarargs
    public static <T> StreamEx<T> of(T ... elements) {
        return StreamEx.of(Arrays.spliterator(elements));
    }

    public static <T> StreamEx<T> of(T[] array2, int startInclusive, int endExclusive) {
        return StreamEx.of(Arrays.spliterator(array2, startInclusive, endExclusive));
    }

    public static <T> StreamEx<T> of(Collection<? extends T> collection) {
        return StreamEx.of(collection.spliterator());
    }

    public static <T> StreamEx<T> ofReversed(List<? extends T> list) {
        int size = list.size();
        return IntStreamEx.ofIndices(list).mapToObj(idx -> list.get(size - idx - 1));
    }

    public static <T> StreamEx<T> ofReversed(T[] array2) {
        int size = array2.length;
        return IntStreamEx.ofIndices(array2).mapToObj(idx -> array2[size - idx - 1]);
    }

    public static <T> StreamEx<T> of(Stream<T> stream) {
        if (stream instanceof AbstractStreamEx) {
            AbstractStreamEx ase = (AbstractStreamEx)stream;
            if (ase.spliterator != null) {
                return new StreamEx<T>(ase.spliterator(), ase.context);
            }
            return new StreamEx<T>((Stream)ase.stream(), ase.context);
        }
        return new StreamEx<T>(stream, StreamContext.of(stream));
    }

    public static <T> StreamEx<T> of(Spliterator<? extends T> spliterator) {
        return new StreamEx<T>(spliterator, StreamContext.SEQUENTIAL);
    }

    public static <T> StreamEx<T> of(Iterator<? extends T> iterator) {
        return StreamEx.of(new UnknownSizeSpliterator.USOfRef<T>(iterator));
    }

    public static <T> StreamEx<T> of(final Enumeration<? extends T> enumeration) {
        return StreamEx.of(new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }
        });
    }

    public static <T> StreamEx<T> of(Optional<? extends T> optional) {
        return optional.isPresent() ? StreamEx.of(optional.get()) : StreamEx.empty();
    }

    public static <T> StreamEx<T> ofNullable(T element) {
        return element == null ? StreamEx.empty() : StreamEx.of(element);
    }

    public static StreamEx<String> ofLines(BufferedReader reader) {
        return new StreamEx<String>(reader.lines(), StreamContext.SEQUENTIAL);
    }

    public static StreamEx<String> ofLines(Reader reader) {
        if (reader instanceof BufferedReader) {
            return StreamEx.ofLines((BufferedReader)reader);
        }
        return StreamEx.ofLines(new BufferedReader(reader));
    }

    public static StreamEx<String> ofLines(Path path) throws IOException {
        return StreamEx.of(Files.lines(path));
    }

    public static StreamEx<String> ofLines(Path path, Charset charset) throws IOException {
        return StreamEx.of(Files.lines(path, charset));
    }

    public static <T> StreamEx<T> ofKeys(Map<T, ?> map2) {
        return StreamEx.of(map2.keySet().spliterator());
    }

    public static <T, V> StreamEx<T> ofKeys(Map<T, V> map2, Predicate<? super V> valueFilter) {
        return EntryStream.of(map2).filterValues(valueFilter).keys();
    }

    public static <T> StreamEx<T> ofValues(Map<?, T> map2) {
        return StreamEx.of(map2.values().spliterator());
    }

    public static <K, T> StreamEx<T> ofValues(Map<K, T> map2, Predicate<? super K> keyFilter) {
        return EntryStream.of(map2).filterKeys(keyFilter).values();
    }

    public static StreamEx<int[]> ofPermutations(int length) {
        return StreamEx.of(new PermutationSpliterator(length));
    }

    public static StreamEx<int[]> ofCombinations(int n, int k) {
        Internals.checkNonNegative("k", k);
        Internals.checkNonNegative("n", n);
        if (k > n) {
            return StreamEx.empty();
        }
        if (k == 0) {
            return StreamEx.of(new int[0]);
        }
        long size = CombinationSpliterator.cnk(n, k);
        int[] value = new int[k];
        for (int i = 0; i < k; ++i) {
            value[i] = i;
        }
        return StreamEx.of(new CombinationSpliterator(n, size, 0L, value));
    }

    public static StreamEx<String> split(CharSequence str, Pattern pattern) {
        if (str.length() == 0) {
            return StreamEx.of("");
        }
        return new StreamEx<String>(pattern.splitAsStream(str), StreamContext.SEQUENTIAL);
    }

    public static StreamEx<String> split(CharSequence str, String regex) {
        if (str.length() == 0) {
            return StreamEx.of("");
        }
        if (regex.isEmpty()) {
            return IntStreamEx.ofChars(str).mapToObj(ch -> String.valueOf((char)ch));
        }
        char ch2 = regex.charAt(0);
        if (regex.length() == 1 && StreamEx.isNotRegexSpecialCaseStarter(ch2)) {
            return StreamEx.split(str, ch2);
        }
        if (regex.length() == 2 && ch2 == '\\' && StreamEx.isTransparentlyQuotableCharacter(ch2 = regex.charAt(1))) {
            return StreamEx.split(str, ch2);
        }
        return new StreamEx<String>(Pattern.compile(regex).splitAsStream(str), StreamContext.SEQUENTIAL);
    }

    private static boolean isNotRegexSpecialCaseStarter(char ch) {
        return ".$|()[{^?*+\\".indexOf(ch) == -1;
    }

    private static boolean isTransparentlyQuotableCharacter(char ch) {
        return !(ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z');
    }

    public static StreamEx<String> split(CharSequence str, char delimiter) {
        return StreamEx.split(str, delimiter, true);
    }

    public static StreamEx<String> split(CharSequence str, char delimiter, boolean trimEmpty) {
        if (str.length() == 0) {
            return StreamEx.of("");
        }
        return StreamEx.of(new CharSpliterator(str, delimiter, trimEmpty));
    }

    public static <T> StreamEx<T> iterate(T seed, UnaryOperator<T> f) {
        return StreamEx.iterate(seed, Internals.alwaysTrue(), f);
    }

    public static <T> StreamEx<T> iterate(final T seed, final Predicate<? super T> predicate, final UnaryOperator<T> f) {
        Objects.requireNonNull(f);
        Objects.requireNonNull(predicate);
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1040){
            T prev;
            boolean started;
            boolean finished;

            @Override
            public boolean tryAdvance(Consumer<? super T> action2) {
                Object t;
                Objects.requireNonNull(action2);
                if (this.finished) {
                    return false;
                }
                if (this.started) {
                    t = f.apply(this.prev);
                } else {
                    t = seed;
                    this.started = true;
                }
                if (!predicate.test(t)) {
                    this.prev = null;
                    this.finished = true;
                    return false;
                }
                this.prev = t;
                action2.accept(this.prev);
                return true;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action2) {
                Objects.requireNonNull(action2);
                if (this.finished) {
                    return;
                }
                this.finished = true;
                Object t = this.started ? f.apply(this.prev) : seed;
                this.prev = null;
                while (predicate.test(t)) {
                    action2.accept(t);
                    t = f.apply(t);
                }
            }
        };
        return StreamEx.of(spliterator);
    }

    public static <T> StreamEx<T> generate(Supplier<T> s) {
        return new StreamEx<T>(Stream.generate(s), StreamContext.SEQUENTIAL);
    }

    public static <T> StreamEx<T> produce(Predicate<Consumer<? super T>> producer) {
        Internals.Box box = new Internals.Box();
        box.a = action2 -> producer.test(action2) ? (Emitter)box.a : null;
        return box.a.stream();
    }

    public static <T> StreamEx<T> constant(T value, long length) {
        return StreamEx.of(new ConstSpliterator.OfRef<T>(value, length, false));
    }

    public static <U, T> StreamEx<T> ofPairs(List<U> list, BiFunction<? super U, ? super U, ? extends T> mapper) {
        return StreamEx.of(new PairPermutationSpliterator<U, T>(list, mapper));
    }

    public static <U, T> StreamEx<T> ofPairs(U[] array2, BiFunction<? super U, ? super U, ? extends T> mapper) {
        return StreamEx.ofPairs(Arrays.asList(array2), mapper);
    }

    public static <U, V, T> StreamEx<T> zip(List<U> first2, List<V> second2, BiFunction<? super U, ? super V, ? extends T> mapper) {
        return StreamEx.of(new RangeBasedSpliterator.ZipRef<U, V, T>(0, Internals.checkLength(first2.size(), second2.size()), mapper, first2, second2));
    }

    public static <U, V, T> StreamEx<T> zip(U[] first2, V[] second2, BiFunction<? super U, ? super V, ? extends T> mapper) {
        return StreamEx.zip(Arrays.asList(first2), Arrays.asList(second2), mapper);
    }

    public static <T> StreamEx<T> ofTree(T root, Function<T, Stream<T>> mapper) {
        TreeSpliterator.Plain<T> spliterator = new TreeSpliterator.Plain<T>(root, mapper);
        return new StreamEx<T>(spliterator, StreamContext.SEQUENTIAL.onClose(spliterator));
    }

    public static <T, TT extends T> StreamEx<T> ofTree(T root, Class<TT> collectionClass, Function<TT, Stream<T>> mapper) {
        return StreamEx.ofTree(root, t -> collectionClass.isInstance(t) ? (Stream)mapper.apply(t) : null);
    }

    public static <T> StreamEx<List<T>> ofSubLists(List<T> source, int length) {
        return StreamEx.ofSubLists(source, length, length);
    }

    public static <T> StreamEx<List<T>> ofSubLists(List<T> source, int length, int shift) {
        if (length <= 0) {
            throw new IllegalArgumentException("length = " + length);
        }
        if (shift <= 0) {
            throw new IllegalArgumentException("shift = " + shift);
        }
        if (source.isEmpty()) {
            return StreamEx.empty();
        }
        return StreamEx.of(new RangeBasedSpliterator.OfSubLists<T>(source, length, shift));
    }

    public static <T> StreamEx<List<T>> cartesianProduct(Collection<? extends Collection<T>> source) {
        if (source.isEmpty()) {
            return StreamEx.of(new ConstSpliterator.OfRef(Collections.emptyList(), 1L, true));
        }
        return StreamEx.of(new CrossSpliterator.ToList(source));
    }

    public static <T, U> StreamEx<U> cartesianProduct(Collection<? extends Collection<T>> source, U identity, BiFunction<U, ? super T, U> accumulator) {
        if (source.isEmpty()) {
            return StreamEx.of(identity);
        }
        return StreamEx.of(new CrossSpliterator.Reducing<T, U>(source, identity, accumulator));
    }

    public static <T> StreamEx<List<T>> cartesianPower(int n, Collection<T> source) {
        if (n == 0) {
            return StreamEx.of(new ConstSpliterator.OfRef(Collections.emptyList(), 1L, true));
        }
        return StreamEx.of(new CrossSpliterator.ToList<T>(Collections.nCopies(n, source)));
    }

    public static <T, U> StreamEx<U> cartesianPower(int n, Collection<T> source, U identity, BiFunction<U, ? super T, U> accumulator) {
        if (n == 0) {
            return StreamEx.of(identity);
        }
        return StreamEx.of(new CrossSpliterator.Reducing<T, U>(Collections.nCopies(n, source), identity, accumulator));
    }

    @FunctionalInterface
    public static interface Emitter<T> {
        public Emitter<T> next(Consumer<? super T> var1);

        default public Spliterator<T> spliterator() {
            return new EmitterSpliterator(this);
        }

        default public StreamEx<T> stream() {
            return StreamEx.of(this.spliterator());
        }
    }
}

