/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import one.util.streamex.BaseStreamEx;
import one.util.streamex.DistinctSpliterator;
import one.util.streamex.DoubleStreamEx;
import one.util.streamex.IfEmptySpliterator;
import one.util.streamex.IntStreamEx;
import one.util.streamex.Internals;
import one.util.streamex.LongStreamEx;
import one.util.streamex.MoreCollectors;
import one.util.streamex.OrderedCancellableSpliterator;
import one.util.streamex.PairSpliterator;
import one.util.streamex.PrefixOps;
import one.util.streamex.StreamContext;
import one.util.streamex.StreamEx;
import one.util.streamex.TailConcatSpliterator;
import one.util.streamex.TakeDrop;
import one.util.streamex.UnorderedCancellableSpliterator;
import one.util.streamex.VerSpec;

public abstract class AbstractStreamEx<T, S extends AbstractStreamEx<T, S>>
extends BaseStreamEx<T, Stream<T>, Spliterator<T>, S>
implements Stream<T>,
Iterable<T> {
    AbstractStreamEx(Stream<? extends T> stream, StreamContext context2) {
        super(stream, context2);
    }

    AbstractStreamEx(Spliterator<? extends T> spliterator, StreamContext context2) {
        super(spliterator, context2);
    }

    @Override
    final Stream<T> createStream() {
        return StreamSupport.stream(this.spliterator, this.context.parallel);
    }

    final <K, V, M extends Map<K, V>> M toMapThrowing(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valMapper, M map2) {
        this.forEach(t -> AbstractStreamEx.addToMap(map2, keyMapper.apply(t), Objects.requireNonNull(valMapper.apply(t))));
        return map2;
    }

    static <K, V, M extends Map<K, V>> void addToMap(M map2, K key, V val) {
        V oldVal = map2.putIfAbsent(key, val);
        if (oldVal != null) {
            throw new IllegalStateException("Duplicate entry for key '" + key + "' (attempt to merge values '" + oldVal + "' and '" + val + "')");
        }
    }

    <R, A> R rawCollect(Collector<? super T, A, R> collector2) {
        if (this.context.fjp != null) {
            return (R)this.context.terminate(collector2, ((Stream)this.stream())::collect);
        }
        return ((Stream)this.stream()).collect(collector2);
    }

    S appendSpliterator(Stream<? extends T> other, Spliterator<? extends T> right) {
        if (right.getExactSizeIfKnown() == 0L) {
            return (S)this;
        }
        Spliterator left = this.spliterator();
        Spliterator<Object> result2 = left.getExactSizeIfKnown() == 0L ? right : new TailConcatSpliterator<T>(left, right);
        this.context = this.context.combine(other);
        return this.supply(result2);
    }

    S prependSpliterator(Stream<? extends T> other, Spliterator<? extends T> left) {
        if (left.getExactSizeIfKnown() == 0L) {
            return (S)this;
        }
        Spliterator right = this.spliterator();
        Spliterator<Object> result2 = right.getExactSizeIfKnown() == 0L ? left : new TailConcatSpliterator<T>(left, right);
        this.context = this.context.combine(other);
        return this.supply(result2);
    }

    S ifEmpty(Stream<? extends T> other, Spliterator<? extends T> right) {
        if (right.getExactSizeIfKnown() == 0L) {
            return (S)this;
        }
        Spliterator left = this.spliterator();
        Spliterator<Object> result2 = left.getExactSizeIfKnown() == 0L ? right : new IfEmptySpliterator<T>(left, right);
        this.context = this.context.combine(other);
        return this.supply(result2);
    }

    abstract S supply(Stream<T> var1);

    abstract S supply(Spliterator<T> var1);

    @Override
    public Iterator<T> iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public S sequential() {
        return (S)((AbstractStreamEx)super.sequential());
    }

    @Override
    public S parallel() {
        return (S)((AbstractStreamEx)super.parallel());
    }

    @Override
    public S parallel(ForkJoinPool fjp) {
        return (S)((AbstractStreamEx)super.parallel(fjp));
    }

    @Override
    public S unordered() {
        return (S)((AbstractStreamEx)super.unordered());
    }

    @Override
    public S onClose(Runnable closeHandler) {
        return (S)((AbstractStreamEx)super.onClose(closeHandler));
    }

    public S filter(Predicate<? super T> predicate) {
        return this.supply(((Stream)this.stream()).filter(predicate));
    }

    @Override
    public <R> StreamEx<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return new StreamEx(((Stream)this.stream()).flatMap(mapper), this.context);
    }

    @Override
    public <R> StreamEx<R> map(Function<? super T, ? extends R> mapper) {
        return new StreamEx<R>(((Stream)this.stream()).map(mapper), this.context);
    }

    @Override
    public IntStreamEx mapToInt(ToIntFunction<? super T> mapper) {
        return new IntStreamEx(((Stream)this.stream()).mapToInt(mapper), this.context);
    }

    @Override
    public LongStreamEx mapToLong(ToLongFunction<? super T> mapper) {
        return new LongStreamEx(((Stream)this.stream()).mapToLong(mapper), this.context);
    }

    @Override
    public DoubleStreamEx mapToDouble(ToDoubleFunction<? super T> mapper) {
        return new DoubleStreamEx(((Stream)this.stream()).mapToDouble(mapper), this.context);
    }

    @Override
    public IntStreamEx flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return new IntStreamEx(((Stream)this.stream()).flatMapToInt(mapper), this.context);
    }

    @Override
    public LongStreamEx flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return new LongStreamEx(((Stream)this.stream()).flatMapToLong(mapper), this.context);
    }

    @Override
    public DoubleStreamEx flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return new DoubleStreamEx(((Stream)this.stream()).flatMapToDouble(mapper), this.context);
    }

    public S intersperse(T delimiter) {
        return this.supply(((Stream)this.stream()).flatMap((? super T s) -> StreamEx.of(delimiter, s)).skip(1L));
    }

    public S distinct() {
        return this.supply(((Stream)this.stream()).distinct());
    }

    public S distinct(Function<? super T, ?> keyExtractor) {
        return this.supply(((Stream)this.stream()).map((? super T t) -> new Internals.PairBox(t, keyExtractor.apply(t))).distinct().map((? super T box) -> box.a));
    }

    public S distinct(long atLeast) {
        if (atLeast <= 1L) {
            return (S)this.distinct();
        }
        Spliterator spliterator = this.spliterator();
        Spliterator result2 = spliterator.hasCharacteristics(1) ? Spliterators.emptySpliterator() : new DistinctSpliterator(spliterator, atLeast);
        return this.supply(result2);
    }

    public S sorted() {
        return this.supply(((Stream)this.stream()).sorted());
    }

    public S sorted(Comparator<? super T> comparator) {
        return this.supply(((Stream)this.stream()).sorted(comparator));
    }

    public S peek(Consumer<? super T> action2) {
        return this.supply(((Stream)this.stream()).peek(action2));
    }

    public S limit(long maxSize) {
        return this.supply(((Stream)this.stream()).limit(maxSize));
    }

    public S skip(long n) {
        return this.supply(((Stream)this.stream()).skip(n));
    }

    @Override
    public void forEach(Consumer<? super T> action2) {
        if (this.spliterator != null && !this.isParallel()) {
            this.spliterator().forEachRemaining(action2);
        } else if (this.context.fjp != null) {
            this.context.terminate(() -> {
                ((Stream)this.stream()).forEach(action2);
                return null;
            });
        } else {
            ((Stream)this.stream()).forEach(action2);
        }
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action2) {
        if (this.spliterator != null && !this.isParallel()) {
            this.spliterator().forEachRemaining(action2);
        } else if (this.context.fjp != null) {
            this.context.terminate(() -> {
                ((Stream)this.stream()).forEachOrdered(action2);
                return null;
            });
        } else {
            ((Stream)this.stream()).forEachOrdered(action2);
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArray(Object[]::new);
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        if (this.context.fjp != null) {
            return this.context.terminate(generator, ((Stream)this.stream())::toArray);
        }
        return ((Stream)this.stream()).toArray(generator);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        if (this.context.fjp != null) {
            return (T)this.context.terminate(() -> ((Stream)this.stream()).reduce(identity, accumulator));
        }
        return ((Stream)this.stream()).reduce(identity, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        if (this.context.fjp != null) {
            return this.context.terminate(accumulator, ((Stream)this.stream())::reduce);
        }
        return ((Stream)this.stream()).reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        if (this.context.fjp != null) {
            return (U)this.context.terminate(() -> ((Stream)this.stream()).reduce(identity, accumulator, combiner));
        }
        return ((Stream)this.stream()).reduce(identity, accumulator, combiner);
    }

    public Optional<T> reduceWithZero(T zero, BinaryOperator<T> accumulator) {
        return this.collect(MoreCollectors.reducingWithZero(zero, accumulator));
    }

    public T reduceWithZero(T zero, T identity, BinaryOperator<T> accumulator) {
        return this.collect(MoreCollectors.reducingWithZero(zero, identity, accumulator));
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        if (this.context.fjp != null) {
            return (R)this.context.terminate(() -> ((Stream)this.stream()).collect(supplier, accumulator, combiner));
        }
        return ((Stream)this.stream()).collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector2) {
        Predicate finished = Internals.finished(collector2);
        if (finished != null) {
            BiConsumer acc = collector2.accumulator();
            BinaryOperator<A> combiner = collector2.combiner();
            Spliterator spliterator = this.spliterator();
            if (!this.isParallel()) {
                Object a = collector2.supplier().get();
                if (!finished.test(a)) {
                    try {
                        spliterator.forEachRemaining(e -> {
                            acc.accept(a, (Object)e);
                            if (finished.test(a)) {
                                throw new Internals.CancelException();
                            }
                        });
                    }
                    catch (Internals.CancelException cancelException) {
                        // empty catch block
                    }
                }
                return collector2.finisher().apply(a);
            }
            Internals.CloneableSpliterator spltr = !spliterator.hasCharacteristics(16) || collector2.characteristics().contains((Object)Collector.Characteristics.UNORDERED) ? new UnorderedCancellableSpliterator<T, A>(spliterator, collector2.supplier(), acc, combiner, finished) : new OrderedCancellableSpliterator<T, A>(spliterator, collector2.supplier(), acc, combiner, finished);
            return collector2.finisher().apply(new StreamEx(StreamSupport.stream(spltr, true), this.context).findFirst().get());
        }
        return this.rawCollect(collector2);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.minBy(comparator));
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.maxBy(comparator));
    }

    @Override
    public long count() {
        if (this.context.fjp != null) {
            return this.context.terminate(((Stream)this.stream())::count);
        }
        return ((Stream)this.stream()).count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        if (this.context.fjp != null) {
            return this.context.terminate(predicate, ((Stream)this.stream())::anyMatch);
        }
        return ((Stream)this.stream()).anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        if (this.context.fjp != null) {
            return this.context.terminate(predicate, ((Stream)this.stream())::allMatch);
        }
        return ((Stream)this.stream()).allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        if (this.context.fjp != null) {
            return this.context.terminate(((Stream)this.stream())::findFirst);
        }
        return ((Stream)this.stream()).findFirst();
    }

    @Override
    public Optional<T> findAny() {
        if (this.context.fjp != null) {
            return this.context.terminate(((Stream)this.stream())::findAny);
        }
        return ((Stream)this.stream()).findAny();
    }

    public OptionalLong indexOf(T element) {
        return this.indexOf(Predicate.isEqual(element));
    }

    public OptionalLong indexOf(Predicate<? super T> predicate) {
        return this.collect(new Internals.CancellableCollectorImpl<Object, long[], OptionalLong>(() -> new long[]{-1L}, (acc, t) -> {
            acc[0] = predicate.test(t) ? -acc[0] - 1L : acc[0] - 1L;
        }, (acc1, acc2) -> {
            acc1[0] = acc2[0] < 0L ? acc1[0] + acc2[0] + 1L : acc2[0] - acc1[0] - 1L;
            return acc1;
        }, acc -> acc[0] < 0L ? OptionalLong.empty() : OptionalLong.of(acc[0]), acc -> acc[0] >= 0L, Internals.NO_CHARACTERISTICS));
    }

    public <R> StreamEx<R> flatCollection(Function<? super T, ? extends Collection<? extends R>> mapper) {
        return this.flatMap((T t) -> {
            Collection c = (Collection)mapper.apply(t);
            return c == null ? null : StreamEx.of(c.spliterator());
        });
    }

    public <R> StreamEx<R> flatArray(Function<? super T, ? extends R[]> mapper) {
        return this.flatMap((T t) -> {
            Object[] a = (Object[])mapper.apply(t);
            return a == null ? null : StreamEx.of(Arrays.spliterator(a));
        });
    }

    public <R> StreamEx<R> mapPartial(Function<? super T, ? extends Optional<? extends R>> mapper) {
        return new StreamEx<Object>(((Stream)this.stream()).map((? super T value) -> ((Optional)mapper.apply(value)).orElse(null)).filter(Objects::nonNull), this.context);
    }

    public <R> StreamEx<R> pairMap(BiFunction<? super T, ? super T, ? extends R> mapper) {
        PairSpliterator.PSOfRef<? super T, ? extends R> spliterator = new PairSpliterator.PSOfRef<T, R>(mapper, this.spliterator());
        return new StreamEx(spliterator, this.context);
    }

    public S remove(Predicate<? super T> predicate) {
        return (S)this.filter((Predicate)predicate.negate());
    }

    public S nonNull() {
        return (S)this.filter(Objects::nonNull);
    }

    public Optional<T> findAny(Predicate<? super T> predicate) {
        return ((AbstractStreamEx)this.filter((Predicate)predicate)).findAny();
    }

    public Optional<T> findFirst(Predicate<? super T> predicate) {
        return ((AbstractStreamEx)this.filter((Predicate)predicate)).findFirst();
    }

    public S reverseSorted(Comparator<? super T> comparator) {
        return (S)this.sorted((Comparator)comparator.reversed());
    }

    public <V extends Comparable<? super V>> S sortedBy(Function<? super T, ? extends V> keyExtractor) {
        return (S)this.sorted((Comparator)Comparator.comparing(keyExtractor));
    }

    public S sortedByInt(ToIntFunction<? super T> keyExtractor) {
        return (S)this.sorted((Comparator)Comparator.comparingInt(keyExtractor));
    }

    public S sortedByLong(ToLongFunction<? super T> keyExtractor) {
        return (S)this.sorted((Comparator)Comparator.comparingLong(keyExtractor));
    }

    public S sortedByDouble(ToDoubleFunction<? super T> keyExtractor) {
        return (S)this.sorted((Comparator)Comparator.comparingDouble(keyExtractor));
    }

    public <V extends Comparable<? super V>> Optional<T> minBy(Function<? super T, ? extends V> keyExtractor) {
        return Internals.Box.asOptional(this.reduce(null, (acc, t) -> {
            Comparable val = (Comparable)keyExtractor.apply(t);
            if (acc == null) {
                return new Internals.PairBox<Object, Comparable>(t, val);
            }
            if (val.compareTo(acc.b) < 0) {
                acc.b = val;
                acc.a = t;
            }
            return acc;
        }, (acc1, acc2) -> acc1 == null || acc2 != null && ((Comparable)acc1.b).compareTo(acc2.b) > 0 ? acc2 : acc1));
    }

    public Optional<T> minByInt(ToIntFunction<? super T> keyExtractor) {
        return Internals.Box.asOptional(this.reduce(null, (acc, t) -> {
            int val = keyExtractor.applyAsInt(t);
            if (acc == null) {
                return new Internals.ObjIntBox<Object>(t, val);
            }
            if (val < acc.b) {
                acc.b = val;
                acc.a = t;
            }
            return acc;
        }, (acc1, acc2) -> acc1 == null || acc2 != null && acc1.b > acc2.b ? acc2 : acc1));
    }

    public Optional<T> minByLong(ToLongFunction<? super T> keyExtractor) {
        return Internals.Box.asOptional(this.reduce(null, (acc, t) -> {
            long val = keyExtractor.applyAsLong(t);
            if (acc == null) {
                return new Internals.ObjLongBox<Object>(t, val);
            }
            if (val < acc.b) {
                acc.b = val;
                acc.a = t;
            }
            return acc;
        }, (acc1, acc2) -> acc1 == null || acc2 != null && acc1.b > acc2.b ? acc2 : acc1));
    }

    public Optional<T> minByDouble(ToDoubleFunction<? super T> keyExtractor) {
        return Internals.Box.asOptional(this.reduce(null, (acc, t) -> {
            double val = keyExtractor.applyAsDouble(t);
            if (acc == null) {
                return new Internals.ObjDoubleBox<Object>(t, val);
            }
            if (Double.compare(val, acc.b) < 0) {
                acc.b = val;
                acc.a = t;
            }
            return acc;
        }, (acc1, acc2) -> acc1 == null || acc2 != null && Double.compare(acc1.b, acc2.b) > 0 ? acc2 : acc1));
    }

    public <V extends Comparable<? super V>> Optional<T> maxBy(Function<? super T, ? extends V> keyExtractor) {
        return Internals.Box.asOptional(this.reduce(null, (acc, t) -> {
            Comparable val = (Comparable)keyExtractor.apply(t);
            if (acc == null) {
                return new Internals.PairBox<Object, Comparable>(t, val);
            }
            if (val.compareTo(acc.b) > 0) {
                acc.b = val;
                acc.a = t;
            }
            return acc;
        }, (acc1, acc2) -> acc1 == null || acc2 != null && ((Comparable)acc1.b).compareTo(acc2.b) < 0 ? acc2 : acc1));
    }

    public Optional<T> maxByInt(ToIntFunction<? super T> keyExtractor) {
        return Internals.Box.asOptional(this.reduce(null, (acc, t) -> {
            int val = keyExtractor.applyAsInt(t);
            if (acc == null) {
                return new Internals.ObjIntBox<Object>(t, val);
            }
            if (val > acc.b) {
                acc.b = val;
                acc.a = t;
            }
            return acc;
        }, (acc1, acc2) -> acc1 == null || acc2 != null && acc1.b < acc2.b ? acc2 : acc1));
    }

    public Optional<T> maxByLong(ToLongFunction<? super T> keyExtractor) {
        return Internals.Box.asOptional(this.reduce(null, (acc, t) -> {
            long val = keyExtractor.applyAsLong(t);
            if (acc == null) {
                return new Internals.ObjLongBox<Object>(t, val);
            }
            if (val > acc.b) {
                acc.b = val;
                acc.a = t;
            }
            return acc;
        }, (acc1, acc2) -> acc1 == null || acc2 != null && acc1.b < acc2.b ? acc2 : acc1));
    }

    public Optional<T> maxByDouble(ToDoubleFunction<? super T> keyExtractor) {
        return Internals.Box.asOptional(this.reduce(null, (acc, t) -> {
            double val = keyExtractor.applyAsDouble(t);
            if (acc == null) {
                return new Internals.ObjDoubleBox<Object>(t, val);
            }
            if (Double.compare(val, acc.b) > 0) {
                acc.b = val;
                acc.a = t;
            }
            return acc;
        }, (acc1, acc2) -> acc1 == null || acc2 != null && Double.compare(acc1.b, acc2.b) < 0 ? acc2 : acc1));
    }

    public S append(Stream<? extends T> other) {
        return this.appendSpliterator(other, other.spliterator());
    }

    public S prepend(Stream<? extends T> other) {
        return this.prependSpliterator(other, other.spliterator());
    }

    public S ifEmpty(Stream<? extends T> other) {
        return this.ifEmpty(other, other.spliterator());
    }

    @Override
    public List<T> toList() {
        return Internals.IMMUTABLE_TO_LIST ? this.toImmutableList() : this.toMutableList();
    }

    public List<T> toMutableList() {
        return new ArrayList<Object>(new Internals.ArrayCollection(this.toArray(Object[]::new)));
    }

    public List<T> toImmutableList() {
        A[] array2 = this.toArray(Object[]::new);
        switch (array2.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(array2[0]);
            }
        }
        return Collections.unmodifiableList(Arrays.asList(array2));
    }

    public <R> R toListAndThen(Function<? super List<T>, R> finisher) {
        if (this.context.fjp != null) {
            return (R)this.context.terminate(() -> finisher.apply(this.toMutableList()));
        }
        return finisher.apply(this.toMutableList());
    }

    public Set<T> toSet() {
        return Internals.IMMUTABLE_TO_LIST ? this.toImmutableSet() : this.toMutableSet();
    }

    public Set<T> toMutableSet() {
        return this.rawCollect(Collectors.toSet());
    }

    public Set<T> toImmutableSet() {
        Set<T> result2 = this.toMutableSet();
        if (result2.size() == 0) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(result2);
    }

    public <R> R toSetAndThen(Function<? super Set<T>, R> finisher) {
        if (this.context.fjp != null) {
            return (R)this.context.terminate(() -> finisher.apply(this.toMutableSet()));
        }
        return finisher.apply(this.toMutableSet());
    }

    public <C extends Collection<T>, R> R toCollectionAndThen(Supplier<C> collectionFactory, Function<? super C, R> finisher) {
        if (this.context.fjp != null) {
            return (R)this.context.terminate(() -> finisher.apply(this.toCollection(collectionFactory)));
        }
        return finisher.apply(this.toCollection(collectionFactory));
    }

    public <C extends Collection<T>> C toCollection(Supplier<C> collectionFactory) {
        return (C)((Collection)this.rawCollect(Collectors.toCollection(collectionFactory)));
    }

    public <U> U foldLeft(U seed, BiFunction<U, ? super T, U> accumulator) {
        Internals.Box<U> result2 = new Internals.Box<U>(seed);
        this.forEachOrdered(t -> {
            result2.a = accumulator.apply((Object)result2.a, (Object)t);
        });
        return (U)result2.a;
    }

    public Optional<T> foldLeft(BinaryOperator<T> accumulator) {
        Internals.Box result2 = new Internals.Box(Internals.none());
        this.forEachOrdered(t -> {
            result2.a = result2.a == Internals.NONE ? t : accumulator.apply(result2.a, t);
        });
        return result2.a == Internals.NONE ? Optional.empty() : Optional.of(result2.a);
    }

    public <U> U foldRight(U seed, BiFunction<? super T, U, U> accumulator) {
        return (U)this.toListAndThen(list -> {
            Object result2 = seed;
            for (int i = list.size() - 1; i >= 0; --i) {
                result2 = accumulator.apply((Object)list.get(i), (Object)result2);
            }
            return result2;
        });
    }

    public Optional<T> foldRight(BinaryOperator<T> accumulator) {
        return this.toListAndThen(list -> {
            if (list.isEmpty()) {
                return Optional.empty();
            }
            int i = list.size() - 1;
            Object result2 = list.get(i--);
            while (i >= 0) {
                result2 = accumulator.apply(list.get(i), result2);
                --i;
            }
            return Optional.of(result2);
        });
    }

    public <U> List<U> scanLeft(U seed, BiFunction<U, ? super T, U> accumulator) {
        ArrayList result2 = new ArrayList();
        result2.add(seed);
        this.forEachOrdered(t -> result2.add(accumulator.apply((Object)result2.get(result2.size() - 1), (Object)t)));
        return result2;
    }

    public List<T> scanLeft(BinaryOperator<T> accumulator) {
        ArrayList result2 = new ArrayList();
        this.forEachOrdered(t -> {
            if (result2.isEmpty()) {
                result2.add(t);
            } else {
                result2.add(accumulator.apply(result2.get(result2.size() - 1), t));
            }
        });
        return result2;
    }

    public <U> List<U> scanRight(U seed, BiFunction<? super T, U, U> accumulator) {
        return this.toListAndThen(list -> {
            List result2 = list;
            result2.add(seed);
            for (int i = result2.size() - 2; i >= 0; --i) {
                result2.set(i, accumulator.apply((Object)result2.get(i), (Object)result2.get(i + 1)));
            }
            return result2;
        });
    }

    public List<T> scanRight(BinaryOperator<T> accumulator) {
        return this.toListAndThen(list -> {
            for (int i = list.size() - 2; i >= 0; --i) {
                list.set(i, accumulator.apply(list.get(i), list.get(i + 1)));
            }
            return list;
        });
    }

    public S takeWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return VerSpec.VER_SPEC.callWhile(this, predicate, false);
    }

    public S takeWhileInclusive(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        Spliterator spltr = this.spliterator();
        return this.supply(spltr.hasCharacteristics(16) ? new TakeDrop.TDOfRef<T>(spltr, false, true, predicate) : new TakeDrop.UnorderedTDOfRef<T>(spltr, false, true, predicate));
    }

    public S dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return VerSpec.VER_SPEC.callWhile(this, predicate, true);
    }

    public S prefix(BinaryOperator<T> op) {
        Spliterator spltr = this.spliterator();
        return this.supply(spltr.hasCharacteristics(16) ? new PrefixOps.OfRef<T>(spltr, op) : new PrefixOps.OfUnordRef<T>(spltr, op));
    }

    @Override
    public <U> U chain(Function<? super S, U> mapper) {
        return mapper.apply(this);
    }
}

