/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import net.n3.nanoxml.CDATAReader;
import net.n3.nanoxml.ContentReader;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.IXMLValidator;
import net.n3.nanoxml.PIReader;
import net.n3.nanoxml.XMLEntityResolver;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLUtil;

public class StdXMLParser
implements IXMLParser {
    private IXMLBuilder builder = null;
    private IXMLReader reader = null;
    private IXMLEntityResolver entityResolver = new XMLEntityResolver();
    private IXMLValidator validator = null;

    protected void finalize() throws Throwable {
        this.builder = null;
        this.reader = null;
        this.entityResolver = null;
        this.validator = null;
        super.finalize();
    }

    public void setBuilder(IXMLBuilder iXMLBuilder) {
        this.builder = iXMLBuilder;
    }

    public IXMLBuilder getBuilder() {
        return this.builder;
    }

    public void setValidator(IXMLValidator iXMLValidator) {
        this.validator = iXMLValidator;
    }

    public IXMLValidator getValidator() {
        return this.validator;
    }

    public void setResolver(IXMLEntityResolver iXMLEntityResolver) {
        this.entityResolver = iXMLEntityResolver;
    }

    public IXMLEntityResolver getResolver() {
        return this.entityResolver;
    }

    public void setReader(IXMLReader iXMLReader) {
        this.reader = iXMLReader;
    }

    public IXMLReader getReader() {
        return this.reader;
    }

    public Object parse() throws XMLException {
        try {
            this.builder.startBuilding(this.reader.getSystemID(), this.reader.getLineNr());
            this.scanData();
            return this.builder.getResult();
        }
        catch (XMLException xMLException) {
            throw xMLException;
        }
        catch (Exception exception) {
            throw new XMLException(exception);
        }
    }

    protected void scanData() throws Exception {
        while (!this.reader.atEOF() && this.builder.getResult() == null) {
            String string2 = XMLUtil.read(this.reader, '&');
            char c = string2.charAt(0);
            if (c == '&') {
                XMLUtil.processEntity(string2, this.reader, this.entityResolver);
                continue;
            }
            switch (c) {
                case '<': {
                    this.scanSomeTag(false, null, new Properties());
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    XMLUtil.errorInvalidInput(this.reader.getSystemID(), this.reader.getLineNr(), "`" + c + "' (0x" + Integer.toHexString(c) + ')');
                }
            }
        }
    }

    protected void scanSomeTag(boolean bl, String string2, Properties properties) throws Exception {
        String string3 = XMLUtil.read(this.reader, '&');
        char c = string3.charAt(0);
        if (c == '&') {
            XMLUtil.errorUnexpectedEntity(this.reader.getSystemID(), this.reader.getLineNr(), string3);
        }
        switch (c) {
            case '?': {
                this.processPI();
                break;
            }
            case '!': {
                this.processSpecialTag(bl);
                break;
            }
            default: {
                this.reader.unread(c);
                this.processElement(string2, properties);
            }
        }
    }

    protected void processPI() throws Exception {
        XMLUtil.skipWhitespace(this.reader, null);
        String string2 = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        PIReader pIReader = new PIReader(this.reader);
        if (!string2.equalsIgnoreCase("xml")) {
            this.builder.newProcessingInstruction(string2, pIReader);
        }
        ((Reader)pIReader).close();
    }

    protected void processSpecialTag(boolean bl) throws Exception {
        String string2 = XMLUtil.read(this.reader, '&');
        char c = string2.charAt(0);
        if (c == '&') {
            XMLUtil.errorUnexpectedEntity(this.reader.getSystemID(), this.reader.getLineNr(), string2);
        }
        switch (c) {
            case '[': {
                if (bl) {
                    this.processCDATA();
                } else {
                    XMLUtil.errorUnexpectedCDATA(this.reader.getSystemID(), this.reader.getLineNr());
                }
                return;
            }
            case 'D': {
                this.processDocType();
                return;
            }
            case '-': {
                XMLUtil.skipComment(this.reader);
                return;
            }
        }
    }

    protected void processCDATA() throws Exception {
        if (!XMLUtil.checkLiteral(this.reader, "CDATA[")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "<![[CDATA[");
        }
        this.validator.PCDataAdded(this.reader.getSystemID(), this.reader.getLineNr());
        CDATAReader cDATAReader = new CDATAReader(this.reader);
        this.builder.addPCData(cDATAReader, this.reader.getSystemID(), this.reader.getLineNr());
        ((Reader)cDATAReader).close();
    }

    protected void processDocType() throws Exception {
        if (!XMLUtil.checkLiteral(this.reader, "OCTYPE")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "<!DOCTYPE");
            return;
        }
        XMLUtil.skipWhitespace(this.reader, null);
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        char c = this.reader.read();
        if (c == 'P') {
            string2 = XMLUtil.scanPublicID(stringBuffer, this.reader);
            XMLUtil.skipWhitespace(this.reader, null);
            c = this.reader.read();
        } else if (c == 'S') {
            string2 = XMLUtil.scanSystemID(this.reader);
            XMLUtil.skipWhitespace(this.reader, null);
            c = this.reader.read();
        }
        if (c == '[') {
            this.validator.parseDTD(stringBuffer.toString(), this.reader, this.entityResolver, false);
            XMLUtil.skipWhitespace(this.reader, null);
            c = this.reader.read();
        }
        if (c != '>') {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`>'");
        }
        if (string2 != null) {
            Reader reader = this.reader.openStream(stringBuffer.toString(), string2);
            this.reader.startNewStream(reader);
            this.reader.setSystemID(string2);
            this.reader.setPublicID(stringBuffer.toString());
            this.validator.parseDTD(stringBuffer.toString(), this.reader, this.entityResolver, true);
        }
    }

    protected void processElement(String string2, Properties properties) throws Exception {
        Object object;
        String string3;
        CharSequence charSequence;
        String string4;
        char c;
        String string5;
        String string6 = string5 = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        String string7 = null;
        int n = string6.indexOf(58);
        if (n > 0) {
            string7 = string6.substring(0, n);
            string6 = string6.substring(n + 1);
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        this.validator.elementStarted(string5, this.reader.getSystemID(), this.reader.getLineNr());
        while ((c = this.reader.read()) != '/' && c != '>') {
            this.reader.unread(c);
            this.processAttribute(vector, vector2, vector3);
            XMLUtil.skipWhitespace(this.reader, null);
        }
        Properties properties2 = new Properties();
        this.validator.elementAttributesProcessed(string5, properties2, this.reader.getSystemID(), this.reader.getLineNr());
        Enumeration enumeration = ((Hashtable)properties2).keys();
        while (enumeration.hasMoreElements()) {
            String string8 = (String)enumeration.nextElement();
            string4 = properties2.getProperty(string8);
            vector.addElement(string8);
            vector2.addElement(string4);
            vector3.addElement("CDATA");
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            string4 = (String)vector.elementAt(n2);
            charSequence = (String)vector2.elementAt(n2);
            string3 = (String)vector3.elementAt(n2);
            if (string4.equals("xmlns")) {
                string2 = charSequence;
            } else if (string4.startsWith("xmlns:")) {
                ((Hashtable)properties).put(string4.substring(6), charSequence);
            }
            ++n2;
        }
        if (string7 == null) {
            this.builder.startElement(string6, string7, string2, this.reader.getSystemID(), this.reader.getLineNr());
        } else {
            this.builder.startElement(string6, string7, properties.getProperty(string7), this.reader.getSystemID(), this.reader.getLineNr());
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            charSequence = (String)vector.elementAt(n3);
            if (!((String)charSequence).startsWith("xmlns")) {
                string3 = (String)vector2.elementAt(n3);
                object = (String)vector3.elementAt(n3);
                n = ((String)charSequence).indexOf(58);
                if (n > 0) {
                    String string9 = ((String)charSequence).substring(0, n);
                    charSequence = ((String)charSequence).substring(n + 1);
                    this.builder.addAttribute((String)charSequence, string9, properties.getProperty(string9), string3, (String)object);
                } else {
                    this.builder.addAttribute((String)charSequence, null, null, string3, (String)object);
                }
            }
            ++n3;
        }
        if (string7 == null) {
            this.builder.elementAttributesProcessed(string6, string7, string2);
        } else {
            this.builder.elementAttributesProcessed(string6, string7, properties.getProperty(string7));
        }
        if (c == '/') {
            if (this.reader.read() != '>') {
                XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`>'");
            }
            this.validator.elementEnded(string6, this.reader.getSystemID(), this.reader.getLineNr());
            if (string7 == null) {
                this.builder.endElement(string6, string7, string2);
            } else {
                this.builder.endElement(string6, string7, properties.getProperty(string7));
            }
            return;
        }
        charSequence = new StringBuffer(16);
        while (true) {
            ((StringBuffer)charSequence).setLength(0);
            while (true) {
                XMLUtil.skipWhitespace(this.reader, (StringBuffer)charSequence);
                string3 = XMLUtil.read(this.reader, '&');
                if (string3.charAt(0) != '&' || string3.charAt(1) == '#') break;
                XMLUtil.processEntity(string3, this.reader, this.entityResolver);
            }
            if (string3.charAt(0) == '<') {
                string3 = XMLUtil.read(this.reader, '\u0000');
                if (string3.charAt(0) == '/') {
                    XMLUtil.skipWhitespace(this.reader, null);
                    string3 = XMLUtil.scanIdentifier(this.reader);
                    if (!string3.equals(string5)) {
                        XMLUtil.errorWrongClosingTag(this.reader.getSystemID(), this.reader.getLineNr(), string6, string3);
                    }
                    XMLUtil.skipWhitespace(this.reader, null);
                    if (this.reader.read() != '>') {
                        XMLUtil.errorClosingTagNotEmpty(this.reader.getSystemID(), this.reader.getLineNr());
                    }
                    this.validator.elementEnded(string5, this.reader.getSystemID(), this.reader.getLineNr());
                    if (string7 == null) {
                        this.builder.endElement(string6, string7, string2);
                        break;
                    }
                    this.builder.endElement(string6, string7, properties.getProperty(string7));
                    break;
                }
                this.reader.unread(string3.charAt(0));
                this.scanSomeTag(true, string2, (Properties)((Hashtable)properties).clone());
                continue;
            }
            if (string3.charAt(0) == '&') {
                c = XMLUtil.processCharLiteral(string3);
                ((StringBuffer)charSequence).append(c);
            } else {
                this.reader.unread(string3.charAt(0));
            }
            this.validator.PCDataAdded(this.reader.getSystemID(), this.reader.getLineNr());
            object = new ContentReader(this.reader, this.entityResolver, ((StringBuffer)charSequence).toString());
            this.builder.addPCData((Reader)object, this.reader.getSystemID(), this.reader.getLineNr());
            ((Reader)object).close();
        }
    }

    protected void processAttribute(Vector vector, Vector vector2, Vector vector3) throws Exception {
        String string2 = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        if (!XMLUtil.read(this.reader, '&').equals("=")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`='");
        }
        XMLUtil.skipWhitespace(this.reader, null);
        String string3 = XMLUtil.scanString(this.reader, '&', this.entityResolver);
        vector.addElement(string2);
        vector2.addElement(string3);
        vector3.addElement("CDATA");
        this.validator.attributeAdded(string2, string3, this.reader.getSystemID(), this.reader.getLineNr());
    }
}

