/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TLongHashingStrategy;
import gnu.trove.TLongProcedure;
import gnu.trove.TPrimitiveHash;

public abstract class TLongHash
extends TPrimitiveHash
implements TLongHashingStrategy {
    protected transient long[] _set;
    protected final TLongHashingStrategy _hashingStrategy;

    public TLongHash() {
        this._hashingStrategy = this;
    }

    public TLongHash(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TLongHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TLongHash(TLongHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TLongHash(int initialCapacity, TLongHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TLongHash(int initialCapacity, float loadFactor, TLongHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    @Override
    public Object clone() {
        TLongHash h = (TLongHash)super.clone();
        h._set = this._set == null ? null : (long[])this._set.clone();
        return h;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = initialCapacity == -1 ? null : new long[capacity];
        return capacity;
    }

    public boolean contains(long val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TLongProcedure procedure) {
        byte[] states = this._states;
        long[] set = this._set;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(set[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void removeAt(int index2) {
        this._set[index2] = 0L;
        super.removeAt(index2);
    }

    protected int index(long val) {
        byte[] states = this._states;
        if (states == null) {
            return -1;
        }
        long[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (states[index2] != 0 && (states[index2] == 2 || set[index2] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            } while (states[index2] != 0 && (states[index2] == 2 || set[index2] != val));
        }
        return states[index2] == 0 ? -1 : index2;
    }

    protected int insertionIndex(long val) {
        if (this._set == null) {
            this.setUp(6);
        }
        byte[] states = this._states;
        long[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (states[index2] == 0) {
            return index2;
        }
        if (states[index2] == 1 && set[index2] == val) {
            return -index2 - 1;
        }
        int probe = 1 + hash % (length - 2);
        do {
            if ((index2 -= probe) >= 0) continue;
            index2 += length;
        } while (states[index2] == 1 && set[index2] != val);
        if (states[index2] == 2) {
            int firstRemoved = index2;
            while (states[index2] != 0 && (states[index2] == 2 || set[index2] != val)) {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            }
            return states[index2] == 1 ? -index2 - 1 : firstRemoved;
        }
        return states[index2] == 1 ? -index2 - 1 : index2;
    }

    @Override
    public final int computeHashCode(long val) {
        return HashFunctions.hash(val);
    }
}

