/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl.url;

import com.intellij.workspaceModel.storage.impl.IntIdGenerator;
import com.intellij.workspaceModel.storage.impl.VirtualFileNameStore;
import com.intellij.workspaceModel.storage.impl.url.VirtualFileUrlImpl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\f\b\u0016\u0018\u0000 <2\u00020\u0001:\u0002<=B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0018\u00010\tR\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u0011J$\u0010\u0012\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0018\u00010\tR\u00020\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0002J\u001d\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0018J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000H\u0014J\u0016\u0010\u001d\u001a\b\u0018\u00010\tR\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u001e\u001a\b\u0018\u00010\tR\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u001bH\u0002J\u0016\u0010\u001e\u001a\b\u0018\u00010\tR\u00020\u00002\u0006\u0010 \u001a\u00020\u000fH\u0002J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u000fH\u0016J\u0016\u0010$\u001a\u00020\u00042\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0016J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014J\b\u0010'\u001a\u00020\u0004H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u00042\u0006\u0010)\u001a\u00020\u0004H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010)\u001a\u00020\u0004H\u0016J\u000e\u0010+\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u001bJ\u0006\u00100\u001a\u00020\u000fJ\u0015\u00101\u001a\u0002022\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b3J\u0010\u00104\u001a\u0002022\u0006\u0010\u001f\u001a\u00020\u001bH\u0002J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u00106\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u000fH\u0002J\u001d\u00108\u001a\u0002022\u0006\u00109\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b;R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl;", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "()V", "emptyUrl", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "fileNameStore", "Lcom/intellij/workspaceModel/storage/impl/VirtualFileNameStore;", "id2NodeMapping", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode;", "idGenerator", "Lcom/intellij/workspaceModel/storage/impl/IntIdGenerator;", "rootNode", "add", "path", "", "parentNode", "add$intellij_platform_workspaceModel_storage", "addSegments", "segments", "", "append", "parentVfu", "relativePath", "append$intellij_platform_workspaceModel_storage", "createVirtualFileUrl", "id", "", "manager", "findLatestFilePathNode", "findRootNode", "contentId", "segment", "fromPath", "fromUrl", "url", "fromUrlSegments", "urls", "getCachedVirtualFileUrls", "getEmptyUrl", "getParentVirtualUrl", "vfu", "getSubtreeVirtualUrlsById", "getUrlById", "isEqualOrParentOf", "", "parentNodeId", "childNodeId", "print", "remove", "", "remove$intellij_platform_workspaceModel_storage", "removeNameUsage", "splitNames", "toSystemIndependentName", "fileName", "update", "oldPath", "newPath", "update$intellij_platform_workspaceModel_storage", "Companion", "FilePathNode", "intellij.platform.workspaceModel.storage"})
public class VirtualFileUrlManagerImpl
implements VirtualFileUrlManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final IntIdGenerator idGenerator = new IntIdGenerator();
    @Nullable
    private VirtualFileUrl emptyUrl;
    @NotNull
    private final VirtualFileNameStore fileNameStore = new VirtualFileNameStore();
    @NotNull
    private final Int2ObjectOpenHashMap<FilePathNode> id2NodeMapping = new Int2ObjectOpenHashMap();
    @NotNull
    private final FilePathNode rootNode = new FilePathNode(this, 0, 0, null, 4, null);
    @Deprecated
    @NotNull
    private static final Hash.Strategy<FilePathNode> HASHING_STRATEGY = new Hash.Strategy<FilePathNode>(){

        public boolean equals(@Nullable FilePathNode node1, @Nullable FilePathNode node2) {
            if (node1 == node2) {
                return true;
            }
            if (node1 == null || node2 == null) {
                return false;
            }
            return node1.getContentId() == node2.getContentId();
        }

        public int hashCode(@Nullable FilePathNode node) {
            FilePathNode filePathNode = node;
            return filePathNode != null ? filePathNode.getContentId() : 0;
        }
    };

    @Override
    @NotNull
    public synchronized VirtualFileUrl fromUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (((CharSequence)url).length() == 0) {
            return this.getEmptyUrl();
        }
        return VirtualFileUrlManagerImpl.add$intellij_platform_workspaceModel_storage$default(this, url, null, 2, null);
    }

    @Override
    @NotNull
    public VirtualFileUrl fromUrlSegments(@NotNull List<String> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        if (urls.isEmpty()) {
            return this.getEmptyUrl();
        }
        return this.addSegments(null, urls);
    }

    @Override
    @NotNull
    public VirtualFileUrl fromPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.fromUrl("file://" + this.toSystemIndependentName(path));
    }

    private final String toSystemIndependentName(String fileName) {
        return StringsKt.replace$default((String)fileName, (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    @Override
    @Nullable
    public synchronized VirtualFileUrl getParentVirtualUrl(@NotNull VirtualFileUrl vfu) {
        Intrinsics.checkNotNullParameter((Object)vfu, (String)"vfu");
        VirtualFileUrlImpl cfr_ignored_0 = (VirtualFileUrlImpl)vfu;
        FilePathNode filePathNode = this.id2NodeMapping.get(((VirtualFileUrlImpl)vfu).getId());
        return filePathNode != null && (filePathNode = filePathNode.getParent()) != null ? filePathNode.getVirtualFileUrl(this) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public synchronized List<VirtualFileUrl> getSubtreeVirtualUrlsById(@NotNull VirtualFileUrl vfu) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)vfu, (String)"vfu");
        VirtualFileUrlImpl cfr_ignored_0 = (VirtualFileUrlImpl)vfu;
        Iterable $this$map$iv = this.id2NodeMapping.get(((VirtualFileUrlImpl)vfu).getId()).getSubtreeNodes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FilePathNode filePathNode = (FilePathNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getVirtualFileUrl(this));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final synchronized String getUrlById(int id) {
        if (id <= 0) {
            return "";
        }
        IntArrayList contentIds = new IntArrayList();
        for (FilePathNode node = this.id2NodeMapping.get(id); node != null; node = node.getParent()) {
            contentIds.add(node.getContentId());
        }
        if (contentIds.size() == 1) {
            String string2;
            String string3 = this.fileNameStore.getNameForId(contentIds.getInt(0));
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                string2 = ((CharSequence)it).length() == 0 ? "/" : it;
            } else {
                string2 = "";
            }
            return string2;
        }
        StringBuilder builder = new StringBuilder();
        for (int index2 = contentIds.size() - 1; -1 < index2; --index2) {
            builder.append(this.fileNameStore.getNameForId(contentIds.getInt(index2)));
            if (index2 == 0) continue;
            builder.append("/");
        }
        String string4 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"builder.toString()");
        return string4;
    }

    @NotNull
    public final synchronized VirtualFileUrl append$intellij_platform_workspaceModel_storage(@NotNull VirtualFileUrl parentVfu, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)parentVfu, (String)"parentVfu");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFileUrlImpl cfr_ignored_0 = (VirtualFileUrlImpl)parentVfu;
        return this.add$intellij_platform_workspaceModel_storage(relativePath, this.id2NodeMapping.get(((VirtualFileUrlImpl)parentVfu).getId()));
    }

    @NotNull
    protected VirtualFileUrl createVirtualFileUrl(int id, @NotNull VirtualFileUrlManagerImpl manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        return new VirtualFileUrlImpl(id, manager);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VirtualFileUrl> getCachedVirtualFileUrls() {
        void $this$mapNotNullTo$iv$iv;
        Collection collection = this.id2NodeMapping.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"id2NodeMapping.values");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFileUrl it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FilePathNode p0 = (FilePathNode)element$iv$iv;
            boolean bl2 = false;
            if (p0.getCachedVirtualFileUrl() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final VirtualFileUrl add$intellij_platform_workspaceModel_storage(@NotNull String path, @Nullable FilePathNode parentNode) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        List<String> segments = this.splitNames(path);
        return this.addSegments(parentNode, segments);
    }

    public static /* synthetic */ VirtualFileUrl add$intellij_platform_workspaceModel_storage$default(VirtualFileUrlManagerImpl virtualFileUrlManagerImpl, String string2, FilePathNode filePathNode, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
        }
        if ((n & 2) != 0) {
            filePathNode = null;
        }
        return virtualFileUrlManagerImpl.add$intellij_platform_workspaceModel_storage(string2, filePathNode);
    }

    private final VirtualFileUrl addSegments(FilePathNode parentNode, List<String> segments) {
        FilePathNode filePathNode = parentNode;
        if (filePathNode == null) {
            filePathNode = this.findRootNode((String)CollectionsKt.first(segments));
        }
        FilePathNode latestNode = filePathNode;
        int latestElement = segments.size() - 1;
        int n = segments.size();
        for (int index2 = 0; index2 < n; ++index2) {
            int nameId = this.fileNameStore.generateIdForName(segments.get(index2));
            if (latestNode == null) {
                int nodeId = this.idGenerator.generateId();
                FilePathNode newNode = new FilePathNode(this, nodeId, nameId, null, 4, null);
                Integer n2 = nodeId;
                ((Map)this.id2NodeMapping).put(n2, newNode);
                if (index2 == latestElement) {
                    this.rootNode.addChild(newNode);
                    return newNode.getVirtualFileUrl(this);
                }
                latestNode = newNode;
                this.rootNode.addChild(newNode);
                continue;
            }
            if (latestNode == this.findRootNode(latestNode.getContentId()) && latestNode.getContentId() == nameId) {
                if (index2 != latestElement) continue;
                return latestNode.getVirtualFileUrl(this);
            }
            FilePathNode node = latestNode.findChild(nameId);
            if (node == null) {
                int nodeId = this.idGenerator.generateId();
                FilePathNode newNode = new FilePathNode(this, nodeId, nameId, latestNode);
                Integer n3 = nodeId;
                ((Map)this.id2NodeMapping).put(n3, newNode);
                latestNode.addChild(newNode);
                latestNode = newNode;
                if (index2 != latestElement) continue;
                return newNode.getVirtualFileUrl(this);
            }
            if (index2 == latestElement) {
                return node.getVirtualFileUrl(this);
            }
            latestNode = node;
        }
        return this.getEmptyUrl();
    }

    public final void remove$intellij_platform_workspaceModel_storage(@NotNull String path) {
        FilePathNode parent;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FilePathNode node = this.findLatestFilePathNode(path);
        if (node == null) {
            System.out.println((Object)"File not found");
            return;
        }
        if (!node.isEmpty()) {
            return;
        }
        FilePathNode currentNode = node;
        do {
            if ((parent = currentNode.getParent()) == null) {
                if (currentNode == this.findRootNode(currentNode.getContentId()) && currentNode.isEmpty()) {
                    this.removeNameUsage(currentNode.getContentId());
                    this.id2NodeMapping.remove(currentNode.getNodeId());
                    this.rootNode.removeChild(currentNode);
                }
                return;
            }
            parent.removeChild(currentNode);
            this.removeNameUsage(currentNode.getContentId());
            this.id2NodeMapping.remove(currentNode.getNodeId());
        } while ((currentNode = parent).isEmpty());
    }

    public final void update$intellij_platform_workspaceModel_storage(@NotNull String oldPath, @NotNull String newPath) {
        Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        FilePathNode latestPathNode = this.findLatestFilePathNode(oldPath);
        if (latestPathNode == null) {
            return;
        }
        this.remove$intellij_platform_workspaceModel_storage(oldPath);
        VirtualFileUrlManagerImpl.add$intellij_platform_workspaceModel_storage$default(this, newPath, null, 2, null);
    }

    private final VirtualFileUrl getEmptyUrl() {
        if (this.emptyUrl == null) {
            this.emptyUrl = this.createVirtualFileUrl(0, this);
        }
        VirtualFileUrl virtualFileUrl = this.emptyUrl;
        Intrinsics.checkNotNull((Object)virtualFileUrl);
        return virtualFileUrl;
    }

    private final void removeNameUsage(int contentId) {
        boolean bl;
        String name2 = this.fileNameStore.getNameForId(contentId);
        boolean bl2 = bl = name2 != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        String string3 = name2;
        Intrinsics.checkNotNull((Object)string3);
        this.fileNameStore.removeName(string3);
    }

    private final FilePathNode findLatestFilePathNode(String path) {
        List<String> segments = this.splitNames(path);
        FilePathNode latestNode = null;
        latestNode = this.findRootNode((String)CollectionsKt.first(segments));
        int latestElement = segments.size() - 1;
        int n = segments.size();
        for (int index2 = 0; index2 < n; ++index2) {
            Unit unit;
            Integer n2 = this.fileNameStore.getIdForName(segments.get(index2));
            if (n2 == null) {
                return null;
            }
            int nameId = n2;
            if (latestNode == null) {
                return null;
            }
            if (latestNode == this.findRootNode(latestNode.getContentId()) && latestNode.getContentId() == nameId) {
                if (index2 != latestElement) continue;
                return latestNode;
            }
            if (latestNode.findChild(nameId) != null) {
                FilePathNode it;
                boolean bl = false;
                if (index2 == latestElement) {
                    return it;
                }
                latestNode = it;
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) continue;
            return null;
        }
        return null;
    }

    private final FilePathNode findRootNode(String segment) {
        Integer n = this.fileNameStore.getIdForName(segment);
        if (n == null) {
            return null;
        }
        int segmentId = n;
        return this.rootNode.findChild(segmentId);
    }

    private final FilePathNode findRootNode(int contentId) {
        return this.rootNode.findChild(contentId);
    }

    private final List<String> splitNames(String path) {
        char[] cArray = new char[]{'/', '\\'};
        return StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)false, (int)0, (int)6, null);
    }

    @NotNull
    public final String print() {
        return this.rootNode.print();
    }

    public final boolean isEqualOrParentOf(int parentNodeId, int childNodeId) {
        if (parentNodeId == 0 && childNodeId == 0) {
            return true;
        }
        int current2 = childNodeId;
        while (current2 > 0) {
            if (parentNodeId == current2) {
                return true;
            }
            FilePathNode filePathNode = this.id2NodeMapping.get(current2);
            if (filePathNode == null || (filePathNode = filePathNode.getParent()) == null) {
                return false;
            }
            current2 = filePathNode.getNodeId();
        }
        return false;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0018\u00010\u0000R\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0000R\u00020\u0006J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\u0014\u0010\u0015\u001a\b\u0018\u00010\u0000R\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0003J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u0000R\u00020\u00060\u0019J$\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u0000R\u00020\u00060\u00192\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u0000R\u00020\u00060\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0006J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J$\u0010 \u001a\u00020\u00122\n\u0010\"\u001a\u00060#j\u0002`$2\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020!H\u0002J\u0012\u0010'\u001a\u00020\u00122\n\u0010(\u001a\u00060\u0000R\u00020\u0006R\u001a\u0010\b\u001a\u000e\u0012\b\u0012\u00060\u0000R\u00020\u0006\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0018\u00010\u0000R\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode;", "", "nodeId", "", "contentId", "parent", "Lcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl;", "(Lcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl;IILcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode;)V", "children", "Lit/unimi/dsi/fastutil/objects/ObjectOpenCustomHashSet;", "getContentId", "()I", "getNodeId", "getParent", "()Lcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode;", "virtualFileUrl", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "addChild", "", "newNode", "createChildrenList", "findChild", "nameId", "getCachedVirtualFileUrl", "getSubtreeNodes", "", "subtreeNodes", "", "getVirtualFileUrl", "virtualFileUrlManager", "isEmpty", "", "print", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "prefix", "childrenPrefix", "removeChild", "node", "intellij.platform.workspaceModel.storage"})
    public final class FilePathNode {
        private final int nodeId;
        private final int contentId;
        @Nullable
        private final FilePathNode parent;
        @Nullable
        private VirtualFileUrl virtualFileUrl;
        @Nullable
        private ObjectOpenCustomHashSet<FilePathNode> children;
        final /* synthetic */ VirtualFileUrlManagerImpl this$0;

        public FilePathNode(VirtualFileUrlManagerImpl this$0, int nodeId, @Nullable int contentId, FilePathNode parent) {
            this.this$0 = this$0;
            this.nodeId = nodeId;
            this.contentId = contentId;
            this.parent = parent;
        }

        public /* synthetic */ FilePathNode(VirtualFileUrlManagerImpl virtualFileUrlManagerImpl, int n, int n2, FilePathNode filePathNode, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                filePathNode = null;
            }
            this(virtualFileUrlManagerImpl, n, n2, filePathNode);
        }

        public final int getNodeId() {
            return this.nodeId;
        }

        public final int getContentId() {
            return this.contentId;
        }

        @Nullable
        public final FilePathNode getParent() {
            return this.parent;
        }

        @Nullable
        public final FilePathNode findChild(int nameId) {
            ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
            return objectOpenCustomHashSet != null ? objectOpenCustomHashSet.get(new FilePathNode(this.this$0, 0, nameId, null, 4, null)) : null;
        }

        @NotNull
        public final List<FilePathNode> getSubtreeNodes() {
            return this.getSubtreeNodes(new ArrayList());
        }

        private final List<FilePathNode> getSubtreeNodes(List<FilePathNode> subtreeNodes) {
            block1: {
                ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
                if (objectOpenCustomHashSet == null) break block1;
                Iterable $this$forEach$iv = objectOpenCustomHashSet;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FilePathNode it = (FilePathNode)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    subtreeNodes.add(it);
                    it.getSubtreeNodes(subtreeNodes);
                }
            }
            return subtreeNodes;
        }

        public final void addChild(@NotNull FilePathNode newNode) {
            Intrinsics.checkNotNullParameter((Object)newNode, (String)"newNode");
            this.createChildrenList();
            ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
            Intrinsics.checkNotNull(objectOpenCustomHashSet);
            objectOpenCustomHashSet.add(newNode);
        }

        public final void removeChild(@NotNull FilePathNode node) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
                if (objectOpenCustomHashSet == null) break block0;
                objectOpenCustomHashSet.remove(node);
            }
        }

        @NotNull
        public final VirtualFileUrl getVirtualFileUrl(@NotNull VirtualFileUrlManagerImpl virtualFileUrlManager) {
            VirtualFileUrl url;
            Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
            VirtualFileUrl cachedValue = this.virtualFileUrl;
            if (cachedValue != null) {
                return cachedValue;
            }
            this.virtualFileUrl = url = virtualFileUrlManager.createVirtualFileUrl(this.nodeId, virtualFileUrlManager);
            return url;
        }

        @Nullable
        public final VirtualFileUrl getCachedVirtualFileUrl() {
            return this.virtualFileUrl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isEmpty() {
            if (this.children == null) return true;
            ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
            Intrinsics.checkNotNull(objectOpenCustomHashSet);
            if (!objectOpenCustomHashSet.isEmpty()) return false;
            return true;
        }

        private final void createChildrenList() {
            if (this.children == null) {
                this.children = new ObjectOpenCustomHashSet<FilePathNode>(Companion.getHASHING_STRATEGY());
            }
        }

        @NotNull
        public final String print() {
            StringBuilder buffer = new StringBuilder();
            this.print(buffer, "", "");
            String string2 = buffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"buffer.toString()");
            return string2;
        }

        private final void print(StringBuilder buffer, String prefix, String childrenPrefix) {
            Object object;
            String name2 = this.this$0.fileNameStore.getNameForId(this.contentId);
            if (name2 != null) {
                buffer.append(prefix + " " + name2 + "\n");
            }
            if ((object = this.children) == null || (object = ((ObjectOpenCustomHashSet)object).iterator()) == null) {
                return;
            }
            Object iterator = object;
            while (iterator.hasNext()) {
                FilePathNode next = (FilePathNode)iterator.next();
                if (name2 == null) {
                    next.print(buffer, childrenPrefix, childrenPrefix);
                    continue;
                }
                if (iterator.hasNext()) {
                    next.print(buffer, childrenPrefix + " |- ", childrenPrefix + " |   ");
                    continue;
                }
                next.print(buffer, childrenPrefix + " '- ", childrenPrefix + "     ");
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0005R\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl$Companion;", "", "()V", "HASHING_STRATEGY", "Lit/unimi/dsi/fastutil/Hash$Strategy;", "Lcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode;", "Lcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl;", "getHASHING_STRATEGY", "()Lit/unimi/dsi/fastutil/Hash$Strategy;", "intellij.platform.workspaceModel.storage"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Hash.Strategy<FilePathNode> getHASHING_STRATEGY() {
            return HASHING_STRATEGY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

