/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl.url;

import com.intellij.workspaceModel.storage.impl.url.VirtualFileUrlManagerImpl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\bH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlImpl;", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "id", "", "manager", "Lcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl;", "(ILcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl;)V", "cachedUrl", "", "getId", "()I", "getManager$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl;", "append", "relativePath", "equals", "", "other", "", "getFileName", "getPresentableUrl", "getSubTreeFileUrls", "", "getUrl", "getUrlSegments", "hashCode", "toString", "intellij.platform.workspaceModel.storage"})
public class VirtualFileUrlImpl
implements VirtualFileUrl {
    private final int id;
    @NotNull
    private final VirtualFileUrlManagerImpl manager;
    @Nullable
    private String cachedUrl;

    public VirtualFileUrlImpl(int id, @NotNull VirtualFileUrlManagerImpl manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.id = id;
        this.manager = manager;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final VirtualFileUrlManagerImpl getManager$intellij_platform_workspaceModel_storage() {
        return this.manager;
    }

    @Override
    @NotNull
    public String getUrl() {
        if (this.cachedUrl == null) {
            this.cachedUrl = this.manager.getUrlById(this.id);
        }
        String string2 = this.cachedUrl;
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    @Override
    @NotNull
    public List<String> getUrlSegments() {
        char[] cArray = new char[]{'/', '\\'};
        return StringsKt.split$default((CharSequence)this.getUrl(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
    }

    @Override
    @NotNull
    public String getFileName() {
        return StringsKt.substringAfterLast$default((String)this.getUrl(), (char)'/', null, (int)2, null);
    }

    @Override
    @NotNull
    public String getPresentableUrl() {
        String calculatedUrl = this.getUrl();
        if (StringsKt.startsWith$default((String)calculatedUrl, (String)"file://", (boolean)false, (int)2, null)) {
            String string2 = calculatedUrl.substring(7);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            return string2;
        }
        if (StringsKt.startsWith$default((String)calculatedUrl, (String)"jar://", (boolean)false, (int)2, null)) {
            String removedSuffix = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)calculatedUrl, (CharSequence)"!/"), (CharSequence)"!");
            String string3 = removedSuffix.substring(6);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            return string3;
        }
        return calculatedUrl;
    }

    @Override
    @NotNull
    public List<VirtualFileUrl> getSubTreeFileUrls() {
        return this.manager.getSubtreeVirtualUrlsById(this);
    }

    @Override
    @NotNull
    public VirtualFileUrl append(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return this.manager.append$intellij_platform_workspaceModel_storage(this, StringsKt.removePrefix((String)relativePath, (CharSequence)"/"));
    }

    @NotNull
    public String toString() {
        return this.getUrl();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.url.VirtualFileUrlImpl");
        VirtualFileUrlImpl cfr_ignored_0 = (VirtualFileUrlImpl)other;
        return this.id == ((VirtualFileUrlImpl)other).id;
    }

    public int hashCode() {
        return this.id;
    }
}

