/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl.indices;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import it.unimi.dsi.fastutil.Hash;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\u0018\b\u0000\u0010\u0005\"\b\u0012\u0004\u0012\u00020\u00020\u00062\b\u0012\u0004\u0012\u00020\u00020\u0006*\u0018\b\u0000\u0010\u0007\"\b\u0012\u0004\u0012\u00020\t0\b2\b\u0012\u0004\u0012\u00020\t0\b*0\b\u0000\u0010\n\"\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b\u00a8\u0006\u000e"}, d2={"CASE_INSENSITIVE_STRATEGY", "Lit/unimi/dsi/fastutil/Hash$Strategy;", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "STANDARD_STRATEGY", "getHashingStrategy", "EntityId2JarDir", "Lcom/intellij/workspaceModel/storage/impl/containers/BidirectionalLongMultiMap;", "EntityId2Vfu", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "", "Vfu2EntityId", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenCustomHashMap;", "Lit/unimi/dsi/fastutil/objects/Object2LongMap;", "", "intellij.platform.workspaceModel.storage"})
public final class VirtualFileIndexKt {
    @NotNull
    private static final Hash.Strategy<VirtualFileUrl> STANDARD_STRATEGY = new Hash.Strategy<VirtualFileUrl>(){

        public boolean equals(@Nullable VirtualFileUrl firstVirtualFile, @Nullable VirtualFileUrl secondVirtualFile) {
            if (firstVirtualFile == secondVirtualFile) {
                return true;
            }
            if (firstVirtualFile == null || secondVirtualFile == null) {
                return false;
            }
            return Intrinsics.areEqual((Object)firstVirtualFile, (Object)secondVirtualFile);
        }

        public int hashCode(@Nullable VirtualFileUrl fileUrl) {
            if (fileUrl == null) {
                return 0;
            }
            return fileUrl.hashCode();
        }
    };
    @NotNull
    private static final Hash.Strategy<VirtualFileUrl> CASE_INSENSITIVE_STRATEGY = new Hash.Strategy<VirtualFileUrl>(){

        public boolean equals(@Nullable VirtualFileUrl firstVirtualFile, @Nullable VirtualFileUrl secondVirtualFile) {
            VirtualFileUrl virtualFileUrl = firstVirtualFile;
            VirtualFileUrl virtualFileUrl2 = secondVirtualFile;
            return StringUtilRt.equal(virtualFileUrl != null ? virtualFileUrl.getUrl() : null, virtualFileUrl2 != null ? virtualFileUrl2.getUrl() : null, false);
        }

        public int hashCode(@Nullable VirtualFileUrl fileUrl) {
            if (fileUrl == null) {
                return 0;
            }
            return Strings.stringHashCodeInsensitive(fileUrl.getUrl());
        }
    };

    @NotNull
    public static final Hash.Strategy<VirtualFileUrl> getHashingStrategy() {
        boolean indexSensitivityEnabled = Registry.is("ide.new.project.model.index.case.sensitivity", false);
        if (!indexSensitivityEnabled) {
            return STANDARD_STRATEGY;
        }
        if (!SystemInfoRt.isFileSystemCaseSensitive) {
            return CASE_INSENSITIVE_STRATEGY;
        }
        return STANDARD_STRATEGY;
    }
}

