/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl.containers;

import com.intellij.util.SmartList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004BG\b\u0002\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0006j\b\u0012\u0004\u0012\u00028\u0001`\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001a\u001a\u00020\u001bH\u0007J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010 J\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u0018\u0010$\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001f\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010%J\u001b\u0010&\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010'2\u0006\u0010\"\u001a\u00028\u0001\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0006j\b\u0012\u0004\u0012\u00028\u0001`\u0007H\u0007J\b\u0010*\u001a\u00020\u001eH\u0016J\u001f\u0010+\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001f\u001a\u00028\u00002\u0006\u0010\"\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010,J\u001e\u0010-\u001a\u00020\u001b2\u0014\u0010.\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010/H\u0016J\u0017\u00100\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010%J\u0013\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00028\u0001\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u000205H\u0016R&\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0006j\b\u0012\u0004\u0012\u00028\u0001`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011\u00a8\u00066"}, d2={"Lcom/intellij/workspaceModel/storage/impl/containers/BidirectionalMap;", "K", "V", "", "()V", "slotsWithList", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "keyToValueMap", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "valueToKeysMap", "", "(Ljava/util/HashSet;Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "values", "getValues", "assertConsistency", "", "clear", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "copy", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getKeysByValue", "", "(Ljava/lang/Object;)Ljava/util/List;", "getSlotsWithList", "isEmpty", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putAll", "from", "", "remove", "removeValue", "v", "(Ljava/lang/Object;)V", "toString", "", "intellij.platform.workspaceModel.storage"})
public final class BidirectionalMap<K, V>
implements Map<K, V>,
KMutableMap {
    @NotNull
    private final HashSet<V> slotsWithList;
    @NotNull
    private final Object2ObjectOpenHashMap<K, V> keyToValueMap;
    @NotNull
    private final Object2ObjectOpenHashMap<V, Object> valueToKeysMap;

    private BidirectionalMap(HashSet<V> slotsWithList, Object2ObjectOpenHashMap<K, V> keyToValueMap, Object2ObjectOpenHashMap<V, Object> valueToKeysMap) {
        this.slotsWithList = slotsWithList;
        this.keyToValueMap = keyToValueMap;
        this.valueToKeysMap = valueToKeysMap;
    }

    public BidirectionalMap() {
        this(new HashSet(), new Object2ObjectOpenHashMap(), new Object2ObjectOpenHashMap());
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        Object existingKeys;
        V oldValue = this.keyToValueMap.put(key, value);
        if (oldValue != null) {
            if (Intrinsics.areEqual(oldValue, value)) {
                return oldValue;
            }
            Object object = this.valueToKeysMap.get(oldValue);
            Intrinsics.checkNotNull((Object)object);
            Object keys2 = object;
            if (TypeIntrinsics.isMutableList((Object)keys2)) {
                TypeIntrinsics.asMutableCollection((Object)((Collection)keys2)).remove(key);
                if (((List)keys2).size() == 1) {
                    ((Map)this.valueToKeysMap).put(oldValue, ((List)keys2).get(0));
                    this.slotsWithList.remove(oldValue);
                } else if (((List)keys2).isEmpty()) {
                    this.valueToKeysMap.remove(oldValue);
                    this.slotsWithList.remove(oldValue);
                }
            } else {
                this.valueToKeysMap.remove(oldValue);
            }
        }
        if ((existingKeys = this.valueToKeysMap.get(value)) == null) {
            ((Map)this.valueToKeysMap).put(value, key);
            return oldValue;
        }
        if (TypeIntrinsics.isMutableList((Object)existingKeys)) {
            TypeIntrinsics.asMutableList((Object)existingKeys);
            ((List)existingKeys).add(key);
        } else {
            Map map2 = this.valueToKeysMap;
            Object object = new Object[]{existingKeys, key};
            object = new SmartList<Object>(object);
            map2.put(value, object);
            this.slotsWithList.add(value);
        }
        return oldValue;
    }

    @Override
    public void clear() {
        this.slotsWithList.clear();
        this.keyToValueMap.clear();
        this.valueToKeysMap.clear();
    }

    @Nullable
    public final List<K> getKeysByValue(V value) {
        List list;
        Object object = this.valueToKeysMap.get(value);
        if (object != null) {
            Object keys2 = object;
            boolean bl = false;
            list = TypeIntrinsics.isMutableList((Object)keys2) ? TypeIntrinsics.asMutableList((Object)keys2) : (List)new SmartList<Object>(keys2);
        } else {
            list = null;
        }
        return list;
    }

    @NotNull
    public Set<K> getKeys() {
        Set set = this.keyToValueMap.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keyToValueMap.keys");
        return set;
    }

    public int getSize() {
        return this.keyToValueMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keyToValueMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyToValueMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueToKeysMap.containsKey(value);
    }

    @Override
    @Nullable
    public V get(Object key) {
        return this.keyToValueMap.get(key);
    }

    public final void removeValue(V v) {
        Object keys2 = this.valueToKeysMap.remove(v);
        if (keys2 != null) {
            if (TypeIntrinsics.isMutableList((Object)keys2)) {
                for (Object k : (List)keys2) {
                    TypeIntrinsics.asMutableMap((Object)this.keyToValueMap).remove(k);
                }
                this.slotsWithList.remove(v);
            } else {
                this.keyToValueMap.remove(keys2);
            }
        }
    }

    @Override
    @Nullable
    public V remove(Object key) {
        V value = this.keyToValueMap.remove(key);
        Object keys2 = this.valueToKeysMap.get(value);
        if (keys2 != null) {
            if (TypeIntrinsics.isMutableList((Object)keys2) && ((List)keys2).size() > 1) {
                TypeIntrinsics.asMutableCollection((Object)((Collection)keys2)).remove(key);
                if (((List)keys2).size() == 1) {
                    ((Map)this.valueToKeysMap).put(value, ((List)keys2).get(0));
                    TypeIntrinsics.asMutableCollection((Object)this.slotsWithList).remove(value);
                }
            } else {
                if (TypeIntrinsics.isMutableList((Object)keys2)) {
                    TypeIntrinsics.asMutableCollection((Object)this.slotsWithList).remove(value);
                }
                this.valueToKeysMap.remove(value);
            }
        }
        return value;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        for (Map.Entry<K, V> entry : from.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            this.put(key, value);
        }
    }

    @NotNull
    public Set<V> getValues() {
        Set set = this.valueToKeysMap.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"valueToKeysMap.keys");
        return set;
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        Set set = this.keyToValueMap.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keyToValueMap.entries");
        return set;
    }

    @NotNull
    public final BidirectionalMap<K, V> copy() {
        Object object = this.valueToKeysMap.clone();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"valueToKeysMap.clone()");
        Object clonedValueToKeysMap = object;
        Iterable $this$forEach$iv = this.slotsWithList;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object value = element$iv = iterator.next();
            boolean bl = false;
            Map map2 = (Map)clonedValueToKeysMap;
            Object object2 = this.valueToKeysMap.get(value);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<K of com.intellij.workspaceModel.storage.impl.containers.BidirectionalMap.copy$lambda$1>");
            SmartList smartList = new SmartList(TypeIntrinsics.asMutableList((Object)object2));
            map2.put(value, smartList);
        }
        HashSet hashSet = new HashSet(this.slotsWithList);
        Object object3 = this.keyToValueMap.clone();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"keyToValueMap.clone()");
        return new BidirectionalMap(hashSet, object3, clonedValueToKeysMap);
    }

    @TestOnly
    @NotNull
    public final HashSet<V> getSlotsWithList() {
        return this.slotsWithList;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public final void assertConsistency() {
        void $this$mapTo$iv$iv;
        void $this$map$iv22;
        Set set = this.keyToValueMap.keySet();
        Collection collection = this.valueToKeysMap.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"valueToKeysMap.values");
        Iterable iterable = collection;
        Set set2 = set;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(it instanceof SmartList ? (SmartList<Object>)it : new SmartList<void>(it));
        }
        boolean $this$map$iv22 = Intrinsics.areEqual((Object)set2, (Object)CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv))));
        if (_Assertions.ENABLED && !$this$map$iv22) {
            boolean $i$a$-assert-BidirectionalMap$assertConsistency$42 = false;
            String $i$a$-assert-BidirectionalMap$assertConsistency$42 = "The count of keys in one map does not equal the amount on the second map";
            throw new AssertionError((Object)$i$a$-assert-BidirectionalMap$assertConsistency$42);
        }
        Collection collection3 = this.keyToValueMap.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"keyToValueMap.values");
        $this$map$iv22 = Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)collection3), (Object)this.valueToKeysMap.keySet());
        if (_Assertions.ENABLED && !$this$map$iv22) {
            boolean $i$a$-assert-BidirectionalMap$assertConsistency$52 = false;
            String $i$a$-assert-BidirectionalMap$assertConsistency$52 = "The count of values in one map does not equal the amount on the second map";
            throw new AssertionError((Object)$i$a$-assert-BidirectionalMap$assertConsistency$52);
        }
        Map $this$forEach$iv = this.valueToKeysMap;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Object value = entry.getKey();
            Object keys2 = entry.getValue();
            if (keys2 instanceof SmartList) {
                boolean bl2 = this.slotsWithList.contains(value);
                if (_Assertions.ENABLED && !bl2) {
                    boolean $i$a$-assert-BidirectionalMap$assertConsistency$4$22 = false;
                    String $i$a$-assert-BidirectionalMap$assertConsistency$4$22 = "Not registered value: " + value + " with list at slotsWithList collection";
                    throw new AssertionError((Object)$i$a$-assert-BidirectionalMap$assertConsistency$4$22);
                }
                Iterable $this$forEach$iv2 = (Iterable)keys2;
                boolean $i$f$forEach2 = false;
                Iterator iterator3 = $this$forEach$iv2.iterator();
                while (iterator3.hasNext()) {
                    Object element$iv2;
                    Object it = element$iv2 = iterator3.next();
                    boolean bl3 = false;
                    boolean bl4 = ((Map)this.keyToValueMap).containsKey(it);
                    if (_Assertions.ENABLED && !bl4) {
                        boolean $i$a$-assert-BidirectionalMap$assertConsistency$4$2$32 = false;
                        String $i$a$-assert-BidirectionalMap$assertConsistency$4$2$32 = "Key: " + it + " is not registered at keyToValueMap collection";
                        throw new AssertionError((Object)$i$a$-assert-BidirectionalMap$assertConsistency$4$2$32);
                    }
                    bl4 = Intrinsics.areEqual(((Map)this.keyToValueMap).get(it), value);
                    if (!_Assertions.ENABLED || bl4) continue;
                    boolean bl5 = false;
                    String string2 = "Value by key: " + it + " is different in collections. Expected: " + value + " but actual " + ((Map)this.keyToValueMap).get(it);
                    throw new AssertionError((Object)string2);
                }
                continue;
            }
            boolean bl6 = ((Map)this.keyToValueMap).containsKey(keys2);
            if (_Assertions.ENABLED && !bl6) {
                boolean $i$a$-assert-BidirectionalMap$assertConsistency$4$52 = false;
                String $i$a$-assert-BidirectionalMap$assertConsistency$4$52 = "Key: " + keys2 + " is not registered at keyToValueMap collection";
                throw new AssertionError((Object)$i$a$-assert-BidirectionalMap$assertConsistency$4$52);
            }
            bl6 = Intrinsics.areEqual(((Map)this.keyToValueMap).get(keys2), value);
            if (!_Assertions.ENABLED || bl6) continue;
            boolean bl7 = false;
            String string3 = "Value by key: " + keys2 + " is different in collections. Expected: " + value + " but actual " + ((Map)this.keyToValueMap).get(keys2);
            throw new AssertionError((Object)string3);
        }
    }

    @NotNull
    public String toString() {
        String string2 = this.keyToValueMap.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"keyToValueMap.toString()");
        return string2;
    }
}

