/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.workspaceModel.storage.impl.IdPerCount;
import com.intellij.workspaceModel.storage.impl.IntIdGenerator;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0011J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RV\u0010\b\u001aJ\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b \n*#\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b0\r\u00a2\u0006\u0002\b\f0\t\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/workspaceModel/storage/impl/VirtualFileNameStore;", "", "()V", "generator", "Lcom/intellij/workspaceModel/storage/impl/IntIdGenerator;", "id2NameStore", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "", "name2IdStore", "", "kotlin.jvm.PlatformType", "Lcom/intellij/workspaceModel/storage/impl/IdPerCount;", "Lorg/jetbrains/annotations/NotNull;", "", "clear", "", "generateIdForName", "", "name", "getIdForName", "(Ljava/lang/String;)Ljava/lang/Integer;", "getNameForId", "id", "removeName", "intellij.platform.workspaceModel.storage"})
public final class VirtualFileNameStore {
    @NotNull
    private final IntIdGenerator generator = new IntIdGenerator();
    @NotNull
    private final Int2ObjectOpenHashMap<String> id2NameStore = new Int2ObjectOpenHashMap();
    @NotNull
    private final Map<String, IdPerCount> name2IdStore;

    public VirtualFileNameStore() {
        VirtualFileNameStore virtualFileNameStore = this;
        VirtualFileNameStore virtualFileNameStore2 = this;
        boolean bl = false;
        boolean checkSensitivityEnabled = Registry.is("ide.new.project.model.index.case.sensitivity", false);
        Map map2 = checkSensitivityEnabled && !SystemInfoRt.isFileSystemCaseSensitive ? CollectionFactory.createCustomHashingStrategyMap(HashingStrategy.caseInsensitive()) : CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"run {\n    val checkSensi\u2026String, IdPerCount>()\n  }");
        virtualFileNameStore2.name2IdStore = map2;
    }

    public final int generateIdForName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        IdPerCount idPerCount = this.name2IdStore.get(name2);
        if (idPerCount != null) {
            long l = idPerCount.getUsageCount();
            idPerCount.setUsageCount(l + 1L);
            return idPerCount.getId();
        }
        int id = this.generator.generateId();
        this.name2IdStore.put(name2, new IdPerCount(id, 1L));
        this.id2NameStore.put(id, name2);
        return id;
    }

    public final void removeName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        IdPerCount idPerCount = this.name2IdStore.get(name2);
        if (idPerCount == null) {
            return;
        }
        IdPerCount idPerCount2 = idPerCount;
        if (idPerCount2.getUsageCount() == 1L) {
            this.name2IdStore.remove(name2);
            this.id2NameStore.remove(idPerCount2.getId());
        } else {
            long l = idPerCount2.getUsageCount();
            idPerCount2.setUsageCount(l + -1L);
        }
    }

    @Nullable
    public final String getNameForId(int id) {
        return this.id2NameStore.get(id);
    }

    @Nullable
    public final Integer getIdForName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        IdPerCount idPerCount = this.name2IdStore.get(name2);
        return idPerCount != null ? Integer.valueOf(idPerCount.getId()) : null;
    }

    @TestOnly
    public final void clear() {
        this.name2IdStore.clear();
        this.id2NameStore.clear();
        this.generator.clear();
    }
}

