/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.workspaceModel.storage.CachedValue;
import com.intellij.workspaceModel.storage.CachedValueWithParameter;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.VersionedEntityStorage;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.impl.StorageSnapshotCache;
import com.intellij.workspaceModel.storage.impl.ValuesCache;
import com.intellij.workspaceModel.storage.impl.VersionedStorageChangeImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u00015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ5\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010 \"\u0004\b\u0001\u0010\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u0002H\u001c0!2\u0006\u0010\"\u001a\u0002H H\u0016\u00a2\u0006\u0002\u0010#J\u001c\u0010$\u001a\u00020%\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001eH\u0016J5\u0010$\u001a\u00020%\"\u0004\b\u0000\u0010 \"\u0004\b\u0001\u0010\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u0002H\u001c0!2\u0006\u0010\"\u001a\u0002H H\u0016\u00a2\u0006\u0002\u0010&Jb\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020\u00032 \u0010)\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030+\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030-0,0*2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020%0/2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020%0/2\b\u00102\u001a\u0004\u0018\u000103J\u000e\u00104\u001a\u00020%2\u0006\u0010(\u001a\u00020\u0003R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00066"}, d2={"Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageImpl;", "Lcom/intellij/workspaceModel/storage/VersionedEntityStorage;", "initialStorage", "Lcom/intellij/workspaceModel/storage/EntityStorageSnapshot;", "(Lcom/intellij/workspaceModel/storage/EntityStorageSnapshot;)V", "base", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "getBase", "()Lcom/intellij/workspaceModel/storage/EntityStorage;", "current", "getCurrent", "currentPointer", "Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageImpl$Current;", "currentSnapshot", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/workspaceModel/storage/impl/StorageSnapshotCache;", "pointer", "getPointer", "()Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageImpl$Current;", "valuesCache", "Lcom/intellij/workspaceModel/storage/impl/ValuesCache;", "getValuesCache", "()Lcom/intellij/workspaceModel/storage/impl/ValuesCache;", "version", "", "getVersion", "()J", "cachedValue", "R", "value", "Lcom/intellij/workspaceModel/storage/CachedValue;", "(Lcom/intellij/workspaceModel/storage/CachedValue;)Ljava/lang/Object;", "P", "Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;", "parameter", "(Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;Ljava/lang/Object;)Ljava/lang/Object;", "clearCachedValue", "", "(Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;Ljava/lang/Object;)V", "replace", "newStorage", "changes", "", "Ljava/lang/Class;", "", "Lcom/intellij/workspaceModel/storage/EntityChange;", "beforeChanged", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "afterChanged", "locker", "Ljava/util/concurrent/atomic/AtomicBoolean;", "replaceSilently", "Current", "intellij.platform.workspaceModel.storage"})
public class VersionedEntityStorageImpl
implements VersionedEntityStorage {
    @NotNull
    private final AtomicReference<StorageSnapshotCache> currentSnapshot;
    @NotNull
    private volatile Current currentPointer;

    public VersionedEntityStorageImpl(@NotNull EntityStorageSnapshot initialStorage) {
        Intrinsics.checkNotNullParameter((Object)initialStorage, (String)"initialStorage");
        this.currentSnapshot = new AtomicReference();
        this.currentPointer = new Current(0L, initialStorage);
    }

    private final ValuesCache getValuesCache() {
        StorageSnapshotCache snapshotCache = this.currentSnapshot.get();
        if (snapshotCache == null || this.getVersion() != snapshotCache.getStorageVersion()) {
            ValuesCache cache2 = new ValuesCache();
            this.currentSnapshot.set(new StorageSnapshotCache(this.getVersion(), cache2, this.getCurrent()));
            return cache2;
        }
        return snapshotCache.getCache();
    }

    @Override
    @NotNull
    public EntityStorage getCurrent() {
        return this.currentPointer.getStorage();
    }

    @Override
    @NotNull
    public EntityStorage getBase() {
        return this.getCurrent();
    }

    @Override
    public long getVersion() {
        return this.currentPointer.getVersion();
    }

    @NotNull
    public final Current getPointer() {
        return this.currentPointer;
    }

    @Override
    public <R> R cachedValue(@NotNull CachedValue<R> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.getValuesCache().cachedValue(value, this.getCurrent());
    }

    @Override
    public <P, R> R cachedValue(@NotNull CachedValueWithParameter<P, R> value, P parameter) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.getValuesCache().cachedValue(value, parameter, this.getCurrent());
    }

    @Override
    public <R> void clearCachedValue(@NotNull CachedValue<R> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.getValuesCache().clearCachedValue(value);
    }

    @Override
    public <P, R> void clearCachedValue(@NotNull CachedValueWithParameter<P, R> value, P parameter) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.getValuesCache().clearCachedValue(value, parameter);
    }

    public final synchronized void replace(@NotNull EntityStorageSnapshot newStorage, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes, @NotNull Function1<? super VersionedStorageChange, Unit> beforeChanged, @NotNull Function1<? super VersionedStorageChange, Unit> afterChanged, @Nullable AtomicBoolean locker) {
        Intrinsics.checkNotNullParameter((Object)newStorage, (String)"newStorage");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter(beforeChanged, (String)"beforeChanged");
        Intrinsics.checkNotNullParameter(afterChanged, (String)"afterChanged");
        Current oldCopy = this.currentPointer;
        if (Intrinsics.areEqual((Object)oldCopy.getStorage(), (Object)newStorage)) {
            return;
        }
        VersionedStorageChangeImpl change = new VersionedStorageChangeImpl(this, oldCopy.getStorage(), newStorage, changes);
        beforeChanged.invoke((Object)change);
        this.currentPointer = new Current(oldCopy.getVersion() + 1L, newStorage);
        AtomicBoolean atomicBoolean = locker;
        if (atomicBoolean != null) {
            atomicBoolean.set(false);
        }
        afterChanged.invoke((Object)change);
    }

    public final synchronized void replaceSilently(@NotNull EntityStorageSnapshot newStorage) {
        Intrinsics.checkNotNullParameter((Object)newStorage, (String)"newStorage");
        Current oldCopy = this.currentPointer;
        if (Intrinsics.areEqual((Object)oldCopy.getStorage(), (Object)newStorage)) {
            return;
        }
        this.currentPointer = new Current(oldCopy.getVersion() + 1L, newStorage);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageImpl$Current;", "", "version", "", "storage", "Lcom/intellij/workspaceModel/storage/EntityStorageSnapshot;", "(JLcom/intellij/workspaceModel/storage/EntityStorageSnapshot;)V", "getStorage", "()Lcom/intellij/workspaceModel/storage/EntityStorageSnapshot;", "getVersion", "()J", "intellij.platform.workspaceModel.storage"})
    public static final class Current {
        private final long version;
        @NotNull
        private final EntityStorageSnapshot storage;

        public Current(long version, @NotNull EntityStorageSnapshot storage) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            this.version = version;
            this.storage = storage;
        }

        public final long getVersion() {
            return this.version;
        }

        @NotNull
        public final EntityStorageSnapshot getStorage() {
            return this.storage;
        }
    }
}

