/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.MutableEntityStorage;
import com.intellij.workspaceModel.storage.MutableExternalEntityMapping;
import com.intellij.workspaceModel.storage.ReplaceBySourceOperation;
import com.intellij.workspaceModel.storage.SymbolicEntityId;
import com.intellij.workspaceModel.storage.UtilsKt;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.AddDiffOperation;
import com.intellij.workspaceModel.storage.impl.ChangeEntry;
import com.intellij.workspaceModel.storage.impl.ChildEntityId;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverter;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt;
import com.intellij.workspaceModel.storage.impl.ConnectionId;
import com.intellij.workspaceModel.storage.impl.EntitiesKt;
import com.intellij.workspaceModel.storage.impl.EntityFamily;
import com.intellij.workspaceModel.storage.impl.EntityIdKt;
import com.intellij.workspaceModel.storage.impl.EntityStorageSnapshotImpl;
import com.intellij.workspaceModel.storage.impl.ErrorReportingKt;
import com.intellij.workspaceModel.storage.impl.ImmutableEntitiesBarrel;
import com.intellij.workspaceModel.storage.impl.ModifiableWorkspaceEntityBase;
import com.intellij.workspaceModel.storage.impl.MutableEntitiesBarrel;
import com.intellij.workspaceModel.storage.impl.MutableEntityStorageImpl;
import com.intellij.workspaceModel.storage.impl.MutableRefsTable;
import com.intellij.workspaceModel.storage.impl.MutableStorageIndexes;
import com.intellij.workspaceModel.storage.impl.ParentEntityId;
import com.intellij.workspaceModel.storage.impl.RefsTable;
import com.intellij.workspaceModel.storage.impl.RefsTableKt;
import com.intellij.workspaceModel.storage.impl.ReplaceBySourceAsGraph;
import com.intellij.workspaceModel.storage.impl.ReplaceBySourceAsTree;
import com.intellij.workspaceModel.storage.impl.SoftLinkable;
import com.intellij.workspaceModel.storage.impl.StorageIndexes;
import com.intellij.workspaceModel.storage.impl.WorkspaceBuilderChangeLog;
import com.intellij.workspaceModel.storage.impl.WorkspaceBuilderChangeLogKt;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.containers.ContainerExtensionsKt;
import com.intellij.workspaceModel.storage.impl.exceptions.AddDiffException;
import com.intellij.workspaceModel.storage.impl.exceptions.SymbolicIdAlreadyExistsException;
import com.intellij.workspaceModel.storage.impl.external.ExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.impl.external.MutableExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.workspaceModel.storage.impl.indices.VirtualFileIndex;
import com.intellij.workspaceModel.storage.url.MutableVirtualFileUrlIndex;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u0094\u00012\u00020\u00012\u00020\u0002:\u0002\u0094\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ>\u0010<\u001a\u00020.2\n\u0010=\u001a\u00060 j\u0002`>2\u0010\u0010?\u001a\f\u0012\b\u0012\u00060 j\u0002`>0@2\u0016\u0010A\u001a\u0012\u0012\b\u0012\u00060 j\u0002`>\u0012\u0004\u0012\u00020\n0,H\u0002J\u0010\u0010B\u001a\u00020.2\u0006\u0010C\u001a\u00020\u0001H\u0016J'\u0010D\u001a\u00020.2\u0006\u0010E\u001a\u00020&2\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020GH\u0000\u00a2\u0006\u0002\bIJ \u0010J\u001a\u0002HK\"\b\b\u0000\u0010K*\u00020L2\u0006\u0010M\u001a\u0002HKH\u0096\u0004\u00a2\u0006\u0002\u0010NJ\u0018\u0010O\u001a\u00020.2\u0006\u0010C\u001a\u00020\u00022\u0006\u0010P\u001a\u00020&H\u0002J \u0010Q\u001a\u00020.\"\b\b\u0000\u0010K*\u00020L2\f\u0010R\u001a\b\u0012\u0004\u0012\u0002HK0SH\u0002J*\u0010T\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030V\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030X0W0U2\u0006\u0010Y\u001a\u00020GH\u0016J%\u0010Z\u001a\u00020.\"\b\b\u0000\u0010K*\u00020L2\f\u0010R\u001a\b\u0012\u0004\u0012\u0002HK0SH\u0000\u00a2\u0006\u0002\b[J&\u0010\\\u001a\b\u0012\u0004\u0012\u0002H^0]\"\b\b\u0000\u0010^*\u00020L2\f\u0010_\u001a\b\u0012\u0004\u0012\u0002H^0VH\u0016JB\u0010`\u001a(\u0012\u0004\u0012\u00020a\u0012\u001e\u0012\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020L0V\u0012\n\u0012\b\u0012\u0004\u0012\u00020L0W0U0U2\u0012\u0010b\u001a\u000e\u0012\u0004\u0012\u00020a\u0012\u0004\u0012\u00020\n0,H\u0016J\u001c\u0010c\u001a\b\u0012\u0004\u0012\u0002HK0d\"\u0004\b\u0000\u0010K2\u0006\u0010e\u001a\u00020&H\u0016J\b\u0010f\u001a\u00020gH\u0016J\b\u0010h\u001a\u00020\u0011H\u0002J\b\u0010i\u001a\u00020\nH\u0016J\u0010\u0010j\u001a\u00020\n2\u0006\u0010Y\u001a\u00020GH\u0016J\r\u0010k\u001a\u00020.H\u0000\u00a2\u0006\u0002\blJ\b\u0010m\u001a\u00020\nH\u0017J\b\u0010n\u001a\u00020.H\u0002JX\u0010o\u001a\u0002HK\"\u0010\b\u0000\u0010p*\n\u0012\u0006\b\u0001\u0012\u0002HK0q\"\b\b\u0001\u0010K*\u00020L2\f\u0010r\u001a\b\u0012\u0004\u0012\u0002Hp0V2\u0006\u0010s\u001a\u0002HK2\u0017\u0010t\u001a\u0013\u0012\u0004\u0012\u0002Hp\u0012\u0004\u0012\u00020.0,\u00a2\u0006\u0002\buH\u0016\u00a2\u0006\u0002\u0010vJC\u0010w\u001a\u00020.\"\b\b\u0000\u0010K*\u00020L\"\u000e\b\u0001\u0010^*\b\u0012\u0004\u0012\u0002HK0S\"\u0014\b\u0002\u0010x*\u000e\u0012\u0004\u0012\u0002HK\u0012\u0004\u0012\u0002H^0y2\u0006\u0010M\u001a\u0002Hx\u00a2\u0006\u0002\u0010zJ>\u0010{\u001a\b\u0012\u0004\u0012\u0002H|0]\"\b\b\u0000\u0010^*\u00020}\"\b\b\u0001\u0010|*\u00020L2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H^0~2\f\u0010_\u001a\b\u0012\u0004\u0012\u0002H|0VH\u0016J\u0010\u0010\u007f\u001a\u00020\n2\u0006\u0010s\u001a\u00020LH\u0016J6\u0010\u0080\u0001\u001a\u00020\n2\u000b\u0010\u0081\u0001\u001a\u00060 j\u0002`>2\u0018\b\u0002\u0010A\u001a\u0012\u0012\b\u0012\u00060 j\u0002`>\u0012\u0004\u0012\u00020\n0,H\u0000\u00a2\u0006\u0003\b\u0082\u0001J&\u0010\u0083\u0001\u001a\u00020.2\u0012\u0010b\u001a\u000e\u0012\u0004\u0012\u00020a\u0012\u0004\u0012\u00020\n0,2\u0007\u0010\u0084\u0001\u001a\u00020GH\u0016J)\u0010\u0085\u0001\u001a\u0004\u0018\u0001H^\"\b\b\u0000\u0010^*\u00020}2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H^0~H\u0016\u00a2\u0006\u0003\u0010\u0086\u0001J,\u0010\u0087\u0001\u001a\u00020\n2\u0007\u0010\u0088\u0001\u001a\u00020\u00022\u000b\u0010\u0089\u0001\u001a\u00060 j\u0002`>2\u000b\u0010\u008a\u0001\u001a\u00060 j\u0002`>H\u0002J\u0012\u0010\u008b\u0001\u001a\u00020.2\u0007\u0010\u008c\u0001\u001a\u00020\nH\u0016J\n\u0010\u008d\u0001\u001a\u00030\u008e\u0001H\u0016J\t\u0010\u008f\u0001\u001a\u00020.H\u0002J>\u0010\u0090\u0001\u001a\u00020.\"\b\b\u0000\u0010K*\u00020L2\u000b\u0010\u0091\u0001\u001a\u00060 j\u0002`>2\r\u0010\u0092\u0001\u001a\b\u0012\u0004\u0012\u0002HK0S2\r\u0010\u0093\u0001\u001a\b\u0012\u0004\u0012\u0002HK0SH\u0002R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\bX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\n8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010\u0005\u001a\u00020\u0006X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010'\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R@\u0010/\u001a\u0010\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.\u0018\u00010,2\u0014\u0010+\u001a\u0010\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.\u0018\u00010,@AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R@\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020.\u0018\u00010,2\u0014\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020.\u0018\u00010,@AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00101\"\u0004\b6\u00103R\u001a\u00107\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u001c\"\u0004\b9\u0010\u001eR\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0095\u0001"}, d2={"Lcom/intellij/workspaceModel/storage/impl/MutableEntityStorageImpl;", "Lcom/intellij/workspaceModel/storage/MutableEntityStorage;", "Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "entitiesByType", "Lcom/intellij/workspaceModel/storage/impl/MutableEntitiesBarrel;", "refs", "Lcom/intellij/workspaceModel/storage/impl/MutableRefsTable;", "indexes", "Lcom/intellij/workspaceModel/storage/impl/MutableStorageIndexes;", "trackStackTrace", "", "(Lcom/intellij/workspaceModel/storage/impl/MutableEntitiesBarrel;Lcom/intellij/workspaceModel/storage/impl/MutableRefsTable;Lcom/intellij/workspaceModel/storage/impl/MutableStorageIndexes;Z)V", "changeLog", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceBuilderChangeLog;", "getChangeLog$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/WorkspaceBuilderChangeLog;", "engine", "Lcom/intellij/workspaceModel/storage/ReplaceBySourceOperation;", "getEngine$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/ReplaceBySourceOperation;", "setEngine$intellij_platform_workspaceModel_storage", "(Lcom/intellij/workspaceModel/storage/ReplaceBySourceOperation;)V", "getEntitiesByType$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/MutableEntitiesBarrel;", "getIndexes$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/MutableStorageIndexes;", "keepLastRbsEngine", "getKeepLastRbsEngine$intellij_platform_workspaceModel_storage", "()Z", "setKeepLastRbsEngine$intellij_platform_workspaceModel_storage", "(Z)V", "modificationCount", "", "getModificationCount", "()J", "getRefs$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/MutableRefsTable;", "stackTrace", "", "threadId", "Ljava/lang/Long;", "threadName", "throwExceptionOnError", "<set-?>", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/storage/impl/AddDiffOperation;", "", "upgradeAddDiffEngine", "getUpgradeAddDiffEngine$intellij_platform_workspaceModel_storage", "()Lkotlin/jvm/functions/Function1;", "setUpgradeAddDiffEngine$intellij_platform_workspaceModel_storage", "(Lkotlin/jvm/functions/Function1;)V", "upgradeEngine", "getUpgradeEngine$intellij_platform_workspaceModel_storage", "setUpgradeEngine$intellij_platform_workspaceModel_storage", "useNewRbs", "getUseNewRbs$intellij_platform_workspaceModel_storage", "setUseNewRbs$intellij_platform_workspaceModel_storage", "writingFlag", "Ljava/util/concurrent/atomic/AtomicBoolean;", "accumulateEntitiesToRemove", "id", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "accumulator", "", "entityFilter", "addDiff", "diff", "addDiffAndReport", "message", "left", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "right", "addDiffAndReport$intellij_platform_workspaceModel_storage", "addEntity", "T", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "entity", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntity;)Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "applyDiffProtection", "method", "assertUniqueSymbolicId", "pEntityData", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "collectChanges", "", "Ljava/lang/Class;", "", "Lcom/intellij/workspaceModel/storage/EntityChange;", "original", "createAddEvent", "createAddEvent$intellij_platform_workspaceModel_storage", "entities", "Lkotlin/sequences/Sequence;", "E", "entityClass", "entitiesBySource", "Lcom/intellij/workspaceModel/storage/EntitySource;", "sourceFilter", "getMutableExternalMapping", "Lcom/intellij/workspaceModel/storage/MutableExternalEntityMapping;", "identifier", "getMutableVirtualFileUrlIndex", "Lcom/intellij/workspaceModel/storage/url/MutableVirtualFileUrlIndex;", "getRbsEngine", "hasChanges", "hasSameEntities", "incModificationCount", "incModificationCount$intellij_platform_workspaceModel_storage", "isEmpty", "lockWrite", "modifyEntity", "M", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity$Builder;", "clazz", "e", "change", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Class;Lcom/intellij/workspaceModel/storage/WorkspaceEntity;Lkotlin/jvm/functions/Function1;)Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "putEntity", "D", "Lcom/intellij/workspaceModel/storage/impl/ModifiableWorkspaceEntityBase;", "(Lcom/intellij/workspaceModel/storage/impl/ModifiableWorkspaceEntityBase;)V", "referrers", "R", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityWithSymbolicId;", "Lcom/intellij/workspaceModel/storage/SymbolicEntityId;", "removeEntity", "removeEntityByEntityId", "idx", "removeEntityByEntityId$intellij_platform_workspaceModel_storage", "replaceBySource", "replaceWith", "resolve", "(Lcom/intellij/workspaceModel/storage/SymbolicEntityId;)Lcom/intellij/workspaceModel/storage/WorkspaceEntityWithSymbolicId;", "same", "originalImpl", "addedEntityId", "removedEntityId", "setUseNewRbs", "value", "toSnapshot", "Lcom/intellij/workspaceModel/storage/EntityStorageSnapshot;", "unlockWrite", "updateEntitySource", "entityId", "originalEntityData", "copiedEntityData", "Companion", "intellij.platform.workspaceModel.storage"})
public final class MutableEntityStorageImpl
extends AbstractEntityStorage
implements MutableEntityStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableEntitiesBarrel entitiesByType;
    @NotNull
    private final MutableRefsTable refs;
    @NotNull
    private final MutableStorageIndexes indexes;
    private volatile boolean trackStackTrace;
    @NotNull
    private final WorkspaceBuilderChangeLog changeLog;
    private boolean throwExceptionOnError;
    @NotNull
    private final AtomicBoolean writingFlag;
    @Nullable
    private volatile String stackTrace;
    @Nullable
    private volatile Long threadId;
    @Nullable
    private volatile String threadName;
    private boolean useNewRbs;
    @TestOnly
    private boolean keepLastRbsEngine;
    @Nullable
    private ReplaceBySourceOperation engine;
    @Nullable
    private Function1<? super ReplaceBySourceOperation, Unit> upgradeEngine;
    @Nullable
    private Function1<? super AddDiffOperation, Unit> upgradeAddDiffEngine;
    @NotNull
    private static final Logger LOG;

    public MutableEntityStorageImpl(@NotNull MutableEntitiesBarrel entitiesByType, @NotNull MutableRefsTable refs, @NotNull MutableStorageIndexes indexes, boolean trackStackTrace) {
        Intrinsics.checkNotNullParameter((Object)entitiesByType, (String)"entitiesByType");
        Intrinsics.checkNotNullParameter((Object)refs, (String)"refs");
        Intrinsics.checkNotNullParameter((Object)indexes, (String)"indexes");
        super(null);
        this.entitiesByType = entitiesByType;
        this.refs = refs;
        this.indexes = indexes;
        this.trackStackTrace = trackStackTrace;
        this.changeLog = new WorkspaceBuilderChangeLog();
        this.writingFlag = new AtomicBoolean();
        this.useNewRbs = Registry.is("ide.workspace.model.rbs.as.tree", true);
    }

    public /* synthetic */ MutableEntityStorageImpl(MutableEntitiesBarrel mutableEntitiesBarrel, MutableRefsTable mutableRefsTable, MutableStorageIndexes mutableStorageIndexes, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(mutableEntitiesBarrel, mutableRefsTable, mutableStorageIndexes, bl);
    }

    @Override
    @NotNull
    public MutableEntitiesBarrel getEntitiesByType$intellij_platform_workspaceModel_storage() {
        return this.entitiesByType;
    }

    @Override
    @NotNull
    public MutableRefsTable getRefs$intellij_platform_workspaceModel_storage() {
        return this.refs;
    }

    @Override
    @NotNull
    public MutableStorageIndexes getIndexes$intellij_platform_workspaceModel_storage() {
        return this.indexes;
    }

    @NotNull
    public final WorkspaceBuilderChangeLog getChangeLog$intellij_platform_workspaceModel_storage() {
        return this.changeLog;
    }

    public final void incModificationCount$intellij_platform_workspaceModel_storage() {
        WorkspaceBuilderChangeLog workspaceBuilderChangeLog = this.changeLog;
        long l = workspaceBuilderChangeLog.getModificationCount();
        workspaceBuilderChangeLog.setModificationCount(l + 1L);
    }

    @Override
    public long getModificationCount() {
        return this.changeLog.getModificationCount();
    }

    @Override
    public void setUseNewRbs(boolean value) {
        this.useNewRbs = value;
    }

    public final boolean getUseNewRbs$intellij_platform_workspaceModel_storage() {
        return this.useNewRbs;
    }

    public final void setUseNewRbs$intellij_platform_workspaceModel_storage(boolean bl) {
        this.useNewRbs = bl;
    }

    public final boolean getKeepLastRbsEngine$intellij_platform_workspaceModel_storage() {
        return this.keepLastRbsEngine;
    }

    public final void setKeepLastRbsEngine$intellij_platform_workspaceModel_storage(boolean bl) {
        this.keepLastRbsEngine = bl;
    }

    @Nullable
    public final ReplaceBySourceOperation getEngine$intellij_platform_workspaceModel_storage() {
        return this.engine;
    }

    public final void setEngine$intellij_platform_workspaceModel_storage(@Nullable ReplaceBySourceOperation replaceBySourceOperation) {
        this.engine = replaceBySourceOperation;
    }

    @Nullable
    public final Function1<ReplaceBySourceOperation, Unit> getUpgradeEngine$intellij_platform_workspaceModel_storage() {
        return this.upgradeEngine;
    }

    @TestOnly
    public final void setUpgradeEngine$intellij_platform_workspaceModel_storage(@Nullable Function1<? super ReplaceBySourceOperation, Unit> function1) {
        this.upgradeEngine = function1;
    }

    @Nullable
    public final Function1<AddDiffOperation, Unit> getUpgradeAddDiffEngine$intellij_platform_workspaceModel_storage() {
        return this.upgradeAddDiffEngine;
    }

    @TestOnly
    public final void setUpgradeAddDiffEngine$intellij_platform_workspaceModel_storage(@Nullable Function1<? super AddDiffOperation, Unit> function1) {
        this.upgradeAddDiffEngine = function1;
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntity> Sequence<E> entities(@NotNull Class<E> entityClass) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().get(ClassToIntConverterKt.toClassId(entityClass));
        Sequence sequence2 = sequence = entityFamily != null && (entityFamily = entityFamily.all()) != null ? SequencesKt.map(entityFamily, (Function1)((Function1)new Function1<WorkspaceEntityData<? extends WorkspaceEntity>, WorkspaceEntity.Builder<? extends WorkspaceEntity>>(this){
            final /* synthetic */ MutableEntityStorageImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final WorkspaceEntity.Builder<? extends WorkspaceEntity> invoke(@NotNull WorkspaceEntityData<? extends WorkspaceEntity> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.wrapAsModifiable(this.this$0);
            }
        })) : null;
        Sequence sequence3 = sequence instanceof Sequence ? sequence : null;
        if (sequence3 == null) {
            sequence3 = SequencesKt.emptySequence();
        }
        return sequence3;
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntityWithSymbolicId, R extends WorkspaceEntity> Sequence<R> referrers(@NotNull SymbolicEntityId<? extends E> id, @NotNull Class<R> entityClass) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        int classId = ClassToIntConverterKt.toClassId(entityClass);
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getIndexes$intellij_platform_workspaceModel_storage().getSoftLinks$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(id)), (Function1)((Function1)new Function1<Long, Boolean>(classId){
            final /* synthetic */ int $classId;
            {
                this.$classId = $classId;
                super(1);
            }

            @NotNull
            public final Boolean invoke(long it) {
                return EntityIdKt.getClazz(it) == this.$classId;
            }
        })), (Function1)new Function1<Long, R>(this){
            final /* synthetic */ MutableEntityStorageImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final R invoke(long it) {
                WorkspaceEntity.Builder<? extends WorkspaceEntity> builder = this.this$0.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(it).wrapAsModifiable(this.this$0);
                Intrinsics.checkNotNull(builder, (String)"null cannot be cast to non-null type R of com.intellij.workspaceModel.storage.impl.MutableEntityStorageImpl.referrers");
                return (R)builder;
            }
        });
    }

    @Override
    @Nullable
    public <E extends WorkspaceEntityWithSymbolicId> E resolve(@NotNull SymbolicEntityId<? extends E> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Long l = this.getIndexes$intellij_platform_workspaceModel_storage().getSymbolicIdIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(id);
        if (l == null) {
            return null;
        }
        long entityIds = l;
        WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = this.entityDataById$intellij_platform_workspaceModel_storage(entityIds);
        WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData2 = workspaceEntityData instanceof WorkspaceEntityData ? workspaceEntityData : null;
        if (workspaceEntityData2 == null) {
            return null;
        }
        WorkspaceEntityData<? extends WorkspaceEntity> entityData = workspaceEntityData2;
        return (E)((WorkspaceEntityWithSymbolicId)((Object)entityData.wrapAsModifiable(this)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<EntitySource, Map<Class<? extends WorkspaceEntity>, List<WorkspaceEntity>>> entitiesBySource(@NotNull Function1<? super EntitySource, Boolean> sourceFilter) {
        Intrinsics.checkNotNullParameter(sourceFilter, (String)"sourceFilter");
        Sequence $this$associateWith$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().entries$intellij_platform_workspaceModel_storage()), (Function1)((Function1)new Function1<EntitySource, Boolean>(sourceFilter){
            final /* synthetic */ Function1<EntitySource, Boolean> $sourceFilter;
            {
                this.$sourceFilter = $sourceFilter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull EntitySource it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$sourceFilter.invoke((Object)it);
            }
        }));
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Sequence $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            void $this$mapTo$iv$iv;
            void source;
            EntitySource entitySource = (EntitySource)element$iv$iv;
            Object e = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            List<Long> list = this.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(source);
            Intrinsics.checkNotNull(list);
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                WorkspaceEntityData<? extends WorkspaceEntity> entityDataById;
                void it;
                long l = ((Number)item$iv$iv).longValue();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = this.entityDataById$intellij_platform_workspaceModel_storage((long)it);
                if ((workspaceEntityData instanceof WorkspaceEntityData ? workspaceEntityData : null) == null) {
                    MutableEntityStorageImpl $this$entitiesBySource_u24lambda_u243_u24lambda_u241_u24lambda_u240 = this;
                    boolean bl3 = false;
                    ErrorReportingKt.reportErrorAndAttachStorage("Cannot find an entity by id " + (long)it, this);
                    throw new IllegalStateException(("Cannot find an entity by id " + (long)it).toString());
                }
                entityDataById = entityDataById;
                collection.add(entityDataById.wrapAsModifiable(this));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
                Object object;
                WorkspaceEntity.Builder it = (WorkspaceEntity.Builder)element$iv$iv2;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                Class<? extends WorkspaceEntity> key$iv$iv = ((WorkspaceEntityBase)((Object)it)).getEntityInterface();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv2);
            }
            Object object = destination$iv$iv;
            map2.put(e, object);
        }
        return result$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T extends WorkspaceEntity> T addEntity(@NotNull T entity2) {
        Intrinsics.checkNotNullParameter(entity2, (String)"entity");
        try {
            this.lockWrite();
            ModifiableWorkspaceEntityBase cfr_ignored_0 = (ModifiableWorkspaceEntityBase)entity2;
            ((ModifiableWorkspaceEntityBase)entity2).applyToBuilder(this);
            ((ModifiableWorkspaceEntityBase)entity2).getChangedProperty().clear();
        }
        finally {
            this.unlockWrite();
        }
        return entity2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends WorkspaceEntity, E extends WorkspaceEntityData<T>, D extends ModifiableWorkspaceEntityBase<T, E>> void putEntity(@NotNull D entity2) {
        Intrinsics.checkNotNullParameter(entity2, (String)"entity");
        try {
            this.lockWrite();
            WorkspaceEntityData newEntityData = ModifiableWorkspaceEntityBase.getEntityData$default(entity2, false, 1, null);
            this.assertUniqueSymbolicId(newEntityData);
            this.getEntitiesByType$intellij_platform_workspaceModel_storage().add(newEntityData, ClassToIntConverterKt.toClassId(entity2.getEntityClass()));
            this.createAddEvent$intellij_platform_workspaceModel_storage(newEntityData);
            this.getIndexes$intellij_platform_workspaceModel_storage().entityAdded(newEntityData);
        }
        finally {
            this.unlockWrite();
        }
    }

    private final <T extends WorkspaceEntity> void assertUniqueSymbolicId(WorkspaceEntityData<T> pEntityData) {
        SymbolicEntityId<?> symbolicEntityId = EntitiesKt.symbolicId(pEntityData);
        if (symbolicEntityId != null) {
            SymbolicEntityId<?> symbolicId = symbolicEntityId;
            boolean bl = false;
            Long ids = this.getIndexes$intellij_platform_workspaceModel_storage().getSymbolicIdIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(symbolicId);
            if (ids != null) {
                WorkspaceEntityData<? extends WorkspaceEntity> existingEntityData = this.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(ids);
                WorkspaceEntity existingEntity = existingEntityData.createEntity(this);
                this.removeEntity(existingEntity);
                LOG.error(StringsKt.trimIndent((String)("\n              addEntity: symbolic id already exists. Replacing entity with the new one.\n              Symbolic id: " + symbolicId + "\n              \n              Existing entity data: " + existingEntityData + "\n              New entity data: " + pEntityData + "\n              \n              Broken consistency: " + this.getBrokenConsistency$intellij_platform_workspaceModel_storage() + "\n            ")), new SymbolicIdAlreadyExistsException(symbolicId));
                if (this.throwExceptionOnError) {
                    throw new SymbolicIdAlreadyExistsException(symbolicId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <M extends WorkspaceEntity.Builder<? extends T>, T extends WorkspaceEntity> T modifyEntity(@NotNull Class<M> clazz, @NotNull T e, @NotNull Function1<? super M, Unit> change) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(e, (String)"e");
        Intrinsics.checkNotNullParameter(change, (String)"change");
        try {
            void $this$flatMapTo$iv$iv;
            this.lockWrite();
            if (e instanceof ModifiableWorkspaceEntityBase && ((ModifiableWorkspaceEntityBase)e).getDiff() != this) {
                throw new IllegalStateException("Trying to modify entity from a different builder".toString());
            }
            long entityId = ((WorkspaceEntityBase)e).getId();
            WorkspaceEntityData<?> workspaceEntityData = WorkspaceBuilderChangeLogKt.getOriginalEntityData(this, entityId);
            Intrinsics.checkNotNull(workspaceEntityData, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<T of com.intellij.workspaceModel.storage.impl.MutableEntityStorageImpl.modifyEntity>");
            WorkspaceEntityData<?> originalEntityData = workspaceEntityData;
            WorkspaceEntityData<?> workspaceEntityData2 = this.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityDataForModification(entityId);
            Intrinsics.checkNotNull(workspaceEntityData2, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<T of com.intellij.workspaceModel.storage.impl.MutableEntityStorageImpl.modifyEntity>");
            WorkspaceEntityData<?> copiedData = workspaceEntityData2;
            WorkspaceEntity.Builder<?> builder = e instanceof WorkspaceEntity.Builder ? (WorkspaceEntity.Builder<?>)e : copiedData.wrapAsModifiable(this);
            Intrinsics.checkNotNull(builder, (String)"null cannot be cast to non-null type M of com.intellij.workspaceModel.storage.impl.MutableEntityStorageImpl.modifyEntity");
            WorkspaceEntity.Builder<?> modifiableEntity = builder;
            ModifiableWorkspaceEntityBase cfr_ignored_0 = (ModifiableWorkspaceEntityBase)modifiableEntity;
            ((ModifiableWorkspaceEntityBase)modifiableEntity).getChangedProperty().clear();
            SymbolicEntityId<WorkspaceEntityWithSymbolicId> beforeSymbolicId = e instanceof WorkspaceEntityWithSymbolicId ? ((WorkspaceEntityWithSymbolicId)e).getSymbolicId() : null;
            Map<ConnectionId, ParentEntityId> originalParents = WorkspaceBuilderChangeLogKt.getOriginalParents(this, RefsTableKt.asChild(entityId));
            Map<ConnectionId, ParentEntityId> beforeParents = this.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(entityId));
            Map<ConnectionId, List<ChildEntityId>> $this$flatMap$iv = this.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(entityId));
            boolean $i$f$flatMap = false;
            Map<ConnectionId, List<ChildEntityId>> map2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$mapTo$iv$iv;
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator.next();
                boolean bl = false;
                ConnectionId key = (ConnectionId)entry.getKey();
                List value = (List)entry.getValue();
                Iterable $this$map$iv = value;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ChildEntityId childEntityId = (ChildEntityId)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(TuplesKt.to((Object)key, (Object)it));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List beforeChildren = (List)destination$iv$iv;
            ModifiableWorkspaceEntityBase this_$iv = (ModifiableWorkspaceEntityBase)modifiableEntity;
            boolean $i$f$allowModifications = false;
            this_$iv.getModifiable().set(true);
            try {
                boolean bl = false;
                change.invoke(modifiableEntity);
                ((ModifiableWorkspaceEntityBase)modifiableEntity).afterModification();
            }
            finally {
                this_$iv.getModifiable().remove();
            }
            if (beforeSymbolicId != null) {
                SymbolicEntityId<?> newSymbolicId = EntitiesKt.symbolicId(copiedData);
                if (newSymbolicId != null) {
                    Long ids = this.getIndexes$intellij_platform_workspaceModel_storage().getSymbolicIdIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(newSymbolicId);
                    if (!Intrinsics.areEqual(beforeSymbolicId, newSymbolicId) && ids != null) {
                        WorkspaceEntityData<? extends WorkspaceEntity> existingEntityData = this.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(ids);
                        WorkspaceEntity existingEntity = existingEntityData.createEntity(this);
                        this.removeEntity(existingEntity);
                        LOG.error(StringsKt.trimIndent((String)("\n              modifyEntity: persistent id already exists. Replacing entity with the new one.\n              Old entity: " + existingEntityData + "\n              Persistent id: " + copiedData + "\n              \n              Broken consistency: " + this.getBrokenConsistency$intellij_platform_workspaceModel_storage() + "\n            ")), new SymbolicIdAlreadyExistsException(newSymbolicId));
                        if (this.throwExceptionOnError) {
                            throw new SymbolicIdAlreadyExistsException(newSymbolicId);
                        }
                    }
                } else {
                    LOG.error("Persistent id expected for entity: " + copiedData);
                }
            }
            if (!((ModifiableWorkspaceEntityBase)modifiableEntity).getChangedProperty().contains("entitySource") || ((ModifiableWorkspaceEntityBase)modifiableEntity).getChangedProperty().size() > 1) {
                Companion.addReplaceEvent$intellij_platform_workspaceModel_storage(this, entityId, beforeChildren, beforeParents, copiedData, originalEntityData, originalParents);
            }
            if (((ModifiableWorkspaceEntityBase)modifiableEntity).getChangedProperty().contains("entitySource")) {
                this.updateEntitySource(entityId, originalEntityData, copiedData);
            }
            Object updatedEntity = copiedData.createEntity(this);
            this.getIndexes$intellij_platform_workspaceModel_storage().updateSymbolicIdIndexes(this, (WorkspaceEntity)updatedEntity, beforeSymbolicId, copiedData, (ModifiableWorkspaceEntityBase)modifiableEntity);
            Object obj = updatedEntity;
            return (T)obj;
        }
        finally {
            this.unlockWrite();
        }
    }

    private final <T extends WorkspaceEntity> void updateEntitySource(long entityId, WorkspaceEntityData<T> originalEntityData, WorkspaceEntityData<T> copiedEntityData) {
        block1: {
            EntitySource newSource = copiedEntityData.getEntitySource();
            EntitySource entitySource = WorkspaceBuilderChangeLogKt.getOriginalSourceFromChangelog(this, entityId);
            if (entitySource == null) {
                entitySource = originalEntityData.getEntitySource();
            }
            EntitySource originalSource = entitySource;
            this.changeLog.addChangeSourceEvent$intellij_platform_workspaceModel_storage(entityId, copiedEntityData, originalSource);
            ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(entityId, newSource);
            VirtualFileUrl virtualFileUrl = newSource.getVirtualFileUrl();
            if (virtualFileUrl == null) break block1;
            VirtualFileUrl it = virtualFileUrl;
            boolean bl = false;
            this.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage().index$intellij_platform_workspaceModel_storage(entityId, "entitySource", it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntity(@NotNull WorkspaceEntity e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        try {
            this.lockWrite();
            if (e instanceof ModifiableWorkspaceEntityBase && ((ModifiableWorkspaceEntityBase)e).getDiff() != this) {
                throw new IllegalStateException("Trying to remove entity from a different builder".toString());
            }
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Removing " + e.getClass() + "...", e$iv);
            }
            WorkspaceEntityBase cfr_ignored_0 = (WorkspaceEntityBase)e;
            boolean bl = MutableEntityStorageImpl.removeEntityByEntityId$intellij_platform_workspaceModel_storage$default(this, ((WorkspaceEntityBase)e).getId(), null, 2, null);
            return bl;
        }
        finally {
            this.unlockWrite();
        }
    }

    private final ReplaceBySourceOperation getRbsEngine() {
        if (this.useNewRbs) {
            return new ReplaceBySourceAsTree();
        }
        return new ReplaceBySourceAsGraph();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceBySource(@NotNull Function1<? super EntitySource, Boolean> sourceFilter, @NotNull EntityStorage replaceWith) {
        Intrinsics.checkNotNullParameter(sourceFilter, (String)"sourceFilter");
        Intrinsics.checkNotNullParameter((Object)replaceWith, (String)"replaceWith");
        try {
            this.lockWrite();
            AbstractEntityStorage cfr_ignored_0 = (AbstractEntityStorage)replaceWith;
            ReplaceBySourceOperation rbsEngine = this.getRbsEngine();
            if (this.keepLastRbsEngine) {
                this.engine = rbsEngine;
            }
            Function1<? super ReplaceBySourceOperation, Unit> function1 = this.upgradeEngine;
            if (function1 != null) {
                Function1<? super ReplaceBySourceOperation, Unit> it = function1;
                boolean bl = false;
                it.invoke((Object)rbsEngine);
            }
            rbsEngine.replace(this, (AbstractEntityStorage)replaceWith, sourceFilter);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Class<?>, List<EntityChange<?>>> collectChanges(@NotNull EntityStorage original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        try {
            this.lockWrite();
            AbstractEntityStorage originalImpl = (AbstractEntityStorage)original;
            HashMap res = new HashMap();
            for (Map.Entry<Long, ChangeEntry> entry : this.changeLog.getChangeLog$intellij_platform_workspaceModel_storage().entrySet()) {
                Object object;
                void key$iv;
                List answer$iv;
                Object value$iv;
                WorkspaceEntityBase replaceToData;
                WorkspaceEntityBase replacedData;
                WorkspaceEntityData<? extends WorkspaceEntity> oldData;
                Map key$iv2;
                long entityId = ((Number)entry.getKey()).longValue();
                ChangeEntry change = entry.getValue();
                ChangeEntry changeEntry = change;
                if (changeEntry instanceof ChangeEntry.AddEntity) {
                    Object object2;
                    void $this$getOrPut$iv;
                    WorkspaceEntity workspaceEntity = ((ChangeEntry.AddEntity)change).getEntityData().createEntity(this);
                    Intrinsics.checkNotNull((Object)workspaceEntity, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                    WorkspaceEntityBase addedEntity = (WorkspaceEntityBase)workspaceEntity;
                    Map map2 = res;
                    int $this$findEntityClass$iv = EntityIdKt.getClazz(entityId);
                    boolean $i$f$findEntityClass = false;
                    Intrinsics.checkNotNull(ClassToIntConverter.Companion.getINSTANCE().getClassOrDie($this$findEntityClass$iv), (String)"null cannot be cast to non-null type java.lang.Class<E of com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt.findEntityClass>");
                    boolean $i$f$getOrPut = false;
                    Object value$iv2 = $this$getOrPut$iv.get(key$iv2);
                    if (value$iv2 == null) {
                        boolean bl = false;
                        List answer$iv2 = new ArrayList();
                        $this$getOrPut$iv.put(key$iv2, answer$iv2);
                        object2 = answer$iv2;
                    } else {
                        object2 = value$iv2;
                    }
                    ((List)object2).add(new EntityChange.Added<WorkspaceEntity>(addedEntity));
                    continue;
                }
                if (changeEntry instanceof ChangeEntry.RemoveEntity) {
                    Object object3;
                    void key$iv3;
                    void $this$getOrPut$iv;
                    WorkspaceEntityData<? extends WorkspaceEntity> removedData;
                    if (originalImpl.entityDataById$intellij_platform_workspaceModel_storage(((ChangeEntry.RemoveEntity)change).getId()) == null) continue;
                    WorkspaceEntity workspaceEntity = removedData.createEntity(originalImpl);
                    Intrinsics.checkNotNull((Object)workspaceEntity, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                    WorkspaceEntityBase removedEntity = (WorkspaceEntityBase)workspaceEntity;
                    key$iv2 = res;
                    int $this$findEntityClass$iv = EntityIdKt.getClazz(entityId);
                    boolean $i$f$findEntityClass = false;
                    Intrinsics.checkNotNull(ClassToIntConverter.Companion.getINSTANCE().getClassOrDie($this$findEntityClass$iv), (String)"null cannot be cast to non-null type java.lang.Class<E of com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt.findEntityClass>");
                    boolean $i$f$getOrPut = false;
                    Object value$iv3 = $this$getOrPut$iv.get(key$iv3);
                    if (value$iv3 == null) {
                        boolean bl = false;
                        List answer$iv3 = new ArrayList();
                        $this$getOrPut$iv.put(key$iv3, answer$iv3);
                        object3 = answer$iv3;
                    } else {
                        object3 = value$iv3;
                    }
                    ((List)object3).add(new EntityChange.Removed<WorkspaceEntity>(removedEntity));
                    continue;
                }
                if (changeEntry instanceof ChangeEntry.ReplaceEntity) {
                    Object object4;
                    void key$iv4;
                    void $this$getOrPut$iv;
                    if (originalImpl.entityDataById$intellij_platform_workspaceModel_storage(entityId) == null) continue;
                    WorkspaceEntity workspaceEntity = oldData.createEntity(originalImpl);
                    Intrinsics.checkNotNull((Object)workspaceEntity, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                    replacedData = (WorkspaceEntityBase)workspaceEntity;
                    WorkspaceEntity workspaceEntity2 = ((ChangeEntry.ReplaceEntity)change).getNewData().createEntity(this);
                    Intrinsics.checkNotNull((Object)workspaceEntity2, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                    replaceToData = (WorkspaceEntityBase)workspaceEntity2;
                    Map key$iv3 = res;
                    int $this$findEntityClass$iv = EntityIdKt.getClazz(entityId);
                    boolean $i$f$findEntityClass = false;
                    Intrinsics.checkNotNull(ClassToIntConverter.Companion.getINSTANCE().getClassOrDie($this$findEntityClass$iv), (String)"null cannot be cast to non-null type java.lang.Class<E of com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt.findEntityClass>");
                    boolean $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(key$iv4);
                    if (value$iv == null) {
                        boolean bl = false;
                        answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv4, answer$iv);
                        object4 = answer$iv;
                    } else {
                        object4 = value$iv;
                    }
                    ((List)object4).add(new EntityChange.Replaced<WorkspaceEntity>(replacedData, replaceToData));
                    continue;
                }
                if (changeEntry instanceof ChangeEntry.ChangeEntitySource) {
                    Object object5;
                    void key$iv5;
                    if (originalImpl.entityDataById$intellij_platform_workspaceModel_storage(entityId) == null) continue;
                    WorkspaceEntity workspaceEntity = oldData.createEntity(originalImpl);
                    Intrinsics.checkNotNull((Object)workspaceEntity, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                    replacedData = (WorkspaceEntityBase)workspaceEntity;
                    WorkspaceEntity workspaceEntity3 = ((ChangeEntry.ChangeEntitySource)change).getNewData().createEntity(this);
                    Intrinsics.checkNotNull((Object)workspaceEntity3, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                    replaceToData = (WorkspaceEntityBase)workspaceEntity3;
                    Map $this$getOrPut$iv = res;
                    int $this$findEntityClass$iv = EntityIdKt.getClazz(entityId);
                    boolean $i$f$findEntityClass = false;
                    Intrinsics.checkNotNull(ClassToIntConverter.Companion.getINSTANCE().getClassOrDie($this$findEntityClass$iv), (String)"null cannot be cast to non-null type java.lang.Class<E of com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt.findEntityClass>");
                    boolean $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(key$iv5);
                    if (value$iv == null) {
                        boolean bl = false;
                        answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv5, answer$iv);
                        object5 = answer$iv;
                    } else {
                        object5 = value$iv;
                    }
                    ((List)object5).add(new EntityChange.Replaced<WorkspaceEntity>(replacedData, replaceToData));
                    continue;
                }
                if (!(changeEntry instanceof ChangeEntry.ReplaceAndChangeSource) || originalImpl.entityDataById$intellij_platform_workspaceModel_storage(entityId) == null) continue;
                WorkspaceEntity workspaceEntity = oldData.createEntity(originalImpl);
                Intrinsics.checkNotNull((Object)workspaceEntity, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                replacedData = (WorkspaceEntityBase)workspaceEntity;
                WorkspaceEntity workspaceEntity4 = ((ChangeEntry.ReplaceAndChangeSource)change).getDataChange().getNewData().createEntity(this);
                Intrinsics.checkNotNull((Object)workspaceEntity4, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                replaceToData = (WorkspaceEntityBase)workspaceEntity4;
                Map $this$getOrPut$iv = res;
                int $this$findEntityClass$iv = EntityIdKt.getClazz(entityId);
                boolean $i$f$findEntityClass = false;
                Intrinsics.checkNotNull(ClassToIntConverter.Companion.getINSTANCE().getClassOrDie($this$findEntityClass$iv), (String)"null cannot be cast to non-null type java.lang.Class<E of com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt.findEntityClass>");
                boolean $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(new EntityChange.Replaced<WorkspaceEntity>(replacedData, replaceToData));
            }
            Map map3 = res;
            return map3;
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public boolean hasSameEntities(@NotNull EntityStorage original) {
        Pair pair;
        Object object;
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        if (this.changeLog.getChangeLog$intellij_platform_workspaceModel_storage().isEmpty()) {
            return true;
        }
        AbstractEntityStorage cfr_ignored_0 = (AbstractEntityStorage)original;
        ArrayList adds = new ArrayList();
        Map<WorkspaceEntityData<? extends WorkspaceEntity>, List<WorkspaceEntityData<? extends WorkspaceEntity>>> map2 = CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"createSmallMemoryFootpri\u2026<out WorkspaceEntity>>>()");
        Map<WorkspaceEntityData<? extends WorkspaceEntity>, List<WorkspaceEntityData<? extends WorkspaceEntity>>> removes = map2;
        this.changeLog.getChangeLog$intellij_platform_workspaceModel_storage().forEach((arg_0, arg_1) -> MutableEntityStorageImpl.hasSameEntities$lambda$16((Function2)new Function2<Long, ChangeEntry, Unit>(adds, removes){
            final /* synthetic */ ArrayList<WorkspaceEntityData<?>> $adds;
            final /* synthetic */ Map<WorkspaceEntityData<? extends WorkspaceEntity>, List<WorkspaceEntityData<? extends WorkspaceEntity>>> $removes;
            {
                this.$adds = $adds;
                this.$removes = $removes;
                super(2);
            }

            public final void invoke(@NotNull Long l, @NotNull ChangeEntry value) {
                Intrinsics.checkNotNullParameter((Object)l, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (value instanceof ChangeEntry.AddEntity) {
                    this.$adds.add(((ChangeEntry.AddEntity)value).getEntityData());
                } else if (value instanceof ChangeEntry.RemoveEntity) {
                    Object object;
                    List list;
                    List<WorkspaceEntityData<? extends WorkspaceEntity>> existingValue = this.$removes.get(((ChangeEntry.RemoveEntity)value).getOldData());
                    Map<WorkspaceEntityData<? extends WorkspaceEntity>, List<WorkspaceEntityData<? extends WorkspaceEntity>>> map2 = this.$removes;
                    WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = ((ChangeEntry.RemoveEntity)value).getOldData();
                    if (existingValue != null) {
                        list = new ArrayList<E>(CollectionsKt.plus((Collection)existingValue, ((ChangeEntry.RemoveEntity)value).getOldData()));
                    } else {
                        object = new WorkspaceEntityData[]{((ChangeEntry.RemoveEntity)value).getOldData()};
                        list = CollectionsKt.mutableListOf((Object[])object);
                    }
                    object = list;
                    map2.put(workspaceEntityData, (List<WorkspaceEntityData<? extends WorkspaceEntity>>)object);
                }
            }
        }, arg_0, arg_1));
        ArrayList idsToRemove = new ArrayList();
        Iterable $this$forEach$iv = adds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean hasRemovedMapping;
            boolean bl;
            long initialEntityId;
            WorkspaceEntityData found;
            long newEntityId;
            List<WorkspaceEntityData<? extends WorkspaceEntity>> possibleRemovedSameEntity;
            WorkspaceEntityData addedEntityData;
            block20: {
                WorkspaceEntityData workspaceEntityData;
                boolean hasMapping;
                Object element$iv2;
                boolean bl2;
                block18: {
                    addedEntityData = (WorkspaceEntityData)element$iv;
                    boolean bl3 = false;
                    if (removes.isEmpty()) continue;
                    possibleRemovedSameEntity = removes.get(addedEntityData);
                    newEntityId = addedEntityData.createEntityId();
                    Map<String, MutableExternalEntityMappingImpl<?>> $this$any$iv = this.getIndexes$intellij_platform_workspaceModel_storage().getExternalMappings$intellij_platform_workspaceModel_storage();
                    boolean $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        bl2 = false;
                    } else {
                        Iterator<Map.Entry<String, MutableExternalEntityMappingImpl<?>>> iterator = $this$any$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            object = element$iv2 = iterator.next();
                            boolean bl4 = false;
                            MutableExternalEntityMappingImpl<?> value = object.getValue();
                            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.external.ExternalEntityMappingImpl<*>");
                            if (!(((ExternalEntityMappingImpl)value).getDataByEntityId$intellij_platform_workspaceModel_storage(newEntityId) != null)) continue;
                            bl2 = true;
                            break block18;
                        }
                        bl2 = false;
                    }
                }
                if (hasMapping = bl2) continue;
                List<WorkspaceEntityData<? extends WorkspaceEntity>> list = possibleRemovedSameEntity;
                if (list != null) {
                    Object v3;
                    block19: {
                        Iterable $this$firstOrNull$iv = list;
                        boolean $i$f$firstOrNull = false;
                        element$iv2 = $this$firstOrNull$iv.iterator();
                        while (element$iv2.hasNext()) {
                            Object element$iv3 = element$iv2.next();
                            WorkspaceEntityData possibleRemovedSame = (WorkspaceEntityData)element$iv3;
                            boolean bl5 = false;
                            if (!this.same((AbstractEntityStorage)original, newEntityId, possibleRemovedSame.createEntityId())) continue;
                            v3 = element$iv3;
                            break block19;
                        }
                        v3 = null;
                    }
                    workspaceEntityData = v3;
                } else {
                    workspaceEntityData = null;
                }
                if ((found = workspaceEntityData) == null) continue;
                initialEntityId = found.createEntityId();
                Map<String, ExternalEntityMappingImpl<?>> $this$any$iv = ((AbstractEntityStorage)original).getIndexes$intellij_platform_workspaceModel_storage().getExternalMappings$intellij_platform_workspaceModel_storage();
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterator<Map.Entry<String, ExternalEntityMappingImpl<?>>> iterator = $this$any$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Pair element$iv4;
                        pair = element$iv4 = iterator.next();
                        boolean bl6 = false;
                        ExternalEntityMappingImpl<?> value = pair.getValue();
                        if (!(value.getDataByEntityId$intellij_platform_workspaceModel_storage(initialEntityId) != null)) continue;
                        bl = true;
                        break block20;
                    }
                    bl = false;
                }
            }
            if (hasRemovedMapping = bl) continue;
            possibleRemovedSameEntity.remove(found);
            if (possibleRemovedSameEntity.isEmpty()) {
                removes.remove(addedEntityData);
            }
            ((Collection)idsToRemove).add(TuplesKt.to((Object)newEntityId, (Object)initialEntityId));
        }
        HashSet<Long> collapsibleChanges = new HashSet<Long>();
        Iterable $this$forEach$iv2 = idsToRemove;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Pair pair2 = (Pair)element$iv;
            boolean bl = false;
            long l = ((Number)pair2.component1()).longValue();
            long initial = ((Number)pair2.component2()).longValue();
            collapsibleChanges.add(l);
            collapsibleChanges.add(initial);
            Map<ConnectionId, ParentEntityId> $this$forEach$iv3 = this.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(l));
            boolean $i$f$forEach3 = false;
            object = $this$forEach$iv3.entrySet().iterator();
            while (object.hasNext()) {
                Object object2;
                Object object3;
                Pair it;
                Map.Entry element$iv5;
                Map.Entry entry = element$iv5 = (Map.Entry)object.next();
                boolean bl7 = false;
                ConnectionId connection = (ConnectionId)entry.getKey();
                ParentEntityId parent = (ParentEntityId)entry.getValue();
                ChangeEntry changedParent = this.changeLog.getChangeLog$intellij_platform_workspaceModel_storage().get(parent.getId());
                if (!(changedParent instanceof ChangeEntry.ReplaceEntity) || !Intrinsics.areEqual(((ChangeEntry.ReplaceEntity)changedParent).getNewData(), ((ChangeEntry.ReplaceEntity)changedParent).getOldData()) || !((ChangeEntry.ReplaceEntity)changedParent).getModifiedParents().isEmpty()) continue;
                if ((Pair)CollectionsKt.singleOrNull(((ChangeEntry.ReplaceEntity)changedParent).getRemovedChildren()) != null) {
                    it = pair;
                    boolean bl8 = false;
                    object3 = Intrinsics.areEqual((Object)it.getFirst(), (Object)connection) && ((ChildEntityId)it.getSecond()).getId() == initial ? pair : null;
                } else {
                    object3 = null;
                }
                if (object3 == null) continue;
                if ((Pair)CollectionsKt.singleOrNull(((ChangeEntry.ReplaceEntity)changedParent).getNewChildren()) != null) {
                    it = pair;
                    boolean bl9 = false;
                    object2 = Intrinsics.areEqual((Object)it.getFirst(), (Object)connection) && ((ChildEntityId)it.getSecond()).getId() == l ? pair : null;
                } else {
                    object2 = null;
                }
                if (object2 == null) continue;
                collapsibleChanges.add(parent.getId());
            }
        }
        return Intrinsics.areEqual(collapsibleChanges, this.changeLog.getChangeLog$intellij_platform_workspaceModel_storage().keySet());
    }

    private final boolean same(AbstractEntityStorage originalImpl, long addedEntityId, long removedEntityId) {
        boolean bl;
        block8: {
            if (addedEntityId == removedEntityId) {
                return true;
            }
            if (EntityIdKt.getClazz(addedEntityId) != EntityIdKt.getClazz(removedEntityId)) {
                return false;
            }
            Map<ConnectionId, ParentEntityId> addedParents = this.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(addedEntityId));
            Map<ConnectionId, ParentEntityId> removeParents = originalImpl.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(removedEntityId));
            if (!Intrinsics.areEqual(addedParents.keySet(), removeParents.keySet())) {
                return false;
            }
            Iterable $this$all$iv = addedParents.entrySet();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    ParentEntityId removedParentEntityId;
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl3 = false;
                    ConnectionId connectionId = (ConnectionId)entry.getKey();
                    ParentEntityId addedParentEntityId = (ParentEntityId)entry.getValue();
                    Intrinsics.checkNotNull((Object)removeParents.get(connectionId));
                    if (Intrinsics.areEqual((Object)addedParentEntityId, (Object)removedParentEntityId)) {
                        bl2 = true;
                    } else {
                        ChangeEntry addedParentInfo = this.changeLog.getChangeLog$intellij_platform_workspaceModel_storage().get(addedParentEntityId.getId());
                        ChangeEntry removedParentInfo = this.changeLog.getChangeLog$intellij_platform_workspaceModel_storage().get(removedParentEntityId.getId());
                        bl2 = addedParentInfo instanceof ChangeEntry.AddEntity && removedParentInfo instanceof ChangeEntry.RemoveEntity ? this.same(originalImpl, addedParentEntityId.getId(), removedParentEntityId.getId()) : false;
                    }
                    if (bl2) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public EntityStorageSnapshot toSnapshot() {
        ImmutableEntitiesBarrel newEntities = this.getEntitiesByType$intellij_platform_workspaceModel_storage().toImmutable();
        RefsTable newRefs = this.getRefs$intellij_platform_workspaceModel_storage().toImmutable();
        StorageIndexes newIndexes = this.getIndexes$intellij_platform_workspaceModel_storage().toImmutable();
        return new EntityStorageSnapshotImpl(newEntities, newRefs, newIndexes);
    }

    @Override
    @Deprecated(message="The name may be misleading, use !hasChanges() instead", replaceWith=@ReplaceWith(expression="!hasChanges()", imports={}))
    public boolean isEmpty() {
        return this.changeLog.getChangeLog$intellij_platform_workspaceModel_storage().isEmpty();
    }

    @Override
    public boolean hasChanges() {
        return !this.changeLog.getChangeLog$intellij_platform_workspaceModel_storage().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDiff(@NotNull MutableEntityStorage diff) {
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        try {
            this.lockWrite();
            MutableEntityStorageImpl cfr_ignored_0 = (MutableEntityStorageImpl)diff;
            this.applyDiffProtection((AbstractEntityStorage)((Object)diff), "addDiff");
            AddDiffOperation addDiffOperation = new AddDiffOperation(this, (MutableEntityStorageImpl)diff);
            Function1<? super AddDiffOperation, Unit> function1 = this.upgradeAddDiffEngine;
            if (function1 != null) {
                function1.invoke((Object)addDiffOperation);
            }
            addDiffOperation.addDiff();
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> MutableExternalEntityMapping<T> getMutableExternalMapping(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        try {
            this.lockWrite();
            MutableExternalEntityMapping mutableExternalEntityMapping = this.getIndexes$intellij_platform_workspaceModel_storage().getExternalMappings$intellij_platform_workspaceModel_storage().computeIfAbsent(identifier, arg_0 -> MutableEntityStorageImpl.getMutableExternalMapping$lambda$26(getMutableExternalMapping.mapping.1.INSTANCE, arg_0));
            Intrinsics.checkNotNull((Object)mutableExternalEntityMapping, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.external.MutableExternalEntityMappingImpl<T of com.intellij.workspaceModel.storage.impl.MutableEntityStorageImpl.getMutableExternalMapping>");
            MutableExternalEntityMappingImpl mapping2 = mutableExternalEntityMapping;
            mapping2.setTypedEntityStorage$intellij_platform_workspaceModel_storage(this);
            mutableExternalEntityMapping = mapping2;
            return mutableExternalEntityMapping;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public MutableVirtualFileUrlIndex getMutableVirtualFileUrlIndex() {
        try {
            this.lockWrite();
            VirtualFileIndex.MutableVirtualFileIndex virtualFileIndex = this.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage();
            virtualFileIndex.setTypedEntityStorage$intellij_platform_workspaceModel_storage(this);
            MutableVirtualFileUrlIndex mutableVirtualFileUrlIndex = virtualFileIndex;
            return mutableVirtualFileUrlIndex;
        }
        finally {
            this.unlockWrite();
        }
    }

    public final void addDiffAndReport$intellij_platform_workspaceModel_storage(@NotNull String message, @Nullable EntityStorage left, @NotNull EntityStorage right) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        ErrorReportingKt.reportConsistencyIssue(message, new AddDiffException(message), null, left, right, this);
    }

    private final void applyDiffProtection(AbstractEntityStorage diff, String method) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Applying " + method + ". Builder: " + diff);
        }
        if (diff.getStorageIsAlreadyApplied$intellij_platform_workspaceModel_storage()) {
            LOG.error("Builder is already applied.\n Info: \n" + diff.getApplyInfo$intellij_platform_workspaceModel_storage());
        } else {
            diff.setStorageIsAlreadyApplied$intellij_platform_workspaceModel_storage(true);
            String info = "Applying builder using " + method + ". Previous stack trace >>>>\n";
            if (LOG.isTraceEnabled()) {
                String string2 = ExceptionUtil.currentStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"currentStackTrace()");
                String currentStackTrace2 = string2;
                info = info + "\n" + currentStackTrace2;
            }
            info = info + "<<<<";
            diff.setApplyInfo$intellij_platform_workspaceModel_storage(info);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean removeEntityByEntityId$intellij_platform_workspaceModel_storage(long idx, @NotNull Function1<? super Long, Boolean> entityFilter) {
        Intrinsics.checkNotNullParameter(entityFilter, (String)"entityFilter");
        Object[] objectArray = new Long[]{idx};
        Set accumulator = SetsKt.mutableSetOf((Object[])objectArray);
        if (!this.getEntitiesByType$intellij_platform_workspaceModel_storage().exists(idx)) {
            return false;
        }
        this.accumulateEntitiesToRemove(idx, accumulator, entityFilter);
        Iterator $this$associateWith$iv = accumulator;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            long l = ((Number)element$iv$iv).longValue();
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            WorkspaceEntityData<?> workspaceEntityData = WorkspaceBuilderChangeLogKt.getOriginalEntityData(this, (long)it);
            Intrinsics.checkNotNull(workspaceEntityData, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<com.intellij.workspaceModel.storage.WorkspaceEntity>");
            Pair pair = TuplesKt.to(workspaceEntityData, WorkspaceBuilderChangeLogKt.getOriginalParents(this, RefsTableKt.asChild((long)it)));
            map2.put(t, pair);
        }
        Map originals = result$iv;
        $this$associateWith$iv = accumulator.iterator();
        while ($this$associateWith$iv.hasNext()) {
            long id = ((Number)$this$associateWith$iv.next()).longValue();
            WorkspaceEntityData<? extends WorkspaceEntity> entityData = this.entityDataById$intellij_platform_workspaceModel_storage(id);
            if (entityData instanceof SoftLinkable) {
                this.getIndexes$intellij_platform_workspaceModel_storage().removeFromSoftLinksIndex((SoftLinkable)((Object)entityData));
            }
            this.getEntitiesByType$intellij_platform_workspaceModel_storage().remove(EntityIdKt.getArrayId(id), EntityIdKt.getClazz(id));
        }
        $this$associateWith$iv = accumulator.iterator();
        while ($this$associateWith$iv.hasNext()) {
            long id = ((Number)$this$associateWith$iv.next()).longValue();
            this.getIndexes$intellij_platform_workspaceModel_storage().entityRemoved(id);
        }
        Iterable $this$forEach$iv = accumulator;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger.debug("Cascade removing: " + ClassToIntConverter.Companion.getINSTANCE().getClassOrDie(EntityIdKt.getClazz(it)) + "-" + EntityIdKt.getArrayId(it), e$iv);
            }
            Object v = originals.get(it);
            Intrinsics.checkNotNull(v);
            WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)((Pair)v).getFirst();
            Object v2 = originals.get(it);
            Intrinsics.checkNotNull(v2);
            this.changeLog.addRemoveEvent$intellij_platform_workspaceModel_storage(it, workspaceEntityData, (Map)((Pair)v2).getSecond());
        }
        return true;
    }

    public static /* synthetic */ boolean removeEntityByEntityId$intellij_platform_workspaceModel_storage$default(MutableEntityStorageImpl mutableEntityStorageImpl, long l, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = removeEntityByEntityId.1.INSTANCE;
        }
        return mutableEntityStorageImpl.removeEntityByEntityId$intellij_platform_workspaceModel_storage(l, (Function1<? super Long, Boolean>)function1);
    }

    private final void lockWrite() {
        Thread currentThread = Thread.currentThread();
        if (this.writingFlag.getAndSet(true) && this.threadId != null) {
            Long l = this.threadId;
            long l2 = currentThread.getId();
            if (l == null || l != l2) {
                LOG.error(StringsKt.trimIndent((String)("\n            Concurrent write to builder from the following threads\n            First Thread: " + this.threadName + "\n            Second Thread: " + currentThread.getName() + "\n            Previous stack trace: " + this.stackTrace + "\n          ")));
                this.trackStackTrace = true;
            }
        }
        if (this.trackStackTrace || LOG.isTraceEnabled()) {
            this.stackTrace = ExceptionUtil.currentStackTrace();
        }
        this.threadId = currentThread.getId();
        this.threadName = currentThread.getName();
    }

    private final void unlockWrite() {
        this.writingFlag.set(false);
        this.stackTrace = null;
        this.threadId = null;
        this.threadName = null;
    }

    public final <T extends WorkspaceEntity> void createAddEvent$intellij_platform_workspaceModel_storage(@NotNull WorkspaceEntityData<T> pEntityData) {
        Intrinsics.checkNotNullParameter(pEntityData, (String)"pEntityData");
        long entityId = pEntityData.createEntityId();
        this.changeLog.addAddEvent$intellij_platform_workspaceModel_storage(entityId, pEntityData);
    }

    private final void accumulateEntitiesToRemove(long id, Set<Long> accumulator, Function1<? super Long, Boolean> entityFilter) {
        Map<ConnectionId, List<ChildEntityId>> children2 = this.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(id));
        for (Map.Entry<ConnectionId, List<ChildEntityId>> object : children2.entrySet()) {
            ConnectionId connectionId = object.getKey();
            List<ChildEntityId> childrenIds2 = object.getValue();
            for (ChildEntityId childId : childrenIds2) {
                if (accumulator.contains(childId.getId()) || !((Boolean)entityFilter.invoke((Object)childId.getId())).booleanValue()) continue;
                accumulator.add(childId.getId());
                this.accumulateEntitiesToRemove(childId.getId(), accumulator, entityFilter);
                this.getRefs$intellij_platform_workspaceModel_storage().removeRefsByParent(connectionId, RefsTableKt.asParent(id));
            }
        }
        Map<ConnectionId, ParentEntityId> parents = this.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(id));
        for (Map.Entry<ConnectionId, ParentEntityId> entry : parents.entrySet()) {
            ConnectionId connectionId = entry.getKey();
            ParentEntityId parent = entry.getValue();
            this.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef(connectionId, parent, RefsTableKt.asChild(id));
        }
    }

    private static final void hasSameEntities$lambda$16(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final MutableExternalEntityMappingImpl getMutableExternalMapping$lambda$26(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MutableExternalEntityMappingImpl)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MutableEntityStorageImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0083\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00140\u00132\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00140\u0013H\u0000\u00a2\u0006\u0002\b\u001aJ\u0006\u0010\u001b\u001a\u00020\tJ\u000e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/workspaceModel/storage/impl/MutableEntityStorageImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "addReplaceEvent", "", "builder", "Lcom/intellij/workspaceModel/storage/impl/MutableEntityStorageImpl;", "entityId", "", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "beforeChildren", "", "Lkotlin/Pair;", "Lcom/intellij/workspaceModel/storage/impl/ConnectionId;", "Lcom/intellij/workspaceModel/storage/impl/ChildEntityId;", "beforeParents", "", "Lcom/intellij/workspaceModel/storage/impl/ParentEntityId;", "copiedData", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "originalEntity", "originalParents", "addReplaceEvent$intellij_platform_workspaceModel_storage", "create", "from", "storage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "intellij.platform.workspaceModel.storage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MutableEntityStorageImpl create() {
            return this.from(EntityStorageSnapshotImpl.Companion.getEMPTY());
        }

        @NotNull
        public final MutableEntityStorageImpl from(@NotNull EntityStorage storage) {
            MutableEntityStorageImpl mutableEntityStorageImpl;
            MutableRefsTable copiedRefs;
            MutableEntitiesBarrel copiedBarrel;
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            AbstractEntityStorage cfr_ignored_0 = (AbstractEntityStorage)storage;
            AbstractEntityStorage abstractEntityStorage = (AbstractEntityStorage)storage;
            if (abstractEntityStorage instanceof EntityStorageSnapshotImpl) {
                copiedBarrel = MutableEntitiesBarrel.Companion.from(((EntityStorageSnapshotImpl)storage).getEntitiesByType$intellij_platform_workspaceModel_storage());
                copiedRefs = MutableRefsTable.Companion.from(((EntityStorageSnapshotImpl)storage).getRefs$intellij_platform_workspaceModel_storage());
                MutableStorageIndexes copiedIndex = ((AbstractEntityStorage)storage).getIndexes$intellij_platform_workspaceModel_storage().toMutable();
                mutableEntityStorageImpl = new MutableEntityStorageImpl(copiedBarrel, copiedRefs, copiedIndex, false, 8, null);
            } else if (abstractEntityStorage instanceof MutableEntityStorageImpl) {
                copiedBarrel = MutableEntitiesBarrel.Companion.from(((MutableEntityStorageImpl)storage).getEntitiesByType$intellij_platform_workspaceModel_storage().toImmutable());
                copiedRefs = MutableRefsTable.Companion.from(((MutableEntityStorageImpl)storage).getRefs$intellij_platform_workspaceModel_storage().toImmutable());
                MutableStorageIndexes copiedIndexes = ((MutableEntityStorageImpl)storage).getIndexes$intellij_platform_workspaceModel_storage().toMutable();
                mutableEntityStorageImpl = new MutableEntityStorageImpl(copiedBarrel, copiedRefs, copiedIndexes, ((MutableEntityStorageImpl)storage).trackStackTrace);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            MutableEntityStorageImpl newBuilder = mutableEntityStorageImpl;
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Create new builder " + newBuilder + " from " + storage + ".\n" + UtilsKt.currentStackTrace(10));
            }
            return newBuilder;
        }

        /*
         * WARNING - void declaration
         */
        public final void addReplaceEvent$intellij_platform_workspaceModel_storage(@NotNull MutableEntityStorageImpl builder, long entityId, @NotNull List<Pair<ConnectionId, ChildEntityId>> beforeChildren, @NotNull Map<ConnectionId, ParentEntityId> beforeParents, @NotNull WorkspaceEntityData<? extends WorkspaceEntity> copiedData, @NotNull WorkspaceEntityData<? extends WorkspaceEntity> originalEntity, @NotNull Map<ConnectionId, ParentEntityId> originalParents) {
            void $this$flatMapTo$iv$iv;
            Map<ConnectionId, List<ChildEntityId>> unmappedChildren;
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter(beforeChildren, (String)"beforeChildren");
            Intrinsics.checkNotNullParameter(beforeParents, (String)"beforeParents");
            Intrinsics.checkNotNullParameter(copiedData, (String)"copiedData");
            Intrinsics.checkNotNullParameter(originalEntity, (String)"originalEntity");
            Intrinsics.checkNotNullParameter(originalParents, (String)"originalParents");
            Map<ConnectionId, ParentEntityId> parents = builder.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(entityId));
            Map<ConnectionId, List<ChildEntityId>> $this$flatMap$iv = unmappedChildren = builder.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(entityId));
            boolean $i$f$flatMap = false;
            Map<ConnectionId, List<ChildEntityId>> map2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator<Map.Entry<Object, Object>> iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$mapTo$iv$iv;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl = false;
                ConnectionId key = (ConnectionId)entry2.getKey();
                List value = (List)entry2.getValue();
                Iterable $this$map$iv = value;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ChildEntityId childEntityId = (ChildEntityId)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(TuplesKt.to((Object)key, (Object)it));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List children2 = (List)destination$iv$iv;
            Set beforeChildrenSet = CollectionsKt.toMutableSet((Iterable)beforeChildren);
            Pair pair = ContainerExtensionsKt.getDiff(beforeChildrenSet, children2);
            Set removedChildren = (Set)pair.component1();
            ArrayList addedChildren = (ArrayList)pair.component2();
            Map parentsMapRes = MapsKt.toMutableMap(beforeParents);
            for (Map.Entry<Object, Object> entry : parents.entrySet()) {
                ConnectionId connectionId = (ConnectionId)entry.getKey();
                ParentEntityId parentId = (ParentEntityId)entry.getValue();
                ParentEntityId existingParent = (ParentEntityId)parentsMapRes.get(connectionId);
                if (existingParent != null) {
                    if (Intrinsics.areEqual((Object)existingParent, (Object)parentId)) {
                        parentsMapRes.remove(connectionId, parentId);
                        continue;
                    }
                    parentsMapRes.put(connectionId, parentId);
                    continue;
                }
                parentsMapRes.put(connectionId, parentId);
            }
            Set removedKeys = SetsKt.minus(beforeParents.keySet(), (Iterable)parents.keySet());
            Iterable iterable = removedKeys;
            boolean $i$f$forEach = false;
            for (Object element$iv : iterable) {
                ConnectionId it = (ConnectionId)element$iv;
                boolean bl = false;
                parentsMapRes.put(it, null);
            }
            builder.getChangeLog$intellij_platform_workspaceModel_storage().addReplaceEvent$intellij_platform_workspaceModel_storage(entityId, copiedData, originalEntity, originalParents, addedChildren, removedChildren, parentsMapRes);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

