/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.Compressor;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.MutableEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.AnonymizedEntitySource;
import com.intellij.workspaceModel.storage.impl.ChangeEntry;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverter;
import com.intellij.workspaceModel.storage.impl.ConsistencyCheckingMode;
import com.intellij.workspaceModel.storage.impl.EntityStorageSerializerImpl;
import com.intellij.workspaceModel.storage.impl.ErrorReportingKt;
import com.intellij.workspaceModel.storage.impl.MatchedEntitySource;
import com.intellij.workspaceModel.storage.impl.MutableEntityStorageImpl;
import com.intellij.workspaceModel.storage.impl.SimpleEntityTypesResolver;
import com.intellij.workspaceModel.storage.impl.StorageIndexes;
import com.intellij.workspaceModel.storage.impl.UnmatchedEntitySource;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.workspaceModel.storage.impl.url.VirtualFileUrlManagerImpl;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001a\b\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\b\u0010\r\u001a\u00020\u000eH\u0000\u001a\b\u0010\u000f\u001a\u00020\bH\u0002\u001aJ\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b\u0018\u00010\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0000\u001a\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0018H\u0007\u001a*\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u000e2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00050 H\u0000\u001aD\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010$\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b\u0018\u00010\u0015H\u0002\u001a\u0018\u0010%\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0018H\u0000\u001a\"\u0010&\u001a\u00020\u0016*\u00020\u00162\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b\u0018\u00010\u0015H\u0000\u001a\"\u0010&\u001a\u00020\u0018*\u00020\u00182\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b\u0018\u00010\u0015H\u0000\u001a4\u0010&\u001a\u0016\u0012\b\u0012\u00060\u0001j\u0002`(\u0012\u0004\u0012\u00020)0'j\u0002`**\u0016\u0012\b\u0012\u00060\u0001j\u0002`(\u0012\u0004\u0012\u00020)0'j\u0002`*H\u0000\u001a\u0014\u0010+\u001a\u00020\u0005*\u00020!2\u0006\u0010,\u001a\u00020\"H\u0002\u001a\u001c\u0010-\u001a\u00020\u0005*\u00020.2\u0006\u0010/\u001a\u00020!2\u0006\u0010,\u001a\u00020\"H\u0002\u001a\u0014\u0010-\u001a\u00020\u0005*\u00020.2\u0006\u0010,\u001a\u00020\"H\u0000\u001a0\u00100\u001a\u00020\u0005*\u00020!2\u0006\u0010,\u001a\u00020\"2\u001a\u00101\u001a\u0016\u0012\b\u0012\u00060\u0001j\u0002`(\u0012\u0004\u0012\u00020)0'j\u0002`*H\u0002\u001a\u0014\u00102\u001a\u00020\u0005*\u00020\u00182\u0006\u0010,\u001a\u00020\"H\u0000\u00a8\u00063"}, d2={"ageInDays", "", "file", "Ljava/io/File;", "cleanOldFiles", "", "parentDir", "executingOnTC", "", "formatTime", "", "kotlin.jvm.PlatformType", "timeMs", "getStoreDumpDirectory", "Ljava/nio/file/Path;", "isWrapped", "reportConsistencyIssue", "message", "e", "", "sourceFilter", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/storage/EntitySource;", "left", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "right", "resulting", "reportErrorAndAttachStorage", "storage", "serializeContent", "path", "howToSerialize", "Lkotlin/Function2;", "Lcom/intellij/workspaceModel/storage/impl/EntityStorageSerializerImpl;", "Ljava/io/OutputStream;", "serializeContentToFolder", "contentFolder", "serializeEntityStorage", "anonymize", "", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "Lcom/intellij/workspaceModel/storage/impl/ChangeEntry;", "Lcom/intellij/workspaceModel/storage/impl/ChangeLog;", "serializeClassToIntConverter", "stream", "serializeDiff", "Lcom/intellij/workspaceModel/storage/impl/MutableEntityStorageImpl;", "serializer", "serializeDiffLog", "log", "serializeTo", "intellij.platform.workspaceModel.storage"})
public final class ErrorReportingKt {
    @ApiStatus.Internal
    public static final void reportErrorAndAttachStorage(@NotNull String message, @NotNull EntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        ErrorReportingKt.reportConsistencyIssue(message, new IllegalStateException(), null, null, null, storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void serializeContent(@NotNull Path path, @NotNull Function2<? super EntityStorageSerializerImpl, ? super OutputStream, Unit> howToSerialize) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(howToSerialize, (String)"howToSerialize");
        EntityStorageSerializerImpl serializer = new EntityStorageSerializerImpl(SimpleEntityTypesResolver.INSTANCE, new VirtualFileUrlManagerImpl(), null, 4, null);
        File file2 = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"path.toFile()");
        Object object = file2;
        object = new FileOutputStream((File)object);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)object;
            boolean bl = false;
            howToSerialize.invoke((Object)serializer, (Object)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public static final void serializeEntityStorage(@NotNull Path path, @NotNull EntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        ErrorReportingKt.serializeContent(path, (Function2<? super EntityStorageSerializerImpl, ? super OutputStream, Unit>)((Function2)new Function2<EntityStorageSerializerImpl, OutputStream, Unit>(storage){
            final /* synthetic */ EntityStorage $storage;
            {
                this.$storage = $storage;
                super(2);
            }

            public final void invoke(@NotNull EntityStorageSerializerImpl serializer, @NotNull OutputStream stream) {
                Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                serializer.serializeCache(stream, this.$storage.toSnapshot());
            }
        }));
    }

    @NotNull
    public static final Path getStoreDumpDirectory() {
        String property = System.getProperty("ide.new.project.model.store.dump.directory");
        if (property == null) {
            String pathPrefix = "storeDump-" + ErrorReportingKt.formatTime(System.currentTimeMillis());
            String[] stringArray = new String[]{"workspaceModel"};
            Path workspaceModelDumps = Paths.get(PathManager.getLogPath(), stringArray);
            File file2 = workspaceModelDumps.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"workspaceModelDumps.toFile()");
            ErrorReportingKt.cleanOldFiles(file2);
            Path currentDumpDir = workspaceModelDumps.resolve(pathPrefix);
            FileUtil.createDirectory(currentDumpDir.toFile());
            Intrinsics.checkNotNullExpressionValue((Object)currentDumpDir, (String)"currentDumpDir");
            return currentDumpDir;
        }
        Path path = Paths.get(property, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(property)");
        return path;
    }

    public static final boolean executingOnTC() {
        return System.getProperty("ide.new.project.model.store.dump.directory") != null;
    }

    private static final void cleanOldFiles(File parentDir) {
        Object[] objectArray = parentDir.listFiles();
        if (objectArray == null) {
            return;
        }
        Object[] children2 = objectArray;
        Arrays.sort(children2);
        int n = children2.length;
        for (int i = 0; i < n; ++i) {
            Object child = children2[i];
            if (i >= children2.length - 30) {
                Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                if (ErrorReportingKt.ageInDays((File)child) <= 7L) continue;
            }
            FileUtil.delete((File)child);
        }
    }

    private static final String formatTime(long timeMs) {
        return new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date(timeMs));
    }

    private static final long ageInDays(File file2) {
        return TimeUnit.DAYS.convert(System.currentTimeMillis() - file2.lastModified(), TimeUnit.MILLISECONDS);
    }

    public static final void serializeTo(@NotNull EntityStorage $this$serializeTo, @NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)$this$serializeTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        EntityStorageSerializerImpl serializer = new EntityStorageSerializerImpl(SimpleEntityTypesResolver.INSTANCE, new VirtualFileUrlManagerImpl(), null, 4, null);
        serializer.serializeCache(stream, $this$serializeTo.toSnapshot());
    }

    public static final void serializeDiff(@NotNull MutableEntityStorageImpl $this$serializeDiff, @NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)$this$serializeDiff, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        EntityStorageSerializerImpl serializer = new EntityStorageSerializerImpl(SimpleEntityTypesResolver.INSTANCE, new VirtualFileUrlManagerImpl(), null, 4, null);
        ErrorReportingKt.serializeDiff($this$serializeDiff, serializer, stream);
    }

    private static final void serializeDiff(MutableEntityStorageImpl $this$serializeDiff, EntityStorageSerializerImpl serializer, OutputStream stream) {
        ErrorReportingKt.serializeDiffLog(serializer, stream, ErrorReportingKt.anonymize($this$serializeDiff.getChangeLog$intellij_platform_workspaceModel_storage().getChangeLog$intellij_platform_workspaceModel_storage()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final EntityStorage anonymize(@NotNull EntityStorage $this$anonymize, @Nullable Function1<? super EntitySource, Boolean> sourceFilter) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$anonymize, (String)"<this>");
        if (!ErrorReportingKt.isWrapped()) {
            return $this$anonymize;
        }
        MutableEntityStorage builder = MutableEntityStorage.Companion.from($this$anonymize);
        Map<EntitySource, Map<Class<? extends WorkspaceEntity>, List<WorkspaceEntity>>> $this$flatMap$iv = builder.entitiesBySource((Function1<? super EntitySource, Boolean>)((Function1)anonymize.1.INSTANCE));
        boolean $i$f$flatMap = false;
        Map<EntitySource, Map<Class<? extends WorkspaceEntity>, List<WorkspaceEntity>>> map2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$flatMapTo$iv$iv2;
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            Map $this$flatMap$iv2 = (Map)it.getValue();
            boolean $i$f$flatMap2 = false;
            Map map3 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv2;
                Map.Entry it2 = element$iv$iv2 = iterator2.next();
                boolean bl2 = false;
                Iterable list$iv$iv = (List)it2.getValue();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceEntity entity2 = (WorkspaceEntity)element$iv;
            boolean bl = false;
            builder.modifyEntity(WorkspaceEntity.Builder.class, entity2, (Function1)new Function1<WorkspaceEntity.Builder<?>, Unit>(entity2, sourceFilter){
                final /* synthetic */ WorkspaceEntity $entity;
                final /* synthetic */ Function1<EntitySource, Boolean> $sourceFilter;
                {
                    this.$entity = $entity;
                    this.$sourceFilter = $sourceFilter;
                    super(1);
                }

                public final void invoke(@NotNull WorkspaceEntity.Builder<?> $this$modifyEntity) {
                    Intrinsics.checkNotNullParameter($this$modifyEntity, (String)"$this$modifyEntity");
                    $this$modifyEntity.setEntitySource(ErrorReportingKt.anonymize(this.$entity.getEntitySource(), this.$sourceFilter));
                }
            });
        }
        return builder.toSnapshot();
    }

    @NotNull
    public static final Map<Long, ChangeEntry> anonymize(@NotNull Map<Long, ChangeEntry> $this$anonymize) {
        Intrinsics.checkNotNullParameter($this$anonymize, (String)"<this>");
        if (!ErrorReportingKt.isWrapped()) {
            return $this$anonymize;
        }
        HashMap<Long, ChangeEntry> result2 = new HashMap<Long, ChangeEntry>($this$anonymize);
        result2.replaceAll((arg_0, arg_1) -> ErrorReportingKt.anonymize$lambda$4(anonymize.4.INSTANCE, arg_0, arg_1));
        return result2;
    }

    @NotNull
    public static final EntitySource anonymize(@NotNull EntitySource $this$anonymize, @Nullable Function1<? super EntitySource, Boolean> sourceFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$anonymize, (String)"<this>");
        return sourceFilter != null ? (((Boolean)sourceFilter.invoke((Object)$this$anonymize)).booleanValue() ? (EntitySource)new MatchedEntitySource($this$anonymize.toString()) : (EntitySource)new UnmatchedEntitySource($this$anonymize.toString())) : (EntitySource)new AnonymizedEntitySource($this$anonymize.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final File serializeContentToFolder(Path contentFolder, EntityStorage left, EntityStorage right, EntityStorage resulting, Function1<? super EntitySource, Boolean> sourceFilter) {
        File file2;
        Object entitySourceFilter;
        EntityStorage entityStorage;
        EntityStorage it;
        EntityStorage entityStorage2;
        if (right instanceof MutableEntityStorage) {
            Path path = contentFolder.resolve("Right_Diff_Log");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"contentFolder.resolve(\"Right_Diff_Log\")");
            ErrorReportingKt.serializeContent(path, (Function2<? super EntityStorageSerializerImpl, ? super OutputStream, Unit>)((Function2)new Function2<EntityStorageSerializerImpl, OutputStream, Unit>(right){
                final /* synthetic */ EntityStorage $right;
                {
                    this.$right = $right;
                    super(2);
                }

                public final void invoke(@NotNull EntityStorageSerializerImpl serializer, @NotNull OutputStream stream) {
                    Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
                    Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                    EntityStorage entityStorage = this.$right;
                    Intrinsics.checkNotNull((Object)entityStorage, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.MutableEntityStorageImpl");
                    MutableEntityStorageImpl cfr_ignored_0 = (MutableEntityStorageImpl)entityStorage;
                    ErrorReportingKt.access$serializeDiff((MutableEntityStorageImpl)this.$right, serializer, stream);
                }
            }));
        }
        if ((entityStorage2 = left) != null && (entityStorage2 = ErrorReportingKt.anonymize(entityStorage2, sourceFilter)) != null) {
            it = entityStorage2;
            boolean bl = false;
            Path path = contentFolder.resolve("Left_Store");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"contentFolder.resolve(\"Left_Store\")");
            ErrorReportingKt.serializeEntityStorage(path, it);
        }
        if ((entityStorage = right) != null && (entityStorage = ErrorReportingKt.anonymize(entityStorage, sourceFilter)) != null) {
            it = entityStorage;
            boolean bl = false;
            Path path = contentFolder.resolve("Right_Store");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"contentFolder.resolve(\"Right_Store\")");
            ErrorReportingKt.serializeEntityStorage(path, it);
        }
        Path path = contentFolder.resolve("Res_Store");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"contentFolder.resolve(\"Res_Store\")");
        ErrorReportingKt.serializeEntityStorage(path, ErrorReportingKt.anonymize(resulting, sourceFilter));
        Path path2 = contentFolder.resolve("ClassToIntConverter");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"contentFolder.resolve(\"ClassToIntConverter\")");
        ErrorReportingKt.serializeContent(path2, (Function2<? super EntityStorageSerializerImpl, ? super OutputStream, Unit>)((Function2)serializeContentToFolder.4.INSTANCE));
        String operationName = sourceFilter == null ? "Add_Diff" : "Replace_By_Source";
        Path operationFile = contentFolder.resolve(operationName);
        Intrinsics.checkNotNullExpressionValue((Object)operationFile, (String)"operationFile");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(operationFile, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(this, *attributes)");
        if (!ErrorReportingKt.isWrapped()) {
            String string2;
            if (sourceFilter != null) {
                void $this$fold$iv;
                Object object;
                EntityStorageInternalIndex<EntitySource> allEntitySources;
                Object object2 = left instanceof AbstractEntityStorage ? (AbstractEntityStorage)left : null;
                if (object2 == null || (object2 = ((AbstractEntityStorage)object2).getIndexes$intellij_platform_workspaceModel_storage()) == null || (object2 = ((StorageIndexes)object2).getEntitySourceIndex$intellij_platform_workspaceModel_storage()) == null || (object2 = ((EntityStorageInternalIndex)object2).entries$intellij_platform_workspaceModel_storage()) == null || (object2 = CollectionsKt.toHashSet((Iterable)((Iterable)object2))) == null) {
                    object2 = allEntitySources = new HashSet();
                }
                if ((object = right instanceof AbstractEntityStorage ? (AbstractEntityStorage)right : null) == null || (object = ((AbstractEntityStorage)object).getIndexes$intellij_platform_workspaceModel_storage()) == null || (object = ((StorageIndexes)object).getEntitySourceIndex$intellij_platform_workspaceModel_storage()) == null || (object = ((EntityStorageInternalIndex)object).entries$intellij_platform_workspaceModel_storage()) == null) {
                    object = SetsKt.emptySet();
                }
                ((AbstractCollection)((Object)allEntitySources)).addAll((Collection<EntitySource>)object);
                Iterable $this$sortedBy$iv = (Iterable)((Object)allEntitySources);
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        EntitySource it = (EntitySource)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.toString());
                        it = (EntitySource)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.toString())));
                    }
                });
                String initial$iv = "";
                boolean $i$f$fold = false;
                Object accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void source;
                    EntitySource entitySource = (EntitySource)element$iv;
                    String acc = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = acc + ((Boolean)sourceFilter.invoke((Object)source) != false ? "1" : "0");
                }
                string2 = accumulator$iv;
            } else {
                string2 = "";
            }
            entitySourceFilter = string2;
            PathsKt.writeText$default((Path)operationFile, (CharSequence)((CharSequence)entitySourceFilter), null, (OpenOption[])new OpenOption[0], (int)2, null);
        }
        if (ErrorReportingKt.isWrapped()) {
            Path path3 = contentFolder.resolve("Report_Wrapped");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"contentFolder.resolve(\"Report_Wrapped\")");
            entitySourceFilter = path3;
            FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile((Path)entitySourceFilter, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length)), (String)"createFile(this, *attributes)");
        }
        if (!ErrorReportingKt.executingOnTC()) {
            File zipFile = contentFolder.getParent().resolve(PathsKt.getName((Path)contentFolder) + ".zip").toFile();
            Closeable closeable = new Compressor.Zip(zipFile);
            Throwable throwable = null;
            try {
                Compressor.Zip it2 = (Compressor.Zip)closeable;
                boolean bl = false;
                it2.addDirectory(contentFolder.toFile());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            FileUtil.delete(contentFolder);
            file2 = zipFile;
        } else {
            file2 = null;
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void serializeDiffLog(EntityStorageSerializerImpl $this$serializeDiffLog, OutputStream stream, Map<Long, ChangeEntry> log) {
        Output output = new Output(stream, $this$serializeDiffLog.getKRYO_BUFFER_SIZE$intellij_platform_workspaceModel_storage());
        try {
            void $this$mapNotNullTo$iv$iv;
            Kryo kryo = (Kryo)$this$serializeDiffLog.createKryo$intellij_platform_workspaceModel_storage().component1();
            output.writeString($this$serializeDiffLog.getSerializerDataFormatVersion());
            $this$serializeDiffLog.saveContributedVersions$intellij_platform_workspaceModel_storage(kryo, output);
            Iterable $this$mapNotNull$iv = log.values();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ChangeEntry it = (ChangeEntry)element$iv$iv;
                boolean bl2 = false;
                ChangeEntry changeEntry = it;
                if (changeEntry instanceof ChangeEntry.AddEntity) {
                    workspaceEntityData = ((ChangeEntry.AddEntity)it).getEntityData();
                } else if (changeEntry instanceof ChangeEntry.RemoveEntity) {
                    workspaceEntityData = null;
                } else if (changeEntry instanceof ChangeEntry.ReplaceEntity) {
                    workspaceEntityData = ((ChangeEntry.ReplaceEntity)it).getNewData();
                } else if (changeEntry instanceof ChangeEntry.ChangeEntitySource) {
                    workspaceEntityData = ((ChangeEntry.ChangeEntitySource)it).getNewData();
                } else if (changeEntry instanceof ChangeEntry.ReplaceAndChangeSource) {
                    workspaceEntityData = ((ChangeEntry.ReplaceAndChangeSource)it).getDataChange().getNewData();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if (workspaceEntityData == null) continue;
                WorkspaceEntityData<? extends WorkspaceEntity> it$iv$iv = workspaceEntityData;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Sequence entityDataSequence2 = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
            $this$serializeDiffLog.collectAndRegisterClasses$intellij_platform_workspaceModel_storage(kryo, output, entityDataSequence2);
            kryo.writeClassAndObject(output, log);
        }
        finally {
            $this$serializeDiffLog.flush$intellij_platform_workspaceModel_storage(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void serializeClassToIntConverter(EntityStorageSerializerImpl $this$serializeClassToIntConverter, OutputStream stream) {
        Map converterMap = MapsKt.toMap(ClassToIntConverter.Companion.getINSTANCE().getMap());
        Output output = new Output(stream, $this$serializeClassToIntConverter.getKRYO_BUFFER_SIZE$intellij_platform_workspaceModel_storage());
        try {
            void $this$mapTo$iv$iv;
            Kryo kryo = (Kryo)$this$serializeClassToIntConverter.createKryo$intellij_platform_workspaceModel_storage().component1();
            output.writeString($this$serializeClassToIntConverter.getSerializerDataFormatVersion());
            $this$serializeClassToIntConverter.saveContributedVersions$intellij_platform_workspaceModel_storage(kryo, output);
            Map $this$map$iv = converterMap;
            boolean $i$f$map = false;
            Map map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Class key = (Class)entry.getKey();
                int value = ((Number)entry.getValue()).intValue();
                collection.add(TuplesKt.to((Object)$this$serializeClassToIntConverter.getTypeInfo$intellij_platform_workspaceModel_storage(key), (Object)value));
            }
            List mapData = (List)destination$iv$iv;
            kryo.writeClassAndObject(output, mapData);
        }
        finally {
            $this$serializeClassToIntConverter.flush$intellij_platform_workspaceModel_storage(output);
        }
    }

    public static final void reportConsistencyIssue(@NotNull String message, @NotNull Throwable e, @Nullable Function1<? super EntitySource, Boolean> sourceFilter, @Nullable EntityStorage left, @Nullable EntityStorage right, @NotNull EntityStorage resulting) {
        File zipFile;
        File file2;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)resulting, (String)"resulting");
        String finalMessage = message + "\n\n";
        finalMessage = finalMessage + "\nVersion: v43";
        if (ConsistencyCheckingMode.Companion.getCurrent() != ConsistencyCheckingMode.DISABLED) {
            Path dumpDirectory = ErrorReportingKt.getStoreDumpDirectory();
            finalMessage = finalMessage + "\nSaving store content at: " + dumpDirectory;
            file2 = ErrorReportingKt.serializeContentToFolder(dumpDirectory, left, right, resulting, sourceFilter);
        } else {
            file2 = zipFile = null;
        }
        if (zipFile != null) {
            Attachment attachment = new Attachment("workspaceModelDump.zip", FilesKt.readBytes(zipFile), "Zip of workspace model store");
            attachment.setIncluded(true);
            Attachment[] attachmentArray = new Attachment[]{attachment};
            AbstractEntityStorage.Companion.getLOG().error(finalMessage, e, attachmentArray);
        } else {
            AbstractEntityStorage.Companion.getLOG().error(finalMessage, e);
        }
    }

    private static final boolean isWrapped() {
        return Registry.is("ide.new.project.model.report.wrapped", true);
    }

    private static final ChangeEntry anonymize$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChangeEntry)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$serializeDiff(MutableEntityStorageImpl $receiver, EntityStorageSerializerImpl serializer, OutputStream stream) {
        ErrorReportingKt.serializeDiff($receiver, serializer, stream);
    }

    public static final /* synthetic */ void access$serializeClassToIntConverter(EntityStorageSerializerImpl $receiver, OutputStream stream) {
        ErrorReportingKt.serializeClassToIntConverter($receiver, stream);
    }
}

