/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.workspaceModel.storage.SymbolicEntityId;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverter;
import com.intellij.workspaceModel.storage.impl.EntitiesKt;
import com.intellij.workspaceModel.storage.impl.EntityFamily;
import com.intellij.workspaceModel.storage.impl.EntityIdKt;
import com.intellij.workspaceModel.storage.impl.WithAssertableConsistency;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011J\u001b\u0010\u0012\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J\u0006\u0010\u0015\u001a\u00020\u0014R\"\u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00050\u0004X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0002\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/workspaceModel/storage/impl/EntitiesBarrel;", "", "()V", "entityFamilies", "", "Lcom/intellij/workspaceModel/storage/impl/EntityFamily;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "getEntityFamilies$intellij_platform_workspaceModel_storage", "()Ljava/util/List;", "assertConsistency", "", "abstractEntityStorage", "Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "exists", "", "entityId", "", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "get", "clazz", "", "size", "Lcom/intellij/workspaceModel/storage/impl/ImmutableEntitiesBarrel;", "Lcom/intellij/workspaceModel/storage/impl/MutableEntitiesBarrel;", "intellij.platform.workspaceModel.storage"})
public abstract class EntitiesBarrel {
    private EntitiesBarrel() {
    }

    @NotNull
    public abstract List<EntityFamily<? extends WorkspaceEntity>> getEntityFamilies$intellij_platform_workspaceModel_storage();

    public final boolean exists(long entityId) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.get(EntityIdKt.getClazz(entityId));
        return entityFamily != null ? entityFamily.exists(EntityIdKt.getArrayId(entityId)) : false;
    }

    @Nullable
    public EntityFamily<? extends WorkspaceEntity> get(int clazz) {
        return (EntityFamily)CollectionsKt.getOrNull(this.getEntityFamilies$intellij_platform_workspaceModel_storage(), (int)clazz);
    }

    public final int size() {
        return this.getEntityFamilies$intellij_platform_workspaceModel_storage().size();
    }

    /*
     * WARNING - void declaration
     */
    public final void assertConsistency(@NotNull AbstractEntityStorage abstractEntityStorage) {
        Intrinsics.checkNotNullParameter((Object)abstractEntityStorage, (String)"abstractEntityStorage");
        HashSet symbolicIds = new HashSet();
        Iterable $this$forEachIndexed$iv = this.getEntityFamilies$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Class<?> clazz;
            void family;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            EntityFamily entityFamily = (EntityFamily)item$iv;
            int i = n;
            boolean bl = false;
            if (family == null) continue;
            int $this$findEntityClass$iv = i;
            boolean $i$f$findEntityClass = false;
            Intrinsics.checkNotNull(ClassToIntConverter.Companion.getINSTANCE().getClassOrDie($this$findEntityClass$iv), (String)"null cannot be cast to non-null type java.lang.Class<E of com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt.findEntityClass>");
            boolean hasSymbolicId = WorkspaceEntityWithSymbolicId.class.isAssignableFrom(clazz);
            void this_$iv = family;
            boolean $i$f$assertConsistency = false;
            Iterable $this$forEachIndexed$iv$iv = this_$iv.getEntities$intellij_platform_workspaceModel_storage();
            boolean $i$f$forEachIndexed2 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                boolean bl2;
                void entity$iv;
                int n2;
                if ((n2 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)item$iv$iv;
                int idx$iv = n2;
                boolean bl3 = false;
                if (entity$iv == null) continue;
                boolean bl4 = bl2 = idx$iv == entity$iv.getId();
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl5 = false;
                    String string2 = "Entity with id " + entity$iv.getId() + " is placed at index " + idx$iv;
                    throw new AssertionError((Object)string2);
                }
                void entityData = entity$iv;
                boolean bl6 = false;
                Class<WorkspaceEntity> immutableClass = entityData.getEntityInterface();
                boolean bl7 = Intrinsics.areEqual(clazz, immutableClass);
                if (_Assertions.ENABLED && !bl7) {
                    boolean bl8 = false;
                    String string3 = StringsKt.trimMargin$default((String)("EntityFamily contains entity data of wrong type:\n                | - EntityFamily class:   " + clazz + "\n                | - entityData class:     " + immutableClass + "\n              "), null, (int)1, null);
                    throw new AssertionError((Object)string3);
                }
                if (hasSymbolicId) {
                    boolean bl9;
                    SymbolicEntityId<?> symbolicId = EntitiesKt.symbolicId(entityData);
                    boolean bl10 = bl9 = symbolicId != null;
                    if (_Assertions.ENABLED && !bl9) {
                        boolean $i$a$-assert-EntitiesBarrel$assertConsistency$1$1$42 = false;
                        String $i$a$-assert-EntitiesBarrel$assertConsistency$1$1$42 = "Symbolic id expected for " + clazz;
                        throw new AssertionError((Object)$i$a$-assert-EntitiesBarrel$assertConsistency$1$1$42);
                    }
                    boolean bl11 = bl9 = !CollectionsKt.contains((Iterable)symbolicIds, symbolicId);
                    if (_Assertions.ENABLED && !bl9) {
                        boolean bl12 = false;
                        String string4 = "Duplicated symbolic ids: " + symbolicId;
                        throw new AssertionError((Object)string4);
                    }
                    SymbolicEntityId<?> symbolicEntityId = symbolicId;
                    Intrinsics.checkNotNull(symbolicEntityId);
                    symbolicIds.add(symbolicEntityId);
                }
                if (!(entityData instanceof WithAssertableConsistency)) continue;
                ((WithAssertableConsistency)entityData).assertConsistency(abstractEntityStorage);
            }
            EntityFamily.access$familyCheck((EntityFamily)this_$iv);
        }
    }

    public /* synthetic */ EntitiesBarrel(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

