/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.NotThisEntityId;
import com.intellij.workspaceModel.storage.SymbolicEntityId;
import com.intellij.workspaceModel.storage.ThisEntityId;
import com.intellij.workspaceModel.storage.UtilsKt;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.impl.ChangeEntry;
import com.intellij.workspaceModel.storage.impl.ChildEntityId;
import com.intellij.workspaceModel.storage.impl.ConnectionId;
import com.intellij.workspaceModel.storage.impl.ConsistencyCheckerKt;
import com.intellij.workspaceModel.storage.impl.ConsistencyCheckingMode;
import com.intellij.workspaceModel.storage.impl.EntitiesKt;
import com.intellij.workspaceModel.storage.impl.EntityIdKt;
import com.intellij.workspaceModel.storage.impl.EntityStorageExtensionsKt;
import com.intellij.workspaceModel.storage.impl.ErrorReportingKt;
import com.intellij.workspaceModel.storage.impl.MutableEntityStorageImpl;
import com.intellij.workspaceModel.storage.impl.MutableRefsTable;
import com.intellij.workspaceModel.storage.impl.MutableStorageIndexes;
import com.intellij.workspaceModel.storage.impl.ParentEntityId;
import com.intellij.workspaceModel.storage.impl.RefsTableKt;
import com.intellij.workspaceModel.storage.impl.SoftLinkable;
import com.intellij.workspaceModel.storage.impl.WorkspaceBuilderChangeLogKt;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.indices.EntityStorageInternalIndex;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010'\n\u0002\b\u0002\b\u0000\u0018\u0000 >2\u00020\u0001:\u0001>B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0014H\u0002J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0014H\u0002J-\u0010!\u001a\u00020\u001c2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#2\u000e\u0010%\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000bH\u0002\u00a2\u0006\u0002\u0010&J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020(H\u0002J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,H\u0002J@\u0010-\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020.2\u0006\u0010%\u001a\u00020.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020(002\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020(00H\u0002J\u001c\u00103\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,2\n\u0010%\u001a\u00060\nj\u0002`\u000bH\u0002J \u00104\u001a\u00020\u001c2\u000e\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020:H\u0002J6\u0010;\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\u0004\u0012\u00020\f0=0<*\u0016\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\u0004\u0012\u00020\f0\tj\u0002`\rH\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\u0016\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\u0004\u0012\u00020\f0\tj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0010\u001aB\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00140\u0014 \u0013* \u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0007\u00a8\u0006?"}, d2={"Lcom/intellij/workspaceModel/storage/impl/AddDiffOperation;", "", "target", "Lcom/intellij/workspaceModel/storage/impl/MutableEntityStorageImpl;", "diff", "(Lcom/intellij/workspaceModel/storage/impl/MutableEntityStorageImpl;Lcom/intellij/workspaceModel/storage/impl/MutableEntityStorageImpl;)V", "getDiff", "()Lcom/intellij/workspaceModel/storage/impl/MutableEntityStorageImpl;", "diffLog", "", "", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "Lcom/intellij/workspaceModel/storage/impl/ChangeEntry;", "Lcom/intellij/workspaceModel/storage/impl/ChangeLog;", "initialStorage", "Lcom/intellij/workspaceModel/storage/EntityStorageSnapshot;", "replaceMap", "Lcom/google/common/collect/HashBiMap;", "Lcom/intellij/workspaceModel/storage/NotThisEntityId;", "kotlin.jvm.PlatformType", "Lcom/intellij/workspaceModel/storage/ThisEntityId;", "shaker", "getShaker", "()J", "setShaker", "(J)V", "getTarget", "addDiff", "", "addRestoreChildren", "sourceEntityId", "targetEntityId", "addRestoreParents", "checkSymbolicId", "entityData", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "newEntityId", "(Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;Ljava/lang/Long;)V", "childrenMapper", "Lcom/intellij/workspaceModel/storage/impl/ChildEntityId;", "child", "replaceOperation", "change", "Lcom/intellij/workspaceModel/storage/impl/ChangeEntry$ReplaceEntity;", "replaceRestoreChildren", "Lcom/intellij/workspaceModel/storage/impl/ParentEntityId;", "addedChildrenMap", "Lcom/google/common/collect/HashMultimap;", "Lcom/intellij/workspaceModel/storage/impl/ConnectionId;", "removedChildrenMap", "replaceRestoreParents", "replaceSourceOperation", "data", "originalSource", "Lcom/intellij/workspaceModel/storage/EntitySource;", "serialize", "path", "", "shake", "", "", "Companion", "intellij.platform.workspaceModel.storage"})
public final class AddDiffOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableEntityStorageImpl target;
    @NotNull
    private final MutableEntityStorageImpl diff;
    private final HashBiMap<NotThisEntityId, ThisEntityId> replaceMap;
    @NotNull
    private final Map<Long, ChangeEntry> diffLog;
    @Nullable
    private final EntityStorageSnapshot initialStorage;
    private long shaker;
    @NotNull
    private static final Logger LOG;

    public AddDiffOperation(@NotNull MutableEntityStorageImpl target, @NotNull MutableEntityStorageImpl diff) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        this.target = target;
        this.diff = diff;
        this.replaceMap = HashBiMap.create();
        this.diffLog = this.diff.getChangeLog$intellij_platform_workspaceModel_storage().getChangeLog$intellij_platform_workspaceModel_storage();
        this.initialStorage = ConsistencyCheckingMode.Companion.getCurrent() != ConsistencyCheckingMode.DISABLED ? this.target.toSnapshot() : null;
        this.shaker = -1L;
    }

    @NotNull
    public final MutableEntityStorageImpl getTarget() {
        return this.target;
    }

    @NotNull
    public final MutableEntityStorageImpl getDiff() {
        return this.diff;
    }

    public final long getShaker() {
        return this.shaker;
    }

    public final void setShaker(long l) {
        this.shaker = l;
    }

    private final Collection<Map.Entry<Long, ChangeEntry>> shake(Map<Long, ChangeEntry> $this$shake) {
        return this.shaker != -1L && $this$shake.entrySet().size() > 1 ? (Collection)CollectionsKt.shuffled((Iterable)$this$shake.entrySet(), (Random)new Random(this.shaker)) : (Collection)$this$shake.entrySet();
    }

    public final void addDiff() {
        if (this.target == this.diff) {
            LOG.error("Trying to apply diff to itself");
        }
        if (LOG.isTraceEnabled()) {
            ConsistencyCheckerKt.assertConsistency(this.target);
            ConsistencyCheckerKt.assertConsistency(this.diff);
            LOG.trace("Before starting addDiff no consistency issues were found");
        }
        Iterator<Map.Entry<Long, ChangeEntry>> iterator = this.shake(this.diffLog).iterator();
        while (iterator.hasNext()) {
            Object sourceEntityId;
            Logger logger;
            Logger $this$trace$iv;
            ChangeEntry change = iterator.next().getValue();
            ChangeEntry changeEntry = change;
            if (changeEntry instanceof ChangeEntry.AddEntity) {
                $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("addDiff: newEntity");
                }
                this.checkSymbolicId(((ChangeEntry.AddEntity)change).getEntityData(), null);
                sourceEntityId = UtilsKt.notThis(((ChangeEntry.AddEntity)change).getEntityData().createEntityId());
                WorkspaceEntityData<? extends WorkspaceEntity> targetEntityData = null;
                ThisEntityId targetEntityId = null;
                ThisEntityId idFromReplaceMap = (ThisEntityId)this.replaceMap.get(sourceEntityId);
                if (idFromReplaceMap != null) {
                    targetEntityData = this.target.getEntitiesByType$intellij_platform_workspaceModel_storage().cloneAndAddAt(((ChangeEntry.AddEntity)change).getEntityData(), idFromReplaceMap.getId());
                    targetEntityId = idFromReplaceMap;
                } else {
                    targetEntityData = this.target.getEntitiesByType$intellij_platform_workspaceModel_storage().cloneAndAdd(((ChangeEntry.AddEntity)change).getEntityData(), ((ChangeEntry.AddEntity)change).getClazz());
                    targetEntityId = UtilsKt.asThis(targetEntityData.createEntityId());
                    HashBiMap<NotThisEntityId, ThisEntityId> hashBiMap = this.replaceMap;
                    Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"replaceMap");
                    ((Map)hashBiMap).put(sourceEntityId, targetEntityId);
                }
                if (targetEntityData instanceof SoftLinkable) {
                    this.target.getIndexes$intellij_platform_workspaceModel_storage().updateSoftLinksIndex((SoftLinkable)((Object)targetEntityData));
                }
                this.addRestoreChildren((NotThisEntityId)sourceEntityId, targetEntityId);
                this.addRestoreParents((NotThisEntityId)sourceEntityId, targetEntityId);
                this.target.getIndexes$intellij_platform_workspaceModel_storage().updateIndices(((ChangeEntry.AddEntity)change).getEntityData().createEntityId(), targetEntityData, this.diff);
                this.target.getChangeLog$intellij_platform_workspaceModel_storage().addAddEvent$intellij_platform_workspaceModel_storage(targetEntityId.getId(), targetEntityData);
                continue;
            }
            if (changeEntry instanceof ChangeEntry.RemoveEntity) {
                $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("addDiff: remove entity. " + ((ChangeEntry.RemoveEntity)change).getId());
                }
                if (this.replaceMap.containsValue(sourceEntityId = UtilsKt.asThis(((ChangeEntry.RemoveEntity)change).getId()))) continue;
                this.target.getIndexes$intellij_platform_workspaceModel_storage().entityRemoved(((ThisEntityId)sourceEntityId).getId());
                if (this.target.entityDataById$intellij_platform_workspaceModel_storage(((ThisEntityId)sourceEntityId).getId()) == null) continue;
                MutableEntityStorageImpl.removeEntityByEntityId$intellij_platform_workspaceModel_storage$default(this.target, ((ThisEntityId)sourceEntityId).getId(), null, 2, null);
                continue;
            }
            if (changeEntry instanceof ChangeEntry.ReplaceEntity) {
                $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("addDiff: replace entity");
                }
                this.replaceOperation((ChangeEntry.ReplaceEntity)change);
                continue;
            }
            if (changeEntry instanceof ChangeEntry.ChangeEntitySource) {
                $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("addDiff: change entity source");
                }
                this.replaceSourceOperation(((ChangeEntry.ChangeEntitySource)change).getNewData(), ((ChangeEntry.ChangeEntitySource)change).getOriginalSource());
                continue;
            }
            if (!(changeEntry instanceof ChangeEntry.ReplaceAndChangeSource)) continue;
            $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("addDiff: replace and change source");
            }
            this.replaceOperation(((ChangeEntry.ReplaceAndChangeSource)change).getDataChange());
            this.replaceSourceOperation(((ChangeEntry.ReplaceAndChangeSource)change).getSourceChange().getNewData(), ((ChangeEntry.ReplaceAndChangeSource)change).getSourceChange().getOriginalSource());
        }
        MutableStorageIndexes mutableStorageIndexes = this.target.getIndexes$intellij_platform_workspaceModel_storage();
        HashBiMap<NotThisEntityId, ThisEntityId> hashBiMap = this.replaceMap;
        Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"replaceMap");
        mutableStorageIndexes.applyExternalMappingChanges(this.diff, hashBiMap, this.target);
        if (!this.target.getBrokenConsistency$intellij_platform_workspaceModel_storage() && !this.diff.getBrokenConsistency$intellij_platform_workspaceModel_storage()) {
            this.target.assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage("Check after add Diff", null, this.initialStorage, this.diff);
        } else {
            this.target.setBrokenConsistency$intellij_platform_workspaceModel_storage(true);
        }
    }

    private final void replaceSourceOperation(WorkspaceEntityData<? extends WorkspaceEntity> data, EntitySource originalSource) {
        NotThisEntityId outdatedId = UtilsKt.notThis(data.createEntityId());
        ThisEntityId usedPid = (ThisEntityId)this.replaceMap.getOrDefault((Object)outdatedId, (Object)UtilsKt.asThis(outdatedId.getId()));
        WorkspaceEntityData<?> existingEntityData = this.target.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityDataForModificationOrNull(usedPid.getId());
        if (existingEntityData != null) {
            EntitySource newEntitySource = data.getEntitySource();
            existingEntityData.setEntitySource(newEntitySource);
            ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.target.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(usedPid.getId(), newEntitySource);
            this.target.getChangeLog$intellij_platform_workspaceModel_storage().addChangeSourceEvent$intellij_platform_workspaceModel_storage(usedPid.getId(), existingEntityData, originalSource);
        }
    }

    private final void addRestoreParents(NotThisEntityId sourceEntityId, ThisEntityId targetEntityId) {
        Map<ConnectionId, ParentEntityId> allParents = this.diff.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(sourceEntityId.getId()));
        for (Map.Entry<ConnectionId, ParentEntityId> entry : allParents.entrySet()) {
            WorkspaceEntityBase obsoleteChild;
            ThisEntityId targetParentId;
            ThisEntityId thisEntityId;
            ConnectionId connectionId = entry.getKey();
            ParentEntityId sourceParentId = entry.getValue();
            if (this.diffLog.get(sourceParentId.getId()) instanceof ChangeEntry.AddEntity) {
                thisEntityId = (ThisEntityId)this.replaceMap.get((Object)UtilsKt.notThis(sourceParentId.getId()));
                if (thisEntityId == null) {
                    AddDiffOperation $this$addRestoreParents_u24lambda_u245 = this;
                    boolean bl = false;
                    ThisEntityId placeholderId = UtilsKt.asThis($this$addRestoreParents_u24lambda_u245.target.getEntitiesByType$intellij_platform_workspaceModel_storage().book(EntityIdKt.getClazz(sourceParentId.getId())));
                    HashBiMap<NotThisEntityId, ThisEntityId> hashBiMap = $this$addRestoreParents_u24lambda_u245.replaceMap;
                    Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"replaceMap");
                    Map map2 = (Map)hashBiMap;
                    map2.put(UtilsKt.notThis(sourceParentId.getId()), placeholderId);
                    thisEntityId = placeholderId;
                }
            } else if (this.target.entityDataById$intellij_platform_workspaceModel_storage(sourceParentId.getId()) != null) {
                thisEntityId = UtilsKt.asThis(sourceParentId.getId());
            } else {
                if (!connectionId.canRemoveParent()) {
                    this.target.addDiffAndReport$intellij_platform_workspaceModel_storage("Cannot restore dependency. " + connectionId + ", " + sourceParentId + ".id", this.initialStorage, this.diff);
                }
                thisEntityId = null;
            }
            if ((targetParentId = thisEntityId) == null) continue;
            if ((connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ONE || connectionId.getConnectionType() == ConnectionId.ConnectionType.ABSTRACT_ONE_TO_ONE) && (obsoleteChild = (WorkspaceEntityBase)EntityStorageExtensionsKt.extractOneToOneChild(this.target, connectionId, targetParentId.getId())) != null && obsoleteChild.getId() != targetEntityId.getId()) {
                this.target.removeEntity(obsoleteChild);
            }
            this.target.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage(connectionId, RefsTableKt.asChild(targetEntityId.getId()), RefsTableKt.asParent(targetParentId.getId()));
        }
    }

    private final void addRestoreChildren(NotThisEntityId sourceEntityId, ThisEntityId targetEntityId) {
        Map<ConnectionId, List<ChildEntityId>> allSourceChildren = this.diff.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(sourceEntityId.getId()));
        for (Map.Entry<ConnectionId, List<ChildEntityId>> entry : allSourceChildren.entrySet()) {
            ConnectionId connectionId = entry.getKey();
            List<ChildEntityId> sourceChildrenIds = entry.getValue();
            List targetChildrenIds = new ArrayList();
            for (ChildEntityId sourceChildId : sourceChildrenIds) {
                if (this.diffLog.get(sourceChildId.getId()) instanceof ChangeEntry.AddEntity) {
                    ThisEntityId possibleTargetChildId = (ThisEntityId)this.replaceMap.get((Object)UtilsKt.notThis(sourceChildId.getId()));
                    if (possibleTargetChildId != null) {
                        ((Collection)targetChildrenIds).add(RefsTableKt.asChild(possibleTargetChildId.getId()));
                        continue;
                    }
                    ThisEntityId placeholderId = UtilsKt.asThis(this.target.getEntitiesByType$intellij_platform_workspaceModel_storage().book(EntityIdKt.getClazz(sourceChildId.getId())));
                    HashBiMap<NotThisEntityId, ThisEntityId> hashBiMap = this.replaceMap;
                    Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"replaceMap");
                    Map map2 = (Map)hashBiMap;
                    map2.put(UtilsKt.notThis(sourceChildId.getId()), placeholderId);
                    ((Collection)targetChildrenIds).add(RefsTableKt.asChild(placeholderId.getId()));
                    continue;
                }
                if (this.target.entityDataById$intellij_platform_workspaceModel_storage(sourceChildId.getId()) == null) continue;
                ((Collection)targetChildrenIds).add(sourceChildId);
            }
            this.target.getRefs$intellij_platform_workspaceModel_storage().updateChildrenOfParent$intellij_platform_workspaceModel_storage(connectionId, RefsTableKt.asParent(targetEntityId.getId()), targetChildrenIds);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceOperation(ChangeEntry.ReplaceEntity change) {
        void $this$flatMapTo$iv$iv;
        NotThisEntityId sourceEntityId = UtilsKt.notThis(change.getNewData().createEntityId());
        Map<ConnectionId, List<ChildEntityId>> $this$flatMap$iv = this.target.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(sourceEntityId.getId()));
        boolean $i$f$flatMap = false;
        Map<ConnectionId, List<ChildEntityId>> map2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            ConnectionId key = (ConnectionId)entry.getKey();
            List value = (List)entry.getValue();
            Iterable $this$map$iv = value;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ChildEntityId childEntityId = (ChildEntityId)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)key, (Object)it));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List beforeChildren = (List)destination$iv$iv;
        Map<ConnectionId, ParentEntityId> beforeParents = this.target.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(sourceEntityId.getId()));
        ThisEntityId targetEntityId = (ThisEntityId)this.replaceMap.getOrDefault((Object)sourceEntityId, (Object)UtilsKt.asThis(sourceEntityId.getId()));
        Object newTargetEntityData = change.getNewData().clone();
        ((WorkspaceEntityData)newTargetEntityData).setId(EntityIdKt.getArrayId(targetEntityId.getId()));
        this.checkSymbolicId(change.getNewData(), ((WorkspaceEntityData)newTargetEntityData).createEntityId());
        WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = this.target.entityDataById$intellij_platform_workspaceModel_storage(targetEntityId.getId());
        if (workspaceEntityData == null) {
            return;
        }
        WorkspaceEntityData<? extends WorkspaceEntity> existingTargetEntityData = workspaceEntityData;
        WorkspaceEntityData<?> originalEntityData = WorkspaceBuilderChangeLogKt.getOriginalEntityData(this.target, targetEntityId.getId());
        Map<ConnectionId, ParentEntityId> originalParents = WorkspaceBuilderChangeLogKt.getOriginalParents(this.target, RefsTableKt.asChild(targetEntityId.getId()));
        ((WorkspaceEntityData)newTargetEntityData).setEntitySource(existingTargetEntityData.getEntitySource());
        this.target.getIndexes$intellij_platform_workspaceModel_storage().updateIndices(sourceEntityId.getId(), (WorkspaceEntityData<?>)newTargetEntityData, this.diff);
        long newEntityId = ((WorkspaceEntityData)newTargetEntityData).createEntityId();
        WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData2 = this.target.entityDataById$intellij_platform_workspaceModel_storage(newEntityId);
        SymbolicEntityId<?> oldSymbolicId = workspaceEntityData2 != null ? EntitiesKt.symbolicId(workspaceEntityData2) : null;
        this.target.getEntitiesByType$intellij_platform_workspaceModel_storage().replaceById(newTargetEntityData, EntityIdKt.getClazz(sourceEntityId.getId()));
        MutableStorageIndexes.updateSymbolicIdIndexes$default(this.target.getIndexes$intellij_platform_workspaceModel_storage(), this.target, ((WorkspaceEntityData)newTargetEntityData).createEntity(this.target), oldSymbolicId, (WorkspaceEntityData)newTargetEntityData, null, 16, null);
        HashMultimap addedChildrenMap = HashMultimap.create();
        Iterable $this$forEach$iv = change.getNewChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            addedChildrenMap.put(it.getFirst(), it.getSecond());
        }
        HashMultimap removedChildrenMap = HashMultimap.create();
        Iterable $this$forEach$iv2 = change.getRemovedChildren();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            removedChildrenMap.put(it.getFirst(), it.getSecond());
        }
        ParentEntityId parentEntityId = RefsTableKt.asParent(sourceEntityId.getId());
        ParentEntityId parentEntityId2 = RefsTableKt.asParent(newEntityId);
        Intrinsics.checkNotNullExpressionValue((Object)addedChildrenMap, (String)"addedChildrenMap");
        Intrinsics.checkNotNullExpressionValue((Object)removedChildrenMap, (String)"removedChildrenMap");
        this.replaceRestoreChildren(parentEntityId, parentEntityId2, (HashMultimap<ConnectionId, ChildEntityId>)addedChildrenMap, (HashMultimap<ConnectionId, ChildEntityId>)removedChildrenMap);
        this.replaceRestoreParents(change, newEntityId);
        MutableEntityStorageImpl.Companion.addReplaceEvent$intellij_platform_workspaceModel_storage(this.target, sourceEntityId.getId(), beforeChildren, beforeParents, (WorkspaceEntityData<? extends WorkspaceEntity>)newTargetEntityData, originalEntityData, originalParents);
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceRestoreChildren(ParentEntityId sourceEntityId, ParentEntityId newEntityId, HashMultimap<ConnectionId, ChildEntityId> addedChildrenMap, HashMultimap<ConnectionId, ChildEntityId> removedChildrenMap) {
        ConnectionId connectionId;
        Map<ConnectionId, List<ChildEntityId>> existingChildren = this.target.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(newEntityId);
        for (Map.Entry<ConnectionId, List<ChildEntityId>> entry : existingChildren.entrySet()) {
            Iterator element$iv$iv$iv;
            Iterable destination$iv$iv;
            connectionId = entry.getKey();
            List<ChildEntityId> children2 = entry.getValue();
            if (connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ABSTRACT_MANY) {
                void $this$mapNotNullTo$iv$iv;
                List list = this.diff.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(sourceEntityId).get(connectionId);
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List sourceChildren = list;
                Iterable $this$mapNotNull$iv = sourceChildren;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ChildEntityId it$iv$iv;
                    Iterator element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    ChildEntityId it = (ChildEntityId)((Object)element$iv$iv);
                    boolean bl2 = false;
                    if (this.childrenMapper(it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List updatedChildren = (List)destination$iv$iv;
                if (!Intrinsics.areEqual((Object)updatedChildren, children2)) {
                    this.target.getRefs$intellij_platform_workspaceModel_storage().updateChildrenOfParent$intellij_platform_workspaceModel_storage(connectionId, newEntityId, updatedChildren);
                }
            } else {
                void $this$mapNotNullTo$iv$iv;
                Set mutableChildren = CollectionsKt.toMutableSet((Iterable)children2);
                Set set = addedChildrenMap.get((Object)connectionId);
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                Set addedChildrenSet = set;
                Iterable $this$mapNotNull$iv = addedChildrenSet;
                boolean $i$f$mapNotNull = false;
                destination$iv$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                element$iv$iv$iv = $this$forEach$iv$iv$iv.iterator();
                while (element$iv$iv$iv.hasNext()) {
                    ChildEntityId it$iv$iv;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv = element$iv$iv$iv2 = element$iv$iv$iv.next();
                    boolean bl = false;
                    ChildEntityId it = (ChildEntityId)element$iv$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (this.childrenMapper(it) == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List updatedAddedChildren = (List)destination$iv$iv2;
                mutableChildren.addAll(updatedAddedChildren);
                Set set2 = removedChildrenMap.get((Object)connectionId);
                if (set2 == null) {
                    set2 = SetsKt.emptySet();
                }
                Set removedChildrenSet = set2;
                for (ChildEntityId removedChild : removedChildrenSet) {
                    mutableChildren.remove(removedChild);
                }
                if (!Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)children2), (Object)mutableChildren)) {
                    this.target.getRefs$intellij_platform_workspaceModel_storage().updateChildrenOfParent$intellij_platform_workspaceModel_storage(connectionId, newEntityId, mutableChildren);
                }
            }
            addedChildrenMap.removeAll((Object)connectionId);
            removedChildrenMap.removeAll((Object)connectionId);
        }
        Map map2 = addedChildrenMap.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"addedChildrenMap.asMap()");
        for (Map.Entry<ConnectionId, List<ChildEntityId>> entry : map2.entrySet()) {
            void $this$mapNotNullTo$iv$iv;
            connectionId = entry.getKey();
            Collection children2 = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)children2, (String)"children");
            Iterable $this$mapNotNull$iv = children2;
            boolean $i$f$mapNotNull = false;
            Iterable removedChildrenSet = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ChildEntityId it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ChildEntityId it = (ChildEntityId)element$iv$iv;
                boolean bl6 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (this.childrenMapper(it) == null) continue;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List updatedChildren = (List)destination$iv$iv;
            MutableRefsTable mutableRefsTable = this.target.getRefs$intellij_platform_workspaceModel_storage();
            Intrinsics.checkNotNullExpressionValue((Object)connectionId, (String)"connectionId");
            mutableRefsTable.updateChildrenOfParent$intellij_platform_workspaceModel_storage(connectionId, newEntityId, updatedChildren);
        }
    }

    private final ChildEntityId childrenMapper(ChildEntityId child) {
        ChildEntityId childEntityId;
        if (this.diffLog.get(child.getId()) instanceof ChangeEntry.AddEntity) {
            ThisEntityId possibleNewChildId = (ThisEntityId)this.replaceMap.get((Object)UtilsKt.notThis(child.getId()));
            if (possibleNewChildId != null) {
                childEntityId = RefsTableKt.asChild(possibleNewChildId.getId());
            } else {
                long bookedChildId = this.target.getEntitiesByType$intellij_platform_workspaceModel_storage().book(EntityIdKt.getClazz(child.getId()));
                HashBiMap<NotThisEntityId, ThisEntityId> hashBiMap = this.replaceMap;
                Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"replaceMap");
                Map map2 = (Map)hashBiMap;
                NotThisEntityId notThisEntityId = UtilsKt.notThis(child.getId());
                ThisEntityId thisEntityId = UtilsKt.asThis(bookedChildId);
                map2.put(notThisEntityId, thisEntityId);
                childEntityId = RefsTableKt.asChild(bookedChildId);
            }
        } else {
            childEntityId = this.target.entityDataById$intellij_platform_workspaceModel_storage(child.getId()) != null ? child : null;
        }
        return childEntityId;
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceRestoreParents(ChangeEntry.ReplaceEntity change, long newEntityId) {
        ConnectionId connectionId;
        Object object;
        void $this$mapValuesTo$iv$iv;
        Map<ConnectionId, ParentEntityId> $this$mapValues$iv = change.getModifiedParents();
        boolean $i$f$mapValues = false;
        Map<ConnectionId, ParentEntityId> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean bl = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            object = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl22 = false;
            ParentEntityId parentEntityId = (ParentEntityId)it.getValue();
            map4.put(k, parentEntityId);
        }
        Map updatedModifiedParents = destination$iv$iv;
        Map modifiedParentsMap = MapsKt.toMutableMap((Map)updatedModifiedParents);
        ChildEntityId newChildEntityId = RefsTableKt.asChild(newEntityId);
        Map<ConnectionId, ParentEntityId> existingParents = this.target.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(newChildEntityId);
        for (Map.Entry<ConnectionId, ParentEntityId> entry : existingParents.entrySet()) {
            connectionId = entry.getKey();
            ParentEntityId existingParent = entry.getValue();
            if (!modifiedParentsMap.containsKey(connectionId)) continue;
            ParentEntityId newParent = (ParentEntityId)MapsKt.getValue((Map)modifiedParentsMap, (Object)connectionId);
            if (newParent == null) {
                if (!connectionId.canRemoveParent()) {
                    this.target.addDiffAndReport$intellij_platform_workspaceModel_storage("Cannot restore some dependencies; " + connectionId, this.initialStorage, this.diff);
                } else {
                    this.target.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef(connectionId, existingParent, newChildEntityId);
                }
            } else if (this.diffLog.get(newParent.getId()) instanceof ChangeEntry.AddEntity) {
                ThisEntityId possibleNewParent = (ThisEntityId)this.replaceMap.get((Object)UtilsKt.notThis(newParent.getId()));
                if (possibleNewParent == null) {
                    possibleNewParent = UtilsKt.asThis(this.target.getEntitiesByType$intellij_platform_workspaceModel_storage().book(EntityIdKt.getClazz(newParent.getId())));
                    HashBiMap<NotThisEntityId, ThisEntityId> hashBiMap = this.replaceMap;
                    Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"replaceMap");
                    object = (Map)hashBiMap;
                    object.put(UtilsKt.notThis(newParent.getId()), possibleNewParent);
                }
                this.target.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage(connectionId, RefsTableKt.asChild(newEntityId), RefsTableKt.asParent(possibleNewParent.getId()));
            } else if (this.target.entityDataById$intellij_platform_workspaceModel_storage(newParent.getId()) != null) {
                this.target.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage(connectionId, RefsTableKt.asChild(newEntityId), newParent);
            } else {
                if (!connectionId.canRemoveParent()) {
                    this.target.addDiffAndReport$intellij_platform_workspaceModel_storage("Cannot restore some dependencies; " + connectionId, this.initialStorage, this.diff);
                }
                this.target.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef(connectionId, existingParent, newChildEntityId);
            }
            modifiedParentsMap.remove(connectionId);
        }
        for (Map.Entry<ConnectionId, ParentEntityId> entry : modifiedParentsMap.entrySet()) {
            connectionId = entry.getKey();
            ParentEntityId parentId = entry.getValue();
            if (parentId == null) continue;
            if (this.diffLog.get(parentId.getId()) instanceof ChangeEntry.AddEntity) {
                ThisEntityId possibleNewParent = (ThisEntityId)this.replaceMap.get((Object)UtilsKt.notThis(parentId.getId()));
                if (possibleNewParent == null) {
                    possibleNewParent = UtilsKt.asThis(this.target.getEntitiesByType$intellij_platform_workspaceModel_storage().book(EntityIdKt.getClazz(parentId.getId())));
                    HashBiMap<NotThisEntityId, ThisEntityId> hashBiMap = this.replaceMap;
                    Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"replaceMap");
                    Map map5 = (Map)hashBiMap;
                    map5.put(UtilsKt.notThis(parentId.getId()), possibleNewParent);
                }
                this.target.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage(connectionId, RefsTableKt.asChild(newEntityId), RefsTableKt.asParent(possibleNewParent.getId()));
                continue;
            }
            if (this.target.entityDataById$intellij_platform_workspaceModel_storage(parentId.getId()) == null) continue;
            this.target.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage(connectionId, RefsTableKt.asChild(newEntityId), parentId);
        }
    }

    private final void checkSymbolicId(WorkspaceEntityData<? extends WorkspaceEntity> entityData, Long newEntityId) {
        Long existingIds;
        SymbolicEntityId<?> newSymbolicId = EntitiesKt.symbolicId(entityData);
        if (newSymbolicId != null && (existingIds = this.target.getIndexes$intellij_platform_workspaceModel_storage().getSymbolicIdIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(newSymbolicId)) != null) {
            boolean existingIdCheck;
            Long l = newEntityId;
            boolean bl = l != null ? !Intrinsics.areEqual((Object)existingIds, (Object)l) : (existingIdCheck = true);
            if (existingIdCheck) {
                WorkspaceEntityData<? extends WorkspaceEntity> existingEntityData = this.target.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(existingIds);
                LOG.debug("Removing existing entity... " + existingIds);
                this.target.removeEntity(existingEntityData.createEntity(this.target));
                this.target.addDiffAndReport$intellij_platform_workspaceModel_storage(StringsKt.trimIndent((String)("\n                        Symbolic ID already exists. Removing old entity\n                        Symbolic ID: " + newSymbolicId + "\n                        Existing entity data: " + existingEntityData + "\n                        New entity data: " + entityData + "\n                        ")), this.initialStorage, this.diff);
            }
        }
    }

    private final void serialize(String path) {
        File folder = new File(path);
        ErrorReportingKt.serializeTo(this.target, new FileOutputStream(FilesKt.resolve((File)folder, (String)"Instant_Save_Target")));
        ErrorReportingKt.serializeTo(this.diff, new FileOutputStream(FilesKt.resolve((File)folder, (String)"Instant_Save_Source")));
        ErrorReportingKt.serializeDiff(this.diff, new FileOutputStream(FilesKt.resolve((File)folder, (String)"Instant_Save_Diff")));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AddDiffOperation.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/workspaceModel/storage/impl/AddDiffOperation$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.workspaceModel.storage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

