/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide;

import com.intellij.workspaceModel.ide.StorageReplacement;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.MutableEntityStorage;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/workspaceModel/ide/BuilderSnapshot;", "", "version", "", "storage", "Lcom/intellij/workspaceModel/storage/EntityStorageSnapshot;", "(JLcom/intellij/workspaceModel/storage/EntityStorageSnapshot;)V", "builder", "Lcom/intellij/workspaceModel/storage/MutableEntityStorage;", "getBuilder", "()Lcom/intellij/workspaceModel/storage/MutableEntityStorage;", "getVersion", "()J", "areEntitiesChanged", "", "getStorageReplacement", "Lcom/intellij/workspaceModel/ide/StorageReplacement;", "intellij.platform.projectModel"})
public final class BuilderSnapshot {
    private final long version;
    @NotNull
    private final EntityStorageSnapshot storage;
    @NotNull
    private final MutableEntityStorage builder;

    public BuilderSnapshot(long version, @NotNull EntityStorageSnapshot storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.version = version;
        this.storage = storage;
        this.builder = MutableEntityStorage.Companion.from(this.storage);
    }

    public final long getVersion() {
        return this.version;
    }

    @NotNull
    public final MutableEntityStorage getBuilder() {
        return this.builder;
    }

    public final boolean areEntitiesChanged() {
        return !this.builder.hasSameEntities(this.storage);
    }

    @NotNull
    public final StorageReplacement getStorageReplacement() {
        Map<Class<?>, List<EntityChange<?>>> changes = this.builder.collectChanges(this.storage);
        return new StorageReplacement(this.version, this.builder, changes);
    }
}

