/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import com.intellij.util.messages.impl.MessageBusImpl;
import com.intellij.util.messages.impl.MessageDeliveryListener;
import com.intellij.util.messages.impl.MessageQueue;
import com.intellij.util.messages.impl.MethodHandleCache;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u001a#\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u001a&\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0002\u001a0\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014H\u0002\u001am\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0010\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\b2\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\u0010!\u001ae\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0010\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\b2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010'\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010)2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010*\u001a/\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020\u00042\u0010\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010-\u001a\u0010\u0010.\u001a\u00020,2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a7\u0010/\u001a\u00020,2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u00100\u001a\u00020\u00012\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u00101\u001a\u0016\u00102\u001a\u00020,2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00150\rH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"DISPOSED_STATE", "", "DISPOSE_IN_PROGRESS", "NA", "", "clearSubscriberCacheOnConnectionTerminated", "", "topicAndHandlerPairs", "", "bus", "Lcom/intellij/util/messages/impl/MessageBusImpl;", "([Ljava/lang/Object;Lcom/intellij/util/messages/impl/MessageBusImpl;)Z", "deliverImmediately", "", "Lcom/intellij/util/messages/impl/Message;", "connection", "Lcom/intellij/util/messages/impl/MessageBusConnectionImpl;", "jobs", "Ljava/util/Deque;", "deliverMessage", "", "", "job", "jobQueue", "Lcom/intellij/util/messages/impl/MessageQueue;", "prevExceptions", "executeOrAddToQueue", "topic", "Lcom/intellij/util/messages/Topic;", "method", "Ljava/lang/reflect/Method;", "args", "handlers", "(Lcom/intellij/util/messages/Topic;Ljava/lang/reflect/Method;[Ljava/lang/Object;[Ljava/lang/Object;Lcom/intellij/util/messages/impl/MessageQueue;Ljava/util/List;Lcom/intellij/util/messages/impl/MessageBusImpl;)Ljava/util/List;", "invokeListener", "methodHandle", "Ljava/lang/invoke/MethodHandle;", "methodName", "", "handler", "messageDeliveryListener", "Lcom/intellij/util/messages/impl/MessageDeliveryListener;", "(Ljava/lang/invoke/MethodHandle;Ljava/lang/String;[Ljava/lang/Object;Lcom/intellij/util/messages/Topic;Ljava/lang/Object;Lcom/intellij/util/messages/impl/MessageDeliveryListener;Ljava/util/List;)Ljava/util/List;", "invokeMethod", "", "(Ljava/lang/Object;[Ljava/lang/Object;Ljava/lang/invoke/MethodHandle;)V", "pumpWaiting", "removeDisposedHandlers", "index", "([Ljava/lang/Object;ILcom/intellij/util/messages/Topic;Lcom/intellij/util/messages/impl/MessageBusImpl;)V", "throwExceptions", "exceptions", "intellij.platform.core"})
public final class MessageBusImplKt {
    @NotNull
    private static final Object NA = new Object();
    private static final int DISPOSE_IN_PROGRESS = 1;
    private static final int DISPOSED_STATE = 2;

    private static final void pumpWaiting(MessageQueue jobQueue) {
        block5: {
            List<Throwable> exceptions = null;
            Message job = jobQueue.current;
            if (job != null) {
                if (job.bus.isDisposed()) {
                    MessageBusImpl.LOG.error("Accessing disposed message bus " + job.bus);
                } else {
                    exceptions = MessageBusImplKt.deliverMessage(job, jobQueue, null);
                }
            }
            while (jobQueue.queue.pollFirst() != null) {
                if (job.bus.isDisposed()) {
                    MessageBusImpl.LOG.error("Accessing disposed message bus " + job.bus);
                    continue;
                }
                exceptions = MessageBusImplKt.deliverMessage(job, jobQueue, exceptions);
            }
            List<Throwable> list = exceptions;
            if (list == null) break block5;
            List<Throwable> p0 = list;
            boolean bl = false;
            MessageBusImplKt.throwExceptions(p0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<Throwable> deliverMessage(Message job, MessageQueue jobQueue, List<Throwable> prevExceptions) {
        AutoCloseable autoCloseable = ClientId.Companion.withClientId(job.clientId);
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            jobQueue.current = job;
            Object[] handlers2 = job.handlers;
            List<Throwable> exceptions = prevExceptions;
            int index2 = job.currentHandlerIndex;
            int size = handlers2.length;
            int lastIndex = size - 1;
            while (index2 < size) {
                if (index2 == lastIndex) {
                    jobQueue.current = null;
                }
                int n = job.currentHandlerIndex;
                job.currentHandlerIndex = n + 1;
                Object handler = handlers2[index2];
                if (handler != null) {
                    exceptions = MessageBusImplKt.invokeListener(job.method, job.methodName, job.args, job.topic, handler, job.bus.messageDeliveryListener, exceptions);
                }
                if (++index2 == job.currentHandlerIndex) continue;
                List<Throwable> list = exceptions;
                return list;
            }
            List<Throwable> list = exceptions;
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Nullable
    public static final List<Throwable> executeOrAddToQueue(@NotNull Topic<?> topic, @NotNull Method method, @Nullable Object[] args2, @NotNull Object[] handlers2, @Nullable MessageQueue jobQueue, @Nullable List<Throwable> prevExceptions, @NotNull MessageBusImpl bus) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)handlers2, (String)"handlers");
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        MethodHandle methodHandle = MethodHandleCache.compute(method, args2);
        Intrinsics.checkNotNullExpressionValue((Object)methodHandle, (String)"compute(method, args)");
        MethodHandle methodHandle2 = methodHandle;
        if (jobQueue == null) {
            List<Throwable> exceptions = prevExceptions;
            for (Object handler : handlers2) {
                String string2 = method.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"method.name");
                Object object = handler;
                if (object == null) continue;
                exceptions = MessageBusImplKt.invokeListener(methodHandle2, string2, args2, topic, object, bus.messageDeliveryListener, exceptions);
            }
            return exceptions;
        }
        ArrayDeque<Message> arrayDeque = jobQueue.queue;
        String string3 = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"method.name");
        arrayDeque.offerLast(new Message(topic, methodHandle2, string3, args2, handlers2, bus));
        return prevExceptions;
    }

    private static final boolean clearSubscriberCacheOnConnectionTerminated(Object[] topicAndHandlerPairs, MessageBusImpl bus) {
        boolean isChildClearingNeeded = false;
        int i = 0;
        while (i < topicAndHandlerPairs.length) {
            Topic.BroadcastDirection direction;
            Object object = topicAndHandlerPairs[i];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.util.messages.Topic<*>");
            Topic topic = (Topic)object;
            MessageBusImplKt.removeDisposedHandlers(topicAndHandlerPairs, i, topic, bus);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)topic.getBroadcastDirection()), (String)"topic.broadcastDirection");
            if (direction != Topic.BroadcastDirection.TO_CHILDREN) {
                i += 2;
                continue;
            }
            MessageBusImpl parentBus = bus;
            while (true) {
                CompositeMessageBus compositeMessageBus = parentBus.parentBus;
                if (compositeMessageBus == null) {
                    break;
                }
                parentBus = compositeMessageBus;
                MessageBusImplKt.removeDisposedHandlers(topicAndHandlerPairs, i, topic, parentBus);
            }
            if (bus.hasChildren()) {
                isChildClearingNeeded = true;
            }
            i += 2;
        }
        return isChildClearingNeeded;
    }

    private static final void removeDisposedHandlers(Object[] topicAndHandlerPairs, int index2, Topic<?> topic, MessageBusImpl bus) {
        Object[] objectArray = bus.subscriberCache.remove(topic);
        if (objectArray == null) {
            return;
        }
        Object[] cachedHandlers = objectArray;
        Object handler = topicAndHandlerPairs[index2 + 1];
        if (topic.isImmediateDelivery()) {
            int length = cachedHandlers.length;
            for (int i = 0; i < length; ++i) {
                if (cachedHandlers[i] != handler) continue;
                cachedHandlers[i] = null;
            }
        }
        bus.rootBus.removeDisposedHandlers(topic, handler);
    }

    private static final List<Message> deliverImmediately(MessageBusConnectionImpl connection, Deque<Message> jobs) {
        List newJobs = null;
        Iterator<Message> iterator = jobs.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"jobs.iterator()");
        Iterator<Message> jobIterator = iterator;
        while (jobIterator.hasNext()) {
            Message job = jobIterator.next();
            List connectionHandlers = null;
            Object[] allHandlers = job.handlers;
            int length = allHandlers.length;
            for (int i = 0; i < length; ++i) {
                Object handler = allHandlers[i];
                if (handler == null || connection.bus != job.bus || !connection.isMyHandler(job.topic, handler)) continue;
                allHandlers[i] = null;
                if (connectionHandlers == null) {
                    connectionHandlers = new ArrayList();
                }
                connectionHandlers.add(handler);
            }
            if (connectionHandlers == null) continue;
            if (allHandlers.length == connectionHandlers.size()) {
                jobIterator.remove();
            }
            Collection $this$toTypedArray$iv = connectionHandlers;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Message filteredJob = new Message(job.topic, job.method, job.methodName, job.args, thisCollection$iv.toArray(new Object[0]), job.bus);
            if (newJobs == null) {
                newJobs = new ArrayList();
            }
            newJobs.add(filteredJob);
        }
        return newJobs;
    }

    private static final List<Throwable> invokeListener(MethodHandle methodHandle, String methodName, Object[] args2, Topic<?> topic, Object handler, MessageDeliveryListener messageDeliveryListener, List<Throwable> prevExceptions) {
        try {
            if (handler instanceof MessageHandler) {
                MessageHandler messageHandler = (MessageHandler)handler;
                Object[] objectArray = args2;
                if (args2 == null) {
                    objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
                }
                Object[] objectArray2 = objectArray;
                messageHandler.handle(methodHandle, Arrays.copyOf(objectArray2, objectArray2.length));
            } else if (messageDeliveryListener == null) {
                MessageBusImplKt.invokeMethod(handler, args2, methodHandle);
            } else {
                long startTime = System.nanoTime();
                MessageBusImplKt.invokeMethod(handler, args2, methodHandle);
                messageDeliveryListener.messageDelivered(topic, methodName, handler, System.nanoTime() - startTime);
            }
        }
        catch (AbstractMethodError startTime) {
        }
        catch (Throwable e) {
            List exceptions;
            List list = prevExceptions;
            if (list == null) {
                list = exceptions = (List)new ArrayList();
            }
            if (e instanceof ProcessCanceledException || e instanceof AssertionError || e instanceof CancellationException) {
                exceptions.add(e);
            } else {
                exceptions.add(new RuntimeException("Cannot invoke (class=" + handler.getClass().getSimpleName() + ", method=" + methodName + ", topic=" + topic.getDisplayName() + ')', e));
            }
            return exceptions;
        }
        return prevExceptions;
    }

    private static final void invokeMethod(Object handler, Object[] args2, MethodHandle methodHandle) {
        if (args2 == null) {
            methodHandle.invoke(handler);
        } else {
            methodHandle.bindTo(handler).invokeExact(args2);
        }
    }

    public static final void throwExceptions(@NotNull List<? extends Throwable> exceptions) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
            if (exceptions.size() == 1) {
                throw exceptions.get(0);
            }
            Iterable $this$firstOrNull$iv = exceptions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Throwable it = (Throwable)element$iv;
                boolean bl = false;
                if (!(it instanceof ProcessCanceledException || it instanceof CancellationException)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Throwable throwable = v0;
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw it;
        }
        throw new CompoundRuntimeException(exceptions);
    }

    public static final /* synthetic */ boolean access$clearSubscriberCacheOnConnectionTerminated(Object[] topicAndHandlerPairs, MessageBusImpl bus) {
        return MessageBusImplKt.clearSubscriberCacheOnConnectionTerminated(topicAndHandlerPairs, bus);
    }

    public static final /* synthetic */ List access$deliverImmediately(MessageBusConnectionImpl connection, Deque jobs) {
        return MessageBusImplKt.deliverImmediately(connection, jobs);
    }

    public static final /* synthetic */ List access$deliverMessage(Message job, MessageQueue jobQueue, List prevExceptions) {
        return MessageBusImplKt.deliverMessage(job, jobQueue, prevExceptions);
    }

    public static final /* synthetic */ Object access$getNA$p() {
        return NA;
    }

    public static final /* synthetic */ void access$pumpWaiting(MessageQueue jobQueue) {
        MessageBusImplKt.pumpWaiting(jobQueue);
    }
}

