/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import com.intellij.util.messages.impl.MessageBusImpl;
import com.intellij.util.messages.impl.MessageBusImplKt;
import com.intellij.util.messages.impl.MessageDeliveryListener;
import com.intellij.util.messages.impl.MessagePublisher;
import com.intellij.util.messages.impl.MessageQueue;
import com.intellij.util.messages.impl.RootBus;
import com.intellij.util.messages.impl.SimpleMessageBusConnectionImpl;
import com.intellij.util.messages.impl.ToParentMessagePublisher;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u0000 N2\u00020\u0001:\u0002NOB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u001b\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016H\u0016\u00a2\u0006\u0002\u0010\u001fJ!\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00162\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\tH\u0016J/\u0010&\u001a\b\u0012\u0004\u0012\u0002H(0'\"\u0004\b\u0000\u0010(2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H(0\u00102\u0006\u0010)\u001a\u00020*H\u0010\u00a2\u0006\u0002\b+J\u0015\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.H\u0000\u00a2\u0006\u0002\b/J\u001a\u00100\u001a\u00020\u001b2\u0010\u00101\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030302H\u0016J\b\u00104\u001a\u00020\u001bH\u0016J\b\u00105\u001a\u00020\u001bH\u0014J\u0006\u00106\u001a\u00020\u001bJ\u0006\u00107\u001a\u00020\u001bJ*\u00108\u001a\u00020\u001b2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u00102\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00110:2\u0006\u0010;\u001a\u00020<H\u0016J\n\u0010=\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010>\u001a\u00020<H\u0016J\u0014\u0010?\u001a\u00020<2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\b\u0010@\u001a\u00020<H\u0016J\u001b\u0010A\u001a\u00020<2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016H\u0016\u00a2\u0006\u0002\u0010BJ\u0012\u0010C\u001a\u00020\u001b2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0010J\u0014\u0010D\u001a\u00020\u001b2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\b\u0010E\u001a\u00020\u001bH\u0016J\u0010\u0010F\u001a\u00020\u001b2\b\u0010G\u001a\u0004\u0018\u00010\rJ\b\u0010H\u001a\u00020IH\u0016J%\u0010J\u001a\u0002H(\"\b\b\u0000\u0010(*\u00020\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H(0\u0010H\u0016\u00a2\u0006\u0002\u0010KJ\b\u0010L\u001a\u00020MH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\r8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00110\u000f8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00138\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0014\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00160\u00158\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/intellij/util/messages/impl/MessageBusImpl;", "Lcom/intellij/util/messages/MessageBus;", "owner", "Lcom/intellij/util/messages/MessageBusOwner;", "parentBus", "Lcom/intellij/util/messages/impl/CompositeMessageBus;", "(Lcom/intellij/util/messages/MessageBusOwner;Lcom/intellij/util/messages/impl/CompositeMessageBus;)V", "(Lcom/intellij/util/messages/MessageBusOwner;)V", "connectionDisposable", "Lcom/intellij/openapi/Disposable;", "disposeState", "", "messageDeliveryListener", "Lcom/intellij/util/messages/impl/MessageDeliveryListener;", "publisherCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/util/messages/Topic;", "", "rootBus", "Lcom/intellij/util/messages/impl/RootBus;", "subscriberCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "subscribers", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/intellij/util/messages/impl/MessageBusImpl$MessageHandlerHolder;", "checkNotDisposed", "", "checkNotDisposed$intellij_platform_core", "clearSubscriberCache", "topicAndHandlerPairs", "([Ljava/lang/Object;)V", "computeSubscribers", "topic", "(Lcom/intellij/util/messages/Topic;)[Ljava/lang/Object;", "connect", "Lcom/intellij/util/messages/MessageBusConnection;", "parentDisposable", "createPublisher", "Lcom/intellij/util/messages/impl/MessagePublisher;", "L", "direction", "Lcom/intellij/util/messages/Topic$BroadcastDirection;", "createPublisher$intellij_platform_core", "deliverImmediately", "connection", "Lcom/intellij/util/messages/impl/MessageBusConnectionImpl;", "deliverImmediately$intellij_platform_core", "disconnectPluginConnections", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "dispose", "disposeChildren", "disposeConnection", "disposeConnectionChildren", "doComputeSubscribers", "result", "", "subscribeLazyListeners", "", "getParent", "hasChildren", "hasUndeliveredEvents", "isDisposed", "notifyConnectionTerminated", "([Ljava/lang/Object;)Z", "notifyOnSubscription", "notifyOnSubscriptionToTopicToChildren", "removeEmptyConnectionsRecursively", "setMessageDeliveryListener", "listener", "simpleConnect", "Lcom/intellij/util/messages/SimpleMessageBusConnection;", "syncPublisher", "(Lcom/intellij/util/messages/Topic;)Ljava/lang/Object;", "toString", "", "Companion", "MessageHandlerHolder", "intellij.platform.core"})
@ApiStatus.Internal
public class MessageBusImpl
implements MessageBus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final ConcurrentMap<Topic<?>, Object> publisherCache;
    @JvmField
    @NotNull
    public final ConcurrentLinkedQueue<MessageHandlerHolder> subscribers;
    @JvmField
    @NotNull
    public final ConcurrentHashMap<Topic<?>, Object[]> subscriberCache;
    @JvmField
    @Nullable
    public final CompositeMessageBus parentBus;
    @JvmField
    @NotNull
    public final RootBus rootBus;
    @JvmField
    @NotNull
    public final MessageBusOwner owner;
    private int disposeState;
    @Nullable
    private Disposable connectionDisposable;
    @JvmField
    @Nullable
    public MessageDeliveryListener messageDeliveryListener;
    @JvmField
    @NotNull
    public static final Logger LOG;

    public MessageBusImpl(@NotNull MessageBusOwner owner, @NotNull CompositeMessageBus parentBus) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)parentBus, (String)"parentBus");
        this.publisherCache = new ConcurrentHashMap();
        this.subscribers = new ConcurrentLinkedQueue();
        this.subscriberCache = new ConcurrentHashMap();
        this.connectionDisposable = Disposer.newDisposable();
        this.owner = owner;
        this.parentBus = parentBus;
        this.rootBus = parentBus.rootBus;
        parentBus.addChild(this);
    }

    public MessageBusImpl(@NotNull MessageBusOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.publisherCache = new ConcurrentHashMap();
        this.subscribers = new ConcurrentLinkedQueue();
        this.subscriberCache = new ConcurrentHashMap();
        this.connectionDisposable = Disposer.newDisposable();
        this.owner = owner;
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.intellij.util.messages.impl.RootBus");
        this.rootBus = (RootBus)this;
        this.parentBus = null;
    }

    @Override
    @Nullable
    public MessageBus getParent() {
        return this.parentBus;
    }

    @NotNull
    public String toString() {
        return "MessageBus(owner=" + this.owner + ", disposeState= " + this.disposeState + ')';
    }

    @Override
    @NotNull
    public MessageBusConnection connect() {
        Disposable disposable = this.connectionDisposable;
        Intrinsics.checkNotNull((Object)disposable);
        return this.connect(disposable);
    }

    @Override
    @NotNull
    public MessageBusConnection connect(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.checkNotDisposed$intellij_platform_core();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        this.subscribers.add(connection);
        Disposer.register(parentDisposable, connection);
        return connection;
    }

    @Override
    @NotNull
    public SimpleMessageBusConnection simpleConnect() {
        this.checkNotDisposed$intellij_platform_core();
        SimpleMessageBusConnectionImpl connection = new SimpleMessageBusConnectionImpl(this);
        this.subscribers.add(connection);
        return connection;
    }

    @Override
    @NotNull
    public <L> L syncPublisher(@NotNull Topic<L> topic) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        if (this.isDisposed()) {
            PluginException.logPluginError(LOG, "Already disposed: " + this, null, topic.getClass());
        }
        Object object = this.publisherCache.computeIfAbsent(topic, arg_0 -> MessageBusImpl.syncPublisher$lambda$0((Function1)new Function1<Topic<?>, Object>(this){
            final /* synthetic */ MessageBusImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Object invoke(@NotNull Topic<?> topic1) {
                Intrinsics.checkNotNullParameter(topic1, (String)"topic1");
                Class<?> clazz = topic1.getListenerClass();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"topic1.listenerClass");
                Class<?> aClass = clazz;
                ClassLoader classLoader = aClass.getClassLoader();
                Class[] classArray = new Class[]{aClass};
                Topic.BroadcastDirection broadcastDirection = topic1.getBroadcastDirection();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)broadcastDirection), (String)"topic1.broadcastDirection");
                return Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)this.this$0.createPublisher$intellij_platform_core(topic1, broadcastDirection));
            }
        }, arg_0));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type L of com.intellij.util.messages.impl.MessageBusImpl.syncPublisher");
        return (L)object;
    }

    @NotNull
    public <L> MessagePublisher<L> createPublisher$intellij_platform_core(@NotNull Topic<L> topic, @NotNull Topic.BroadcastDirection direction) {
        MessagePublisher messagePublisher;
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                messagePublisher = new ToParentMessagePublisher<L>(topic, this);
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic broadcast direction to NONE or TO_PARENT");
            }
            default: {
                LOG.error("Topic " + topic.getListenerClass().getName() + " broadcast direction TO_CHILDREN is not allowed for module level message bus. Please change to NONE or TO_PARENT");
                messagePublisher = new MessagePublisher<L>(topic, this);
            }
        }
        return messagePublisher;
    }

    public final void disposeConnectionChildren() {
        this.disposeState = 1;
        Disposable disposable = this.connectionDisposable;
        Intrinsics.checkNotNull((Object)disposable);
        Disposer.disposeChildren(disposable, arg_0 -> MessageBusImpl.disposeConnectionChildren$lambda$1(disposeConnectionChildren.1.INSTANCE, arg_0));
    }

    public final void disposeConnection() {
        Disposable disposable = this.connectionDisposable;
        Intrinsics.checkNotNull((Object)disposable);
        Disposer.dispose(disposable);
        this.connectionDisposable = null;
    }

    @Override
    public void dispose() {
        block2: {
            if (this.disposeState == 2) {
                LOG.error("Already disposed: " + this);
            }
            this.disposeState = 2;
            this.disposeChildren();
            Disposable disposable = this.connectionDisposable;
            if (disposable != null) {
                Disposable it = disposable;
                boolean bl = false;
                Disposer.dispose(it);
            }
            this.rootBus.getQueue$intellij_platform_core().queue.removeIf(arg_0 -> MessageBusImpl.dispose$lambda$3((Function1)new Function1<Message, Boolean>(this){
                final /* synthetic */ MessageBusImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(Message it) {
                    return it.bus == this.this$0;
                }
            }, arg_0));
            CompositeMessageBus compositeMessageBus = this.parentBus;
            if (compositeMessageBus == null) break block2;
            compositeMessageBus.onChildBusDisposed(this);
        }
    }

    protected void disposeChildren() {
    }

    @Override
    public boolean isDisposed() {
        return this.disposeState == 2 || this.owner.isDisposed();
    }

    @Override
    public boolean hasUndeliveredEvents(@NotNull Topic<?> topic) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(topic, (String)"topic");
            if (this.isDisposed()) {
                return false;
            }
            MessageQueue queue = this.rootBus.getQueue$intellij_platform_core();
            Message current2 = queue.current;
            if (current2 != null && current2.topic == topic && current2.bus == this) {
                return true;
            }
            Iterable $this$any$iv = queue.queue;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Message it = (Message)element$iv;
                    boolean bl2 = false;
                    if (!(it.topic == topic && it.bus == this)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void checkNotDisposed$intellij_platform_core() {
        if (this.isDisposed()) {
            LOG.error("Already disposed: " + this);
        }
    }

    public void doComputeSubscribers(@NotNull Topic<?> topic, @NotNull List<Object> result2, boolean subscribeLazyListeners2) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        for (MessageHandlerHolder subscriber : this.subscribers) {
            if (subscriber.isDisposed()) continue;
            subscriber.collectHandlers(topic, result2);
        }
    }

    @NotNull
    public Object[] computeSubscribers(@NotNull Topic<?> topic) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        List result2 = new ArrayList();
        this.doComputeSubscribers(topic, result2, true);
        if (result2.isEmpty()) {
            objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
        } else {
            Collection $this$toTypedArray$iv = result2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Object[0]);
        }
        return objectArray;
    }

    public boolean hasChildren() {
        return false;
    }

    public final void notifyOnSubscription(@NotNull Topic<?> topic) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        this.subscriberCache.remove(topic);
        if (topic.getBroadcastDirection() != Topic.BroadcastDirection.TO_CHILDREN) {
            return;
        }
        MessageBusImpl parentBus = this;
        while (true) {
            CompositeMessageBus compositeMessageBus = parentBus.parentBus;
            if (compositeMessageBus == null) {
                break;
            }
            parentBus = compositeMessageBus;
            parentBus.subscriberCache.remove(topic);
        }
        if (this.hasChildren()) {
            this.notifyOnSubscriptionToTopicToChildren(topic);
        }
    }

    public void notifyOnSubscriptionToTopicToChildren(@NotNull Topic<?> topic) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
    }

    public void removeEmptyConnectionsRecursively() {
        this.subscribers.removeIf(arg_0 -> MessageBusImpl.removeEmptyConnectionsRecursively$lambda$5(removeEmptyConnectionsRecursively.1.INSTANCE, arg_0));
    }

    public boolean notifyConnectionTerminated(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter((Object)topicAndHandlerPairs, (String)"topicAndHandlerPairs");
        if (this.disposeState != 0) {
            return false;
        }
        this.rootBus.scheduleEmptyConnectionRemoving();
        return MessageBusImplKt.access$clearSubscriberCacheOnConnectionTerminated(topicAndHandlerPairs, this);
    }

    public void clearSubscriberCache(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter((Object)topicAndHandlerPairs, (String)"topicAndHandlerPairs");
        for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
            Map map2 = this.subscriberCache;
            Object object = topicAndHandlerPairs[i];
            TypeIntrinsics.asMutableMap((Object)map2).remove(object);
        }
    }

    public final void deliverImmediately$intellij_platform_core(@NotNull MessageBusConnectionImpl connection) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            if (this.disposeState == 2) {
                LOG.error("Already disposed: " + this);
            }
            if (this.owner.isDisposed()) {
                return;
            }
            MessageQueue queue = this.rootBus.getQueue$intellij_platform_core();
            ArrayDeque<Message> jobs = queue.queue;
            if (jobs.isEmpty()) {
                return;
            }
            List list = MessageBusImplKt.access$deliverImmediately(connection, jobs);
            if (list == null) {
                return;
            }
            List newJobs = list;
            int n = newJobs.size() + -1;
            if (0 <= n) {
                do {
                    int i = n--;
                    jobs.addFirst((Message)newJobs.get(i));
                } while (0 <= n);
            }
            List exceptions = null;
            for (Message job : newJobs) {
                jobs.removeFirstOccurrence(job);
                exceptions = MessageBusImplKt.access$deliverMessage(job, queue, exceptions);
            }
            List list2 = exceptions;
            if (list2 == null) break block7;
            List p0 = list2;
            boolean bl = false;
            MessageBusImplKt.throwExceptions(p0);
        }
    }

    public final void setMessageDeliveryListener(@Nullable MessageDeliveryListener listener) {
        if (!(this.messageDeliveryListener == null || listener == null)) {
            boolean bl = false;
            String string2 = "Already set: " + this.messageDeliveryListener;
            throw new IllegalStateException(string2.toString());
        }
        this.messageDeliveryListener = listener;
    }

    public void disconnectPluginConnections(@NotNull Predicate<Class<?>> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        for (MessageHandlerHolder holder : this.subscribers) {
            holder.disconnectIfNeeded(predicate);
        }
        this.subscriberCache.clear();
    }

    private static final Object syncPublisher$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final boolean disposeConnectionChildren$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean dispose$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeEmptyConnectionsRecursively$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(MessageBusImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(MessageBusImpl::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\"\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nH&J\u001a\u0010\u000b\u001a\u00020\u00062\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/messages/impl/MessageBusImpl$MessageHandlerHolder;", "", "isDisposed", "", "()Z", "collectHandlers", "", "topic", "Lcom/intellij/util/messages/Topic;", "result", "", "disconnectIfNeeded", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "intellij.platform.core"})
    public static interface MessageHandlerHolder {
        public boolean isDisposed();

        public void collectHandlers(@NotNull Topic<?> var1, @NotNull List<Object> var2);

        public void disconnectIfNeeded(@NotNull Predicate<Class<?>> var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0015\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/messages/impl/MessageBusImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Topic.BroadcastDirection.values().length];
            try {
                nArray[Topic.BroadcastDirection.TO_PARENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Topic.BroadcastDirection.TO_DIRECT_CHILDREN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

