/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import java.nio.ByteBuffer;

public final class Xor16 {
    private static final int BITS_PER_FINGERPRINT = 16;
    private static final int HASHES = 3;
    private static final int OFFSET = 32;
    private static final int FACTOR_TIMES_100 = 123;
    private final int blockLength;
    private final long seed;
    private final short[] fingerprints;

    private Xor16(short[] fingerprints, int blockLength, long seed) {
        this.seed = seed;
        this.fingerprints = fingerprints;
        this.blockLength = blockLength;
    }

    public Xor16(ByteBuffer buffer) {
        this.seed = buffer.getLong();
        this.fingerprints = new short[buffer.getInt()];
        this.blockLength = this.fingerprints.length / 3;
        buffer.asShortBuffer().get(this.fingerprints);
        buffer.position(buffer.position() + this.fingerprints.length * 2);
    }

    public int sizeInBytes() {
        return 12 + this.fingerprints.length * 2;
    }

    public void write(ByteBuffer buffer) {
        buffer.putLong(this.seed);
        buffer.putInt(this.fingerprints.length);
        buffer.asShortBuffer().put(this.fingerprints);
        buffer.position(buffer.position() + this.fingerprints.length * 2);
    }

    private static int getArrayLength(int size) {
        return (int)(32L + 123L * (long)size / 100L);
    }

    public static int getBlockLength(int keyCount) {
        return Xor16.getArrayLength(keyCount) / 3;
    }

    private static long mix(long x) {
        long h = x * -7046029254386353131L;
        h ^= h >>> 32;
        return h ^ h >>> 16;
    }

    public static Xor16 construct(long[] keys2, int offset, int length) {
        int h;
        int hi;
        int reverseOrderPos;
        int arrayLength = Xor16.getArrayLength(length);
        int blockLength = arrayLength / 3;
        long[] reverseOrder = new long[length];
        byte[] reverseH = new byte[length];
        long seed = 1354212L;
        do {
            seed = Xor16.mix(seed);
            byte[] t2count = new byte[arrayLength];
            long[] t2 = new long[arrayLength];
            for (int i = offset; i < length; ++i) {
                long k = keys2[i];
                for (int hi2 = 0; hi2 < 3; ++hi2) {
                    int h2;
                    int n = h2 = Xor16.getHash(blockLength, k, seed, hi2);
                    t2[n] = t2[n] ^ k;
                    if (t2count[h2] > 120) {
                        throw new IllegalArgumentException();
                    }
                    int n2 = h2;
                    t2count[n2] = (byte)(t2count[n2] + 1);
                }
            }
            int[] alone = new int[arrayLength];
            int alonePos = 0;
            reverseOrderPos = 0;
            int nextAloneCheck = 0;
            while (nextAloneCheck < arrayLength) {
                while (nextAloneCheck < arrayLength) {
                    if (t2count[nextAloneCheck] == 1) {
                        alone[alonePos++] = nextAloneCheck;
                    }
                    ++nextAloneCheck;
                }
                while (alonePos > 0) {
                    int i;
                    if (t2count[i = alone[--alonePos]] == 0) continue;
                    long k = t2[i];
                    int found = -1;
                    for (hi = 0; hi < 3; ++hi) {
                        int n = h = Xor16.getHash(blockLength, k, seed, hi);
                        t2count[n] = (byte)(t2count[n] - 1);
                        byte newCount = t2count[n];
                        if (newCount == 0) {
                            found = (byte)hi;
                            continue;
                        }
                        if (newCount == 1) {
                            alone[alonePos++] = h;
                        }
                        int n3 = h;
                        t2[n3] = t2[n3] ^ k;
                    }
                    reverseOrder[reverseOrderPos] = k;
                    reverseH[reverseOrderPos] = found;
                    ++reverseOrderPos;
                }
            }
        } while (reverseOrderPos != length);
        short[] fingerprints = new short[arrayLength];
        for (int i = reverseOrderPos - 1; i >= 0; --i) {
            long k = reverseOrder[i];
            int found = reverseH[i];
            int change = -1;
            long hash = Xor16.hash64(k, seed);
            int xor = Xor16.fingerprint(hash);
            for (hi = 0; hi < 3; ++hi) {
                h = Xor16.getHash(blockLength, k, seed, hi);
                if (found == hi) {
                    change = h;
                    continue;
                }
                xor ^= fingerprints[h];
            }
            fingerprints[change] = (short)xor;
        }
        return new Xor16(fingerprints, blockLength, seed);
    }

    private static int getHash(int blockLength, long key, long seed, int index2) {
        long r = Long.rotateLeft(Xor16.hash64(key, seed), 21 * index2);
        r = Xor16.reduce((int)r, blockLength);
        return (int)(r += (long)index2 * (long)blockLength);
    }

    public boolean mightContain(long key) {
        int h2;
        int h1;
        long hash = Xor16.hash64(key, this.seed);
        int f = Xor16.fingerprint(hash);
        int r0 = (int)hash;
        int r1 = (int)Long.rotateLeft(hash, 21);
        int r2 = (int)Long.rotateLeft(hash, 42);
        int h0 = Xor16.reduce(r0, this.blockLength);
        return ((f ^= this.fingerprints[h0] ^ this.fingerprints[h1 = Xor16.reduce(r1, this.blockLength) + this.blockLength] ^ this.fingerprints[h2 = Xor16.reduce(r2, this.blockLength) + 2 * this.blockLength]) & 0xFFFF) == 0;
    }

    private static int fingerprint(long hash) {
        return (int)(hash & 0xFFFFL);
    }

    private static long hash64(long x, long seed) {
        x += seed;
        x = (x ^ x >>> 33) * -49064778989728563L;
        x = (x ^ x >>> 33) * -4265267296055464877L;
        x ^= x >>> 33;
        return x;
    }

    private static int reduce(int hash, int n) {
        return (int)(((long)hash & 0xFFFFFFFFL) * (long)n >>> 32);
    }
}

