/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.MapBackedFMap;
import com.intellij.util.keyFMap.OneElementFMap;
import com.intellij.util.keyFMap.PairElementsFMap;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

final class ArrayBackedFMap
implements KeyFMap {
    static final int ARRAY_THRESHOLD = 8;
    private final int[] keys;
    @NotNull
    private final @NotNull Object @NotNull [] values;

    ArrayBackedFMap(int @NotNull [] keys2, @NotNull @NotNull Object @NotNull [] values2) {
        if (keys2 == null) {
            ArrayBackedFMap.$$$reportNull$$$0(0);
        }
        if (values2 == null) {
            ArrayBackedFMap.$$$reportNull$$$0(1);
        }
        this.keys = keys2;
        this.values = values2;
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        int keyCode;
        int keyPos;
        if (key == null) {
            ArrayBackedFMap.$$$reportNull$$$0(2);
        }
        if (value == null) {
            ArrayBackedFMap.$$$reportNull$$$0(3);
        }
        if ((keyPos = this.indexOf(keyCode = key.hashCode())) >= 0) {
            if (this.values[keyPos] == value) {
                ArrayBackedFMap arrayBackedFMap = this;
                if (arrayBackedFMap == null) {
                    ArrayBackedFMap.$$$reportNull$$$0(4);
                }
                return arrayBackedFMap;
            }
            Object[] newValues = (Object[])this.values.clone();
            newValues[keyPos] = value;
            return new ArrayBackedFMap(this.keys, newValues);
        }
        if (this.size() < 8) {
            int[] newKeys = ArrayUtil.insert(this.keys, -keyPos - 1, keyCode);
            Object[] newValues = ArrayUtil.insert(this.values, -keyPos - 1, value);
            return new ArrayBackedFMap(newKeys, newValues);
        }
        return new MapBackedFMap(this.keys, keyCode, this.values, value);
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    private int indexOf(int keyCode) {
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (key == keyCode) {
                return i;
            }
            if (key <= keyCode) continue;
            return -i - 1;
        }
        return -this.keys.length - 1;
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        int i;
        if (key == null) {
            ArrayBackedFMap.$$$reportNull$$$0(5);
        }
        if ((i = this.indexOf(key.hashCode())) >= 0) {
            if (this.size() == 3) {
                int otherI1 = (2 - i) / 2;
                int otherI2 = 3 - (i + 2) / 2;
                Key key1 = Key.getKeyByIndex(this.keys[otherI1]);
                Key key2 = Key.getKeyByIndex(this.keys[otherI2]);
                if (key1 == null && key2 == null) {
                    KeyFMap keyFMap = EMPTY_MAP;
                    if (keyFMap == null) {
                        ArrayBackedFMap.$$$reportNull$$$0(6);
                    }
                    return keyFMap;
                }
                if (key1 == null) {
                    return new OneElementFMap<Object>(key2, this.values[otherI2]);
                }
                if (key2 == null) {
                    return new OneElementFMap<Object>(key1, this.values[otherI1]);
                }
                return new PairElementsFMap<Object, Object>(key1, this.values[otherI1], key2, this.values[otherI2]);
            }
            int[] newKeys = ArrayUtil.remove(this.keys, i);
            Object[] newValues = ArrayUtil.remove(this.values, i, ArrayUtil.OBJECT_ARRAY_FACTORY);
            return new ArrayBackedFMap(newKeys, newValues);
        }
        ArrayBackedFMap arrayBackedFMap = this;
        if (arrayBackedFMap == null) {
            ArrayBackedFMap.$$$reportNull$$$0(7);
        }
        return arrayBackedFMap;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        int i;
        if (key == null) {
            ArrayBackedFMap.$$$reportNull$$$0(8);
        }
        return (V)((i = this.indexOf(key.hashCode())) < 0 ? null : this.values[i]);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("{");
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            Object value = this.values[i];
            s.append(s.length() == 1 ? "" : ", ").append(Key.getKeyByIndex(key)).append("=").append(value);
        }
        return s.append("}").toString();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getValueIdentityHashCode() {
        int hash = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            hash = hash * 31 + this.keys[i];
            hash = hash * 31 + System.identityHashCode(this.values[i]);
        }
        return hash;
    }

    @Override
    @NotNull
    public @NotNull Key<?> @NotNull [] getKeys() {
        return ArrayBackedFMap.getKeysByIndices(this.keys);
    }

    @NotNull
    static @NotNull Key<?> @NotNull [] getKeysByIndices(int @NotNull [] indexes) {
        if (indexes == null) {
            ArrayBackedFMap.$$$reportNull$$$0(9);
        }
        Key[] result2 = new Key[indexes.length];
        int o = 0;
        for (int index2 : indexes) {
            Key key = Key.getKeyByIndex(index2);
            if (key == null) continue;
            result2[o++] = key;
        }
        Key[] keyArray = o == result2.length ? result2 : Arrays.copyOf(result2, o);
        if (keyArray == null) {
            ArrayBackedFMap.$$$reportNull$$$0(10);
        }
        return keyArray;
    }

    public int hashCode() {
        int hash = 0;
        int length = this.keys.length;
        for (int i = 0; i < length; ++i) {
            hash += this.keys[i] ^ this.values[i].hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayBackedFMap)) {
            return false;
        }
        ArrayBackedFMap map2 = (ArrayBackedFMap)o;
        if (map2.size() != this.size()) {
            return false;
        }
        int length = this.keys.length;
        for (int i = 0; i < length; ++i) {
            if (this.keys[i] == map2.keys[i] && this.values[i].equals(map2.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsByReference(@NotNull KeyFMap o) {
        if (o == null) {
            ArrayBackedFMap.$$$reportNull$$$0(11);
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayBackedFMap)) {
            return false;
        }
        ArrayBackedFMap map2 = (ArrayBackedFMap)o;
        if (map2.size() != this.size()) {
            return false;
        }
        int length = this.keys.length;
        for (int i = 0; i < length; ++i) {
            if (this.keys[i] == map2.keys[i] && this.values[i] == map2.values[i]) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/keyFMap/ArrayBackedFMap";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/keyFMap/ArrayBackedFMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "plus";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysByIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "plus";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getKeysByIndices";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "equalsByReference";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

