/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThreadLocalCachedValue;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.text.ByteArrayCharSequence;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IOUtil {
    @ApiStatus.Internal
    public static final ThreadLocal<Boolean> OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP = new ThreadLocal<Boolean>(){

        @Override
        public void set(Boolean value) {
            if (this.get() != null) {
                throw new RuntimeException("Reentrant access");
            }
            super.set(value);
        }
    };
    @ApiStatus.Internal
    public static final String SHARED_CACHES_PROP = "idea.shared.caches";
    private static final int STRING_HEADER_SIZE = 1;
    private static final int STRING_LENGTH_THRESHOLD = 255;
    private static final String LONGER_THAN_64K_MARKER = "LONGER_THAN_64K";
    private static final ThreadLocalCachedValue<byte[]> ourReadWriteBuffersCache = new ThreadLocalCachedValue<byte[]>(){

        @Override
        protected byte @NotNull [] create() {
            byte[] byArray = IOUtil.allocReadWriteUTFBuffer();
            if (byArray == null) {
                2.$$$reportNull$$$0(0);
            }
            return byArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/IOUtil$2", "create"));
        }
    };

    @ApiStatus.Internal
    public static boolean useNativeByteOrderForByteBuffers() {
        Boolean forced = OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP.get();
        return forced == null || forced != false;
    }

    public static boolean isSharedCachesEnabled() {
        return SystemProperties.getBooleanProperty(SHARED_CACHES_PROP, false);
    }

    private IOUtil() {
    }

    public static String readString(@NotNull DataInput stream) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(0);
        }
        try {
            int length = stream.readInt();
            if (length == -1) {
                return null;
            }
            if (length == 0) {
                return "";
            }
            byte[] bytes = new byte[length * 2];
            stream.readFully(bytes);
            return new String(bytes, 0, length * 2, StandardCharsets.UTF_16BE);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public static void writeString(@Nullable String s, @NotNull DataOutput stream) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(1);
        }
        IOUtil.writeCharSequence(s, stream);
    }

    public static void writeCharSequence(@Nullable CharSequence s, @NotNull DataOutput stream) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(2);
        }
        if (s == null) {
            stream.writeInt(-1);
            return;
        }
        stream.writeInt(s.length());
        if (s.length() == 0) {
            return;
        }
        byte[] bytes = new byte[s.length() * 2];
        int i = 0;
        int i2 = 0;
        while (i < s.length()) {
            char aChar = s.charAt(i);
            bytes[i2] = (byte)(aChar >>> 8 & 0xFF);
            bytes[i2 + 1] = (byte)(aChar & 0xFF);
            ++i;
            i2 += 2;
        }
        stream.write(bytes);
    }

    public static void writeUTFTruncated(@NotNull DataOutput stream, @NotNull String text) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(3);
        }
        if (text == null) {
            IOUtil.$$$reportNull$$$0(4);
        }
        if (text.length() > 16383) {
            stream.writeUTF(text.substring(0, 16383));
        } else {
            stream.writeUTF(text);
        }
    }

    public static void writeUTF(@NotNull DataOutput storage, @NotNull String value) throws IOException {
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(5);
        }
        if (value == null) {
            IOUtil.$$$reportNull$$$0(6);
        }
        IOUtil.writeUTFFast(ourReadWriteBuffersCache.getValue(), storage, value);
    }

    public static void writeUTF(@NotNull DataOutput storage, @NotNull CharSequence value) throws IOException {
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(7);
        }
        if (value == null) {
            IOUtil.$$$reportNull$$$0(8);
        }
        IOUtil.writeUTFFast(ourReadWriteBuffersCache.getValue(), storage, value);
    }

    public static String readUTF(@NotNull DataInput storage) throws IOException {
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(9);
        }
        return IOUtil.readUTFFast(ourReadWriteBuffersCache.getValue(), storage);
    }

    public static CharSequence readUTFCharSequence(@NotNull DataInput storage) throws IOException {
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(10);
        }
        return IOUtil.readUTFFastCharSequence(storage);
    }

    public static byte @NotNull [] allocReadWriteUTFBuffer() {
        return new byte[256];
    }

    public static void writeUTFFast(byte @NotNull [] buffer, @NotNull DataOutput storage, @NotNull String value) throws IOException {
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(11);
        }
        if (value == null) {
            IOUtil.$$$reportNull$$$0(12);
        }
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(13);
        }
        IOUtil.writeUTFFast(buffer, storage, (CharSequence)value);
    }

    public static void writeUTFFast(byte @NotNull [] buffer, @NotNull DataOutput storage, @NotNull CharSequence value) throws IOException {
        int len;
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(14);
        }
        if (value == null) {
            IOUtil.$$$reportNull$$$0(15);
        }
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(16);
        }
        if ((len = value.length()) < 255) {
            buffer[0] = (byte)len;
            boolean isAscii = true;
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (c >= '\u0080') {
                    isAscii = false;
                    break;
                }
                buffer[i + 1] = (byte)c;
            }
            if (isAscii) {
                storage.write(buffer, 0, len + 1);
                return;
            }
        }
        storage.writeByte(-1);
        try {
            storage.writeUTF(value.toString());
        }
        catch (UTFDataFormatException e) {
            storage.writeUTF(LONGER_THAN_64K_MARKER);
            IOUtil.writeCharSequence(value, storage);
        }
    }

    public static String readUTFFast(byte @NotNull [] buffer, @NotNull DataInput storage) throws IOException {
        int len;
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(17);
        }
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(18);
        }
        if ((len = 0xFF & storage.readByte()) == 255) {
            return IOUtil.readLongString(storage);
        }
        if (len == 0) {
            return "";
        }
        storage.readFully(buffer, 0, len);
        return new String(buffer, 0, len, StandardCharsets.ISO_8859_1);
    }

    @Nullable
    private static String readLongString(@NotNull DataInput storage) throws IOException {
        String result2;
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(19);
        }
        if (LONGER_THAN_64K_MARKER.equals(result2 = storage.readUTF())) {
            return IOUtil.readString(storage);
        }
        return result2;
    }

    public static CharSequence readUTFFastCharSequence(@NotNull DataInput storage) throws IOException {
        int len;
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(20);
        }
        if ((len = 0xFF & storage.readByte()) == 255) {
            return IOUtil.readLongString(storage);
        }
        if (len == 0) {
            return "";
        }
        byte[] data = new byte[len];
        storage.readFully(data, 0, len);
        return new ByteArrayCharSequence(data, 0, len);
    }

    public static boolean isAscii(@NotNull String str) {
        if (str == null) {
            IOUtil.$$$reportNull$$$0(21);
        }
        return IOUtil.isAscii((CharSequence)str);
    }

    public static boolean isAscii(@NotNull CharSequence str) {
        if (str == null) {
            IOUtil.$$$reportNull$$$0(22);
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) < '\u0080') continue;
            return false;
        }
        return true;
    }

    public static boolean isAscii(char c) {
        return c < '\u0080';
    }

    public static boolean deleteAllFilesStartingWith(@NotNull Path file2) {
        List files2;
        if (file2 == null) {
            IOUtil.$$$reportNull$$$0(23);
        }
        String baseName = file2.getFileName().toString();
        Path parentFile = file2.getParent();
        if (parentFile == null) {
            return true;
        }
        try (Stream<Path> stream = Files.list(parentFile);){
            files2 = stream.filter(it -> it.getFileName().toString().startsWith(baseName)).collect(Collectors.toList());
        }
        catch (NoSuchFileException ignore) {
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
        boolean ok = true;
        for (Path f : files2) {
            try {
                Files.deleteIfExists(f);
            }
            catch (IOException ignore) {
                ok = false;
            }
        }
        return ok;
    }

    public static boolean deleteAllFilesStartingWith(@NotNull File file2) {
        if (file2 == null) {
            IOUtil.$$$reportNull$$$0(24);
        }
        String baseName = file2.getName();
        File parentFile = file2.getParentFile();
        File[] files2 = parentFile != null ? parentFile.listFiles(pathname -> pathname.getName().startsWith(baseName)) : null;
        boolean ok = true;
        if (files2 != null) {
            for (File f : files2) {
                ok &= FileUtil.delete(f);
            }
        }
        return ok;
    }

    public static void syncStream(@NotNull OutputStream stream) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(25);
        }
        stream.flush();
        try {
            Object o;
            Field outField = FilterOutputStream.class.getDeclaredField("out");
            outField.setAccessible(true);
            while (stream instanceof FilterOutputStream && (o = outField.get(stream)) instanceof OutputStream) {
                stream = (OutputStream)o;
            }
            if (stream instanceof FileOutputStream) {
                ((FileOutputStream)stream).getFD().sync();
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull Path file2) throws IOException {
        if (factoryComputable == null) {
            IOUtil.$$$reportNull$$$0(26);
        }
        if (file2 == null) {
            IOUtil.$$$reportNull$$$0(27);
        }
        return IOUtil.openCleanOrResetBroken(factoryComputable, file2.toFile());
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull File file2) throws IOException {
        if (factoryComputable == null) {
            IOUtil.$$$reportNull$$$0(28);
        }
        if (file2 == null) {
            IOUtil.$$$reportNull$$$0(29);
        }
        return IOUtil.openCleanOrResetBroken(factoryComputable, () -> IOUtil.deleteAllFilesStartingWith(file2));
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull Runnable cleanupCallback) throws IOException {
        if (factoryComputable == null) {
            IOUtil.$$$reportNull$$$0(30);
        }
        if (cleanupCallback == null) {
            IOUtil.$$$reportNull$$$0(31);
        }
        try {
            return factoryComputable.compute();
        }
        catch (IOException ex) {
            cleanupCallback.run();
            return factoryComputable.compute();
        }
    }

    public static void writeStringList(@NotNull DataOutput out, @NotNull Collection<String> list) throws IOException {
        if (out == null) {
            IOUtil.$$$reportNull$$$0(32);
        }
        if (list == null) {
            IOUtil.$$$reportNull$$$0(33);
        }
        DataInputOutputUtil.writeINT(out, list.size());
        for (String s : list) {
            IOUtil.writeUTF(out, s);
        }
    }

    @NotNull
    public static <C extends Collection<String>> C readStringCollection(@NotNull DataInput in, @NotNull IntFunction<? extends C> collectionGenerator) throws IOException {
        if (in == null) {
            IOUtil.$$$reportNull$$$0(34);
        }
        if (collectionGenerator == null) {
            IOUtil.$$$reportNull$$$0(35);
        }
        int size = DataInputOutputUtil.readINT(in);
        Collection strings2 = (Collection)collectionGenerator.apply(size);
        for (int i = 0; i < size; ++i) {
            strings2.add(IOUtil.readUTF(in));
        }
        Collection collection = strings2;
        if (collection == null) {
            IOUtil.$$$reportNull$$$0(36);
        }
        return (C)collection;
    }

    @NotNull
    public static List<String> readStringList(@NotNull DataInput in) throws IOException {
        if (in == null) {
            IOUtil.$$$reportNull$$$0(37);
        }
        return IOUtil.readStringCollection(in, ArrayList::new);
    }

    public static void closeSafe(@NotNull Logger log, Closeable ... closeables) {
        if (log == null) {
            IOUtil.$$$reportNull$$$0(38);
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                log.error(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 36: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 23: 
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryComputable";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanupCallback";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionGenerator";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/IOUtil";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/IOUtil";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "readStringCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeCharSequence";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeUTFTruncated";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeUTF";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readUTF";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readUTFCharSequence";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeUTFFast";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readUTFFast";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readLongString";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readUTFFastCharSequence";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAscii";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "deleteAllFilesStartingWith";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "syncStream";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "openCleanOrResetBroken";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "writeStringList";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "readStringCollection";
                break;
            }
            case 36: {
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "readStringList";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "closeSafe";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 36: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

