/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.containers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.indexing.containers.IntIdsIterator;
import com.intellij.util.indexing.containers.RandomAccessIntContainer;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class IntHashSetAsRAIntContainer
implements RandomAccessIntContainer {
    private HashSet<Integer> myHashSet;

    public IntHashSetAsRAIntContainer(int initialCapacity, float loadFactor) {
        this.myHashSet = new HashSet(initialCapacity, loadFactor);
    }

    @Override
    public Object clone() {
        try {
            IntHashSetAsRAIntContainer copy2 = (IntHashSetAsRAIntContainer)super.clone();
            copy2.myHashSet = (HashSet)this.myHashSet.clone();
            return copy2;
        }
        catch (CloneNotSupportedException e) {
            Logger.getInstance(this.getClass().getName()).error(e);
            return null;
        }
    }

    @Override
    public boolean add(int value) {
        return this.myHashSet.add(value);
    }

    @Override
    public boolean remove(int value) {
        return this.myHashSet.remove(value);
    }

    @Override
    @NotNull
    public IntIdsIterator intIterator() {
        return new MyIterator();
    }

    @Override
    public void compact() {
    }

    @Override
    public int size() {
        return this.myHashSet.size();
    }

    @Override
    public boolean contains(int value) {
        return this.myHashSet.contains(value);
    }

    @Override
    @NotNull
    public RandomAccessIntContainer ensureContainerCapacity(int diff) {
        IntHashSetAsRAIntContainer intHashSetAsRAIntContainer = this;
        if (intHashSetAsRAIntContainer == null) {
            IntHashSetAsRAIntContainer.$$$reportNull$$$0(0);
        }
        return intHashSetAsRAIntContainer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/containers/IntHashSetAsRAIntContainer", "ensureContainerCapacity"));
    }

    private class MyIterator
    implements IntIdsIterator {
        private final Iterator<Integer> myHashSetIterator;

        private MyIterator() {
            this.myHashSetIterator = IntHashSetAsRAIntContainer.this.myHashSet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.myHashSetIterator.hasNext();
        }

        @Override
        public int next() {
            return this.myHashSetIterator.next();
        }

        @Override
        public int size() {
            return IntHashSetAsRAIntContainer.this.myHashSet.size();
        }

        @Override
        public boolean hasAscendingOrder() {
            return false;
        }

        @Override
        public IntIdsIterator createCopyInInitialState() {
            return new MyIterator();
        }
    }
}

