/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.containers.Enumerator;
import com.intellij.util.diff.DiffConfig;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.diff.LCSBuilder;
import com.intellij.util.diff.MyersLCS;
import com.intellij.util.diff.PatienceIntLCS;
import com.intellij.util.diff.Reindexer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Diff {
    private static final LoggerRt LOG = LoggerRt.getInstance(Diff.class);

    @Nullable
    public static Change buildChanges(@NotNull CharSequence before, @NotNull CharSequence after) throws FilesTooBigForDiffException {
        if (before == null) {
            Diff.$$$reportNull$$$0(0);
        }
        if (after == null) {
            Diff.$$$reportNull$$$0(1);
        }
        return Diff.buildChanges(Diff.splitLines(before), Diff.splitLines(after));
    }

    public static String @NotNull [] splitLines(@NotNull CharSequence s) {
        String[] stringArray;
        if (s == null) {
            Diff.$$$reportNull$$$0(2);
        }
        if (s.length() == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = LineTokenizer.tokenize(s, false, false);
        }
        if (stringArray == null) {
            Diff.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @Nullable
    public static <T> Change buildChanges(T @NotNull [] objects1, T @NotNull [] objects2) throws FilesTooBigForDiffException {
        int endCut;
        if (objects1 == null) {
            Diff.$$$reportNull$$$0(4);
        }
        if (objects2 == null) {
            Diff.$$$reportNull$$$0(5);
        }
        for (T anObjects1 : objects1) {
            assert (anObjects1 != null);
        }
        for (T anObjects2 : objects2) {
            assert (anObjects2 != null);
        }
        int startShift = Diff.getStartShift(objects1, objects2);
        Ref<Change> changeRef = Diff.doBuildChangesFast(objects1.length, objects2.length, startShift, endCut = Diff.getEndCut(objects1, objects2, startShift));
        if (changeRef != null) {
            return changeRef.get();
        }
        int trimmedLength = objects1.length + objects2.length - 2 * startShift - 2 * endCut;
        Enumerator<T> enumerator = new Enumerator<T>(trimmedLength);
        int[] ints1 = enumerator.enumerate(objects1, startShift, endCut);
        int[] ints2 = enumerator.enumerate(objects2, startShift, endCut);
        return Diff.doBuildChanges(ints1, ints2, new ChangeBuilder(startShift));
    }

    @Nullable
    public static Change buildChanges(int @NotNull [] array1, int @NotNull [] array2) throws FilesTooBigForDiffException {
        int endCut;
        int startShift;
        Ref<Change> changeRef;
        if (array1 == null) {
            Diff.$$$reportNull$$$0(6);
        }
        if (array2 == null) {
            Diff.$$$reportNull$$$0(7);
        }
        if ((changeRef = Diff.doBuildChangesFast(array1.length, array2.length, startShift = Diff.getStartShift(array1, array2), endCut = Diff.getEndCut(array1, array2, startShift))) != null) {
            return changeRef.get();
        }
        boolean copyArray = startShift != 0 || endCut != 0;
        int[] ints1 = copyArray ? Arrays.copyOfRange(array1, startShift, array1.length - endCut) : array1;
        int[] ints2 = copyArray ? Arrays.copyOfRange(array2, startShift, array2.length - endCut) : array2;
        return Diff.doBuildChanges(ints1, ints2, new ChangeBuilder(startShift));
    }

    @Nullable
    private static Ref<Change> doBuildChangesFast(int length1, int length2, int startShift, int endCut) {
        int trimmedLength1 = length1 - startShift - endCut;
        int trimmedLength2 = length2 - startShift - endCut;
        if (trimmedLength1 != 0 && trimmedLength2 != 0) {
            return null;
        }
        Change change = trimmedLength1 != 0 || trimmedLength2 != 0 ? new Change(startShift, startShift, trimmedLength1, trimmedLength2, null) : null;
        return new Ref<Change>(change);
    }

    private static Change doBuildChanges(int @NotNull [] ints1, int @NotNull [] ints2, @NotNull ChangeBuilder builder) throws FilesTooBigForDiffException {
        BitSet[] changes;
        Reindexer reindexer;
        int[][] discarded;
        if (builder == null) {
            Diff.$$$reportNull$$$0(8);
        }
        if (ints1 == null) {
            Diff.$$$reportNull$$$0(9);
        }
        if (ints2 == null) {
            Diff.$$$reportNull$$$0(10);
        }
        if ((discarded = (reindexer = new Reindexer()).discardUnique(ints1, ints2))[0].length == 0 && discarded[1].length == 0) {
            builder.addChange(ints1.length, ints2.length);
            return builder.getFirstChange();
        }
        if (DiffConfig.USE_PATIENCE_ALG) {
            PatienceIntLCS patienceIntLCS = new PatienceIntLCS(discarded[0], discarded[1]);
            patienceIntLCS.execute();
            changes = patienceIntLCS.getChanges();
        } else {
            try {
                MyersLCS intLCS = new MyersLCS(discarded[0], discarded[1]);
                intLCS.executeWithThreshold();
                changes = intLCS.getChanges();
            }
            catch (FilesTooBigForDiffException e) {
                PatienceIntLCS patienceIntLCS = new PatienceIntLCS(discarded[0], discarded[1]);
                patienceIntLCS.execute(true);
                changes = patienceIntLCS.getChanges();
                LOG.info("Successful fallback to patience diff");
            }
        }
        reindexer.reindex(changes, builder);
        return builder.getFirstChange();
    }

    private static <T> int getStartShift(T @NotNull [] o1, T @NotNull [] o2) {
        if (o1 == null) {
            Diff.$$$reportNull$$$0(11);
        }
        if (o2 == null) {
            Diff.$$$reportNull$$$0(12);
        }
        int size = Math.min(o1.length, o2.length);
        int idx = 0;
        for (int i = 0; i < size && o1[i].equals(o2[i]); ++i) {
            ++idx;
        }
        return idx;
    }

    private static <T> int getEndCut(T @NotNull [] o1, T @NotNull [] o2, int startShift) {
        if (o1 == null) {
            Diff.$$$reportNull$$$0(13);
        }
        if (o2 == null) {
            Diff.$$$reportNull$$$0(14);
        }
        int size = Math.min(o1.length, o2.length) - startShift;
        int idx = 0;
        for (int i = 0; i < size && o1[o1.length - i - 1].equals(o2[o2.length - i - 1]); ++i) {
            ++idx;
        }
        return idx;
    }

    private static int getStartShift(int @NotNull [] o1, int @NotNull [] o2) {
        if (o1 == null) {
            Diff.$$$reportNull$$$0(15);
        }
        if (o2 == null) {
            Diff.$$$reportNull$$$0(16);
        }
        int size = Math.min(o1.length, o2.length);
        int idx = 0;
        for (int i = 0; i < size && o1[i] == o2[i]; ++i) {
            ++idx;
        }
        return idx;
    }

    private static int getEndCut(int @NotNull [] o1, int @NotNull [] o2, int startShift) {
        if (o1 == null) {
            Diff.$$$reportNull$$$0(17);
        }
        if (o2 == null) {
            Diff.$$$reportNull$$$0(18);
        }
        int size = Math.min(o1.length, o2.length) - startShift;
        int idx = 0;
        for (int i = 0; i < size && o1[o1.length - i - 1] == o2[o2.length - i - 1]; ++i) {
            ++idx;
        }
        return idx;
    }

    public static int translateLine(@NotNull CharSequence before, @NotNull CharSequence after, int line, boolean approximate) throws FilesTooBigForDiffException {
        if (before == null) {
            Diff.$$$reportNull$$$0(19);
        }
        if (after == null) {
            Diff.$$$reportNull$$$0(20);
        }
        String[] strings1 = LineTokenizer.tokenize(before, false);
        String[] strings2 = LineTokenizer.tokenize(after, false);
        if (approximate) {
            strings1 = Diff.trim(strings1);
            strings2 = Diff.trim(strings2);
        }
        Change change = Diff.buildChanges(strings1, strings2);
        return Diff.translateLine(change, line, approximate);
    }

    private static String @NotNull [] trim(String @NotNull [] lines) {
        if (lines == null) {
            Diff.$$$reportNull$$$0(21);
        }
        String[] result2 = new String[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            result2[i] = lines[i].trim();
        }
        if (result2 == null) {
            Diff.$$$reportNull$$$0(22);
        }
        return result2;
    }

    public static int translateLine(@Nullable Change change, int line) {
        return Diff.translateLine(change, line, false);
    }

    public static int translateLine(@Nullable Change change, int line, boolean approximate) {
        int result2 = line;
        Change currentChange = change;
        while (currentChange != null && line >= currentChange.line0) {
            if (line >= currentChange.line0 + currentChange.deleted) {
                result2 += currentChange.inserted - currentChange.deleted;
            } else {
                return approximate ? currentChange.line1 : -1;
            }
            currentChange = currentChange.link;
        }
        return result2;
    }

    @Nullable
    public static CharSequence linesDiff(@NotNull @NotNull CharSequence @NotNull [] lines1, @NotNull @NotNull CharSequence @NotNull [] lines2) throws FilesTooBigForDiffException {
        Change ch;
        if (lines1 == null) {
            Diff.$$$reportNull$$$0(23);
        }
        if (lines2 == null) {
            Diff.$$$reportNull$$$0(24);
        }
        if ((ch = Diff.buildChanges(lines1, lines2)) == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (ch != null) {
            int i;
            if (sb.length() != 0) {
                sb.append("====================").append("\n");
            }
            for (i = ch.line0; i < ch.line0 + ch.deleted; ++i) {
                sb.append('-').append(lines1[i]).append('\n');
            }
            for (i = ch.line1; i < ch.line1 + ch.inserted; ++i) {
                sb.append('+').append(lines2[i]).append('\n');
            }
            ch = ch.link;
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 1: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/diff/Diff";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array2";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ints1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ints2";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines1";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/diff/Diff";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "splitLines";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "trim";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildChanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "splitLines";
                break;
            }
            case 3: 
            case 22: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doBuildChanges";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStartShift";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getEndCut";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "translateLine";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "linesDiff";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Change {
        public Change link;
        public final int inserted;
        public final int deleted;
        public final int line0;
        public final int line1;

        public Change(int line0, int line1, int deleted, int inserted, @Nullable Change old) {
            this.line0 = line0;
            this.line1 = line1;
            this.inserted = inserted;
            this.deleted = deleted;
            this.link = old;
        }

        @NonNls
        public String toString() {
            return "change[inserted=" + this.inserted + ", deleted=" + this.deleted + ", line0=" + this.line0 + ", line1=" + this.line1 + "]";
        }

        public ArrayList<Change> toList() {
            ArrayList<Change> result2 = new ArrayList<Change>();
            Change current2 = this;
            while (current2 != null) {
                result2.add(current2);
                current2 = current2.link;
            }
            return result2;
        }
    }

    public static class ChangeBuilder
    implements LCSBuilder {
        private int myIndex1 = 0;
        private int myIndex2 = 0;
        private Change myFirstChange;
        private Change myLastChange;

        public ChangeBuilder(int startShift) {
            this.skip(startShift, startShift);
        }

        @Override
        public void addChange(int first2, int second2) {
            Change change = new Change(this.myIndex1, this.myIndex2, first2, second2, null);
            if (this.myLastChange != null) {
                this.myLastChange.link = change;
            } else {
                this.myFirstChange = change;
            }
            this.myLastChange = change;
            this.skip(first2, second2);
        }

        private void skip(int first2, int second2) {
            this.myIndex1 += first2;
            this.myIndex2 += second2;
        }

        @Override
        public void addEqual(int length) {
            this.skip(length, length);
        }

        public Change getFirstChange() {
            return this.myFirstChange;
        }
    }
}

