/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ObjectCacheBase;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Iterator;

public final class IntObjectCache<T>
extends ObjectCacheBase
implements Iterable<T> {
    private static final int DEFAULT_SIZE = 8192;
    public static final int MIN_SIZE = 4;
    private int myTop;
    private int myBack;
    private CacheEntry<T>[] myCache;
    private int[] myHashTable;
    private int myHashTableSize;
    private int myCount;
    private int myFirstFree;
    private DeletedPairsListener[] myListeners;
    private int myAttempts;
    private int myHits;

    public IntObjectCache() {
        this(8192);
    }

    public IntObjectCache(int cacheSize) {
        if (cacheSize < 4) {
            cacheSize = 4;
        }
        this.myBack = 0;
        this.myTop = 0;
        this.myCache = new CacheEntry[cacheSize + 1];
        for (int i = 0; i < this.myCache.length; ++i) {
            this.myCache[i] = new CacheEntry();
        }
        this.myHashTableSize = IntObjectCache.getAdjustedTableSize(cacheSize);
        this.myHashTable = new int[this.myHashTableSize];
        this.myAttempts = 0;
        this.myHits = 0;
        this.myFirstFree = 0;
        this.myCount = 0;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public boolean containsKey(int key) {
        return this.isCached(key);
    }

    public T get(int key) {
        return this.tryKey(key);
    }

    public T put(int key, T value) {
        T oldValue = this.tryKey(key);
        if (oldValue != null) {
            this.remove(key);
        }
        this.cacheObject(key, value);
        return oldValue;
    }

    public void remove(int key) {
        int index2 = this.searchForCacheEntry(key);
        if (index2 != 0) {
            this.removeEntry(index2);
            this.removeEntryFromHashTable(index2);
            this.myCache[index2].hash_next = this.myFirstFree;
            this.myFirstFree = index2;
            CacheEntry<T> cacheEntry = this.myCache[index2];
            int deletedKey = cacheEntry.key;
            Object deletedValue = cacheEntry.value;
            this.myCache[index2].value = null;
            this.fireListenersAboutDeletion(deletedKey, deletedValue);
        }
    }

    public void removeAll() {
        IntArrayList keys2 = new IntArrayList(this.count());
        int current2 = this.myTop;
        while (current2 > 0) {
            if (this.myCache[current2].value != null) {
                keys2.add(this.myCache[current2].key);
            }
            current2 = this.myCache[current2].next;
        }
        for (int i = 0; i < keys2.size(); ++i) {
            this.remove(keys2.getInt(i));
        }
    }

    public void cacheObject(int key, T x) {
        int deletedKey = 0;
        T deletedValue = null;
        int index2 = this.myFirstFree;
        if (this.myCount < this.myCache.length - 1) {
            if (index2 == 0) {
                index2 = this.myCount;
                ++index2;
            } else {
                this.myFirstFree = this.myCache[index2].hash_next;
            }
            if (this.myCount == 0) {
                this.myBack = index2;
            }
        } else {
            index2 = this.myBack;
            this.removeEntryFromHashTable(index2);
            CacheEntry<T> cacheEntry = this.myCache[index2];
            deletedKey = cacheEntry.key;
            deletedValue = cacheEntry.value;
            this.myBack = this.myCache[index2].prev;
            this.myCache[this.myCache[index2].prev].next = 0;
        }
        this.myCache[index2].key = key;
        this.myCache[index2].value = x;
        this.addEntry2HashTable(index2);
        this.add2Top(index2);
        if (deletedValue != null) {
            this.fireListenersAboutDeletion(deletedKey, deletedValue);
        }
    }

    public T tryKey(int key) {
        ++this.myAttempts;
        int index2 = this.searchForCacheEntry(key);
        if (index2 == 0) {
            return null;
        }
        ++this.myHits;
        CacheEntry<T> cacheEntry = this.myCache[index2];
        int top = this.myTop;
        if (index2 != top) {
            int prev = cacheEntry.prev;
            int next = cacheEntry.next;
            if (index2 == this.myBack) {
                this.myBack = prev;
            } else {
                this.myCache[next].prev = prev;
            }
            this.myCache[prev].next = next;
            cacheEntry.next = top;
            cacheEntry.prev = 0;
            this.myCache[top].prev = index2;
            this.myTop = index2;
        }
        return cacheEntry.value;
    }

    public boolean isCached(int key) {
        return this.searchForCacheEntry(key) != 0;
    }

    public int count() {
        return this.myCount;
    }

    public int size() {
        return this.myCache.length - 1;
    }

    public void resize(int newSize) {
        IntObjectCache newCache = new IntObjectCache(newSize);
        CacheEntry<T>[] cache2 = this.myCache;
        int back = this.myBack;
        while (back != 0) {
            CacheEntry<T> cacheEntry = cache2[back];
            newCache.cacheObject(cacheEntry.key, cacheEntry.value);
            back = cacheEntry.prev;
        }
        this.myTop = newCache.myTop;
        this.myBack = newCache.myBack;
        this.myCache = newCache.myCache;
        this.myHashTable = newCache.myHashTable;
        this.myHashTableSize = newCache.myHashTableSize;
        this.myCount = newCache.myCount;
        this.myFirstFree = newCache.myFirstFree;
    }

    public double hitRate() {
        return this.myAttempts > 0 ? (double)this.myHits / (double)this.myAttempts : 0.0;
    }

    private void add2Top(int index2) {
        this.myCache[index2].next = this.myTop;
        this.myCache[index2].prev = 0;
        this.myCache[this.myTop].prev = index2;
        this.myTop = index2;
    }

    private void removeEntry(int index2) {
        if (index2 == this.myBack) {
            this.myBack = this.myCache[index2].prev;
        } else {
            this.myCache[this.myCache[index2].next].prev = this.myCache[index2].prev;
        }
        if (index2 == this.myTop) {
            this.myTop = this.myCache[index2].next;
        } else {
            this.myCache[this.myCache[index2].prev].next = this.myCache[index2].next;
        }
    }

    private void addEntry2HashTable(int index2) {
        int hash_index = (this.myCache[index2].key & Integer.MAX_VALUE) % this.myHashTableSize;
        this.myCache[index2].hash_next = this.myHashTable[hash_index];
        this.myHashTable[hash_index] = index2;
        ++this.myCount;
    }

    private void removeEntryFromHashTable(int index2) {
        int hash_index = (this.myCache[index2].key & Integer.MAX_VALUE) % this.myHashTableSize;
        int current2 = this.myHashTable[hash_index];
        int previous = 0;
        while (current2 != 0) {
            int next = this.myCache[current2].hash_next;
            if (current2 == index2) {
                if (previous != 0) {
                    this.myCache[previous].hash_next = next;
                } else {
                    this.myHashTable[hash_index] = next;
                }
                --this.myCount;
                break;
            }
            previous = current2;
            current2 = next;
        }
    }

    private int searchForCacheEntry(int key) {
        this.myCache[0].key = key;
        int current2 = this.myHashTable[(key & Integer.MAX_VALUE) % this.myHashTableSize];
        while (true) {
            CacheEntry<T> cacheEntry = this.myCache[current2];
            if (key == cacheEntry.key) break;
            current2 = cacheEntry.hash_next;
        }
        return current2;
    }

    @Override
    public Iterator<T> iterator() {
        return new IntObjectCacheIterator(this);
    }

    public void addDeletedPairsListener(DeletedPairsListener<T> listener) {
        this.myListeners = this.myListeners == null ? new DeletedPairsListener[1] : Arrays.copyOf(this.myListeners, this.myListeners.length + 1);
        this.myListeners[this.myListeners.length - 1] = listener;
    }

    public void removeDeletedPairsListener(DeletedPairsListener<T> listener) {
        if (this.myListeners != null) {
            if (this.myListeners.length == 1) {
                this.myListeners = null;
            } else {
                DeletedPairsListener[] newListeners = new DeletedPairsListener[this.myListeners.length - 1];
                int i = 0;
                for (DeletedPairsListener myListener : this.myListeners) {
                    if (myListener == listener) continue;
                    newListeners[i++] = myListener;
                }
                this.myListeners = newListeners;
            }
        }
    }

    private void fireListenersAboutDeletion(int key, T value) {
        if (this.myListeners != null) {
            for (DeletedPairsListener myListener : this.myListeners) {
                myListener.objectRemoved(key, value);
            }
        }
    }

    protected static class CacheEntry<T> {
        public int key;
        public T value;
        public int prev;
        public int next;
        public int hash_next;

        protected CacheEntry() {
        }
    }

    protected class IntObjectCacheIterator
    implements Iterator<T> {
        private int myCurrentEntry = 0;

        public IntObjectCacheIterator(IntObjectCache cache2) {
            ((IntObjectCache)cache2).myCache[0].next = cache2.myTop;
        }

        @Override
        public boolean hasNext() {
            this.myCurrentEntry = ((IntObjectCache)IntObjectCache.this).myCache[this.myCurrentEntry].next;
            return this.myCurrentEntry != 0;
        }

        @Override
        public T next() {
            return ((IntObjectCache)IntObjectCache.this).myCache[this.myCurrentEntry].value;
        }

        @Override
        public void remove() {
            IntObjectCache.this.removeEntry(((IntObjectCache)IntObjectCache.this).myCache[this.myCurrentEntry].key);
        }
    }

    @FunctionalInterface
    public static interface DeletedPairsListener<T>
    extends EventListener {
        public void objectRemoved(int var1, T var2);
    }
}

