/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentBitSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.NotNull;

class ConcurrentBitSetImpl
implements ConcurrentBitSet {
    private volatile int[] array;
    private static final VarHandle ARRAY_ELEMENT = MethodHandles.arrayElementVarHandle(int[].class);
    private static final int ADDRESS_BITS_PER_WORD = 5;
    static final int BITS_PER_WORD = 32;

    ConcurrentBitSetImpl() {
        this(32);
    }

    ConcurrentBitSetImpl(int estimatedSize) {
        this.array = new int[Math.max(32, estimatedSize / 32)];
    }

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 5;
    }

    private static int wordMaskForIndex(int bitIndex) {
        return 1 << bitIndex;
    }

    @Override
    public boolean set(int bitIndex) {
        int mask = ConcurrentBitSetImpl.wordMaskForIndex(bitIndex);
        long prevWord = this.changeWord(bitIndex, word -> word | mask);
        return (prevWord & (long)mask) != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int changeWord(int bitIndex, @NotNull IntUnaryOperator changeWord) {
        if (changeWord == null) {
            ConcurrentBitSetImpl.$$$reportNull$$$0(0);
        }
        ConcurrentBitSetImpl.assertNonNegative(bitIndex);
        int i = ConcurrentBitSetImpl.wordIndex(bitIndex);
        ConcurrentBitSetImpl concurrentBitSetImpl = this;
        synchronized (concurrentBitSetImpl) {
            int oldWord;
            int[] newArray;
            int[] oldArray = this.array;
            if (i < oldArray.length) {
                newArray = oldArray;
                oldWord = ConcurrentBitSetImpl.arrayRead(oldArray, i);
            } else {
                oldArray = this.array;
                this.array = newArray = ArrayUtil.realloc(oldArray, Math.max(oldArray.length * 2, i + 1));
                oldWord = 0;
            }
            int newWord = changeWord.applyAsInt(oldWord);
            ARRAY_ELEMENT.setVolatile(newArray, i, newWord);
            return oldWord;
        }
    }

    private static int arrayRead(int[] oldArray, int i) {
        return ARRAY_ELEMENT.getVolatile(oldArray, i);
    }

    private static void assertNonNegative(int index2) {
        if (index2 < 0) {
            ConcurrentBitSetImpl.reportNegativeIndex(index2);
        }
    }

    private static void reportNegativeIndex(int fromIndex) {
        throw new IndexOutOfBoundsException("index < 0: " + fromIndex);
    }

    @Override
    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    @Override
    public boolean clear(int bitIndex) {
        int wordMaskForIndex = ConcurrentBitSetImpl.wordMaskForIndex(bitIndex);
        int prevWord = this.changeWord(bitIndex, word -> word & ~wordMaskForIndex);
        return (prevWord & wordMaskForIndex) != 0;
    }

    @Override
    public void clear() {
        this.array = new int[32];
    }

    @Override
    public boolean get(int bitIndex) {
        return (this.getWord(bitIndex) & ConcurrentBitSetImpl.wordMaskForIndex(bitIndex)) != 0;
    }

    int getWord(int bitIndex) {
        ConcurrentBitSetImpl.assertNonNegative(bitIndex);
        int arrayIndex = ConcurrentBitSetImpl.wordIndex(bitIndex);
        int[] array2 = this.array;
        return arrayIndex < array2.length ? ConcurrentBitSetImpl.arrayRead(array2, arrayIndex) : 0;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        ConcurrentBitSetImpl.assertNonNegative(fromIndex);
        int i = ConcurrentBitSetImpl.wordIndex(fromIndex);
        int result2 = -1;
        int[] array2 = this.array;
        if (i < array2.length) {
            int w = ConcurrentBitSetImpl.arrayRead(array2, i);
            int nextBitsInWord = w & -ConcurrentBitSetImpl.wordMaskForIndex(fromIndex);
            if (nextBitsInWord != 0) {
                int wordIndex = Integer.numberOfTrailingZeros(nextBitsInWord);
                result2 = i * 32 + wordIndex;
            } else {
                ++i;
                while (i < array2.length) {
                    w = ConcurrentBitSetImpl.arrayRead(array2, i);
                    if (w != 0) {
                        int wordIndex = Integer.numberOfTrailingZeros(w);
                        result2 = i * 32 + wordIndex;
                        break;
                    }
                    ++i;
                }
            }
        }
        return result2;
    }

    @Override
    public int nextClearBit(int fromIndex) {
        ConcurrentBitSetImpl.assertNonNegative(fromIndex);
        int i = ConcurrentBitSetImpl.wordIndex(fromIndex);
        int[] array2 = this.array;
        int result2 = array2.length * 32;
        if (i >= array2.length) {
            result2 = fromIndex;
        } else {
            int w = ~ConcurrentBitSetImpl.arrayRead(array2, i);
            int nextBitsInWord = w & -ConcurrentBitSetImpl.wordMaskForIndex(fromIndex);
            if (nextBitsInWord != 0) {
                int wordIndex = Integer.numberOfTrailingZeros(nextBitsInWord);
                result2 = i * 32 + wordIndex;
            } else {
                ++i;
                while (i < array2.length) {
                    w = ~ConcurrentBitSetImpl.arrayRead(array2, i);
                    if (w != 0) {
                        int wordIndex = Integer.numberOfTrailingZeros(w);
                        result2 = i * 32 + wordIndex;
                        break;
                    }
                    ++i;
                }
            }
        }
        return result2;
    }

    @Override
    public int size() {
        return this.array.length << 5;
    }

    @Override
    public int cardinality() {
        int sum = 0;
        for (int l : this.array) {
            sum += Integer.bitCount(l);
        }
        return sum;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        int i = this.nextSetBit(0);
        while (i >= 0) {
            int endOfRun = this.nextClearBit(i);
            if (endOfRun - i > 1) {
                if (b.length() != 1) {
                    b.append(", ");
                }
                b.append(i).append("...").append(endOfRun - 1);
                i = endOfRun;
            } else {
                do {
                    if (b.length() != 1) {
                        b.append(", ");
                    }
                    b.append(i);
                } while (++i < endOfRun);
            }
            i = this.nextSetBit(i + 1);
        }
        b.append('}');
        return b.toString();
    }

    public int @NotNull [] toIntArray() {
        int[] nArray = (int[])this.array.clone();
        if (nArray == null) {
            ConcurrentBitSetImpl.$$$reportNull$$$0(1);
        }
        return nArray;
    }

    public void writeTo(@NotNull File file2) throws IOException {
        if (file2 == null) {
            ConcurrentBitSetImpl.$$$reportNull$$$0(2);
        }
        try (DataOutputStream bitSetStorage = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));){
            int[] words;
            for (int word : words = this.toIntArray()) {
                bitSetStorage.writeInt(word);
            }
        }
    }

    @NotNull
    public static ConcurrentBitSet readFrom(@NotNull File file2) throws IOException {
        if (file2 == null) {
            ConcurrentBitSetImpl.$$$reportNull$$$0(3);
        }
        if (!file2.exists()) {
            ConcurrentBitSet concurrentBitSet = ConcurrentBitSet.create();
            if (concurrentBitSet == null) {
                ConcurrentBitSetImpl.$$$reportNull$$$0(4);
            }
            return concurrentBitSet;
        }
        DataInputStream bitSetStorage = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));
        long length = file2.length();
        int[] words = new int[(int)(length / 8L)];
        for (int i = 0; i < words.length; ++i) {
            words[i] = bitSetStorage.readInt();
        }
        ConcurrentBitSetImpl concurrentBitSetImpl = new ConcurrentBitSetImpl(words);
        ConcurrentBitSetImpl concurrentBitSetImpl2 = concurrentBitSetImpl;
        if (concurrentBitSetImpl2 == null) {
            ConcurrentBitSetImpl.$$$reportNull$$$0(5);
        }
        return concurrentBitSetImpl2;
        finally {
            bitSetStorage.close();
        }
    }

    private ConcurrentBitSetImpl(int @NotNull [] words) {
        if (words == null) {
            ConcurrentBitSetImpl.$$$reportNull$$$0(6);
        }
        this.array = words;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeWord";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ConcurrentBitSetImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ConcurrentBitSetImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toIntArray";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "changeWord";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readFrom";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 4, 5 -> new IllegalStateException(string2);
        };
    }
}

