/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.concurrency.ContextCallable;
import com.intellij.concurrency.ContextRunnable;
import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.CancellationCallable;
import com.intellij.openapi.progress.CancellationFutureTask;
import com.intellij.openapi.progress.CancellationRunnable;
import com.intellij.openapi.progress.PeriodicCancellationRunnable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.SchedulingWrapper;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class Propagation {
    @TestOnly
    static void runWithContextPropagationEnabled(@NotNull Runnable runnable) {
        if (runnable == null) {
            Propagation.$$$reportNull$$$0(0);
        }
        boolean propagateThreadContext = Holder.propagateThreadContext;
        Holder.propagateThreadContext = true;
        try {
            runnable.run();
        }
        finally {
            Holder.propagateThreadContext = propagateThreadContext;
        }
    }

    @TestOnly
    static void runWithCancellationPropagationEnabled(@NotNull Runnable runnable) {
        if (runnable == null) {
            Propagation.$$$reportNull$$$0(1);
        }
        boolean propagateThreadCancellation = Holder.propagateThreadCancellation;
        Holder.propagateThreadCancellation = true;
        try {
            runnable.run();
        }
        finally {
            Holder.propagateThreadCancellation = propagateThreadCancellation;
        }
    }

    private Propagation() {
    }

    static boolean isPropagateThreadContext() {
        return Holder.propagateThreadContext;
    }

    static boolean isPropagateCancellation() {
        return Holder.propagateThreadCancellation;
    }

    @NotNull
    static Runnable capturePropagationAndCancellationContext(@NotNull Runnable command2) {
        if (command2 == null) {
            Propagation.$$$reportNull$$$0(2);
        }
        if (Propagation.isPropagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableJob childJob = JobKt.Job(currentJob);
            command2 = new CancellationRunnable(childJob, command2);
        }
        return Propagation.capturePropagationContext(command2);
    }

    @NotNull
    public static Pair<Runnable, Condition<?>> capturePropagationAndCancellationContext(@NotNull Runnable command2, @NotNull Condition<?> expired) {
        if (command2 == null) {
            Propagation.$$$reportNull$$$0(3);
        }
        if (expired == null) {
            Propagation.$$$reportNull$$$0(4);
        }
        if (Propagation.isPropagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableJob childJob = JobKt.Job(currentJob);
            expired = Propagation.cancelIfExpired(expired, childJob);
            command2 = new CancellationRunnable(childJob, command2);
        }
        Pair<Runnable, Condition<?>> pair = Pair.create(Propagation.capturePropagationContext(command2), expired);
        if (pair == null) {
            Propagation.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @NotNull
    private static <T> Condition<T> cancelIfExpired(@NotNull Condition<? super T> expiredCondition, @NotNull Job childJob) {
        if (expiredCondition == null) {
            Propagation.$$$reportNull$$$0(6);
        }
        if (childJob == null) {
            Propagation.$$$reportNull$$$0(7);
        }
        Condition<Object> condition = t -> {
            boolean expired = expiredCondition.value(t);
            if (expired) {
                childJob.cancel(null);
                return true;
            }
            return childJob.isCancelled();
        };
        if (condition == null) {
            Propagation.$$$reportNull$$$0(8);
        }
        return condition;
    }

    @NotNull
    private static Runnable capturePropagationContext(@NotNull Runnable runnable) {
        if (runnable == null) {
            Propagation.$$$reportNull$$$0(9);
        }
        if (Propagation.isPropagateThreadContext()) {
            Runnable runnable2 = ThreadContext.captureThreadContext(runnable);
            if (runnable2 == null) {
                Propagation.$$$reportNull$$$0(10);
            }
            return runnable2;
        }
        Runnable runnable3 = runnable;
        if (runnable3 == null) {
            Propagation.$$$reportNull$$$0(11);
        }
        return runnable3;
    }

    @NotNull
    static <V> FutureTask<V> capturePropagationAndCancellationContext(@NotNull Callable<V> callable) {
        if (callable == null) {
            Propagation.$$$reportNull$$$0(12);
        }
        if (Propagation.isPropagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableDeferred<Job> childDeferred = CompletableDeferredKt.CompletableDeferred(currentJob);
            CancellationCallable<Job> cancellationCallable = new CancellationCallable<Job>(childDeferred, callable);
            return new CancellationFutureTask<Job>(childDeferred, Propagation.capturePropagationContext(cancellationCallable));
        }
        return new FutureTask<V>(Propagation.capturePropagationContext(callable));
    }

    @NotNull
    static <V> SchedulingWrapper.MyScheduledFutureTask<V> capturePropagationAndCancellationContext(@NotNull SchedulingWrapper wrapper, @NotNull Callable<V> callable, long ns) {
        if (wrapper == null) {
            Propagation.$$$reportNull$$$0(13);
        }
        if (callable == null) {
            Propagation.$$$reportNull$$$0(14);
        }
        if (Propagation.isPropagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableDeferred<Job> childDeferred = CompletableDeferredKt.CompletableDeferred(currentJob);
            CancellationCallable<Job> cancellationCallable = new CancellationCallable<Job>(childDeferred, callable);
            return new CancellationScheduledFutureTask<Job>(wrapper, childDeferred, Propagation.capturePropagationContext(cancellationCallable), ns);
        }
        SchedulingWrapper schedulingWrapper = wrapper;
        Objects.requireNonNull(schedulingWrapper);
        return new SchedulingWrapper.MyScheduledFutureTask<V>(schedulingWrapper, Propagation.capturePropagationContext(callable), ns);
    }

    @NotNull
    private static <V> Callable<V> capturePropagationContext(@NotNull Callable<V> callable) {
        if (callable == null) {
            Propagation.$$$reportNull$$$0(15);
        }
        if (Propagation.isPropagateThreadContext()) {
            return new ContextCallable<V>(false, callable);
        }
        Callable<V> callable2 = callable;
        if (callable2 == null) {
            Propagation.$$$reportNull$$$0(16);
        }
        return callable2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    static SchedulingWrapper.MyScheduledFutureTask<?> capturePropagationAndCancellationContext(@NotNull SchedulingWrapper wrapper, @NotNull Runnable runnable, long ns, long l) {
        void period;
        if (wrapper == null) {
            Propagation.$$$reportNull$$$0(17);
        }
        if (runnable == null) {
            Propagation.$$$reportNull$$$0(18);
        }
        if (Propagation.isPropagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableJob childJob = JobKt.Job(currentJob);
            PeriodicCancellationRunnable cancellationRunnable = new PeriodicCancellationRunnable(childJob, runnable);
            return new CancellationScheduledFutureTask(wrapper, childJob, Propagation.wrapWithPropagationContext(cancellationRunnable), ns, (long)period);
        }
        SchedulingWrapper schedulingWrapper = wrapper;
        Objects.requireNonNull(schedulingWrapper);
        return new SchedulingWrapper.MyScheduledFutureTask<Object>(schedulingWrapper, Propagation.wrapWithPropagationContext(runnable), null, ns, (long)period);
    }

    @NotNull
    private static Runnable wrapWithPropagationContext(@NotNull Runnable runnable) {
        if (runnable == null) {
            Propagation.$$$reportNull$$$0(19);
        }
        if (Propagation.isPropagateThreadContext()) {
            return new ContextRunnable(false, runnable);
        }
        Runnable runnable2 = runnable;
        if (runnable2 == null) {
            Propagation.$$$reportNull$$$0(20);
        }
        return runnable2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 16: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 16: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/Propagation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expiredCondition";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childJob";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/Propagation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "capturePropagationAndCancellationContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "cancelIfExpired";
                break;
            }
            case 10: 
            case 11: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "capturePropagationContext";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithPropagationContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runWithContextPropagationEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runWithCancellationPropagationEnabled";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "capturePropagationAndCancellationContext";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 16: 
            case 20: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cancelIfExpired";
                break;
            }
            case 9: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "capturePropagationContext";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithPropagationContext";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 16: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private static boolean propagateThreadContext = Registry.is("ide.propagate.context");
        private static boolean propagateThreadCancellation = Registry.is("ide.propagate.cancellation");

        private Holder() {
        }
    }

    private static final class CancellationScheduledFutureTask<V>
    extends SchedulingWrapper.MyScheduledFutureTask<V> {
        @NotNull
        private final Job myJob;

        CancellationScheduledFutureTask(@NotNull SchedulingWrapper self, @NotNull Job job, @NotNull Callable<V> callable, long ns) {
            if (self == null) {
                CancellationScheduledFutureTask.$$$reportNull$$$0(0);
            }
            if (job == null) {
                CancellationScheduledFutureTask.$$$reportNull$$$0(1);
            }
            if (callable == null) {
                CancellationScheduledFutureTask.$$$reportNull$$$0(2);
            }
            SchedulingWrapper schedulingWrapper = self;
            Objects.requireNonNull(schedulingWrapper);
            super(schedulingWrapper, callable, ns);
            this.myJob = job;
        }

        /*
         * WARNING - void declaration
         */
        CancellationScheduledFutureTask(@NotNull SchedulingWrapper self, @NotNull Job job, @NotNull Runnable r, long ns, long l) {
            void period;
            if (self == null) {
                CancellationScheduledFutureTask.$$$reportNull$$$0(3);
            }
            if (job == null) {
                CancellationScheduledFutureTask.$$$reportNull$$$0(4);
            }
            if (r == null) {
                CancellationScheduledFutureTask.$$$reportNull$$$0(5);
            }
            SchedulingWrapper schedulingWrapper = self;
            Objects.requireNonNull(schedulingWrapper);
            super(schedulingWrapper, r, null, ns, (long)period);
            this.myJob = job;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result2 = super.cancel(mayInterruptIfRunning);
            this.myJob.cancel(null);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "self";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "job";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "callable";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "r";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/concurrency/Propagation$CancellationScheduledFutureTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

