/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.FlippantFuture;
import java.awt.EventQueue;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

final class EdtExecutorServiceImpl
extends EdtExecutorService {
    static final EdtExecutorService INSTANCE = new EdtExecutorServiceImpl();

    private EdtExecutorServiceImpl() {
    }

    @Override
    public void execute(@NotNull Runnable command2) {
        Application application;
        if (command2 == null) {
            EdtExecutorServiceImpl.$$$reportNull$$$0(0);
        }
        this.execute(command2, (application = ApplicationManager.getApplication()) == null ? ModalityState.NON_MODAL : application.getAnyModalityState());
    }

    @Override
    public void execute(@NotNull Runnable command2, @NotNull ModalityState modalityState) {
        Application application;
        if (command2 == null) {
            EdtExecutorServiceImpl.$$$reportNull$$$0(1);
        }
        if (modalityState == null) {
            EdtExecutorServiceImpl.$$$reportNull$$$0(2);
        }
        this.execute(command2, modalityState, (application = ApplicationManager.getApplication()) == null ? Conditions.alwaysFalse() : application.getDisposed());
    }

    @Override
    public void execute(@NotNull Runnable command2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired) {
        Application application;
        if (command2 == null) {
            EdtExecutorServiceImpl.$$$reportNull$$$0(3);
        }
        if (modalityState == null) {
            EdtExecutorServiceImpl.$$$reportNull$$$0(4);
        }
        if (expired == null) {
            EdtExecutorServiceImpl.$$$reportNull$$$0(5);
        }
        if ((application = ApplicationManager.getApplication()) == null) {
            EventQueue.invokeLater(command2);
        } else {
            application.invokeLater(command2, modalityState, expired);
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return this.newTaskFor(Executors.callable(runnable, value));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        FutureTask<T> task = AppScheduledExecutorService.capturePropagationAndCancellationContext(callable);
        if (EdtExecutorServiceImpl.shouldManifestExceptionsImmediately()) {
            return new FlippantFuture<T>(task);
        }
        return task;
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable command2, @NotNull ModalityState modalityState) {
        if (command2 == null) {
            EdtExecutorServiceImpl.$$$reportNull$$$0(6);
        }
        if (modalityState == null) {
            EdtExecutorServiceImpl.$$$reportNull$$$0(7);
        }
        RunnableFuture<Object> future = this.newTaskFor(command2, null);
        this.execute(future, modalityState);
        RunnableFuture<Object> runnableFuture = future;
        if (runnableFuture == null) {
            EdtExecutorServiceImpl.$$$reportNull$$$0(8);
        }
        return runnableFuture;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task, @NotNull ModalityState modalityState) {
        if (task == null) {
            EdtExecutorServiceImpl.$$$reportNull$$$0(9);
        }
        if (modalityState == null) {
            EdtExecutorServiceImpl.$$$reportNull$$$0(10);
        }
        RunnableFuture<T> future = this.newTaskFor(task);
        this.execute(future, modalityState);
        RunnableFuture<T> runnableFuture = future;
        if (runnableFuture == null) {
            EdtExecutorServiceImpl.$$$reportNull$$$0(11);
        }
        return runnableFuture;
    }

    @Override
    public void shutdown() {
        AppScheduledExecutorService.notAllowedMethodCall();
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List<Runnable> list = AppScheduledExecutorService.notAllowedMethodCall();
        if (list == null) {
            EdtExecutorServiceImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            EdtExecutorServiceImpl.$$$reportNull$$$0(13);
        }
        AppScheduledExecutorService.notAllowedMethodCall();
        return false;
    }

    static boolean shouldManifestExceptionsImmediately() {
        return ApplicationManager.getApplication() != null && ApplicationManager.getApplication().isUnitTestMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/EdtExecutorServiceImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/EdtExecutorServiceImpl";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "submit";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "shutdownNow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "awaitTermination";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 11, 12 -> new IllegalStateException(string2);
        };
    }
}

