/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class SmartList<E>
extends AbstractList<E>
implements RandomAccess {
    private int mySize;
    private Object myElem;

    public SmartList() {
    }

    public SmartList(E element) {
        this.myElem = element;
        this.mySize = 1;
    }

    public SmartList(@NotNull Collection<? extends E> elements) {
        if (elements == null) {
            SmartList.$$$reportNull$$$0(0);
        }
        int size = elements.size();
        if (size == 1) {
            E element = elements instanceof List && elements instanceof RandomAccess ? ((List)elements).get(0) : elements.iterator().next();
            this.add(element);
        } else if (size > 0) {
            this.mySize = size;
            this.myElem = elements.toArray(new Object[size]);
        }
    }

    @SafeVarargs
    public SmartList(E ... elements) {
        if (elements == null) {
            SmartList.$$$reportNull$$$0(1);
        }
        int length = elements.length;
        switch (length) {
            case 0: {
                break;
            }
            case 1: {
                this.myElem = elements[0];
                this.mySize = 1;
                break;
            }
            default: {
                this.myElem = Arrays.copyOf(elements, length);
                this.mySize = length;
            }
        }
    }

    @Override
    public E get(int index2) {
        int size = this.mySize;
        SmartList.checkOutOfBounds(index2, size, false);
        if (size == 1) {
            return this.asElement();
        }
        return this.asArray()[index2];
    }

    private static void checkOutOfBounds(int index2, int size, boolean inclusive) {
        if (index2 < 0 || (inclusive ? index2 > size : index2 >= size)) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + size);
        }
    }

    @Override
    public boolean add(E e) {
        int size = this.mySize;
        switch (size) {
            case 0: {
                this.myElem = e;
                break;
            }
            case 1: {
                this.myElem = new Object[]{this.myElem, e};
                break;
            }
            default: {
                E[] array2 = this.resizeIfNecessary(size);
                array2[size] = e;
            }
        }
        ++this.mySize;
        ++this.modCount;
        return true;
    }

    private E @NotNull [] resizeIfNecessary(int size) {
        E[] array2 = this.asArray();
        int oldCapacity = array2.length;
        if (size >= oldCapacity) {
            int newCapacity = Math.max(oldCapacity * 3 / 2 + 1, size + 1);
            array2 = ArrayUtil.realloc(array2, newCapacity, Object[]::new);
            this.myElem = array2;
        }
        if (array2 == null) {
            SmartList.$$$reportNull$$$0(2);
        }
        return array2;
    }

    @Override
    public void add(int index2, E e) {
        int size = this.mySize;
        SmartList.checkOutOfBounds(index2, size, true);
        switch (size) {
            case 0: {
                this.myElem = e;
                break;
            }
            case 1: {
                Object[] objectArray;
                if (index2 == 0) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = e;
                    objectArray = objectArray2;
                    objectArray2[1] = this.myElem;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = this.myElem;
                    objectArray = objectArray3;
                    objectArray3[1] = e;
                }
                this.myElem = objectArray;
                break;
            }
            default: {
                E[] array2 = this.resizeIfNecessary(size);
                System.arraycopy(array2, index2, array2, index2 + 1, size - index2);
                array2[index2] = e;
            }
        }
        ++this.mySize;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public void clear() {
        this.myElem = null;
        this.mySize = 0;
        ++this.modCount;
    }

    @Override
    public E set(int index2, E element) {
        E oldValue;
        int size = this.mySize;
        SmartList.checkOutOfBounds(index2, size, false);
        if (size == 1) {
            oldValue = this.asElement();
            this.myElem = element;
        } else {
            E[] array2 = this.asArray();
            oldValue = array2[index2];
            array2[index2] = element;
        }
        return oldValue;
    }

    private E asElement() {
        return (E)this.myElem;
    }

    private E[] asArray() {
        return (Object[])this.myElem;
    }

    @Override
    public E remove(int index2) {
        E oldValue;
        int size = this.mySize;
        SmartList.checkOutOfBounds(index2, size, false);
        switch (size) {
            case 0: 
            case 1: {
                oldValue = this.asElement();
                this.myElem = null;
                break;
            }
            case 2: {
                E[] array2 = this.asArray();
                oldValue = array2[index2];
                this.myElem = array2[1 - index2];
                break;
            }
            default: {
                E[] array3 = this.asArray();
                oldValue = array3[index2];
                int numMoved = size - index2 - 1;
                if (numMoved > 0) {
                    System.arraycopy(array3, index2 + 1, array3, index2, numMoved);
                }
                array3[size - 1] = null;
            }
        }
        --this.mySize;
        ++this.modCount;
        return oldValue;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        Iterator<Object> iterator = this.mySize == 0 ? Collections.emptyIterator() : super.iterator();
        if (iterator == null) {
            SmartList.$$$reportNull$$$0(3);
        }
        return iterator;
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        if (this.mySize >= 2) {
            Arrays.sort(this.asArray(), 0, this.mySize, comparator);
        }
    }

    public int getModificationCount() {
        return this.modCount;
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] a) {
        if (a == null) {
            SmartList.$$$reportNull$$$0(4);
        }
        int aLength = a.length;
        int size = this.mySize;
        switch (size) {
            case 0: {
                break;
            }
            case 1: {
                E t = this.asElement();
                if (aLength == 0) {
                    T[] r = ArrayUtil.newArray(ArrayUtil.getComponentType(a), 1);
                    r[0] = t;
                    if (r == null) {
                        SmartList.$$$reportNull$$$0(5);
                    }
                    return r;
                }
                a[0] = t;
                break;
            }
            default: {
                if (aLength < size) {
                    T[] TArray = Arrays.copyOf(this.asArray(), size, a.getClass());
                    if (TArray == null) {
                        SmartList.$$$reportNull$$$0(6);
                    }
                    return TArray;
                }
                System.arraycopy(this.asArray(), 0, a, 0, size);
            }
        }
        if (aLength > size) {
            a[size] = null;
        }
        if (a == null) {
            SmartList.$$$reportNull$$$0(7);
        }
        return a;
    }

    public void trimToSize() {
        int size = this.mySize;
        if (size < 2) {
            return;
        }
        E[] array2 = this.asArray();
        if (size < array2.length) {
            ++this.modCount;
            this.myElem = Arrays.copyOf(array2, size);
        }
    }

    @Override
    public int indexOf(Object o) {
        switch (this.mySize) {
            case 0: {
                return -1;
            }
            case 1: {
                return Objects.equals(o, this.myElem) ? 0 : -1;
            }
        }
        return ArrayUtilRt.indexOf(this.asArray(), o, 0, this.mySize);
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SmartList) {
            return this.equalsWithSmartList((SmartList)o);
        }
        if (o instanceof ArrayList) {
            return this.equalsWithArrayList((ArrayList)o);
        }
        return super.equals(o);
    }

    private boolean equalsWithSmartList(@NotNull SmartList<?> that) {
        int size;
        if (that == null) {
            SmartList.$$$reportNull$$$0(8);
        }
        if ((size = this.mySize) != that.mySize) {
            return false;
        }
        switch (size) {
            case 0: {
                return true;
            }
            case 1: {
                return Objects.equals(this.myElem, that.myElem);
            }
        }
        return this.compareOneByOne(size, that);
    }

    private boolean equalsWithArrayList(@NotNull ArrayList<?> that) {
        int size;
        if (that == null) {
            SmartList.$$$reportNull$$$0(9);
        }
        if ((size = this.mySize) != that.size()) {
            return false;
        }
        switch (size) {
            case 0: {
                return true;
            }
            case 1: {
                return Objects.equals(this.myElem, that.get(0));
            }
        }
        return this.compareOneByOne(size, that);
    }

    private boolean compareOneByOne(int size, @NotNull List<?> that) {
        if (that == null) {
            SmartList.$$$reportNull$$$0(10);
        }
        E[] array2 = this.asArray();
        for (int i = 0; i < size; ++i) {
            E o1 = array2[i];
            Object o2 = that.get(i);
            if (Objects.equals(o1, o2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forEach(@NotNull Consumer<? super E> action2) {
        if (action2 == null) {
            SmartList.$$$reportNull$$$0(11);
        }
        int size = this.mySize;
        switch (size) {
            case 0: {
                break;
            }
            case 1: {
                action2.accept(this.asElement());
                break;
            }
            default: {
                E[] array2 = this.asArray();
                for (int i = 0; i < size; ++i) {
                    action2.accept(array2[i]);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/SmartList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/SmartList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resizeIfNecessary";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "equalsWithSmartList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "equalsWithArrayList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "compareOneByOne";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

