/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeGenerator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTreeGenerator
implements TreeGenerator {
    private static final Logger LOG = Logger.getInstance(JavaTreeGenerator.class);
    private static final JavaParserUtil.ParserWrapper MOD_LIST = builder -> JavaParser.INSTANCE.getDeclarationParser().parseModifierList(builder);
    static final Key<PsiClass> REFERENCED_CLASS_KEY = Key.create("REFERENCED_CLASS_KEY");
    static final Key<PsiMember> REFERENCED_MEMBER_KEY = Key.create("REFERENCED_MEMBER_KEY");

    @Override
    @Nullable
    public TreeElement generateTreeFor(@NotNull PsiElement original, @NotNull CharTable table, @NotNull PsiManager manager) {
        if (original == null) {
            JavaTreeGenerator.$$$reportNull$$$0(0);
        }
        if (table == null) {
            JavaTreeGenerator.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            JavaTreeGenerator.$$$reportNull$$$0(2);
        }
        if (original instanceof PsiJavaToken) {
            String text = original.getText();
            return JavaTreeGenerator.createLeafFromText(text, table, manager, original, ((PsiJavaToken)original).getTokenType());
        }
        if (original instanceof PsiModifierList) {
            String text = original.getText();
            assert (text != null) : "Text is null for " + original + "; " + original.getClass();
            LanguageLevel level = PsiUtil.getLanguageLevel(original);
            DummyHolder holder = DummyHolderFactory.createHolder(original.getManager(), new JavaDummyElement(text, MOD_LIST, level), null);
            TreeElement modifierListElement = holder.getTreeElement().getFirstChildNode();
            if (modifierListElement == null) {
                throw new AssertionError((Object)("No modifier list for \"" + text + '\"'));
            }
            return JavaTreeGenerator.markGeneratedIfNeeded(original, modifierListElement);
        }
        if (original instanceof PsiReferenceExpression) {
            TreeElement element = JavaTreeGenerator.createReferenceExpression(original.getProject(), original.getText(), original);
            PsiElement refElement = ((PsiJavaCodeReferenceElement)original).resolve();
            if (refElement instanceof PsiClass) {
                element.putCopyableUserData(REFERENCED_CLASS_KEY, (PsiClass)refElement);
            }
            return element;
        }
        if (original instanceof PsiJavaCodeReferenceElement) {
            boolean generated;
            PsiElement refElement = ((PsiJavaCodeReferenceElement)original).resolve();
            boolean bl = generated = refElement != null && CodeEditUtil.isNodeGenerated(refElement.getNode());
            if (refElement instanceof PsiClass) {
                if (refElement instanceof PsiAnonymousClass) {
                    PsiJavaCodeReferenceElement ref = ((PsiAnonymousClass)refElement).getBaseClassReference();
                    original = ref;
                    refElement = ref.resolve();
                }
                boolean isFQ = false;
                if (original instanceof PsiJavaCodeReferenceElementImpl) {
                    PsiJavaCodeReferenceElementImpl.Kind kind = ((PsiJavaCodeReferenceElementImpl)original).getKindEnum(original.getContainingFile());
                    switch (kind) {
                        case CLASS_OR_PACKAGE_NAME_KIND: 
                        case CLASS_NAME_KIND: 
                        case CLASS_IN_QUALIFIED_NEW_KIND: {
                            isFQ = false;
                            break;
                        }
                        case CLASS_FQ_NAME_KIND: 
                        case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                            isFQ = true;
                            break;
                        }
                        default: {
                            LOG.assertTrue(false);
                        }
                    }
                }
                String text = isFQ ? ((PsiClass)refElement).getQualifiedName() : original.getText();
                TreeElement element = JavaTreeGenerator.createReference(original.getProject(), text, generated);
                element.putCopyableUserData(REFERENCED_CLASS_KEY, (PsiClass)refElement);
                return element;
            }
            return JavaTreeGenerator.createReference(original.getProject(), original.getText(), generated);
        }
        if (original instanceof PsiCompiledElement) {
            PsiElement sourceVersion = original.getNavigationElement();
            if (sourceVersion != original) {
                return ChangeUtil.generateTreeElement(sourceVersion, table, manager);
            }
            PsiElement mirror = ((PsiCompiledElement)original).getMirror();
            return ChangeUtil.generateTreeElement(mirror, table, manager);
        }
        if (original instanceof PsiTypeElement) {
            PsiTypeElement typeElement = (PsiTypeElement)original;
            PsiType type = typeElement.getType();
            if (type instanceof PsiIntersectionType) {
                type = ((PsiIntersectionType)type).getRepresentative();
            } else if (type instanceof PsiMethodReferenceType || type instanceof PsiLambdaExpressionType) {
                type = PsiType.getJavaLangObject(manager, GlobalSearchScope.projectScope(manager.getProject()));
            }
            String text = type.getCanonicalText(true);
            PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(original.getProject()).getParserFacade();
            PsiTypeElement element = parserFacade.createTypeElementFromText(text, original);
            TreeElement result2 = (TreeElement)element.getNode();
            JavaTreeGenerator.markGeneratedIfNeeded(original, result2);
            JavaTreeGenerator.encodeInfoInTypeElement(result2, type);
            return result2;
        }
        return null;
    }

    private static LeafElement createLeafFromText(String text, CharTable table, PsiManager manager, PsiElement original, IElementType type) {
        return Factory.createSingleLeafElement(type, (CharSequence)text, 0, text.length(), table, manager, CodeEditUtil.isNodeGenerated(original.getNode()));
    }

    private static TreeElement markGeneratedIfNeeded(@NotNull PsiElement original, @NotNull TreeElement copy2) {
        if (original == null) {
            JavaTreeGenerator.$$$reportNull$$$0(3);
        }
        if (copy2 == null) {
            JavaTreeGenerator.$$$reportNull$$$0(4);
        }
        if (CodeEditUtil.isNodeGenerated(original.getNode())) {
            copy2.acceptTree(new GeneratedMarkerVisitor());
        }
        return copy2;
    }

    private static TreeElement createReference(Project project, String text, boolean mark) {
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(project).getParserFacade();
        TreeElement element = (TreeElement)parserFacade.createReferenceFromText(text, null).getNode();
        if (mark) {
            element.acceptTree(new GeneratedMarkerVisitor());
        }
        return element;
    }

    private static TreeElement createReferenceExpression(Project project, String text, PsiElement context2) {
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(project).getParserFacade();
        PsiExpression expression = parserFacade.createExpressionFromText(text, context2);
        return (TreeElement)expression.getNode();
    }

    private static void encodeInfoInTypeElement(ASTNode typeElement, PsiType type) {
        if (type instanceof PsiPrimitiveType) {
            return;
        }
        LOG.assertTrue(typeElement.getElementType() == JavaElementType.TYPE);
        if (type instanceof PsiArrayType) {
            ASTNode firstChild = typeElement.getFirstChildNode();
            LOG.assertTrue(firstChild.getElementType() == JavaElementType.TYPE);
            JavaTreeGenerator.encodeInfoInTypeElement(firstChild, type.getDeepComponentType());
        } else if (type instanceof PsiWildcardType) {
            PsiType bound = ((PsiWildcardType)type).getBound();
            if (bound == null) {
                return;
            }
            ASTNode lastChild = typeElement.getLastChildNode();
            if (lastChild.getElementType() != JavaElementType.TYPE) {
                return;
            }
            JavaTreeGenerator.encodeInfoInTypeElement(lastChild, bound);
        } else if (type instanceof PsiCapturedWildcardType) {
            PsiType bound = ((PsiCapturedWildcardType)type).getWildcard().getBound();
            if (bound == null) {
                return;
            }
            ASTNode lastChild = typeElement.getLastChildNode();
            if (lastChild.getElementType() != JavaElementType.TYPE) {
                return;
            }
            JavaTreeGenerator.encodeInfoInTypeElement(lastChild, bound);
        } else if (type instanceof PsiIntersectionType) {
            JavaTreeGenerator.encodeInfoInTypeElement(typeElement, ((PsiIntersectionType)type).getRepresentative());
        } else if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass referencedClass = resolveResult.getElement();
            if (referencedClass == null) {
                return;
            }
            if (referencedClass instanceof PsiAnonymousClass) {
                JavaTreeGenerator.encodeInfoInTypeElement(typeElement, ((PsiAnonymousClass)referencedClass).getBaseClassType());
            } else {
                ASTNode reference = typeElement.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
                if (reference instanceof CompositeElement) {
                    JavaTreeGenerator.encodeClassTypeInfoInReference((CompositeElement)reference, resolveResult.getElement(), resolveResult.getSubstitutor());
                }
            }
        }
    }

    private static void encodeClassTypeInfoInReference(@NotNull CompositeElement reference, PsiClass referencedClass, PsiSubstitutor substitutor) {
        if (reference == null) {
            JavaTreeGenerator.$$$reportNull$$$0(5);
        }
        reference.putCopyableUserData(REFERENCED_CLASS_KEY, referencedClass);
        PsiTypeParameter[] typeParameters = referencedClass.getTypeParameters();
        if (typeParameters.length == 0) {
            return;
        }
        ASTNode referenceParameterList = reference.findChildByRole(246);
        int index2 = 0;
        for (ASTNode child = referenceParameterList.getFirstChildNode(); child != null && index2 < typeParameters.length; child = child.getTreeNext()) {
            if (child.getElementType() != JavaElementType.TYPE) continue;
            PsiType substitutedType = substitutor.substitute(typeParameters[index2]);
            if (substitutedType != null) {
                JavaTreeGenerator.encodeInfoInTypeElement(child, substitutedType);
            }
            ++index2;
        }
        ASTNode qualifier = reference.findChildByRole(54);
        if (qualifier != null) {
            if (referencedClass.hasModifierProperty("static")) {
                return;
            }
            PsiClass outerClass = referencedClass.getContainingClass();
            if (outerClass != null) {
                JavaTreeGenerator.encodeClassTypeInfoInReference((CompositeElement)qualifier, outerClass, substitutor);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/JavaTreeGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateTreeFor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "markGeneratedIfNeeded";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "encodeClassTypeInfoInReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

