/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.impl.PsiElementFactoryImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiAnnotationStubImpl
extends StubBase<PsiAnnotation>
implements PsiAnnotationStub {
    private static final Logger LOG = Logger.getInstance(PsiAnnotationStubImpl.class);
    private final String myText;
    private SoftReference<PsiAnnotation> myParsedFromRepository;

    public PsiAnnotationStubImpl(StubElement<?> parent, @NotNull String text) {
        if (text == null) {
            PsiAnnotationStubImpl.$$$reportNull$$$0(0);
        }
        super(parent, JavaStubElementTypes.ANNOTATION);
        CharSequence interned = CharTableImpl.getStaticInterned(text);
        this.myText = interned == null ? text : interned.toString();
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public PsiAnnotation getPsiElement() {
        PsiAnnotation annotation = SoftReference.dereference(this.myParsedFromRepository);
        if (annotation != null) {
            return annotation;
        }
        String text = this.getText();
        try {
            PsiJavaParserFacade facade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
            annotation = facade instanceof PsiElementFactoryImpl ? ((PsiElementFactoryImpl)facade).createAnnotationFromText(text, (PsiElement)this.getPsi(), false) : facade.createAnnotationFromText(text, (PsiElement)this.getPsi());
            ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
            this.myParsedFromRepository = new SoftReference<PsiAnnotation>(annotation);
            return annotation;
        }
        catch (IncorrectOperationException e) {
            LOG.error("Bad annotation in " + this.fileName(), e);
            return null;
        }
    }

    private String fileName() {
        StubElement<PsiAnnotation> stub = this;
        while ((stub = stub.getParentStub()) != null) {
            PsiAnnotation psi;
            if (!(stub instanceof PsiFileStub) || !((psi = stub.getPsi()) instanceof PsiFile)) continue;
            VirtualFile file2 = ((PsiFile)((Object)psi)).getVirtualFile();
            return file2 != null ? file2.getUrl() : ((PsiFile)((Object)psi)).getName();
        }
        return "<unknown file>";
    }

    @Override
    public String toString() {
        return "PsiAnnotationStub[" + this.myText + ']';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/java/stubs/impl/PsiAnnotationStubImpl", "<init>"));
    }
}

