/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Comparing;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Trinity<A, B, C> {
    public final A first;
    public final B second;
    public final C third;

    public Trinity(A first2, B second2, C third) {
        this.first = first2;
        this.second = second2;
        this.third = third;
    }

    public final A getFirst() {
        return this.first;
    }

    public final B getSecond() {
        return this.second;
    }

    public final C getThird() {
        return this.third;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <A, B, C> Trinity<A, B, C> create(A first2, B second2, C third) {
        return new Trinity<A, B, C>(first2, second2, third);
    }

    public static <T> T getFirst(@Nullable Trinity<T, ?, ?> pair) {
        return pair != null ? (T)pair.first : null;
    }

    public static <T> T getSecond(@Nullable Trinity<?, T, ?> pair) {
        return pair != null ? (T)pair.second : null;
    }

    public static <T> T getThird(@Nullable Trinity<?, ?, T> pair) {
        return pair != null ? (T)pair.third : null;
    }

    public final boolean equals(Object o) {
        return o instanceof Trinity && Comparing.equal(this.first, ((Trinity)o).first) && Comparing.equal(this.second, ((Trinity)o).second) && Comparing.equal(this.third, ((Trinity)o).third);
    }

    public final int hashCode() {
        int hashCode = 0;
        if (this.first != null) {
            hashCode += Trinity.hashCode(this.first);
        }
        if (this.second != null) {
            hashCode += Trinity.hashCode(this.second);
        }
        if (this.third != null) {
            hashCode += Trinity.hashCode(this.third);
        }
        return hashCode;
    }

    private static int hashCode(Object o) {
        return o instanceof Object[] ? Arrays.hashCode((Object[])o) : o.hashCode();
    }

    public String toString() {
        return "<" + this.first + "," + this.second + "," + this.third + ">";
    }
}

