/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class ProjectLocator {
    private static ProjectLocator ourInstance = CachedSingletonsRegistry.markCachedField(ProjectLocator.class);
    private static final ThreadLocal<Map<VirtualFile, Project>> ourPreferredProjects = ThreadLocal.withInitial(() -> new HashMap());

    public static ProjectLocator getInstance() {
        ProjectLocator result2 = ourInstance;
        if (result2 == null) {
            ourInstance = result2 = ApplicationManager.getApplication().getService(ProjectLocator.class);
        }
        return result2;
    }

    @Nullable
    public abstract Project guessProjectForFile(@NotNull VirtualFile var1);

    @NotNull
    public abstract Collection<Project> getProjectsForFile(@NotNull VirtualFile var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T computeWithPreferredProject(@NotNull VirtualFile file2, @NotNull Project preferredProject, @NotNull ThrowableComputable<T, E> runnable) throws E {
        if (file2 == null) {
            ProjectLocator.$$$reportNull$$$0(0);
        }
        if (preferredProject == null) {
            ProjectLocator.$$$reportNull$$$0(1);
        }
        if (runnable == null) {
            ProjectLocator.$$$reportNull$$$0(2);
        }
        Map<VirtualFile, Project> local = ourPreferredProjects.get();
        Project prev = local.put(file2, preferredProject);
        try {
            T t = runnable.compute();
            return t;
        }
        finally {
            if (prev == null) {
                local.remove(file2);
            } else {
                local.put(file2, prev);
            }
        }
    }

    @Nullable
    static Project getPreferredProject(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectLocator.$$$reportNull$$$0(3);
        }
        return ourPreferredProjects.get().get(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredProject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/project/ProjectLocator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeWithPreferredProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreferredProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

