/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.CurrentJobCancellationException;
import com.intellij.openapi.progress.IndicatorCancellationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExceptionsKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a'\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\b0\nH\u0007\u00a2\u0006\u0002\u0010\u000b\u001a>\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\u0005\u001a\u00020\u00062!\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u0002H\b0\nH\u0000\u00a2\u0006\u0002\u0010\u000f\u001a'\u0010\u0010\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\b0\nH\u0000\u00a2\u0006\u0002\u0010\u000b\u001a/\u0010\u0011\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\b0\nH\u0002\u00a2\u0006\u0002\u0010\u0014\u001a)\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0004\u001a\u00020\u00172\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0007\u00a2\u0006\u0002\u0010\u0019\u001a'\u0010\u001a\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018\u00a2\u0006\u0002\u0010\u001b\u001a)\u0010\u001c\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0007\u00a2\u0006\u0002\u0010\u001b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "cancelWithIndicator", "Lkotlinx/coroutines/Job;", "job", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "ensureCurrentJob", "T", "action", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lkotlin/ParameterName;", "name", "currentJob", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "ensureCurrentJobAllowingOrphan", "ensureCurrentJobInner", "allowOrphan", "", "(ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "executeWithJobAndCompleteIt", "X", "Lkotlinx/coroutines/CompletableJob;", "Lkotlin/Function0;", "(Lkotlinx/coroutines/CompletableJob;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withCurrentJob", "(Lkotlinx/coroutines/Job;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withJob", "intellij.platform.core"})
@ApiStatus.Internal
public final class CancellationKt {
    @NotNull
    private static final Logger LOG;

    public static final <X> X withCurrentJob(@NotNull Job job, @NotNull Function0<? extends X> action2) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return (X)Cancellation.withCurrentJob(job, () -> CancellationKt.withCurrentJob$lambda$0(action2));
    }

    @Deprecated(message="Renamed to `withCurrentJob`", replaceWith=@ReplaceWith(expression="withCurrentJob(job, action)", imports={"com.intellij.openapi.progress.withCurrentJob"}))
    public static final <X> X withJob(@NotNull Job job, @NotNull Function0<? extends X> action2) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return CancellationKt.withCurrentJob(job, action2);
    }

    @ApiStatus.Internal
    public static final <T> T ensureCurrentJob(@NotNull Function1<? super Job, ? extends T> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return CancellationKt.ensureCurrentJobInner(false, action2);
    }

    public static final <T> T ensureCurrentJobAllowingOrphan(@NotNull Function1<? super Job, ? extends T> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return CancellationKt.ensureCurrentJobInner(true, action2);
    }

    private static final <T> T ensureCurrentJobInner(boolean allowOrphan, Function1<? super Job, ? extends T> action2) {
        ProgressIndicator indicator = ProgressManager.getGlobalProgressIndicator();
        if (indicator != null) {
            return CancellationKt.ensureCurrentJob(indicator, action2);
        }
        Job currentJob = Cancellation.currentJob();
        if (currentJob != null) {
            return (T)action2.invoke((Object)currentJob);
        }
        if (!allowOrphan) {
            LOG.error("There is no ProgressIndicator or Job in this thread, the current job is not cancellable.");
        }
        CompletableJob orphanJob = JobKt.Job(null);
        return (T)CancellationKt.executeWithJobAndCompleteIt(orphanJob, (Function0)new Function0<T>(action2, orphanJob){
            final /* synthetic */ Function1<Job, T> $action;
            final /* synthetic */ CompletableJob $orphanJob;
            {
                this.$action = $action;
                this.$orphanJob = $orphanJob;
                super(0);
            }

            public final T invoke() {
                return (T)this.$action.invoke((Object)this.$orphanJob);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T ensureCurrentJob(@NotNull ProgressIndicator indicator, @NotNull Function1<? super Job, ? extends T> action2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        CompletableJob currentJob = JobKt.Job(null);
        Job indicatorWatcher = CancellationKt.cancelWithIndicator(currentJob, indicator);
        ModalityState modalityState = ProgressManager.getInstance().getCurrentProgressModality();
        if (modalityState == null || (modalityState = ModalityKt.asContextElement(modalityState)) == null) {
            modalityState = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
        }
        ModalityState progressModality = modalityState;
        try {
            object = ProgressManager.getInstance().silenceGlobalIndicator(() -> CancellationKt.ensureCurrentJob$lambda$1(currentJob, (CoroutineContext)progressModality, action2));
        }
        catch (IndicatorCancellationException ce) {
            throw new ProcessCanceledException(ce);
        }
        catch (CurrentJobCancellationException ce) {
            throw new ProcessCanceledException(ce);
        }
        finally {
            Job.DefaultImpls.cancel$default(indicatorWatcher, null, 1, null);
        }
        return (T)object;
    }

    private static final Job cancelWithIndicator(Job job, ProgressIndicator indicator) {
        return BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO()), (CoroutineContext)new CoroutineName("indicator watcher"), null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(indicator, job, null){
            int label;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ Job $job;
            {
                this.$indicator = $indicator;
                this.$job = $job;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                        // 3 sources

                        while (!this.$indicator.isCanceled()) {
                            this.label = 1;
                            v0 = DelayKt.delay(10L, (Continuation<? super Unit>)((Continuation)this));
                            if (v0 != var3_2) continue;
                            return var3_2;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl5
                    }
                }
                try {
                    this.$indicator.checkCanceled();
                    var2_3 = "A cancelled indicator must throw PCE";
                    throw new IllegalStateException(var2_3.toString());
                }
                catch (ProcessCanceledException pce) {
                    this.$job.cancel(new IndicatorCancellationException(pce));
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    @ApiStatus.Internal
    public static final <X> X executeWithJobAndCompleteIt(@NotNull CompletableJob job, @NotNull Function0<? extends X> action2) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        try {
            X result2 = CancellationKt.withCurrentJob(job, action2);
            job.complete();
            return result2;
        }
        catch (CancellationException ce) {
            job.cancel(ce);
            throw ce;
        }
        catch (Throwable e) {
            job.cancel(ExceptionsKt.CancellationException(null, e));
            throw e;
        }
    }

    private static final Object withCurrentJob$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke();
    }

    private static final Object ensureCurrentJob$lambda$1(CompletableJob $currentJob, CoroutineContext $progressModality, Function1 $action) {
        Intrinsics.checkNotNullParameter((Object)$currentJob, (String)"$currentJob");
        Intrinsics.checkNotNullParameter((Object)$progressModality, (String)"$progressModality");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        return CancellationKt.executeWithJobAndCompleteIt($currentJob, (Function0)new Function0<T>($progressModality, $action, $currentJob){
            final /* synthetic */ CoroutineContext $progressModality;
            final /* synthetic */ Function1<Job, T> $action;
            final /* synthetic */ CompletableJob $currentJob;
            {
                this.$progressModality = $progressModality;
                this.$action = $action;
                this.$currentJob = $currentJob;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T invoke() {
                Object object;
                AutoCloseable autoCloseable = ThreadContext.withThreadContext(this.$progressModality);
                Function1<Job, T> function1 = this.$action;
                CompletableJob completableJob = this.$currentJob;
                Throwable throwable = null;
                try {
                    AccessToken it = (AccessToken)autoCloseable;
                    boolean bl = false;
                    object = function1.invoke((Object)completableJob);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                return (T)object;
            }
        });
    }

    static {
        Logger logger = Logger.getInstance("#com.intellij.openapi.progress");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"#com.intellij.openapi.progress\")");
        LOG = logger;
    }
}

