/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u0000 \u0017*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0017B\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\bJ\u0013\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J4\u0010\u0010\u001a\u00028\u00002!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00028\u00000\u0012H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/components/SerializablePersistentStateComponent;", "T", "", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "state", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "timestamp", "", "getState", "()Ljava/lang/Object;", "getStateModificationCount", "loadState", "", "setState", "newState", "updateState", "updateFunction", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "currentState", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "intellij.platform.projectModel"})
@ApiStatus.Experimental
public abstract class SerializablePersistentStateComponent<T>
implements PersistentStateComponentWithModificationTracker<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private T state;
    private long timestamp;
    @NotNull
    private static final VarHandle STATE_HANDLE;
    @NotNull
    private static final VarHandle TIMESTAMP_HANDLE;

    protected SerializablePersistentStateComponent(@NotNull T state) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        this.state = state;
    }

    @Override
    @NotNull
    public final T getState() {
        return (T)STATE_HANDLE.getVolatile(this);
    }

    public final void setState(@NotNull T newState) {
        Intrinsics.checkNotNullParameter(newState, (String)"newState");
        STATE_HANDLE.setVolatile(this, newState);
    }

    @Override
    public final void loadState(@NotNull T state) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        this.setState(state);
    }

    @Override
    public final long getStateModificationCount() {
        return TIMESTAMP_HANDLE.getVolatile(this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final T updateState(@NotNull Function1<? super T, ? extends T> updateFunction) {
        Intrinsics.checkNotNullParameter(updateFunction, (String)"updateFunction");
        boolean $i$f$updateState = false;
        Object prev = null;
        prev = this.getState();
        Object next = null;
        boolean haveNext = false;
        while (true) {
            void it;
            T t;
            if (!haveNext) {
                next = updateFunction.invoke(prev);
            }
            if (Companion.compareAndSet(this, prev, next)) {
                Object object = next;
                Intrinsics.checkNotNull((Object)object);
                return (T)object;
            }
            T t2 = t = this.getState();
            Object var9_9 = prev;
            boolean bl = false;
            prev = it;
            haveNext = var9_9 == t;
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(SerializablePersistentStateComponent.class, MethodHandles.lookup());
            VarHandle varHandle = lookup.findVarHandle(SerializablePersistentStateComponent.class, "state", Object.class);
            Intrinsics.checkNotNullExpressionValue((Object)varHandle, (String)"lookup.findVarHandle(\n  \u2026ny::class.java,\n        )");
            STATE_HANDLE = varHandle;
            VarHandle varHandle2 = lookup.findVarHandle(SerializablePersistentStateComponent.class, "timestamp", Long.TYPE);
            Intrinsics.checkNotNullExpressionValue((Object)varHandle2, (String)"lookup.findVarHandle(\n  \u2026aPrimitiveType,\n        )");
            TIMESTAMP_HANDLE = varHandle2;
        }
        catch (ReflectiveOperationException e) {
            Logger.getInstance(SerializablePersistentStateComponent.class).error(e);
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create()");
            throw (Throwable)extensionNotApplicableException;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/components/SerializablePersistentStateComponent$Companion;", "", "()V", "STATE_HANDLE", "Ljava/lang/invoke/VarHandle;", "TIMESTAMP_HANDLE", "compareAndSet", "", "component", "Lcom/intellij/openapi/components/SerializablePersistentStateComponent;", "prev", "next", "intellij.platform.projectModel"})
    public static final class Companion {
        private Companion() {
        }

        @PublishedApi
        public final boolean compareAndSet(@NotNull SerializablePersistentStateComponent<?> component, @NotNull Object prev, @Nullable Object next) {
            Intrinsics.checkNotNullParameter(component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
            if (STATE_HANDLE.weakCompareAndSet(component, prev, next)) {
                TIMESTAMP_HANDLE.getAndAdd(component, 1L);
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

