/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ModalityInvokator;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ThrowableComputable;
import java.awt.Component;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Application
extends ComponentManager {
    @ApiStatus.Experimental
    public void invokeLaterOnWriteThread(@NotNull Runnable var1);

    @ApiStatus.Experimental
    public void invokeLaterOnWriteThread(@NotNull Runnable var1, @NotNull ModalityState var2);

    @ApiStatus.Experimental
    public void invokeLaterOnWriteThread(@NotNull Runnable var1, @NotNull ModalityState var2, @NotNull Condition<?> var3);

    public void runReadAction(@NotNull Runnable var1);

    public <T> T runReadAction(@NotNull Computable<T> var1);

    public <T, E extends Throwable> T runReadAction(@NotNull ThrowableComputable<T, E> var1) throws E;

    public void runWriteAction(@NotNull Runnable var1);

    public <T> T runWriteAction(@NotNull Computable<T> var1);

    public <T, E extends Throwable> T runWriteAction(@NotNull ThrowableComputable<T, E> var1) throws E;

    public boolean hasWriteAction(@NotNull Class<?> var1);

    public void assertReadAccessAllowed();

    public void assertWriteAccessAllowed();

    @ApiStatus.Experimental
    public void assertReadAccessNotAllowed();

    public void assertIsDispatchThread();

    @ApiStatus.Experimental
    public void assertIsNonDispatchThread();

    @ApiStatus.Experimental
    public void assertIsWriteThread();

    public void addApplicationListener(@NotNull ApplicationListener var1, @NotNull Disposable var2);

    public void saveAll();

    public void saveSettings();

    public void exit();

    default public void exit(boolean force, boolean exitConfirmed, boolean restart) {
        this.exit();
    }

    @Contract(pure=true)
    public boolean isWriteAccessAllowed();

    @Contract(pure=true)
    public boolean isReadAccessAllowed();

    @Contract(pure=true)
    public boolean isDispatchThread();

    @ApiStatus.Experimental
    @Contract(pure=true)
    public boolean isWriteThread();

    public void invokeLater(@NotNull Runnable var1);

    public void invokeLater(@NotNull Runnable var1, @NotNull Condition<?> var2);

    public void invokeLater(@NotNull Runnable var1, @NotNull ModalityState var2);

    public void invokeLater(@NotNull Runnable var1, @NotNull ModalityState var2, @NotNull Condition<?> var3);

    public void invokeAndWait(@NotNull Runnable var1, @NotNull ModalityState var2) throws ProcessCanceledException;

    public void invokeAndWait(@NotNull Runnable var1) throws ProcessCanceledException;

    @NotNull
    public ModalityState getCurrentModalityState();

    @NotNull
    public ModalityState getModalityStateForComponent(@NotNull Component var1);

    @NotNull
    public ModalityState getDefaultModalityState();

    @NotNull
    public ModalityState getNoneModalityState();

    @NotNull
    public ModalityState getAnyModalityState();

    public long getStartTime();

    public long getIdleTime();

    public boolean isUnitTestMode();

    public boolean isHeadlessEnvironment();

    public boolean isCommandLine();

    @NotNull
    public Future<?> executeOnPooledThread(@NotNull Runnable var1);

    @NotNull
    public <T> Future<T> executeOnPooledThread(@NotNull Callable<T> var1);

    public boolean isRestartCapable();

    public void restart();

    public boolean isActive();

    public boolean isInternal();

    public boolean isEAP();

    @Deprecated
    @ApiStatus.Internal
    public CoroutineScope getCoroutineScope();

    @Deprecated
    public void addApplicationListener(@NotNull ApplicationListener var1);

    @Deprecated
    public void removeApplicationListener(@NotNull ApplicationListener var1);

    @Deprecated
    @NotNull
    public ModalityInvokator getInvokator();

    @Deprecated
    default public boolean isDisposeInProgress() {
        return this.isDisposed();
    }

    @Deprecated
    @NotNull
    public AccessToken acquireReadActionLock();

    @Deprecated
    @NotNull
    public AccessToken acquireWriteActionLock(@NotNull Class<?> var1);

    @Deprecated
    @ApiStatus.Internal
    @Nullable
    public <T> T getServiceByClassName(@NotNull String var1);
}

