/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PatternParser {
    private static final TokenSet PATTERN_MODIFIERS = TokenSet.create(JavaTokenType.FINAL_KEYWORD);
    private final JavaParser myParser;

    public PatternParser(JavaParser javaParser) {
        this.myParser = javaParser;
    }

    @Contract(pure=true)
    public boolean isPattern(PsiBuilder builder) {
        PsiBuilder.Marker patternStart = builder.mark();
        while (builder.getTokenType() == JavaTokenType.LPARENTH) {
            builder.advanceLexer();
        }
        this.myParser.getDeclarationParser().parseModifierList(builder, PATTERN_MODIFIERS);
        PsiBuilder.Marker type = this.myParser.getReferenceParser().parseType(builder, 5);
        boolean isPattern = type != null && (builder.getTokenType() == JavaTokenType.IDENTIFIER || builder.getTokenType() == JavaTokenType.LPARENTH);
        patternStart.rollbackTo();
        return isPattern;
    }

    public @NotNull PsiBuilder.Marker parsePattern(PsiBuilder builder) {
        return this.parsePattern(builder, false);
    }

    private @NotNull PsiBuilder.Marker parsePattern(PsiBuilder builder, boolean expectVar) {
        PsiBuilder.Marker guardPattern = builder.mark();
        PsiBuilder.Marker primaryPattern = this.parsePrimaryPattern(builder, expectVar);
        if (builder.getTokenType() != JavaTokenType.ANDAND) {
            guardPattern.drop();
            PsiBuilder.Marker marker = primaryPattern;
            if (marker == null) {
                PatternParser.$$$reportNull$$$0(0);
            }
            return marker;
        }
        builder.advanceLexer();
        PsiBuilder.Marker guardingExpression = this.myParser.getExpressionParser().parseConditionalAnd(builder, 1);
        if (guardingExpression == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        }
        JavaParserUtil.done(guardPattern, JavaElementType.GUARDED_PATTERN);
        PsiBuilder.Marker marker = guardPattern;
        if (marker == null) {
            PatternParser.$$$reportNull$$$0(1);
        }
        return marker;
    }

    @NotNull PsiBuilder.Marker parsePrimaryPattern(PsiBuilder builder, boolean expectVar) {
        if (builder.getTokenType() == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker parenPattern = builder.mark();
            builder.advanceLexer();
            this.parsePattern(builder);
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
            }
            JavaParserUtil.done(parenPattern, JavaElementType.PARENTHESIZED_PATTERN);
            PsiBuilder.Marker marker = parenPattern;
            if (marker == null) {
                PatternParser.$$$reportNull$$$0(2);
            }
            return marker;
        }
        return this.parseTypeOrRecordPattern(builder, expectVar);
    }

    private void parseRecordStructurePattern(PsiBuilder builder) {
        PsiBuilder.Marker recordStructure = builder.mark();
        boolean hasLparen = PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH);
        assert (hasLparen);
        boolean isFirst = true;
        while (builder.getTokenType() != JavaTokenType.RPARENTH) {
            if (!isFirst) {
                JavaParserUtil.expectOrError(builder, JavaTokenType.COMMA, "expected.comma");
            }
            if (builder.getTokenType() == null) break;
            if (this.isPattern(builder)) {
                this.parsePattern(builder, true);
                isFirst = false;
                continue;
            }
            int flags = 133;
            this.myParser.getReferenceParser().parseType(builder, flags);
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.pattern", new Object[0]));
            if (builder.getTokenType() == JavaTokenType.RPARENTH) break;
            builder.advanceLexer();
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
            builder.error(JavaPsiBundle.message("expected.rparen", new Object[0]));
        }
        recordStructure.done(JavaElementType.DECONSTRUCTION_LIST);
    }

    private @NotNull PsiBuilder.Marker parseTypeOrRecordPattern(PsiBuilder builder, boolean expectVar) {
        boolean hasIdentifier;
        PsiBuilder.Marker pattern = builder.mark();
        PsiBuilder.Marker patternVariable = builder.mark();
        this.myParser.getDeclarationParser().parseModifierList(builder, PATTERN_MODIFIERS);
        int flags = 5;
        if (expectVar) {
            flags |= 0x80;
        }
        PsiBuilder.Marker type = this.myParser.getReferenceParser().parseType(builder, flags);
        assert (type != null);
        boolean isRecord = false;
        if (builder.getTokenType() == JavaTokenType.LPARENTH) {
            this.parseRecordStructurePattern(builder);
            isRecord = true;
        }
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER && (!"when".equals(builder.getTokenText()) || PatternParser.isWhenAfterWhen(builder))) {
            if (isRecord) {
                PsiBuilder.Marker variable = builder.mark();
                builder.advanceLexer();
                variable.done(JavaElementType.DECONSTRUCTION_PATTERN_VARIABLE);
            } else {
                builder.advanceLexer();
            }
            hasIdentifier = true;
        } else {
            hasIdentifier = false;
        }
        if (isRecord) {
            patternVariable.drop();
            JavaParserUtil.done(pattern, JavaElementType.DECONSTRUCTION_PATTERN);
        } else {
            if (hasIdentifier) {
                JavaParserUtil.done(patternVariable, JavaElementType.PATTERN_VARIABLE);
            } else {
                patternVariable.drop();
            }
            JavaParserUtil.done(pattern, JavaElementType.TYPE_TEST_PATTERN);
        }
        PsiBuilder.Marker marker = pattern;
        if (marker == null) {
            PatternParser.$$$reportNull$$$0(3);
        }
        return marker;
    }

    private static boolean isWhenAfterWhen(PsiBuilder builder) {
        if (builder.lookAhead(1) != JavaTokenType.IDENTIFIER) {
            return false;
        }
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        boolean isWhenAfterWhen = builder.getTokenType() == JavaTokenType.IDENTIFIER && "when".equals(builder.getTokenText());
        mark.rollbackTo();
        return isWhenAfterWhen;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/java/parser/PatternParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePrimaryPattern";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeOrRecordPattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

